% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cca.R
\name{ccaProj}
\alias{ccaProj}
\alias{CCAproj}
\title{(Robust) CCA via projections through the data points}
\usage{
ccaProj(
  x,
  y,
  k = 1,
  method = c("spearman", "kendall", "quadrant", "M", "pearson"),
  control = list(...),
  standardize = TRUE,
  useL1Median = TRUE,
  fallback = FALSE,
  ...
)

CCAproj(
  x,
  y,
  k = 1,
  method = c("spearman", "kendall", "quadrant", "M", "pearson"),
  standardize = TRUE,
  useL1Median = TRUE,
  fallback = FALSE,
  ...
)
}
\arguments{
\item{x, y}{each can be a numeric vector, matrix or data frame.}

\item{k}{an integer giving the number of canonical variables to compute.}

\item{method}{a character string specifying the correlation functional to
maximize.  Possible values are \code{"spearman"} for the Spearman
correlation, \code{"kendall"} for the Kendall correlation, \code{"quadrant"}
for the quadrant correlation, \code{"M"} for the correlation based on a
bivariate M-estimator of location and scatter with a Huber loss function, or
\code{"pearson"} for the classical Pearson correlation (see
\code{\link{corFunctions}}).}

\item{control}{a list of additional arguments to be passed to the specified
correlation functional.  If supplied, this takes precedence over additional
arguments supplied via the \code{\dots} argument.}

\item{standardize}{a logical indicating whether the data should be
(robustly) standardized.}

\item{useL1Median}{a logical indicating whether the \eqn{L_{1}}{L1} medians
should be used as the centers of the data sets in standardization (defaults
to \code{TRUE}).  If \code{FALSE}, the columnwise centers are used instead
(columnwise means if \code{method} is \code{"pearson"} and columnwise
medians otherwise).}

\item{fallback}{logical indicating whether a fallback mode for robust
standardization should be used.  If a correlation functional other than the
Pearson correlation is maximized, the first attempt for standardizing the
data is via median and MAD.  In the fallback mode, variables whose MADs are
zero (e.g., dummy variables) are standardized via mean and standard
deviation.  Note that if the Pearson correlation is maximized,
standardization is always done via mean and standard deviation.}

\item{\dots}{additional arguments to be passed to the specified correlation
functional.  Currently, this is only relevant for the M-estimator.  For
Spearman, Kendall and quadrant correlation, consistency at the normal model
is always forced.}
}
\value{
An object of class \code{"cca"} with the following components:
\item{cor}{a numeric vector giving the canonical correlation
measures.}
\item{A}{a numeric matrix in which the columns contain the canonical vectors
for \code{x}.}
\item{B}{a numeric matrix in which the columns contain the canonical vectors
for \code{y}.}
\item{centerX}{a numeric vector giving the center estimates used in
standardization of \code{x}.}
\item{centerY}{a numeric vector giving the center estimates used in
standardization of \code{y}.}
\item{scaleX}{a numeric vector giving the scale estimates used in
standardization of \code{x}.}
\item{scaleY}{a numeric vector giving the scale estimates used in
standardization of \code{y}.}
\item{call}{the matched function call.}
}
\description{
Perform canoncial correlation analysis via projection pursuit based on
projections through the data points, with a focus on robust and
nonparametric methods.
}
\details{
First the candidate projection directions are defined for each data set
from the respective center through each data point.  Then the algorithm
scans all \eqn{n^2} possible combinations for the maximum correlation,
where \eqn{n} is the number of observations.

For higher order canonical correlations, the data are first transformed into
suitable subspaces.  Then the alternate grid algorithm is applied to the
reduced data and the results are back-transformed to the original space.
}
\note{
\code{CCAproj} is a simple wrapper function for \code{ccaProj} for
more compatibility with package \pkg{pcaPP} concerning function names.
}
\examples{
data("diabetes")
x <- diabetes$x
y <- diabetes$y

## Spearman correlation
ccaProj(x, y, method = "spearman")

## Pearson correlation
ccaProj(x, y, method = "pearson")

}
\seealso{
\code{\link{ccaGrid}}, \code{\link{maxCorProj}},
\code{\link{corFunctions}}
}
\author{
Andreas Alfons
}
\keyword{multivariate}
\keyword{robust}
