% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataSimClass.R
\name{LaLonde}
\alias{LaLonde}
\title{LaLonde data example}
\value{
An \link[R6:R6Class]{R6} object of class \link{DataSim}
}
\description{
LaLonde data example

LaLonde data example
}
\details{
Returns the LaLonde data as used by Dehjia and Wahba. Note the data
is fixed and \code{gen_data()} will just initialize the fixed data.
}
\examples{

## ------------------------------------------------
## Method `LaLonde$new`
## ------------------------------------------------

nsw <- LaLonde$new(design = "NSW")
nsw$gen_data()
nsw$get_n()

obs.study <-  LaLonde$new(design = "Full")
obs.study$gen_data()
obs.study$get_n()
}
\section{Super class}{
\code{\link[causalOT:DataSim]{causalOT::DataSim}} -> \code{LaLonde}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LaLonde-gen_data}{\code{LaLonde$gen_data()}}
\item \href{#method-LaLonde-get_tau}{\code{LaLonde$get_tau()}}
\item \href{#method-LaLonde-gen_x}{\code{LaLonde$gen_x()}}
\item \href{#method-LaLonde-gen_y}{\code{LaLonde$gen_y()}}
\item \href{#method-LaLonde-gen_z}{\code{LaLonde$gen_z()}}
\item \href{#method-LaLonde-new}{\code{LaLonde$new()}}
\item \href{#method-LaLonde-get_design}{\code{LaLonde$get_design()}}
\item \href{#method-LaLonde-clone}{\code{LaLonde$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="causalOT" data-topic="DataSim" data-id="get_n"><a href='../../causalOT/html/DataSim.html#method-DataSim-get_n'><code>causalOT::DataSim$get_n()</code></a></span></li>
<li><span class="pkg-link" data-pkg="causalOT" data-topic="DataSim" data-id="get_p"><a href='../../causalOT/html/DataSim.html#method-DataSim-get_p'><code>causalOT::DataSim$get_p()</code></a></span></li>
<li><span class="pkg-link" data-pkg="causalOT" data-topic="DataSim" data-id="get_x"><a href='../../causalOT/html/DataSim.html#method-DataSim-get_x'><code>causalOT::DataSim$get_x()</code></a></span></li>
<li><span class="pkg-link" data-pkg="causalOT" data-topic="DataSim" data-id="get_x0"><a href='../../causalOT/html/DataSim.html#method-DataSim-get_x0'><code>causalOT::DataSim$get_x0()</code></a></span></li>
<li><span class="pkg-link" data-pkg="causalOT" data-topic="DataSim" data-id="get_x1"><a href='../../causalOT/html/DataSim.html#method-DataSim-get_x1'><code>causalOT::DataSim$get_x1()</code></a></span></li>
<li><span class="pkg-link" data-pkg="causalOT" data-topic="DataSim" data-id="get_y"><a href='../../causalOT/html/DataSim.html#method-DataSim-get_y'><code>causalOT::DataSim$get_y()</code></a></span></li>
<li><span class="pkg-link" data-pkg="causalOT" data-topic="DataSim" data-id="get_z"><a href='../../causalOT/html/DataSim.html#method-DataSim-get_z'><code>causalOT::DataSim$get_z()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LaLonde-gen_data"></a>}}
\if{latex}{\out{\hypertarget{method-LaLonde-gen_data}{}}}
\subsection{Method \code{gen_data()}}{
Sets up the data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LaLonde$gen_data()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LaLonde-get_tau"></a>}}
\if{latex}{\out{\hypertarget{method-LaLonde-get_tau}{}}}
\subsection{Method \code{get_tau()}}{
Returns the experimental treatment effect, $1794
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LaLonde$get_tau()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LaLonde-gen_x"></a>}}
\if{latex}{\out{\hypertarget{method-LaLonde-gen_x}{}}}
\subsection{Method \code{gen_x()}}{
Sets up the covariate data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LaLonde$gen_x()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LaLonde-gen_y"></a>}}
\if{latex}{\out{\hypertarget{method-LaLonde-gen_y}{}}}
\subsection{Method \code{gen_y()}}{
Sets up the outcome data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LaLonde$gen_y()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LaLonde-gen_z"></a>}}
\if{latex}{\out{\hypertarget{method-LaLonde-gen_z}{}}}
\subsection{Method \code{gen_z()}}{
Sets up the treatment indicator
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LaLonde$gen_z()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LaLonde-new"></a>}}
\if{latex}{\out{\hypertarget{method-LaLonde-new}{}}}
\subsection{Method \code{new()}}{
Initializes the LaLonde object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LaLonde$new(n = NULL, p = NULL, param = list(), design = "NSW", ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{Not used.
Maintained for symmetry with other
DataSim objects.}

\item{\code{p}}{Not used.
Maintained for symmetry with other
DataSim objects.}

\item{\code{param}}{Not used.
Maintained for symmetry with other
DataSim objects.}

\item{\code{design}}{One of "NSW" or "Full".
"NSW" uses the original experimental data
from the job training program while option "Full"
uses the treated individuals from
LaLonde's study and compares them to
individuals from the
Current Population Survey as controls.}

\item{\code{...}}{Not used.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{nsw <- LaLonde$new(design = "NSW")
nsw$gen_data()
nsw$get_n()

obs.study <-  LaLonde$new(design = "Full")
obs.study$gen_data()
obs.study$get_n()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LaLonde-get_design"></a>}}
\if{latex}{\out{\hypertarget{method-LaLonde-get_design}{}}}
\subsection{Method \code{get_design()}}{
Returns the chosen design parameters
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LaLonde$get_design()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LaLonde-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LaLonde-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LaLonde$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
