% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitCauchy.R
\name{plot.profile.cauphyfit}
\alias{plot.profile.cauphyfit}
\title{Plot for class \code{profile.cauphyfit}}
\usage{
\method{plot}{profile.cauphyfit}(x, n_col, ...)
}
\arguments{
\item{x}{an object of class \code{profile.cauphyfit}}

\item{n_col}{the number of columns on which to display the plot. Can be left blank.}

\item{...}{further arguments to be passed to \code{\link{plot}}.}
}
\value{
None.
}
\description{
This function takes an object of class \code{\link{profile.cauphyfit}},
and plots the profile likelihood for each parameter.
}
\examples{
phy <- ape::rphylo(5, 0.1, 0)
dat <- rTraitCauchy(n = 1, phy = phy, model = "cauchy", parameters = list(root.value = 0, disp = 1))
fit <- fitCauchy(phy, dat, model = "cauchy", method = "fixed.root")
pr <- profile(fit)
plot(pr)

}
\seealso{
\code{\link{profile.cauphyfit}}, \code{\link{fitCauchy}}.
}
