% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{table_exists}
\alias{table_exists}
\title{Check If A Table Exists}
\usage{
table_exists(sc, table, database = NULL)
}
\arguments{
\item{sc}{A \code{spark_connection}.}

\item{table}{\code{character(1)}. The name of the table.}

\item{database}{\code{character(1)}. The name of the database for which the
functions should be listed (default: \code{NULL}).}
}
\value{
A \code{logical(1)} vector indicating \code{TRUE} if the table exists within the
specified database and \code{FALSE} otherwise.
}
\description{
Check if the table or view with the specified name exists in the specified
database. This can either be a temporary view or a table/view.
}
\details{
If \code{database} is \code{NULL}, \code{table_exists} refers to a table in the current
database (see \code{\link[=current_database]{current_database()}}).
}
\examples{
\dontrun{
sc <- sparklyr::spark_connect(master = "local")
mtcars_spark <- sparklyr::copy_to(dest = sc, df = mtcars)
table_exists(sc = sc, table = "mtcars")
}

}
\seealso{
\code{\link[=cache_table]{cache_table()}}, \code{\link[=create_table]{create_table()}}, \code{\link[=get_table]{get_table()}}, \code{\link[=list_tables]{list_tables()}},
\code{\link[=refresh_table]{refresh_table()}}, \code{\link[=uncache_table]{uncache_table()}}
}
