% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{list_functions}
\alias{list_functions}
\title{List Functions}
\usage{
list_functions(sc, database = NULL)
}
\arguments{
\item{sc}{A \code{spark_connection}.}

\item{database}{\code{character(1)}. The name of the database for which the
functions should be listed (default: \code{NULL}).}
}
\value{
A \code{tibble} containing 5 columns:
\itemize{
\item \code{name} - Name of the function.
\item \code{database} - Name of the database the function belongs to.
\item \code{description} - Description of the function.
\item \code{className} - The fully qualified class name of the function.
\item \code{isTemporary} - Whether the function is temporary or not.
}
}
\description{
Returns a list of functions registered in the specified database. This
includes all temporary functions. The result contains the class name,
database, description, whether it is temporary and the name of each function.
}
\examples{
\dontrun{
sc <- sparklyr::spark_connect(master = "local")
list_functions(sc = sc)
list_functions(sc = sc, database = "default")
}

}
\seealso{
\code{\link[=function_exists]{function_exists()}}, \code{\link[=get_function]{get_function()}}
}
