% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flowmap.R
\name{flowmap}
\alias{flowmap}
\title{Mapping a flow matrix origin-destination}
\usage{
flowmap(tab, format, fdc, code, filter, threshold, taille, a.head,
  a.length, a.angle, a.col)
}
\arguments{
\item{tab}{the input flow dataset .csv}

\item{format}{the flow dataset format : M=matrice or L=long.}

\item{fdc}{the geographical background file .shp}

\item{code}{is the column with the spatial units ID}

\item{filter}{allows you to filter (or not) the flow dataset. See details}

\item{threshold}{is the value of the threshold criterion used to filter the values. The default is 1.}

\item{taille}{is a graphical parameter for modifying the width of the feature}

\item{a.head}{integer code, determining the kind of arrows to be drawn. See Details}

\item{a.length}{length of the edges of the arrow head (in inches).}

\item{a.angle}{angle from the shaft of the arrow to the edge of the arrow head.}

\item{a.col}{color of the arrows}
}
\value{
a matrix or a list with the correct tabflow ID code

The resulting flowmap
}
\description{
Mapping a flow matrix origin-destination
}
\details{
The flow dataset must be converted to a dataframe for optimal performance (troubles remains with tibble format)

If filter = FALSE, all the matrice values are plot [(n*(n-1)] cells, i.e. all links out of the main diagonal.
If filter = TRUE only non-zero values are plotted, i.e. existing links with or without threshold.
The default threshold is set to 1.

a.head is for applying an arrow or not
-- code=0 : the link has no head - no arrow
-- code=1 : an arrow is draw at (x0[i], y0[i]).
-- code=2 : an arrow is draw at (x1[j], y1[j])
-- code=3 : an arrow is draw at both nodes.
}
\examples{
library(cartograflow)
data(flowdata)
bkg<- system.file("shape/MGP_TER.shp", package="cartograflow",
                  lib.loc = NULL, mustWork = TRUE)
flowmap(flows,format="L",bkg,code = "EPT_NUM",filter = TRUE,
         threshold = 20,taille = 5,a.head = 1,a.length = 0.05)
}
