% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/longstring.R
\name{longstring}
\alias{longstring}
\title{Identifies the longest string of identical consecutive responses for each observation}
\usage{
longstring(x, avg = FALSE)
}
\arguments{
\item{x}{a matrix of data (e.g. item responses)}

\item{avg}{a boolean indicating whether to additionally return the average length of identical consecutive responses}
}
\description{
Takes a matrix of item responses and, beginning with the second column (i.e., second item)
compares each column with the previous one to check for matching responses.
For each observation, the length of the maximum uninterrupted string of
identical responses is returned. Additionally, can return the average length of uninterrupted string of identical responses.
}
\examples{
careless_long <- longstring(careless_dataset, avg = FALSE)
careless_avg <- longstring(careless_dataset, avg = TRUE)
boxplot(careless_avg$longstr) #produce a boxplot of the longstring index
boxplot(careless_avg$avgstr)
}
\references{
Johnson, J. A. (2005). Ascertaining the validity of individual protocols
from web-based personality inventories. \emph{Journal of Research in Personality, 39}, 103-129. \doi{10.1016/j.jrp.2004.09.009}
}
\author{
Richard Yentes \email{rdyentes@ncsu.edu}, Francisco Wilhelm \email{franciscowilhelm@gmail.com}
}
