% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_continuous.survey.design.R
\name{ard_continuous.survey.design}
\alias{ard_continuous.survey.design}
\title{ARD Continuous Survey Statistics}
\usage{
\method{ard_continuous}{survey.design}(
  data,
  variables,
  by = NULL,
  statistic = everything() ~ c("median", "p25", "p75"),
  fmt_fn = NULL,
  stat_label = NULL,
  ...
)
}
\arguments{
\item{data}{(\code{survey.design})\cr
a design object often created with \code{\link[survey:svydesign]{survey::svydesign()}}.}

\item{variables}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
columns to include in summaries.}

\item{by}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
results are calculated for \strong{all combinations} of the columns specified,
including unobserved combinations and unobserved factor levels.}

\item{statistic}{(\code{\link[cards:syntax]{formula-list-selector}})\cr
a named list, a list of formulas,
or a single formula where the list element is a character vector of
statistic names to include. See below for options.}

\item{fmt_fn}{(\code{\link[cards:syntax]{formula-list-selector}})\cr
a named list, a list of formulas,
or a single formula where the list element is a named list of functions
(or the RHS of a formula),
e.g. \verb{list(mpg = list(mean = \\(x) round(x, digits = 2) |> as.character))}.}

\item{stat_label}{(\code{\link[cards:syntax]{formula-list-selector}})\cr
a named list, a list of formulas, or a single formula where
the list element is either a named list or a list of formulas defining the
statistic labels, e.g. \code{everything() ~ list(mean = "Mean", sd = "SD")} or
\code{everything() ~ list(mean ~ "Mean", sd ~ "SD")}.}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
an ARD data frame of class 'card'
}
\description{
Returns an ARD of weighted statistics using the \code{{survey}} package.
}
\section{statistic argument}{


The following statistics are available:
'mean', 'median', 'min', 'max', 'sum', 'var', 'sd', 'mean.std.error', 'deff', 'p##',
where 'p##' is are the percentiles and \verb{##} is an integer between 0 and 100.
}

\examples{
\dontshow{if (do.call(asNamespace("cardx")$is_pkg_installed, list(pkg = "survey", reference_pkg = "cardx"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(api, package = "survey")
dclus1 <- survey::svydesign(id = ~dnum, weights = ~pw, data = apiclus1, fpc = ~fpc)

ard_continuous(
  data = dclus1,
  variables = api00,
  by = stype
)
\dontshow{\}) # examplesIf}
}
