% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{gen_wavydims3}
\alias{gen_wavydims3}
\title{Generate Random Noise Dimensions With Wavy Pattern}
\usage{
gen_wavydims3(n = 500, p = 4, data)
}
\arguments{
\item{n}{A numeric value (default: 500) representing the sample size.}

\item{p}{A numeric value (default: 4) representing the number of dimensions.}

\item{data}{A matrix representing the first three dimensions of the data structure.}
}
\value{
A data containing the generated random noise dimensions.
}
\description{
This function generates random noise dimensions by adding wavy patterns.
}
\examples{
set.seed(20240412)
df <- gen_scurve(n = 500, p = 4) |> as.matrix()
gen_wavydims3(n = 500, p = 4, data = df)

}
