# one_grid() works

    Code
      one_grid(nx = 10, ny = 10, num_noise = 2, min_n = -0.05, max_n = 0.05)
    Output
             [,1] [,2]         [,3]          [,4]
        [1,]    1    1 -0.040620890  0.0494111540
        [2,]    2    1 -0.006958216  0.0095421034
        [3,]    3    1  0.023961491  0.0095423958
        [4,]    4    1  0.014336807  0.0056648134
        [5,]    5    1  0.040183118  0.0361641475
        [6,]    6    1 -0.030828246  0.0137938427
        [7,]    7    1 -0.040057099 -0.0227676261
        [8,]    8    1  0.003444101 -0.0486252397
        [9,]    9    1 -0.014709934  0.0374798555
       [10,]   10    1 -0.005895188  0.0060145900
       [11,]    1    2  0.006125192 -0.0122375009
       [12,]    2    2  0.009199008  0.0151320067
       [13,]    3    2  0.043725434  0.0069745122
       [14,]    4    2  0.032775383 -0.0119806817
       [15,]    5    2 -0.015198423 -0.0425165671
       [16,]    6    2 -0.009840486  0.0198855986
       [17,]    7    2  0.017884363 -0.0341541310
       [18,]    8    2  0.003128339 -0.0139019090
       [19,]    9    2 -0.049855517 -0.0043720318
       [20,]   10    2 -0.042550838  0.0362611223
       [21,]    1    3 -0.014135695  0.0091411981
       [22,]    2    3 -0.039919336 -0.0375122381
       [23,]    3    3  0.000868859  0.0205436346
       [24,]    4    3  0.046917972 -0.0096704798
       [25,]    5    3 -0.010018197  0.0074246488
       [26,]    6    3 -0.041176753  0.0395226781
       [27,]    7    3  0.002883964 -0.0140160184
       [28,]    8    3  0.043384065 -0.0001349537
       [29,]    9    3  0.019484127 -0.0395929786
       [30,]   10    3 -0.015735495  0.0421812224
       [31,]    1    4 -0.014806867  0.0192060802
       [32,]    2    4  0.034943412 -0.0329963851
       [33,]    3    4  0.012234167  0.0441801412
       [34,]    4    4  0.040322342 -0.0359260298
       [35,]    5    4 -0.013342465  0.0215506210
       [36,]    6    4  0.048743341  0.0231140854
       [37,]    7    4 -0.015834825  0.0290469873
       [38,]    8    4  0.028985684 -0.0346599014
       [39,]    9    4 -0.033649094  0.0245407152
       [40,]   10    4  0.034743458 -0.0438232428
       [41,]    1    5 -0.040947145 -0.0190370204
       [42,]    2    5  0.025659902  0.0157330000
       [43,]    3    5  0.034062270 -0.0136145061
       [44,]    4    5 -0.001927530  0.0211817049
       [45,]    5    5  0.006010157  0.0296529576
       [46,]    6    5  0.005157653  0.0385897858
       [47,]    7    5  0.040785119  0.0114352393
       [48,]    8    5 -0.008590486 -0.0394679684
       [49,]    9    5 -0.013594900  0.0379028531
       [50,]   10    5 -0.008194703 -0.0086608654
       [51,]    1    6 -0.014514506 -0.0397832549
       [52,]    2    6 -0.042610457  0.0389684510
       [53,]    3    6 -0.004394658  0.0107839450
       [54,]    4    6  0.031400799 -0.0229901668
       [55,]    5    6 -0.005396931  0.0032016000
       [56,]    6    6 -0.041821771  0.0188916723
       [57,]    7    6  0.031016598  0.0406173033
       [58,]    8    6 -0.038376223 -0.0218278701
       [59,]    9    6 -0.039518429  0.0178925602
       [60,]   10    6 -0.048856669 -0.0418970450
       [61,]    1    7  0.007757624  0.0289520095
       [62,]    2    7  0.035364025 -0.0182308341
       [63,]    3    7  0.031473265 -0.0420673159
       [64,]    4    7  0.034647305  0.0215416480
       [65,]    5    7 -0.014155501  0.0032879685
       [66,]    6    7 -0.013249423 -0.0136172979
       [67,]    7    7 -0.024790063  0.0128606171
       [68,]    8    7 -0.044271391 -0.0406865353
       [69,]    9    7 -0.010676471  0.0056567913
       [70,]   10    7  0.043851697 -0.0206802091
       [71,]    1    8  0.016443681 -0.0293639539
       [72,]    2    8 -0.021509732 -0.0099463716
       [73,]    3    8  0.008581070 -0.0216768384
       [74,]    4    8 -0.025245797 -0.0126717287
       [75,]    5    8 -0.034141930 -0.0137911398
       [76,]    6    8 -0.040357834  0.0201560635
       [77,]    7    8 -0.020771534  0.0474466317
       [78,]    8    8  0.040356428 -0.0034467781
       [79,]    9    8  0.030966772  0.0451321898
       [80,]   10    8  0.029159332 -0.0449525188
       [81,]    1    9  0.023592625 -0.0301143471
       [82,]    2    9  0.038851087 -0.0015380326
       [83,]    3    9  0.039433618 -0.0313923658
       [84,]    4    9 -0.024846803 -0.0142799772
       [85,]    5    9 -0.047168665  0.0342363236
       [86,]    6    9 -0.035636917  0.0437694831
       [87,]    7    9 -0.039748340 -0.0163590239
       [88,]    8    9  0.032319008 -0.0215670073
       [89,]    9    9  0.039741895 -0.0312772650
       [90,]   10    9 -0.014166147 -0.0404797181
       [91,]    1   10 -0.029024773 -0.0197967365
       [92,]    2   10 -0.002584811  0.0082434738
       [93,]    3   10  0.007053171 -0.0110442976
       [94,]    4   10  0.003947746 -0.0086618911
       [95,]    5   10 -0.036401528 -0.0378016111
       [96,]    6   10  0.031450933 -0.0267662517
       [97,]    7   10 -0.012927440 -0.0202962862
       [98,]    8   10  0.015580769  0.0326327926
       [99,]    9   10 -0.025986426  0.0398299208
      [100,]   10   10  0.038668635 -0.0465680600

---

    Code
      one_grid(nx = 10, ny = 10, num_noise = 0)
    Output
             [,1] [,2]
        [1,]    1    1
        [2,]    2    1
        [3,]    3    1
        [4,]    4    1
        [5,]    5    1
        [6,]    6    1
        [7,]    7    1
        [8,]    8    1
        [9,]    9    1
       [10,]   10    1
       [11,]    1    2
       [12,]    2    2
       [13,]    3    2
       [14,]    4    2
       [15,]    5    2
       [16,]    6    2
       [17,]    7    2
       [18,]    8    2
       [19,]    9    2
       [20,]   10    2
       [21,]    1    3
       [22,]    2    3
       [23,]    3    3
       [24,]    4    3
       [25,]    5    3
       [26,]    6    3
       [27,]    7    3
       [28,]    8    3
       [29,]    9    3
       [30,]   10    3
       [31,]    1    4
       [32,]    2    4
       [33,]    3    4
       [34,]    4    4
       [35,]    5    4
       [36,]    6    4
       [37,]    7    4
       [38,]    8    4
       [39,]    9    4
       [40,]   10    4
       [41,]    1    5
       [42,]    2    5
       [43,]    3    5
       [44,]    4    5
       [45,]    5    5
       [46,]    6    5
       [47,]    7    5
       [48,]    8    5
       [49,]    9    5
       [50,]   10    5
       [51,]    1    6
       [52,]    2    6
       [53,]    3    6
       [54,]    4    6
       [55,]    5    6
       [56,]    6    6
       [57,]    7    6
       [58,]    8    6
       [59,]    9    6
       [60,]   10    6
       [61,]    1    7
       [62,]    2    7
       [63,]    3    7
       [64,]    4    7
       [65,]    5    7
       [66,]    6    7
       [67,]    7    7
       [68,]    8    7
       [69,]    9    7
       [70,]   10    7
       [71,]    1    8
       [72,]    2    8
       [73,]    3    8
       [74,]    4    8
       [75,]    5    8
       [76,]    6    8
       [77,]    7    8
       [78,]    8    8
       [79,]    9    8
       [80,]   10    8
       [81,]    1    9
       [82,]    2    9
       [83,]    3    9
       [84,]    4    9
       [85,]    5    9
       [86,]    6    9
       [87,]    7    9
       [88,]    8    9
       [89,]    9    9
       [90,]   10    9
       [91,]    1   10
       [92,]    2   10
       [93,]    3   10
       [94,]    4   10
       [95,]    5   10
       [96,]    6   10
       [97,]    7   10
       [98,]    8   10
       [99,]    9   10
      [100,]   10   10

# two_grid() works

    Code
      two_grid(n_value = 19, num_noise = 2, min_n = -0.05, max_n = 0.05)
    Output
      $df
             [,1]          [,2]          [,3]          [,4]          [,5]
        [1,]    1  1.000000e+00  8.124178e-03 -3.443638e-03 -4.209089e-02
        [2,]    2  1.000000e+00  1.391643e-03  6.891297e-03 -3.185854e-02
        [3,]    3  1.000000e+00 -4.792298e-03 -2.910514e-03 -3.563576e-02
        [4,]    4  1.000000e+00 -2.867361e-03  4.812824e-04  1.051819e-02
        [5,]    5  1.000000e+00 -8.036624e-03  9.410904e-03  3.939468e-02
        [6,]    6  1.000000e+00  6.165649e-03 -8.592627e-03  4.866550e-02
        [7,]    7  1.000000e+00  8.011420e-03  6.289616e-03 -1.587339e-02
        [8,]    8  1.000000e+00 -6.888202e-04 -9.385140e-03 -3.396841e-02
        [9,]    9  1.000000e+00  2.941987e-03  1.344373e-03 -5.183702e-03
       [10,]   10  1.000000e+00  1.179038e-03 -7.301414e-03  5.894272e-03
       [11,]   11  1.000000e+00 -1.225038e-03  2.961852e-03 -2.040092e-02
       [12,]   12  1.000000e+00 -1.839802e-03 -5.763175e-03 -3.029022e-02
       [13,]   13  1.000000e+00 -8.745087e-03 -7.878189e-03 -2.525259e-02
       [14,]   14  1.000000e+00 -6.555077e-03 -8.739905e-03  3.809278e-02
       [15,]   15  1.000000e+00  3.039685e-03 -9.304360e-03  1.722212e-02
       [16,]   16  1.000000e+00  1.968097e-03 -5.827845e-03 -5.295695e-03
       [17,]   17  1.000000e+00 -3.576873e-03  2.297630e-03  3.252943e-02
       [18,]   18  1.000000e+00 -6.256678e-04 -3.896577e-03  3.881004e-02
       [19,]   19  1.000000e+00  9.971103e-03 -9.706979e-03 -3.432162e-02
       [20,]    1  2.000000e+00  8.510168e-03 -1.943989e-03  3.307733e-03
       [21,]    2  2.000000e+00  2.827139e-03 -8.956622e-04 -3.864742e-02
       [22,]    3  2.000000e+00  7.983867e-03  7.329231e-03  2.935148e-02
       [23,]    4  2.000000e+00 -1.737718e-04 -7.901102e-03 -3.374147e-02
       [24,]    5  2.000000e+00 -9.383594e-03 -1.077499e-03  4.458650e-02
       [25,]    6  2.000000e+00  2.003639e-03  1.160693e-03  1.077786e-02
       [26,]    7  2.000000e+00  8.235351e-03  1.219500e-03  2.557774e-02
       [27,]    8  2.000000e+00 -5.767927e-04 -4.683468e-03  4.333159e-02
       [28,]    9  2.000000e+00 -8.676813e-03  3.754727e-03 -2.001096e-02
       [29,]   10  2.000000e+00 -3.896825e-03 -8.842582e-03 -7.087577e-03
       [30,]   11  2.000000e+00  3.147099e-03 -8.387487e-03  3.921849e-02
       [31,]   12  2.000000e+00  2.961373e-03 -9.978020e-03  1.691827e-02
       [32,]   13  2.000000e+00 -6.988682e-03  2.194821e-03 -2.630801e-02
       [33,]   14  2.000000e+00 -2.446833e-03 -1.495039e-03  4.093119e-02
       [34,]   15  2.000000e+00 -8.064468e-03 -6.104260e-03 -4.567397e-02
       [35,]   16  2.000000e+00  2.668493e-03 -3.446854e-03 -2.368329e-02
       [36,]   17  2.000000e+00 -9.748668e-03 -8.139106e-04 -2.806454e-02
       [37,]   18  2.000000e+00  3.166965e-03  7.859061e-03 -2.213439e-02
       [38,]   19  2.000000e+00 -5.797137e-03  6.745224e-03  4.185543e-03
       [39,]    1  3.000000e+00  6.729819e-03  3.801970e-03  3.658573e-02
       [40,]    2  3.000000e+00 -6.948692e-03  2.917797e-03  4.376599e-02
       [41,]    3  3.000000e+00  8.189429e-03 -5.731245e-03  1.782739e-02
       [42,]    4  3.000000e+00 -5.131980e-03 -5.219563e-03 -4.086111e-02
       [43,]    5  3.000000e+00 -6.812454e-03 -8.221478e-03  4.300166e-02
       [44,]    6  3.000000e+00  3.855060e-04 -9.930245e-03  2.771449e-02
       [45,]    7  3.000000e+00 -1.202031e-03 -6.503715e-03 -4.484880e-03
       [46,]    8  3.000000e+00 -1.031531e-03  4.562084e-03 -1.324502e-03
       [47,]    9  3.000000e+00 -8.157024e-03  9.377155e-03 -3.159992e-02
       [48,]   10  3.000000e+00  1.718097e-03 -7.171829e-03  2.750809e-02
       [49,]   11  3.000000e+00  2.718980e-03  8.093255e-03  4.548592e-02
       [50,]   12  3.000000e+00  1.638941e-03 -2.179648e-03  7.812990e-03
       [51,]   13  3.000000e+00  2.902901e-03 -6.827107e-03 -1.890919e-02
       [52,]   14  3.000000e+00  8.522091e-03 -6.179010e-03 -3.338383e-02
       [53,]   15  3.000000e+00  8.789316e-04  8.049303e-03 -1.435705e-02
       [54,]   16  3.000000e+00 -6.280160e-03 -5.638084e-03  4.807476e-02
       [55,]   17  3.000000e+00  1.079386e-03 -7.542908e-03  8.845130e-03
       [56,]   18  3.000000e+00  8.364354e-03 -9.260504e-04 -8.831416e-03
       [57,]   19  3.000000e+00 -6.203320e-03 -8.984751e-03  4.564154e-02
       [58,]    1  4.000000e+00  7.675245e-03  2.722302e-03  3.658085e-02
       [59,]    2  4.000000e+00  7.903686e-03 -5.522995e-03 -8.921461e-03
       [60,]    3  4.000000e+00  9.771334e-03  1.403361e-03  3.351342e-02
       [61,]    4  4.000000e+00 -1.551525e-03  1.446101e-03  2.072570e-02
       [62,]    5  4.000000e+00 -7.072805e-03  2.704042e-03  8.042781e-03
       [63,]    6  4.000000e+00 -6.294653e-03 -8.914038e-03 -4.166021e-02
       [64,]    7  4.000000e+00 -6.929461e-03 -2.620067e-04 -2.494433e-02
       [65,]    8  4.000000e+00  2.831100e-03 -1.902759e-03  4.553618e-02
       [66,]    9  4.000000e+00  2.649885e-03  6.007690e-03 -1.715480e-02
       [67,]   10  4.000000e+00  4.958013e-03  1.276564e-03  1.738370e-02
       [68,]   11  4.000000e+00  8.854278e-03 -4.889959e-03 -3.362814e-02
       [69,]   12  4.000000e+00  2.135294e-03 -5.354200e-03  4.303222e-02
       [70,]   13  4.000000e+00 -8.770339e-03  9.409730e-03 -3.350280e-02
       [71,]   14  4.000000e+00 -3.288736e-03 -5.923561e-03  1.936839e-02
       [72,]   15  4.000000e+00  4.301946e-03  6.740342e-03  1.944254e-02
       [73,]   16  4.000000e+00 -1.716214e-03  3.309367e-03  1.909080e-02
       [74,]   17  4.000000e+00  5.049159e-03  3.666450e-03 -3.042735e-02
       [75,]   18  4.000000e+00  6.828386e-03 -7.733417e-04 -3.842425e-02
       [76,]   19  4.000000e+00  8.071567e-03 -8.126574e-03  3.465975e-02
       [77,]    1  5.000000e+00  4.154307e-03  6.802457e-03 -4.354046e-03
       [78,]    2  5.000000e+00 -8.071286e-03  8.911312e-04 -1.014612e-02
       [79,]    3  5.000000e+00 -6.193354e-03  4.675507e-03  3.923015e-02
       [80,]    4  5.000000e+00 -5.831866e-03  1.320145e-03  1.768380e-03
       [81,]    5  5.000000e+00 -4.718525e-03  1.486074e-03  4.402041e-03
       [82,]    6  5.000000e+00 -7.770217e-03 -8.726588e-03 -3.860631e-02
       [83,]    7  5.000000e+00 -7.886724e-03  8.381871e-03 -2.764302e-02
       [84,]    8  5.000000e+00  4.969361e-03  6.850851e-03 -2.317968e-02
       [85,]    9  5.000000e+00  9.433733e-03 -7.720366e-03 -3.990011e-02
       [86,]   10  5.000000e+00  7.127383e-03 -1.487052e-03  2.521825e-02
       [87,]   11  5.000000e+00  7.949668e-03  8.080831e-03  2.716887e-02
       [88,]   12  5.000000e+00 -6.463802e-03 -8.553476e-03  4.058681e-02
       [89,]   13  5.000000e+00 -7.948379e-03  5.989384e-03  4.616510e-02
       [90,]   14  5.000000e+00  2.833229e-03 -8.913970e-03  2.396861e-02
       [91,]   15  5.000000e+00  5.804955e-03 -2.164222e-03  2.843553e-02
       [92,]   16  5.000000e+00  5.169622e-04 -2.483721e-03  4.322368e-02
       [93,]   17  5.000000e+00 -1.410634e-03 -3.263303e-03  8.444753e-04
       [94,]   18  5.000000e+00 -7.895493e-04  6.081672e-04  4.313025e-02
       [95,]   19  5.000000e+00  7.280306e-03 -8.055756e-03  1.351383e-02
       [96,]    1  6.000000e+00 -6.290187e-03 -1.870207e-03  2.403508e-02
       [97,]    2  6.000000e+00  2.585488e-03 -3.435507e-03  2.622149e-02
       [98,]    3  6.000000e+00 -3.116154e-03 -1.427123e-03 -2.537844e-02
       [99,]    4  6.000000e+00  5.197285e-03 -6.670750e-03  4.016834e-02
      [100,]    5  6.000000e+00 -7.733727e-03  6.862231e-04 -1.482019e-02
      [101,]    6  6.000000e+00  9.882231e-03  3.733012e-03 -1.456987e-02
      [102,]    7  6.000000e+00  1.908421e-03 -4.277005e-03  4.277571e-02
      [103,]    8  6.000000e+00  1.908479e-03  9.335539e-03  2.948042e-02
      [104,]    9  6.000000e+00  1.132963e-03 -6.507916e-03  1.067549e-02
      [105,]   10  6.000000e+00  7.232830e-03  5.609305e-03 -4.513663e-02
      [106,]   11  6.000000e+00  2.758769e-03  1.801918e-03  4.537128e-02
      [107,]   12  6.000000e+00 -4.553525e-03 -5.976260e-03 -3.784427e-02
      [108,]   13  6.000000e+00 -9.725048e-03 -1.411748e-03  3.378596e-02
      [109,]   14  6.000000e+00  7.495971e-03  3.417429e-03 -4.172730e-02
      [110,]   15  6.000000e+00  1.202918e-03  5.132195e-03  3.725280e-02
      [111,]   16  6.000000e+00 -2.447500e-03  6.410127e-03 -2.962656e-02
      [112,]   17  6.000000e+00  3.026401e-03  5.188265e-03  4.788282e-02
      [113,]   18  6.000000e+00  1.394902e-03 -7.606264e-03  4.047813e-02
      [114,]   19  6.000000e+00 -2.396136e-03 -8.758609e-03 -2.070826e-02
      [115,]    1  7.000000e+00 -8.503313e-03  2.868308e-03  9.671411e-03
      [116,]    2  7.000000e+00  3.977120e-03  8.898322e-04 -4.271431e-04
      [117,]    3  7.000000e+00 -6.830826e-03  1.500765e-03  4.148067e-02
      [118,]    4  7.000000e+00 -2.780382e-03  9.313555e-03 -2.609828e-03
      [119,]    5  7.000000e+00 -8.744064e-04  5.421682e-03 -1.204501e-02
      [120,]    6  7.000000e+00  7.252224e-03 -5.201622e-03 -1.518534e-02
      [121,]    7  7.000000e+00  1.828240e-03  6.568626e-03 -4.045804e-02
      [122,]    8  7.000000e+00 -7.502448e-03  8.958034e-03  4.064733e-02
      [123,]    9  7.000000e+00  4.108727e-03  6.354810e-03  4.542111e-02
      [124,]   10  7.000000e+00 -1.934096e-03 -2.428218e-03 -2.328358e-02
      [125,]   11  7.000000e+00  1.484930e-03  5.091455e-04  1.601116e-02
      [126,]   12  7.000000e+00  7.904536e-03  6.739245e-03  9.612985e-03
      [127,]   13  7.000000e+00 -2.803204e-03  7.885662e-03 -3.364516e-02
      [128,]   14  7.000000e+00 -2.699075e-05 -2.144002e-03 -3.675064e-02
      [129,]   15  7.000000e+00 -7.918596e-03  8.369593e-03 -4.998203e-02
      [130,]   16  7.000000e+00  8.436244e-03  9.251521e-03 -4.502455e-02
      [131,]   17  7.000000e+00  3.841216e-03  4.769873e-03  3.259354e-02
      [132,]   18  7.000000e+00 -6.599277e-03  4.059189e-03  1.423421e-02
      [133,]   19  7.000000e+00  8.836028e-03  6.178087e-06 -4.185965e-02
      [134,]    1  8.000000e+00 -7.185206e-03  4.328919e-03 -2.739464e-02
      [135,]    2  8.000000e+00  4.310124e-03 -1.456172e-03  2.909594e-02
      [136,]    3  8.000000e+00  4.622817e-03  1.031921e-03 -4.407612e-02
      [137,]    4  8.000000e+00  5.809397e-03 -9.143837e-03 -2.522003e-02
      [138,]    5  8.000000e+00 -6.931980e-03 -8.742367e-03  3.201596e-03
      [139,]    6  8.000000e+00  4.908143e-03  1.693190e-03 -3.344076e-02
      [140,]    7  8.000000e+00 -8.764649e-03 -1.959514e-03 -1.009472e-02
      [141,]    8  8.000000e+00 -3.807404e-03  4.845282e-03  3.052443e-02
      [142,]    9  8.000000e+00  3.146600e-03 -6.554405e-03 -1.160597e-02
      [143,]   10  8.000000e+00 -2.722901e-03  1.999421e-03  3.792113e-02
      [144,]   11  8.000000e+00  4.236341e-03  6.138640e-03 -3.158116e-02
      [145,]   12  8.000000e+00  5.930592e-03 -2.953229e-03  1.444737e-06
      [146,]   13  8.000000e+00  7.717957e-03  3.678565e-03  4.780702e-02
      [147,]   14  8.000000e+00  2.287048e-03 -5.291641e-03 -1.786560e-02
      [148,]   15  8.000000e+00 -7.893594e-03 -2.556391e-03  8.289509e-03
      [149,]   16  8.000000e+00  7.580571e-03  8.455372e-03 -4.142237e-03
      [150,]   17  8.000000e+00 -1.732173e-03  1.921221e-03 -2.878036e-02
      [151,]   18  8.000000e+00 -7.956651e-03  5.660565e-03 -4.678112e-02
      [152,]   19  8.000000e+00  7.793690e-03  8.362482e-03 -7.248781e-03
      [153,]    1  9.000000e+00  2.156789e-03 -2.622270e-03 -2.387026e-02
      [154,]    2  9.000000e+00 -4.598033e-03 -3.761914e-03 -2.788312e-02
      [155,]    3  9.000000e+00  6.403200e-04 -3.424589e-03  2.355788e-02
      [156,]    4  9.000000e+00  3.778334e-03 -1.576951e-03  9.073966e-03
      [157,]    5  9.000000e+00  8.123461e-03 -8.401258e-03  1.385957e-02
      [158,]    6  9.000000e+00 -4.365574e-03 -5.754086e-03  4.566643e-02
      [159,]    7  9.000000e+00  3.578512e-03 -6.457054e-03  1.217832e-02
      [160,]    8  9.000000e+00 -8.379409e-03 -5.576639e-03 -2.136589e-02
      [161,]    9  9.000000e+00  5.790402e-03  3.483966e-03 -4.100529e-03
      [162,]   10  9.000000e+00 -3.646167e-03 -1.036426e-03 -3.363362e-02
      [163,]   11  9.000000e+00 -8.413463e-03  5.949426e-03  1.029730e-03
      [164,]   12  9.000000e+00  4.308330e-03 -4.055288e-03  7.640567e-03
      [165,]   13  9.000000e+00  6.575937e-04 -1.389019e-03  2.222287e-02
      [166,]   14  9.000000e+00 -2.723460e-03  5.716461e-04  5.950782e-03
      [167,]   15  9.000000e+00  2.572123e-03 -9.628675e-03  3.322597e-02
      [168,]   16  9.000000e+00 -8.137307e-03  3.277114e-03 -2.577741e-02
      [169,]   17  9.000000e+00  1.131358e-03  8.479375e-03 -4.813649e-03
      [170,]   18  9.000000e+00 -4.136042e-03 -4.065323e-03 -1.810236e-02
      [171,]   19  9.000000e+00 -5.872791e-03 -9.048134e-04  3.902698e-02
      [172,]    1  1.000000e+01 -1.989274e-03 -3.425837e-03  1.436196e-02
      [173,]    2  1.000000e+01 -4.335368e-03 -8.000005e-03  2.589669e-02
      [174,]    3  1.000000e+01 -2.534346e-03  6.258925e-03  3.991658e-02
      [175,]    4  1.000000e+01 -2.758228e-03  3.393085e-03  3.474310e-02
      [176,]    5  1.000000e+01  4.031213e-03  5.198048e-03  2.178738e-02
      [177,]    6  1.000000e+01  9.489326e-03 -5.371736e-03  1.391394e-02
      [178,]    7  1.000000e+01 -6.893556e-04 -6.351854e-03 -1.622641e-02
      [179,]    8  1.000000e+01  9.026438e-03  4.035104e-03 -4.215942e-02
      [180,]    9  1.000000e+01 -8.990504e-03 -2.861124e-03 -1.544534e-02
      [181,]   10  1.000000e+01 -6.022869e-03  8.776436e-03 -4.290784e-02
      [182,]   11  1.000000e+01 -3.076065e-04 -9.409343e-03 -4.012456e-03
      [183,]   12  1.000000e+01 -6.278473e-03  8.865740e-04 -1.207017e-02
      [184,]   13  1.000000e+01 -2.855995e-03  7.323564e-03  2.392500e-02
      [185,]   14  1.000000e+01  6.847265e-03 -1.705751e-03 -3.337082e-02
      [186,]   15  1.000000e+01  8.753897e-03  1.567409e-03 -1.450514e-02
      [187,]   16  1.000000e+01 -3.271805e-03  7.289348e-03 -4.277526e-02
      [188,]   17  1.000000e+01 -4.313401e-03 -6.672655e-03 -2.957142e-02
      [189,]   18  1.000000e+01 -6.255453e-03  3.815950e-03  1.864701e-02
      [190,]   19  1.000000e+01 -8.095944e-03  2.942335e-04  5.865818e-03
      [191,]    1  1.100000e+01 -3.959347e-03  2.685807e-03 -9.092460e-03
      [192,]    2  1.100000e+01  1.648695e-03 -7.040128e-03 -1.464067e-02
      [193,]    3  1.100000e+01 -2.208860e-03  4.762521e-03  6.559555e-04
      [194,]    4  1.100000e+01 -1.732378e-03  5.323742e-03  9.123974e-04
      [195,]    5  1.100000e+01 -7.560322e-03 -7.111525e-03  1.988204e-02
      [196,]    6  1.100000e+01 -5.353250e-03 -7.190495e-03  2.317451e-02
      [197,]    7  1.100000e+01 -4.059257e-03  2.728205e-03  1.936986e-02
      [198,]    8  1.100000e+01  6.526559e-03 -9.750771e-03  1.021051e-02
      [199,]    9  1.100000e+01  7.965984e-03 -4.987743e-03 -2.221891e-02
      [200,]   10  1.100000e+01 -9.313612e-03  9.793845e-04 -1.553250e-02
      [201,]   11  1.100000e+01 -9.362255e-03  7.940113e-03  2.984757e-02
      [202,]   12  1.100000e+01  2.499252e-03 -1.744993e-03  3.411384e-03
      [203,]   13  1.100000e+01  7.807261e-03 -3.194318e-03  8.514175e-03
      [204,]   14  1.100000e+01 -2.422849e-03  4.039531e-03  2.402575e-02
      [205,]   15  1.100000e+01  1.555406e-03 -1.827810e-03 -1.379349e-02
      [206,]   16  1.100000e+01  8.662333e-03 -6.056735e-03 -1.567895e-02
      [207,]   17  1.100000e+01 -1.923632e-03 -3.577160e-03 -3.803652e-02
      [208,]   18  1.100000e+01 -8.089308e-03  8.580138e-03  1.626677e-02
      [209,]   19  1.100000e+01  9.949015e-03  4.404908e-03 -2.913256e-02
      [210,]    1  1.200000e+01  3.053061e-03 -1.333212e-03 -3.116542e-02
      [211,]    2  1.200000e+01 -7.314230e-03 -8.796207e-03  4.537057e-03
      [212,]    3  1.200000e+01 -3.183824e-03 -5.968613e-03 -2.753074e-02
      [213,]    4  1.200000e+01  6.288714e-03 -9.336182e-04 -2.978112e-02
      [214,]    5  1.200000e+01 -8.988095e-03  2.295755e-03  3.389820e-02
      [215,]    6  1.200000e+01  5.787779e-03  5.862211e-03 -3.612796e-02
      [216,]    7  1.200000e+01 -2.719086e-03  6.992313e-03 -5.702680e-03
      [217,]    8  1.200000e+01 -4.737982e-04 -1.019514e-04 -1.836704e-02
      [218,]    9  1.200000e+01  6.114454e-03  2.215128e-03 -4.548412e-02
      [219,]   10  1.200000e+01  3.687395e-03 -6.888008e-03 -4.938652e-02
      [220,]   11  1.200000e+01 -9.190662e-03 -3.442055e-04  6.767121e-03
      [221,]   12  1.200000e+01 -6.961224e-03 -1.021214e-03  4.575589e-02
      [222,]   13  1.200000e+01 -8.401188e-04  1.894261e-03  3.026242e-02
      [223,]   14  1.200000e+01  6.185991e-03 -4.569165e-03 -2.203272e-02
      [224,]   15  1.200000e+01  4.665265e-03  7.422544e-03 -2.572107e-02
      [225,]   16  1.200000e+01 -7.771238e-03 -8.863161e-03 -1.736868e-02
      [226,]   17  1.200000e+01 -7.201051e-03 -2.767813e-03 -8.254937e-03
      [227,]   18  1.200000e+01  1.109557e-03  7.980463e-03 -2.628355e-03
      [228,]   19  1.200000e+01 -2.159565e-03 -2.786208e-03  1.052407e-02
      [229,]    1  1.300000e+01 -5.927098e-03  9.337891e-04 -4.656037e-02
      [230,]    2  1.300000e+01 -1.993570e-03 -2.674021e-03  2.746602e-02
      [231,]    3  1.300000e+01  1.291416e-03  6.161841e-03 -3.305347e-02
      [232,]    4  1.300000e+01  6.190910e-03 -2.380880e-03  2.058071e-02
      [233,]    5  1.300000e+01  5.017797e-03 -4.352470e-03 -2.243888e-02
      [234,]    6  1.300000e+01 -6.386814e-03 -7.617288e-04  4.207739e-02
      [235,]    7  1.300000e+01  7.080693e-03  4.045069e-03 -1.392473e-02
      [236,]    8  1.300000e+01  8.571925e-03  7.285794e-04 -2.141981e-02
      [237,]    9  1.300000e+01  6.885707e-03 -1.112248e-03 -7.021189e-03
      [238,]   10  1.300000e+01 -6.832592e-03 -5.171503e-03  4.598387e-02
      [239,]   11  1.300000e+01  9.081327e-03  3.161240e-03 -1.378928e-02
      [240,]   12  1.300000e+01 -2.452100e-03 -2.433089e-03  1.969493e-02
      [241,]   13  1.300000e+01 -4.505364e-04  4.876077e-03  3.483497e-02
      [242,]   14  1.300000e+01 -9.730280e-04 -7.385134e-03  2.907384e-02
      [243,]   15  1.300000e+01 -7.420903e-03  2.459800e-03  1.371125e-02
      [244,]   16  1.300000e+01 -3.837808e-03 -9.085466e-03 -2.013265e-02
      [245,]   17  1.300000e+01 -3.389438e-03 -2.135503e-03 -3.084027e-02
      [246,]   18  1.300000e+01 -4.694906e-03  7.456168e-03 -3.868453e-02
      [247,]   19  1.300000e+01  9.292101e-03  9.269159e-03  1.726326e-03
      [248,]    1  1.400000e+01  2.809439e-03  7.010324e-03  3.016054e-02
      [249,]    2  1.400000e+01  5.548812e-04 -9.771664e-03  3.947962e-02
      [250,]    3  1.400000e+01 -4.395632e-03 -9.475544e-03  2.612400e-02
      [251,]    4  1.400000e+01 -2.919785e-04  2.088122e-03  3.830163e-02
      [252,]    5  1.400000e+01  6.536049e-03  9.110802e-03  4.030351e-02
      [253,]    6  1.400000e+01  1.390530e-03  2.931319e-03 -3.075214e-02
      [254,]    7  1.400000e+01 -9.811379e-03 -3.037637e-03  2.825564e-02
      [255,]    8  1.400000e+01  7.485827e-03 -1.958815e-03  3.687231e-03
      [256,]    9  1.400000e+01 -8.037336e-03 -4.180963e-04  5.937318e-03
      [257,]   10  1.400000e+01 -7.564791e-03 -3.345936e-03 -3.891223e-02
      [258,]   11  1.400000e+01  2.760285e-03  2.106166e-03 -4.915326e-02
      [259,]   12  1.400000e+01 -2.836160e-03 -5.138136e-03  1.149312e-02
      [260,]   13  1.400000e+01 -3.222136e-03 -3.903976e-03 -1.708466e-02
      [261,]   14  1.400000e+01 -9.139869e-03 -5.951670e-03  2.145910e-03
      [262,]   15  1.400000e+01  3.456228e-03 -2.219871e-03 -2.224431e-02
      [263,]   16  1.400000e+01  4.444186e-03  2.983104e-03 -3.747981e-02
      [264,]   17  1.400000e+01 -9.760273e-03 -3.237790e-03 -2.936580e-02
      [265,]   18  1.400000e+01 -1.491733e-03 -9.473253e-03 -2.452042e-02
      [266,]   19  1.400000e+01  6.685134e-03  5.490189e-03 -1.861751e-02
      [267,]    1  1.500000e+01  7.112059e-03  8.317638e-04  3.227076e-02
      [268,]    2  1.500000e+01 -9.339865e-03 -6.732507e-03  1.698146e-02
      [269,]    3  1.500000e+01 -4.245543e-03  7.125508e-03  4.052699e-02
      [270,]    4  1.500000e+01 -5.747640e-03  4.033672e-03 -9.298904e-03
      [271,]    5  1.500000e+01  9.762612e-03  7.948379e-04 -1.551375e-03
      [272,]    6  1.500000e+01  5.082966e-03  3.780131e-03 -1.099064e-02
      [273,]    7  1.500000e+01  8.992155e-03  6.789074e-03  4.142531e-02
      [274,]    8  1.500000e+01  6.584313e-03 -7.909685e-03 -2.446827e-02
      [275,]    9  1.500000e+01 -8.053304e-04  7.031569e-03 -4.758606e-02
      [276,]   10  1.500000e+01 -2.856928e-03  2.369103e-03 -4.651402e-04
      [277,]   11  1.500000e+01  6.592752e-03 -5.785696e-04 -4.746333e-02
      [278,]   12  1.500000e+01 -9.892893e-03 -8.320918e-03  3.040590e-02
      [279,]   13  1.500000e+01  7.213955e-03  2.671022e-03 -4.718330e-02
      [280,]   14  1.500000e+01 -4.057860e-03 -7.259535e-03  1.494812e-02
      [281,]   15  1.500000e+01 -7.326619e-03 -6.283451e-03 -4.221738e-03
      [282,]   16  1.500000e+01  5.982906e-03 -3.549791e-03  3.731033e-02
      [283,]   17  1.500000e+01 -7.121738e-03  1.624180e-03 -4.333750e-02
      [284,]   18  1.500000e+01 -6.153689e-03 -3.173237e-03 -5.679760e-03
      [285,]   19  1.500000e+01 -4.530639e-03 -1.837188e-03  1.348684e-02
      [286,]    1  1.600000e+01 -2.977271e-03  5.819077e-03  1.485019e-02
      [287,]    2  1.600000e+01  6.951713e-04 -4.107218e-03 -4.501220e-02
      [288,]    3  1.600000e+01 -4.301289e-03  1.612727e-03  1.433110e-02
      [289,]    4  1.600000e+01 -6.387494e-03 -3.106765e-03  1.455981e-02
      [290,]    5  1.600000e+01  7.432062e-03 -5.205726e-03 -3.729943e-02
      [291,]    6  1.600000e+01 -9.960357e-03  8.921946e-03 -3.664081e-02
      [292,]    7  1.600000e+01 -2.554415e-03 -9.041786e-03 -4.065603e-02
      [293,]    8  1.600000e+01 -1.175548e-03 -4.654371e-04 -6.297873e-03
      [294,]    9  1.600000e+01 -5.152251e-03  7.707501e-03 -4.625811e-02
      [295,]   10  1.600000e+01 -5.468458e-03  1.476067e-03 -3.713206e-02
      [296,]   11  1.600000e+01  7.078435e-03  4.465915e-03  1.392627e-02
      [297,]   12  1.600000e+01 -3.612173e-03  1.213135e-03 -2.710864e-02
      [298,]   13  1.600000e+01  8.896829e-04  2.518088e-03 -1.909521e-02
      [299,]   14  1.600000e+01  9.429478e-03 -8.665436e-03 -3.333264e-02
      [300,]   15  1.600000e+01  3.597598e-03 -4.726525e-03 -2.350889e-02
      [301,]   16  1.600000e+01 -7.940527e-03  4.317620e-03  3.155377e-02
      [302,]   17  1.600000e+01  5.815264e-03  2.468865e-04  2.224099e-02
      [303,]   18  1.600000e+01  8.447204e-03 -7.573496e-03  4.653660e-02
      [304,]   19  1.600000e+01 -4.286200e-03  1.197882e-03  3.230525e-02
      [305,]    1  1.700000e+01 -9.988666e-03 -9.394548e-03  1.660479e-02
      [306,]    2  1.700000e+01 -7.137036e-03  9.222476e-03  2.903426e-03
      [307,]    3  1.700000e+01  3.127460e-04 -1.127845e-04  3.384094e-02
      [308,]    4  1.700000e+01 -2.467935e-03  7.690986e-03  3.966680e-02
      [309,]    5  1.700000e+01 -5.686786e-03  1.632591e-03  2.314145e-02
      [310,]    6  1.700000e+01 -7.016596e-03 -8.785331e-03 -8.618596e-05
      [311,]    7  1.700000e+01 -7.068782e-03 -5.418908e-03 -4.029880e-02
      [312,]    8  1.700000e+01  8.462850e-03  3.673432e-03  4.980999e-02
      [313,]    9  1.700000e+01 -1.039249e-03 -1.276375e-03  1.772390e-02
      [314,]   10  1.700000e+01 -7.789385e-03  3.980618e-03 -4.220014e-04
      [315,]   11  1.700000e+01 -1.731518e-03 -5.461563e-03  4.190222e-03
      [316,]   12  1.700000e+01  4.640812e-03 -8.452436e-03  3.202595e-02
      [317,]   13  1.700000e+01 -4.913826e-03 -9.329997e-03 -3.258464e-02
      [318,]   14  1.700000e+01 -6.317783e-03 -4.233597e-03 -2.502427e-02
      [319,]   15  1.700000e+01  4.546898e-03  8.618832e-03  2.228136e-02
      [320,]   16  1.700000e+01 -7.329898e-03  3.841355e-03  2.469313e-02
      [321,]   17  1.700000e+01  3.156973e-03  4.485796e-03 -2.446548e-02
      [322,]   18  1.700000e+01  1.402710e-03 -8.383547e-03  4.090000e-02
      [323,]   19  1.700000e+01  4.163981e-03 -7.348133e-04 -2.503988e-02
      [324,]    1  1.800000e+01 -3.784492e-03  8.886913e-03  3.567281e-03
      [325,]    2  1.800000e+01  6.764322e-03  3.720362e-03 -4.994604e-02
      [326,]    3  1.800000e+01 -9.219848e-03 -4.350904e-03  3.451284e-03
      [327,]    4  1.800000e+01  8.947567e-03  4.360508e-03 -2.568657e-02
      [328,]    5  1.800000e+01  5.449948e-03 -8.184809e-03  1.665835e-02
      [329,]    6  1.800000e+01 -3.219428e-03  2.312188e-03 -7.784689e-04
      [330,]    7  1.800000e+01  9.288966e-03 -8.782262e-03  4.800170e-03
      [331,]    8  1.800000e+01  3.586987e-03 -6.843370e-03 -1.267691e-02
      [332,]    9  1.800000e+01 -4.147651e-03 -8.441619e-03  2.163002e-02
      [333,]   10  1.800000e+01  7.488758e-04  8.044291e-03 -4.221882e-02
      [334,]   11  1.800000e+01 -2.371676e-03 -8.593162e-03  6.387561e-03
      [335,]   12  1.800000e+01  1.274808e-03  9.048052e-03 -2.755540e-02
      [336,]   13  1.800000e+01 -5.957310e-03  5.022304e-03 -1.837432e-02
      [337,]   14  1.800000e+01 -8.669652e-03  5.813386e-03  2.392649e-02
      [338,]   15  1.800000e+01 -3.270653e-03 -4.978115e-04  3.514697e-03
      [339,]   16  1.800000e+01  7.198392e-03 -3.781265e-03  3.119108e-02
      [340,]   17  1.800000e+01 -7.418030e-03 -5.854440e-03 -5.540429e-03
      [341,]   18  1.800000e+01 -9.927640e-03 -8.185530e-03  1.618475e-02
      [342,]   19  1.800000e+01  2.289039e-03 -6.097144e-03  9.456337e-03
      [343,]    1  1.900000e+01 -3.153726e-03 -6.614133e-03  4.957765e-02
      [344,]    2  1.900000e+01 -9.654501e-03 -7.498770e-03  6.347590e-03
      [345,]    3  1.900000e+01  8.348924e-03  6.822533e-03 -6.813395e-03
      [346,]    4  1.900000e+01  9.815200e-03  6.410245e-03 -2.170461e-02
      [347,]    5  1.900000e+01 -2.868335e-03 -7.715640e-03 -1.013966e-02
      [348,]    6  1.900000e+01 -7.793873e-03  5.352304e-03 -6.150014e-03
      [349,]    7  1.900000e+01 -1.010439e-03 -4.011615e-03  1.581000e-02
      [350,]    8  1.900000e+01 -6.769806e-03  7.927158e-03 -3.519517e-03
      [351,]    9  1.900000e+01  1.441549e-04  8.928919e-03 -1.422476e-02
      [352,]   10  1.900000e+01  7.171226e-03 -6.519079e-03 -4.483558e-03
      [353,]   11  1.900000e+01 -6.868655e-03 -8.631516e-03 -3.223102e-02
      [354,]   12  1.900000e+01  7.618252e-03  8.646982e-03  4.229882e-02
      [355,]   13  1.900000e+01 -3.530397e-04  2.897096e-03  2.437980e-02
      [356,]   14  1.900000e+01  5.424616e-03 -4.434600e-03 -3.771110e-02
      [357,]   15  1.900000e+01 -3.073482e-03  2.054127e-03 -2.464664e-02
      [358,]   16  1.900000e+01 -8.715833e-03 -8.993642e-03  2.867190e-02
      [359,]   17  1.900000e+01 -1.407769e-04 -5.311832e-03  9.037591e-03
      [360,]   18  1.900000e+01 -8.524857e-04  1.610883e-03 -3.101351e-02
      [361,]   19  1.900000e+01  6.141171e-03  8.784747e-03  1.389445e-02
      [362,]    1  4.719050e-03  1.000000e+00  7.121565e-03 -4.937113e-02
      [363,]    2  2.184780e-03  1.000000e+00 -9.518970e-03 -2.616510e-02
      [364,]    3 -9.260203e-03  1.000000e+00 -4.829693e-03  1.585941e-02
      [365,]    4 -5.324397e-03  1.000000e+00 -7.505171e-03  3.534739e-02
      [366,]    5  8.527036e-04  1.000000e+00 -9.361616e-03 -4.894152e-02
      [367,]    6  5.223168e-03  1.000000e+00  7.557629e-03  1.911558e-02
      [368,]    7 -8.710902e-03  1.000000e+00  9.807455e-03 -4.030151e-02
      [369,]    8  2.249607e-03  1.000000e+00  3.393233e-04  4.596931e-02
      [370,]    9  5.734180e-03  1.000000e+00  3.515476e-03 -4.382092e-02
      [371,]   10 -2.970875e-03  1.000000e+00 -2.117157e-03  2.556041e-02
      [372,]   11 -8.248991e-03  1.000000e+00  7.559761e-03 -1.820583e-02
      [373,]   12  7.699294e-03  1.000000e+00  1.834826e-03  3.313954e-02
      [374,]   13  8.070712e-03  1.000000e+00 -9.057311e-03  2.516389e-02
      [375,]   14 -8.876201e-03  1.000000e+00 -5.255012e-03  1.211432e-02
      [376,]   15 -3.828059e-03  1.000000e+00  4.960460e-03 -1.358386e-02
      [377,]   16  1.765430e-03  1.000000e+00  3.727356e-03 -6.448415e-03
      [378,]   17 -1.381279e-03  1.000000e+00  8.856493e-03  2.990380e-02
      [379,]   18  5.000991e-03  1.000000e+00  6.618167e-03 -2.130271e-02
      [380,]   19 -6.972830e-03  1.000000e+00  1.241114e-04  4.476727e-02
      [381,]    1 -6.414732e-03  2.000000e+00  2.549877e-03 -4.042377e-02
      [382,]    2 -2.952841e-03  2.000000e+00  5.113155e-03  3.276544e-03
      [383,]    3  2.974263e-04  2.000000e+00 -5.408926e-04  1.509542e-02
      [384,]    4  6.229766e-03  2.000000e+00 -3.431356e-03 -3.147555e-02
      [385,]    5 -7.861248e-03  2.000000e+00  5.106738e-03 -2.269256e-02
      [386,]    6  2.584182e-03  2.000000e+00 -2.684442e-03  1.415252e-02
      [387,]    7  6.876220e-03  2.000000e+00 -4.270484e-03 -1.119100e-04
      [388,]    8 -7.346659e-03  2.000000e+00 -8.871276e-03  2.043492e-02
      [389,]    9  1.557158e-03  2.000000e+00 -6.960300e-03  4.888483e-02
      [390,]   10 -7.551974e-03  2.000000e+00  1.468553e-03  2.145869e-02
      [391,]   11  5.635559e-03  2.000000e+00 -1.502855e-03  1.532614e-02
      [392,]   12 -2.129707e-03  2.000000e+00  3.995790e-03  1.956015e-02
      [393,]   13 -8.844936e-03  2.000000e+00  4.274365e-03 -2.077103e-02
      [394,]   14 -8.818969e-04  2.000000e+00 -1.741195e-03 -2.898717e-02
      [395,]   15 -5.531683e-03  2.000000e+00  3.463503e-03 -4.298932e-02
      [396,]   16 -1.328320e-03  2.000000e+00 -8.955959e-03  4.286987e-02
      [397,]   17  5.024899e-03  2.000000e+00  8.380865e-03 -9.771545e-04
      [398,]   18  9.911261e-03  2.000000e+00  4.015975e-03  1.950709e-02
      [399,]   19  6.293679e-04  2.000000e+00 -6.231887e-03 -9.352862e-03
      [400,]    1 -1.966258e-03  3.000000e+00 -4.617252e-03 -4.308087e-02
      [401,]    2  5.428778e-03  3.000000e+00  6.661480e-03 -4.677090e-02
      [402,]    3  8.004948e-03  3.000000e+00  8.831003e-03 -3.476164e-02
      [403,]    4 -6.835594e-03  3.000000e+00 -7.669115e-03  8.730871e-03
      [404,]    5 -1.138257e-03  3.000000e+00  4.618348e-03 -4.504072e-02
      [405,]    6 -4.319614e-03  3.000000e+00 -1.667781e-03  6.780303e-03
      [406,]    7  1.614245e-03  3.000000e+00  7.624110e-03  2.882522e-02
      [407,]    8 -8.782634e-04  3.000000e+00  7.467307e-06 -3.816602e-03
      [408,]    9  9.543025e-04  3.000000e+00 -9.448559e-03  4.861056e-02
      [409,]   10 -3.174142e-03  3.000000e+00 -3.788072e-03  2.160100e-03
      [410,]   11 -7.271945e-03  3.000000e+00  1.586975e-03 -6.936142e-03
      [411,]   12  2.266740e-03  3.000000e+00  4.942988e-03 -2.273453e-02
      [412,]   13 -4.577580e-03  3.000000e+00 -1.803178e-03  2.043049e-02
      [413,]   14  1.332218e-03  3.000000e+00 -4.238139e-04 -8.681279e-03
      [414,]   15  7.189330e-03  3.000000e+00  5.725031e-03 -1.762661e-02
      [415,]   16  6.919522e-03  3.000000e+00 -9.874436e-03 -4.465917e-02
      [416,]   17  1.159072e-03  3.000000e+00  2.379983e-04  1.165084e-02
      [417,]   18 -3.313073e-03  3.000000e+00 -2.104690e-03  3.651556e-02
      [418,]   19 -2.030413e-03  3.000000e+00  2.838945e-03 -4.107493e-02
      [419,]    1  9.740572e-03  4.000000e+00 -7.790841e-03  3.489026e-04
      [420,]    2  2.305015e-03  4.000000e+00  3.215552e-03 -8.349610e-03
      [421,]    3  8.888612e-03  4.000000e+00  7.039901e-03  9.278252e-03
      [422,]    4  1.654222e-03  4.000000e+00 -8.612470e-03  4.260002e-02
      [423,]    5 -7.208670e-03  4.000000e+00 -5.355847e-03  2.550407e-02
      [424,]    6 -8.384901e-03  4.000000e+00  6.740230e-03  1.728088e-04
      [425,]    7 -6.927158e-03  4.000000e+00 -1.525651e-03  2.896951e-03
      [426,]    8 -1.125888e-03  4.000000e+00  2.949451e-04  4.934212e-02
      [427,]    9 -7.473087e-04  4.000000e+00  4.238079e-03  8.792619e-03
      [428,]   10 -2.935396e-03  4.000000e+00  2.536762e-03  3.234848e-02
      [429,]   11 -4.377720e-04  4.000000e+00  2.692013e-03  3.889366e-02
      [430,]   12 -4.500235e-04  4.000000e+00 -3.097492e-03  1.614205e-02
      [431,]   13  1.673121e-03  4.000000e+00 -4.615636e-03  4.051367e-02
      [432,]   14  4.696026e-03  4.000000e+00  8.435945e-03  3.401311e-02
      [433,]   15  3.010851e-03  4.000000e+00  9.658966e-03  1.649366e-02
      [434,]   16  3.697113e-03  4.000000e+00  4.144166e-03 -4.424764e-02
      [435,]   17 -7.912113e-03  4.000000e+00  7.400118e-03 -2.774106e-02
      [436,]   18  6.952831e-03  4.000000e+00 -5.365917e-03 -3.729462e-02
      [437,]   19 -8.033111e-03  4.000000e+00  1.002052e-03  2.926491e-02
      [438,]    1  6.784981e-03  5.000000e+00  4.277629e-03  4.189435e-02
      [439,]    2 -1.878618e-03  5.000000e+00  6.768426e-03  1.767774e-02
      [440,]    3 -2.787606e-03  5.000000e+00 -4.763285e-03 -1.790605e-02
      [441,]    4 -4.451094e-03  5.000000e+00 -7.483446e-03 -1.063573e-03
      [442,]    5 -5.476424e-03  5.000000e+00 -4.971694e-03 -1.953979e-02
      [443,]    6  6.146959e-03  5.000000e+00 -2.919472e-04 -6.052435e-03
      [444,]    7 -4.991987e-03  5.000000e+00 -9.370885e-04 -2.008441e-02
      [445,]    8 -8.048586e-03  5.000000e+00 -8.042054e-03 -6.385177e-03
      [446,]    9  9.243947e-03  5.000000e+00  8.624782e-03 -4.789999e-02
      [447,]   10 -7.864473e-03  5.000000e+00  2.990224e-03  1.113657e-02
      [448,]   11  4.798042e-03  5.000000e+00 -2.245910e-03  3.635667e-02
      [449,]   12 -9.752597e-03  5.000000e+00  9.442817e-03  2.542376e-02
      [450,]   13 -1.114155e-03  5.000000e+00 -9.408891e-03  2.214781e-02
      [451,]   14  7.438722e-03  5.000000e+00  1.368544e-03  8.309937e-03
      [452,]   15  8.728125e-03  5.000000e+00  2.573295e-03  2.698273e-02
      [453,]   16  7.815505e-03  5.000000e+00 -6.719574e-03 -1.891075e-02
      [454,]   17  4.549356e-03  5.000000e+00 -8.968097e-03 -3.650853e-02
      [455,]   18 -5.528222e-03  5.000000e+00 -8.482178e-03 -3.939030e-02
      [456,]   19  8.937630e-03  5.000000e+00 -6.742824e-03  3.501267e-02
      [457,]    1  3.269954e-04  6.000000e+00 -3.318038e-03 -4.003563e-02
      [458,]    2 -4.802787e-03  6.000000e+00 -4.000088e-03  2.339343e-02
      [459,]    3  3.625321e-03  6.000000e+00  3.380679e-03  3.131715e-02
      [460,]    4 -9.844647e-03  6.000000e+00 -1.992372e-03 -3.843496e-02
      [461,]    5 -6.598407e-03  6.000000e+00 -5.776684e-03 -3.850678e-03
      [462,]    6  1.294873e-03  6.000000e+00 -5.860409e-03  3.007830e-02
      [463,]    7  8.447220e-03  6.000000e+00 -8.677449e-03  8.006866e-03
      [464,]    8 -6.896963e-03  6.000000e+00  2.050726e-04 -3.881110e-02
      [465,]    9  6.105331e-03  6.000000e+00  1.389486e-03  2.242328e-02
      [466,]   10  4.623349e-03  6.000000e+00 -6.214614e-03  2.908962e-03
      [467,]   11 -3.885720e-03  6.000000e+00 -5.966119e-03 -2.101866e-02
      [468,]   12 -3.437781e-05  6.000000e+00 -7.174928e-04 -4.872209e-02
      [469,]   13  6.809614e-03  6.000000e+00  7.325672e-03  6.335303e-03
      [470,]   14 -4.743897e-03  6.000000e+00 -5.114260e-03  2.416729e-02
      [471,]   15  8.685195e-05  6.000000e+00 -9.641201e-03 -4.103958e-03
      [472,]   16 -9.647035e-03  6.000000e+00 -9.941167e-03  3.720816e-02
      [473,]   17 -3.929841e-03  6.000000e+00  2.424278e-03 -2.364207e-02
      [474,]   18  3.896715e-03  6.000000e+00  6.588650e-03 -7.637792e-04
      [475,]   19 -3.184997e-03  6.000000e+00  2.516530e-03  1.632639e-02
      [476,]    1  4.913338e-03  7.000000e+00 -3.139829e-05 -4.858008e-02
      [477,]    2 -9.575573e-03  7.000000e+00 -3.082767e-03  3.462471e-02
      [478,]    3  4.386039e-04  7.000000e+00  6.712303e-03 -3.244711e-02
      [479,]    4  8.335769e-03  7.000000e+00 -1.373662e-03 -2.806393e-03
      [480,]    5 -4.632210e-03  7.000000e+00  5.228171e-03 -3.658441e-02
      [481,]    6 -5.246019e-03  7.000000e+00  4.642238e-03 -9.543710e-03
      [482,]    7  7.406355e-03  7.000000e+00 -8.303129e-03  3.203271e-02
      [483,]    8  6.926338e-03  7.000000e+00  1.372496e-03  9.442801e-03
      [484,]    9 -8.203907e-03  7.000000e+00  7.645477e-03 -1.677126e-02
      [485,]   10 -3.321042e-03  7.000000e+00  5.363035e-03  4.558632e-02
      [486,]   11  6.110416e-03  7.000000e+00 -7.033514e-03  4.238090e-02
      [487,]   12  4.913510e-03  7.000000e+00  8.350512e-04  1.848536e-02
      [488,]   13  6.909102e-03  7.000000e+00 -9.245942e-03 -2.231539e-02
      [489,]   14  7.017190e-05  7.000000e+00  6.386577e-03 -4.757411e-02
      [490,]   15  6.811405e-04  7.000000e+00 -3.352984e-03  1.067789e-02
      [491,]   16  2.372507e-04  7.000000e+00  7.053812e-03  4.042701e-02
      [492,]   17  2.192069e-03  7.000000e+00  6.175208e-03  4.034660e-03
      [493,]   18 -4.243876e-03  7.000000e+00  2.140159e-03  3.870926e-02
      [494,]   19  4.351080e-03  7.000000e+00  6.459496e-03 -3.357774e-02
      [495,]    1  3.834150e-03  8.000000e+00  9.084246e-03 -3.488080e-02
      [496,]    2 -8.846689e-03  8.000000e+00  3.311787e-03 -2.413755e-02
      [497,]    3  4.390183e-03  8.000000e+00  3.495426e-04  3.840204e-02
      [498,]    4  9.906225e-03  8.000000e+00 -6.588879e-03  1.484996e-02
      [499,]    5 -2.276813e-03  8.000000e+00  9.126518e-03  4.090407e-02
      [500,]    6 -3.101797e-03  8.000000e+00  7.070281e-04 -3.239419e-02
      [501,]    7  8.020438e-03  8.000000e+00  3.157866e-03 -4.962991e-02
      [502,]    8 -3.269894e-03  8.000000e+00  8.565903e-03 -1.054196e-02
      [503,]    9  8.507957e-03  8.000000e+00 -9.754369e-03 -3.209140e-02
      [504,]   10 -9.617963e-03  8.000000e+00 -2.401945e-03  3.592445e-02
      [505,]   11 -6.162168e-03  8.000000e+00  5.827555e-03  3.726563e-02
      [506,]   12  1.438103e-03  8.000000e+00 -2.448532e-03 -2.661149e-02
      [507,]   13 -8.255804e-03  8.000000e+00  3.493280e-03  4.943967e-03
      [508,]   14  4.809198e-03  8.000000e+00 -2.991725e-03 -3.690188e-02
      [509,]   15  3.867533e-03  8.000000e+00  6.365806e-03  2.558621e-02
      [510,]   16 -8.479927e-03  8.000000e+00  2.170962e-05  2.692998e-02
      [511,]   17  3.699545e-03  8.000000e+00  6.600702e-03 -2.761597e-02
      [512,]   18  3.979691e-03  8.000000e+00 -7.106479e-03 -1.498543e-02
      [513,]   19  2.338595e-03  8.000000e+00  4.711215e-04 -3.445429e-02
      [514,]    1 -4.645510e-03  9.000000e+00 -4.962766e-03 -2.703413e-02
      [515,]    2  3.854042e-03  9.000000e+00  8.889458e-03  2.812390e-02
      [516,]    3  6.402538e-03  9.000000e+00  6.769537e-03 -4.569461e-02
      [517,]    4  1.639111e-03  9.000000e+00  7.970074e-03  2.798526e-02
      [518,]    5  6.270930e-03  9.000000e+00  4.434012e-03 -2.466477e-02
      [519,]    6 -4.885500e-03  9.000000e+00  4.801545e-03  4.446746e-02
      [520,]    7  3.035768e-03  9.000000e+00  7.213759e-04  4.352216e-02
      [521,]    8  7.028179e-03  9.000000e+00 -6.160456e-03 -8.835073e-03
      [522,]    9 -4.301648e-03  9.000000e+00 -5.073485e-03  3.263325e-02
      [523,]   10 -5.456970e-04  9.000000e+00 -2.694222e-03 -7.839162e-03
      [524,]   11 -7.742404e-03  9.000000e+00 -8.088663e-03  6.331712e-03
      [525,]   12 -4.556764e-03  9.000000e+00 -1.192388e-03  2.226424e-02
      [526,]   13 -5.024815e-03  9.000000e+00  8.739367e-03  1.420945e-02
      [527,]   14  9.298652e-03  9.000000e+00  7.057752e-03  4.693771e-02
      [528,]   15 -3.990156e-03  9.000000e+00 -7.934177e-03  3.325703e-02
      [529,]   16  5.130297e-03  9.000000e+00 -2.562161e-03 -1.769548e-02
      [530,]   17  8.117338e-03  9.000000e+00 -1.268018e-03  1.571661e-02
      [531,]   18 -5.746332e-04  9.000000e+00 -4.271594e-03  3.468879e-02
      [532,]   19 -8.885512e-03  9.000000e+00  3.726241e-03  4.463916e-02
      [533,]    1  9.822231e-03  1.000000e+01  4.895750e-03 -1.481807e-02
      [534,]    2  8.330926e-03  1.000000e+01 -7.469659e-03 -8.362405e-03
      [535,]    3  6.839723e-03  1.000000e+01  8.677236e-04 -4.047060e-02
      [536,]    4  1.726179e-03  1.000000e+01  8.563107e-03  2.106157e-03
      [537,]    5 -2.154987e-03  1.000000e+01 -1.048945e-04  3.426053e-02
      [538,]    6 -3.003085e-03  1.000000e+01  3.856202e-03 -3.972092e-02
      [539,]    7 -6.499698e-03  1.000000e+01 -7.136235e-03  2.241082e-02
      [540,]    8  7.152015e-03  1.000000e+01 -4.451619e-03 -7.425372e-04
      [541,]    9  3.701359e-03  1.000000e+01  7.964761e-03  1.977467e-02
      [542,]   10 -5.421063e-03  1.000000e+01  8.340821e-03 -2.400050e-02
      [543,]   11 -4.471364e-03  1.000000e+01  7.430361e-03  8.489766e-03
      [544,]   12 -7.201184e-03  1.000000e+01 -8.440140e-03 -1.861546e-02
      [545,]   13  2.140482e-03  1.000000e+01  5.037655e-04 -1.966067e-02
      [546,]   14 -3.637172e-03  1.000000e+01 -7.318078e-03 -4.767330e-02
      [547,]   15 -5.631340e-03  1.000000e+01  7.433207e-03 -7.978885e-03
      [548,]   16  7.657615e-04  1.000000e+01 -6.436257e-03 -9.636001e-03
      [549,]   17  8.188556e-03  1.000000e+01  5.501597e-03  4.228494e-02
      [550,]   18 -6.501867e-03  1.000000e+01 -3.402120e-03  9.634535e-03
      [551,]   19  4.106512e-03  1.000000e+01  6.117549e-03  1.172297e-02
      [552,]    1  7.118616e-03  1.100000e+01  5.083098e-03 -3.513113e-02
      [553,]    2 -9.756129e-03  1.100000e+01 -5.289158e-03  5.242316e-03
      [554,]    3 -8.963838e-03  1.100000e+01  7.593421e-04 -3.536907e-02
      [555,]    4  8.795104e-03  1.100000e+01 -4.482100e-03 -1.453367e-02
      [556,]    5 -7.220617e-03  1.100000e+01 -6.551829e-03  2.585763e-02
      [557,]    6  4.262828e-03  1.100000e+01 -2.060307e-03  3.735815e-02
      [558,]    7 -7.273596e-04  1.100000e+01 -5.697836e-03  4.830091e-02
      [559,]    8 -6.804379e-03  1.100000e+01  9.617557e-03 -3.998022e-02
      [560,]    9 -6.098874e-03  1.100000e+01  6.183346e-03 -4.609395e-02
      [561,]   10  1.704101e-03  1.100000e+01 -5.558815e-03  4.031427e-02
      [562,]   11 -7.345323e-03  1.100000e+01 -3.214119e-03 -6.959813e-03
      [563,]   12 -5.284339e-03  1.100000e+01  8.890253e-05 -8.474371e-03
      [564,]   13 -1.828949e-03  1.100000e+01  1.070092e-03  1.238320e-02
      [565,]   14  1.189915e-03  1.100000e+01 -6.296524e-03 -3.963503e-02
      [566,]   15 -5.632388e-03  1.100000e+01 -3.371627e-03  2.582052e-02
      [567,]   16  3.453919e-04  1.100000e+01  2.421324e-04  3.666144e-02
      [568,]   17 -5.139669e-03  1.100000e+01  9.700813e-03 -1.732156e-02
      [569,]   18 -9.934118e-03  1.100000e+01  7.281134e-03  2.340045e-02
      [570,]   19  1.027050e-03  1.100000e+01 -8.911240e-03  2.269575e-02
      [571,]    1 -5.471567e-03  1.200000e+01 -1.243818e-03  3.797933e-03
      [572,]    2 -2.318309e-03  1.200000e+01 -8.190202e-04  1.362773e-02
      [573,]    3  5.281280e-03  1.200000e+01 -1.302994e-03  4.035808e-02
      [574,]    4  3.970587e-03  1.200000e+01  7.214195e-03 -3.633839e-02
      [575,]    5 -4.877196e-05  1.200000e+01 -7.223807e-03 -3.677719e-02
      [576,]    6 -1.061936e-03  1.200000e+01  8.354762e-03  1.550856e-02
      [577,]    7 -7.244590e-03  1.200000e+01 -7.374214e-03  3.366331e-02
      [578,]    8 -3.877052e-03  1.200000e+01 -6.179174e-03 -1.305279e-02
      [579,]    9  1.865031e-03  1.200000e+01 -9.683892e-03 -4.472780e-02
      [580,]   10 -4.974391e-03  1.200000e+01 -6.959177e-03 -4.157727e-02
      [581,]   11  9.461054e-03  1.200000e+01 -1.553048e-03  3.654747e-02
      [582,]   12  4.779549e-03  1.200000e+01  1.698602e-03  8.391661e-03
      [583,]   13 -5.295543e-03  1.200000e+01 -8.734675e-03 -3.075708e-02
      [584,]   14 -3.781181e-03  1.200000e+01  3.466970e-03  4.582797e-02
      [585,]   15 -6.995083e-03  1.200000e+01 -4.154600e-03 -2.128738e-02
      [586,]   16  9.143709e-03  1.200000e+01 -3.162253e-04 -3.296850e-02
      [587,]   17  2.161069e-03  1.200000e+01  5.157060e-03  1.197620e-02
      [588,]   18 -8.553565e-03  1.200000e+01 -8.317120e-03  2.961024e-02
      [589,]   19  3.107808e-03  1.200000e+01  6.478801e-03 -2.207589e-02
      [590,]    1 -2.052549e-03  1.300000e+01 -7.142680e-04  1.073866e-02
      [591,]    2 -5.087794e-03  1.300000e+01  5.609875e-03  4.914543e-02
      [592,]    3 -3.561989e-03  1.300000e+01 -3.271278e-03 -1.332064e-02
      [593,]    4 -2.106730e-03  1.300000e+01  2.918022e-03 -3.006807e-02
      [594,]    5 -5.939605e-03  1.300000e+01 -3.792883e-03  3.601301e-02
      [595,]    6 -2.636468e-03  1.300000e+01  1.611428e-03  3.833162e-02
      [596,]    7 -4.422069e-03  1.300000e+01  8.387588e-03 -1.026528e-02
      [597,]    8 -3.899120e-03  1.300000e+01  1.877439e-03  1.289836e-02
      [598,]    9  6.862048e-03  1.300000e+01  1.470605e-03  4.407485e-02
      [599,]   10 -7.095820e-03  1.300000e+01  8.098518e-03 -4.882801e-02
      [600,]   11 -9.110619e-03  1.300000e+01  2.971400e-03  3.762259e-02
      [601,]   12  8.892672e-03  1.300000e+01 -4.607844e-03  3.554593e-02
      [602,]   13 -5.563822e-03  1.300000e+01 -3.916161e-03 -3.598521e-02
      [603,]   14 -2.004112e-03  1.300000e+01  4.878608e-03 -4.125677e-02
      [604,]   15  4.158302e-03  1.300000e+01 -2.415293e-03  1.704831e-02
      [605,]   16  3.880426e-03  1.300000e+01  2.993973e-03  2.232142e-02
      [606,]   17 -8.405715e-03  1.300000e+01  4.469117e-04  3.989344e-02
      [607,]   18  2.874731e-03  1.300000e+01 -5.673328e-03  3.035974e-02
      [608,]   19  9.423332e-03  1.300000e+01 -9.762122e-03 -2.691487e-02
      [609,]    1  2.221175e-04  1.400000e+01  9.870467e-03  3.252347e-02
      [610,]    2  6.478035e-03  1.400000e+01  2.828163e-03 -4.060526e-02
      [611,]    3  2.678459e-03  1.400000e+01  1.433900e-03  4.295171e-02
      [612,]    4  9.290593e-03  1.400000e+01 -6.081174e-03  3.730394e-02
      [613,]    5  2.385461e-03  1.400000e+01 -6.402705e-03  2.356179e-02
      [614,]    6  4.232371e-03  1.400000e+01 -8.205720e-03  4.657178e-02
      [615,]    7  3.263288e-03  1.400000e+01  8.022395e-03  3.589794e-02
      [616,]    8  3.093206e-03  1.400000e+01  7.646953e-04  1.935289e-02
      [617,]    9 -1.388316e-04  1.400000e+01 -2.980328e-03  9.377028e-03
      [618,]   10  5.319908e-03  1.400000e+01 -9.875608e-03 -3.820919e-03
      [619,]   11 -3.293430e-03  1.400000e+01  5.951792e-03 -3.765107e-02
      [620,]   12  8.678982e-03  1.400000e+01 -9.768151e-03 -4.706944e-02
      [621,]   13 -4.291879e-03  1.400000e+01 -3.717920e-03 -2.254395e-02
      [622,]   14  1.195546e-03  1.400000e+01  1.760280e-03 -3.094709e-03
      [623,]   15 -6.637059e-03  1.400000e+01  2.678552e-04  2.087131e-02
      [624,]   16 -2.499874e-03  1.400000e+01  3.529488e-03  4.131867e-02
      [625,]   17  1.306013e-03  1.400000e+01  5.404252e-04 -1.286176e-03
      [626,]   18 -8.228348e-03  1.400000e+01 -8.181239e-03  1.197071e-02
      [627,]   19 -4.956899e-03  1.400000e+01 -1.277069e-03  9.529484e-03
      [628,]    1  8.705372e-03  1.500000e+01 -7.371809e-03 -4.562203e-02
      [629,]    2 -9.178463e-03  1.500000e+01  7.006224e-03 -3.303392e-02
      [630,]    3  9.234017e-04  1.500000e+01 -1.645596e-03 -2.524656e-02
      [631,]    4  9.015292e-03  1.500000e+01  8.636643e-03 -1.576156e-02
      [632,]    5  1.188030e-03  1.500000e+01 -8.537773e-03  5.870919e-03
      [633,]    6 -1.637673e-03  1.500000e+01  7.090920e-03 -2.989053e-02
      [634,]    7 -6.092026e-03  1.500000e+01 -4.619721e-03 -4.711720e-02
      [635,]    8 -4.165926e-04  1.500000e+01 -6.754211e-03 -1.398463e-02
      [636,]    9 -6.095632e-03  1.500000e+01 -7.426737e-03  2.193298e-02
      [637,]   10  8.515316e-03  1.500000e+01 -5.008155e-03  1.853059e-02
      [638,]   11 -2.283199e-03  1.500000e+01 -4.404289e-03  2.594361e-02
      [639,]   12 -4.674814e-03  1.500000e+01  5.152397e-03 -3.207162e-02
      [640,]   13  6.781931e-03  1.500000e+01  8.216286e-03 -1.228585e-02
      [641,]   14 -8.287549e-03  1.500000e+01  9.773805e-03 -7.564024e-03
      [642,]   15 -7.483058e-03  1.500000e+01 -4.140785e-03 -3.610054e-02
      [643,]   16  8.078887e-03  1.500000e+01  4.958551e-03  2.209594e-02
      [644,]   17  5.690709e-03  1.500000e+01  7.507370e-03  1.480265e-02
      [645,]   18  2.868031e-03  1.500000e+01 -8.948176e-03 -6.797089e-03
      [646,]   19  3.017950e-03  1.500000e+01 -9.643118e-03  1.226375e-02
      [647,]    1 -5.893326e-03  1.600000e+01 -7.598340e-03  2.143220e-04
      [648,]    2 -5.374545e-03  1.600000e+01 -4.929457e-03  9.526145e-03
      [649,]    3  4.900201e-03  1.600000e+01 -1.677600e-03 -3.835115e-02
      [650,]    4  6.472190e-03  1.600000e+01 -5.322725e-03  2.853751e-02
      [651,]    5 -5.668141e-03  1.600000e+01  3.588168e-03  1.578832e-02
      [652,]    6  2.035218e-03  1.600000e+01  7.774503e-03 -5.088801e-03
      [653,]    7 -9.902021e-04  1.600000e+01 -8.749547e-03  3.453331e-02
      [654,]    8 -1.865827e-03  1.600000e+01 -5.359288e-03  4.556198e-02
      [655,]    9  1.847140e-03  1.600000e+01 -7.466373e-03 -9.688747e-03
      [656,]   10  2.848897e-03  1.600000e+01  2.593664e-03  1.732829e-02
      [657,]   11  5.531873e-03  1.600000e+01 -7.577421e-03 -1.162753e-02
      [658,]   12 -4.715045e-03  1.600000e+01  3.095226e-03  1.120910e-02
      [659,]   13 -1.849421e-04  1.600000e+01  9.396330e-03  4.187839e-02
      [660,]   14  4.453066e-03  1.600000e+01  7.712582e-03 -2.660367e-03
      [661,]   15  2.175273e-03  1.600000e+01 -1.751532e-03 -3.725421e-02
      [662,]   16 -9.811651e-04  1.600000e+01 -5.722064e-03 -4.334503e-02
      [663,]   17 -4.910103e-03  1.600000e+01  5.681892e-03  1.924035e-02
      [664,]   18 -3.290559e-04  1.600000e+01  1.073915e-03 -3.380902e-02
      [665,]   19 -4.676059e-03  1.600000e+01 -6.454179e-03 -4.038754e-02
      [666,]    1 -9.207879e-03  1.700000e+01 -7.085446e-03  2.806323e-03
      [667,]    2  6.657348e-03  1.700000e+01 -7.078398e-04  2.982517e-02
      [668,]    3  8.129148e-03  1.700000e+01 -2.797693e-03  3.282359e-03
      [669,]    4 -2.596368e-03  1.700000e+01 -7.216217e-03 -2.443474e-03
      [670,]    5 -2.762491e-04  1.700000e+01  9.874102e-04 -3.750777e-02
      [671,]    6 -1.982836e-03  1.700000e+01  9.791371e-03  4.663574e-02
      [672,]    7 -5.061052e-04  1.700000e+01 -7.394795e-03  3.321190e-02
      [673,]    8 -5.459230e-03  1.700000e+01  5.363622e-03 -4.447182e-02
      [674,]    9  9.954721e-03  1.700000e+01  7.615855e-03 -1.620424e-02
      [675,]   10 -7.476966e-03  1.700000e+01 -1.539400e-03 -2.974086e-02
      [676,]   11 -3.563791e-03  1.700000e+01 -4.610645e-03 -4.994478e-02
      [677,]   12  5.819334e-03  1.700000e+01 -8.600674e-03 -1.321127e-02
      [678,]   13  7.531427e-03  1.700000e+01  9.691225e-03  1.029813e-02
      [679,]   14 -2.444505e-03  1.700000e+01  5.139707e-03  3.239072e-02
      [680,]   15 -4.150418e-03  1.700000e+01  2.085742e-03 -4.812774e-02
      [681,]   16  9.797493e-03  1.700000e+01  8.876084e-03  3.531598e-02
      [682,]   17 -6.385459e-03  1.700000e+01  1.506199e-03 -2.903111e-02
      [683,]   18  4.694689e-03  1.700000e+01  5.739632e-03 -3.703878e-02
      [684,]   19  7.855978e-03  1.700000e+01 -2.028377e-04 -2.702799e-02
      [685,]    1  8.243424e-03  1.800000e+01  1.635366e-03 -4.150694e-02
      [686,]    2 -7.856995e-03  1.800000e+01  9.383784e-03 -2.514183e-02
      [687,]    3  7.405071e-03  1.800000e+01  2.009945e-04  4.760427e-02
      [688,]    4  2.907912e-03  1.800000e+01 -1.518133e-03 -4.139118e-03
      [689,]    5  3.023339e-03  1.800000e+01 -2.358417e-03 -3.037990e-02
      [690,]    6 -4.170171e-03  1.800000e+01 -6.236670e-03  6.054004e-03
      [691,]    7  5.262552e-03  1.800000e+01 -9.911832e-03  2.109246e-02
      [692,]    8  7.848877e-03  1.800000e+01  3.946121e-03 -3.303767e-02
      [693,]    9  7.925215e-03  1.800000e+01 -2.150619e-03 -2.924807e-02
      [694,]   10  7.203589e-03  1.800000e+01  7.207185e-03  4.357811e-02
      [695,]   11 -4.264818e-03  1.800000e+01  7.184857e-03  1.438196e-02
      [696,]   12 -9.599149e-03  1.800000e+01  5.410525e-03  3.219200e-02
      [697,]   13 -7.910131e-03  1.800000e+01 -9.435210e-03  2.426664e-02
      [698,]   14 -6.707357e-03  1.800000e+01  7.709262e-03 -2.499765e-02
      [699,]   15  7.498116e-04  1.800000e+01 -9.692423e-03  1.772448e-02
      [700,]   16  5.123847e-03  1.800000e+01 -8.176556e-03 -4.402105e-03
      [701,]   17 -8.656108e-03  1.800000e+01  2.490836e-03 -3.693942e-02
      [702,]   18 -5.314485e-03  1.800000e+01 -6.138091e-03 -1.448546e-02
      [703,]   19 -4.965873e-04  1.800000e+01  3.633123e-03  8.779103e-03
      [704,]    1  4.134976e-03  1.900000e+01 -1.308641e-03  2.496282e-02
      [705,]    2 -5.819660e-03  1.900000e+01  5.221317e-03 -1.599621e-03
      [706,]    3  1.052388e-03  1.900000e+01  7.136652e-03 -4.158335e-02
      [707,]    4  2.450621e-04  1.900000e+01  4.050678e-03 -3.803668e-02
      [708,]    5 -5.147957e-03  1.900000e+01  9.966920e-04 -4.658349e-02
      [709,]    6 -9.840423e-03  1.900000e+01  1.957858e-03  4.000885e-03
      [710,]    7  7.656225e-04  1.900000e+01  5.066012e-03 -7.615013e-03
      [711,]    8 -9.680266e-03  1.900000e+01  8.429543e-03  2.030571e-02
      [712,]    9  3.244842e-03  1.900000e+01 -2.673356e-03  1.985818e-02
      [713,]   10  9.410919e-03  1.900000e+01  1.888618e-03 -4.765020e-02
      [714,]   11 -1.116688e-03  1.900000e+01 -7.363031e-03  1.259014e-02
      [715,]   12 -3.712378e-03  1.900000e+01  9.088602e-03 -2.557375e-02
      [716,]   13 -7.863819e-03  1.900000e+01 -9.374634e-03  1.713725e-02
      [717,]   14 -4.261928e-03  1.900000e+01  7.319134e-03 -2.902950e-02
      [718,]   15  4.685481e-03  1.900000e+01 -8.152783e-03  5.984129e-03
      [719,]   16  5.867284e-03  1.900000e+01 -3.829878e-03  2.226048e-02
      [720,]   17 -5.342292e-03  1.900000e+01  1.492620e-03  1.097714e-02
      [721,]   18 -5.748868e-04  1.900000e+01 -5.505340e-03 -4.690411e-02
      [722,]   19 -8.671432e-03  1.900000e+01 -7.006433e-03  2.557972e-02
                      [,6]
        [1,]  4.595498e-02
        [2,] -2.671738e-02
        [3,]  2.845164e-02
        [4,] -3.757026e-02
        [5,] -3.676504e-02
        [6,]  3.096397e-02
        [7,]  3.713657e-03
        [8,] -3.178552e-02
        [9,] -2.245714e-02
       [10,] -3.596595e-02
       [11,] -4.486436e-02
       [12,] -3.970906e-03
       [13,]  3.710219e-02
       [14,] -2.119106e-02
       [15,] -2.193383e-02
       [16,] -5.885119e-03
       [17,]  3.188463e-02
       [18,] -1.695252e-02
       [19,]  8.734928e-03
       [20,]  1.212618e-02
       [21,] -1.270700e-03
       [22,] -1.922721e-02
       [23,]  4.664516e-02
       [24,] -2.562518e-02
       [25,]  4.805317e-02
       [26,] -1.788533e-02
       [27,] -1.558704e-02
       [28,] -3.622353e-02
       [29,] -2.061816e-02
       [30,]  3.570716e-02
       [31,] -4.006067e-02
       [32,] -2.199711e-02
       [33,] -1.633653e-02
       [34,]  1.958726e-02
       [35,]  2.113027e-02
       [36,]  3.964192e-02
       [37,]  1.109235e-02
       [38,]  3.918130e-02
       [39,]  2.774248e-02
       [40,]  4.898508e-02
       [41,]  3.015235e-02
       [42,] -2.947018e-02
       [43,]  4.472535e-02
       [44,] -2.820021e-02
       [45,] -3.657595e-02
       [46,]  9.277405e-03
       [47,] -3.195501e-02
       [48,] -3.340519e-02
       [49,] -9.687616e-03
       [50,]  3.700694e-02
       [51,]  1.995895e-02
       [52,] -1.891713e-03
       [53,] -2.204819e-03
       [54,] -1.688701e-02
       [55,]  4.745116e-02
       [56,] -2.502368e-02
       [57,]  2.910960e-02
       [58,]  4.563196e-02
       [59,]  4.754595e-02
       [60,] -2.087470e-02
       [61,] -1.125828e-02
       [62,] -3.410738e-02
       [63,] -4.214554e-02
       [64,] -8.157021e-03
       [65,] -1.975641e-02
       [66,]  4.845060e-02
       [67,]  3.203262e-02
       [68,] -7.546765e-03
       [69,] -3.530202e-02
       [70,] -1.524499e-02
       [71,] -3.684505e-02
       [72,]  4.847520e-02
       [73,]  1.452707e-02
       [74,]  1.237406e-02
       [75,] -4.071550e-02
       [76,]  8.268405e-03
       [77,]  5.035731e-04
       [78,]  2.730288e-02
       [79,] -1.616363e-02
       [80,]  2.584736e-02
       [81,]  3.883382e-02
       [82,] -2.295926e-02
       [83,]  1.241069e-02
       [84,] -1.361610e-02
       [85,] -2.875965e-02
       [86,]  1.480032e-02
       [87,]  2.705773e-02
       [88,]  3.457750e-02
       [89,] -2.935648e-02
       [90,]  3.339890e-02
       [91,] -4.615371e-03
       [92,]  4.222585e-02
       [93,] -4.632158e-02
       [94,]  2.284979e-02
       [95,]  1.565798e-02
       [96,]  3.394468e-02
       [97,]  3.091716e-02
       [98,]  1.627463e-02
       [99,] -2.070922e-02
      [100,] -2.394215e-02
      [101,]  9.716894e-04
      [102,] -2.741069e-02
      [103,]  3.801982e-02
      [104,]  4.852471e-02
      [105,] -1.795839e-02
      [106,] -1.712492e-02
      [107,]  2.048495e-02
      [108,] -1.799800e-02
      [109,]  3.501128e-02
      [110,]  3.227235e-02
      [111,]  4.098759e-02
      [112,] -4.724632e-02
      [113,] -1.349210e-02
      [114,] -3.256790e-03
      [115,] -2.853291e-02
      [116,] -3.351378e-02
      [117,] -4.236649e-02
      [118,]  1.341455e-02
      [119,]  4.583760e-02
      [120,]  1.674615e-02
      [121,]  2.397815e-02
      [122,] -4.026603e-02
      [123,]  1.948318e-02
      [124,] -4.502416e-02
      [125,]  2.955782e-02
      [126,] -3.472863e-02
      [127,]  1.236937e-02
      [128,]  6.509437e-03
      [129,]  3.332570e-02
      [130,] -4.188470e-02
      [131,] -4.799588e-03
      [132,] -9.816996e-03
      [133,] -2.299659e-02
      [134,]  4.505719e-02
      [135,] -4.056851e-02
      [136,] -8.499063e-03
      [137,]  4.917396e-02
      [138,]  3.052782e-02
      [139,]  1.446719e-02
      [140,] -2.681782e-02
      [141,]  3.215182e-02
      [142,] -1.510659e-02
      [143,] -1.833131e-02
      [144,] -4.318452e-02
      [145,] -3.499008e-02
      [146,] -4.141254e-02
      [147,]  1.362796e-03
      [148,]  2.258668e-02
      [149,] -4.249389e-02
      [150,]  2.208354e-02
      [151,] -1.138374e-03
      [152,]  4.085769e-02
      [153,]  4.116320e-02
      [154,]  2.550988e-02
      [155,]  4.932891e-02
      [156,]  1.927353e-02
      [157,] -4.286371e-02
      [158,] -4.280882e-02
      [159,]  3.880552e-02
      [160,]  1.205992e-02
      [161,]  1.073886e-02
      [162,]  2.577444e-02
      [163,] -2.871906e-02
      [164,] -4.814526e-02
      [165,]  4.392057e-02
      [166,] -4.562522e-02
      [167,] -4.109367e-02
      [168,] -1.895656e-02
      [169,]  1.107319e-02
      [170,] -1.482847e-02
      [171,] -4.451275e-02
      [172,] -2.103587e-02
      [173,] -6.460953e-03
      [174,]  4.273817e-02
      [175,] -5.466591e-03
      [176,]  4.124682e-02
      [177,]  3.103995e-02
      [178,]  1.066735e-02
      [179,] -2.150426e-02
      [180,]  8.867650e-03
      [181,]  1.321469e-02
      [182,] -2.521920e-02
      [183,] -1.662150e-02
      [184,] -4.737055e-02
      [185,] -1.142768e-02
      [186,]  2.584830e-02
      [187,]  4.873602e-02
      [188,] -5.080838e-03
      [189,]  3.556777e-02
      [190,] -2.813483e-02
      [191,]  3.019307e-02
      [192,] -2.647572e-02
      [193,] -4.976672e-02
      [194,]  1.383833e-02
      [195,]  1.702941e-02
      [196,] -1.053227e-02
      [197,] -2.539950e-02
      [198,]  3.956183e-03
      [199,]  2.543802e-02
      [200,] -2.756319e-04
      [201,] -2.525965e-02
      [202,]  1.328972e-02
      [203,]  2.053304e-02
      [204,] -3.446120e-02
      [205,]  3.502182e-02
      [206,] -4.099398e-02
      [207,] -1.761458e-02
      [208,] -4.481736e-02
      [209,]  4.801782e-02
      [210,]  4.791488e-02
      [211,]  4.679056e-02
      [212,]  3.678429e-03
      [213,] -2.845056e-02
      [214,]  2.379404e-02
      [215,] -3.424222e-02
      [216,] -2.458123e-02
      [217,]  3.856414e-02
      [218,] -2.316987e-02
      [219,]  3.928309e-02
      [220,] -3.849106e-02
      [221,] -1.099428e-03
      [222,] -4.839619e-02
      [223,] -3.353079e-02
      [224,] -1.667827e-02
      [225,]  8.944256e-04
      [226,]  3.905501e-02
      [227,]  3.480769e-02
      [228,] -3.309222e-02
      [229,] -9.116598e-03
      [230,] -2.761087e-03
      [231,]  4.342722e-02
      [232,] -1.726424e-02
      [233,] -2.655819e-02
      [234,]  2.533096e-02
      [235,]  1.636529e-02
      [236,] -2.224537e-03
      [237,]  1.341185e-02
      [238,]  1.857520e-02
      [239,]  4.569429e-02
      [240,] -4.582746e-02
      [241,]  3.455254e-02
      [242,] -2.582430e-02
      [243,] -1.039657e-02
      [244,]  1.376949e-02
      [245,]  4.073165e-02
      [246,] -4.847071e-02
      [247,]  2.970373e-02
      [248,] -6.991699e-05
      [249,] -2.383065e-02
      [250,]  4.223552e-02
      [251,] -1.261618e-02
      [252,] -4.623033e-02
      [253,]  2.674662e-02
      [254,] -4.767000e-02
      [255,]  2.139238e-02
      [256,] -6.776200e-03
      [257,] -2.578724e-02
      [258,] -4.627391e-02
      [259,] -4.988278e-03
      [260,] -1.933860e-02
      [261,]  2.677462e-02
      [262,]  1.975191e-02
      [263,] -4.798282e-02
      [264,]  7.112537e-03
      [265,] -8.021953e-03
      [266,] -4.239841e-03
      [267,] -2.394034e-02
      [268,] -3.145418e-03
      [269,]  2.163410e-02
      [270,]  2.126563e-03
      [271,] -2.195558e-02
      [272,] -3.284489e-03
      [273,] -4.787364e-02
      [274,] -4.729554e-02
      [275,]  1.139702e-02
      [276,]  1.521704e-02
      [277,] -2.190798e-02
      [278,]  1.470256e-02
      [279,]  2.105489e-02
      [280,] -4.948568e-02
      [281,]  4.643196e-02
      [282,] -2.906671e-02
      [283,]  4.218292e-02
      [284,] -4.991574e-02
      [285,]  4.200190e-02
      [286,]  1.333662e-02
      [287,]  2.654866e-02
      [288,]  2.783990e-02
      [289,]  4.780630e-02
      [290,] -4.970827e-02
      [291,] -3.006407e-03
      [292,] -8.176925e-03
      [293,] -4.956267e-02
      [294,]  1.627479e-02
      [295,]  1.695537e-03
      [296,]  4.294849e-02
      [297,]  1.343644e-02
      [298,]  2.834701e-02
      [299,] -2.343479e-02
      [300,]  3.167909e-02
      [301,] -1.233606e-02
      [302,]  1.595814e-02
      [303,]  2.958210e-03
      [304,] -3.158711e-02
      [305,] -1.725153e-02
      [306,] -3.596430e-03
      [307,] -4.273322e-02
      [308,]  4.458161e-02
      [309,]  3.275242e-02
      [310,] -1.450788e-02
      [311,]  2.351118e-03
      [312,]  1.977617e-02
      [313,] -3.313871e-02
      [314,]  2.347922e-02
      [315,]  8.599617e-03
      [316,]  4.361080e-02
      [317,] -3.581735e-02
      [318,]  2.593632e-02
      [319,] -1.919897e-02
      [320,]  3.999030e-02
      [321,] -1.818160e-03
      [322,] -3.022244e-02
      [323,] -3.515036e-02
      [324,] -4.743709e-02
      [325,]  4.547735e-02
      [326,]  4.286151e-02
      [327,]  3.121946e-02
      [328,]  4.569175e-03
      [329,] -5.641874e-03
      [330,] -4.250327e-02
      [331,] -3.357234e-03
      [332,]  5.549375e-04
      [333,]  2.555933e-02
      [334,] -2.165986e-02
      [335,] -2.600802e-02
      [336,]  4.266945e-02
      [337,] -1.312419e-02
      [338,]  3.457974e-02
      [339,] -3.813075e-02
      [340,] -4.583308e-02
      [341,] -3.153494e-02
      [342,]  1.656454e-02
      [343,] -4.074052e-02
      [344,]  5.229591e-03
      [345,] -4.289947e-02
      [346,]  4.693646e-02
      [347,] -4.079205e-02
      [348,] -4.593775e-02
      [349,]  3.207291e-02
      [350,]  4.309148e-02
      [351,] -4.208677e-02
      [352,] -3.084040e-02
      [353,]  3.804917e-03
      [354,]  1.082145e-02
      [355,]  8.248837e-03
      [356,]  2.394960e-02
      [357,]  4.812042e-02
      [358,] -4.655695e-02
      [359,] -4.746066e-02
      [360,]  1.690880e-02
      [361,]  3.542551e-02
      [362,]  2.490102e-02
      [363,]  4.686855e-02
      [364,] -4.568508e-02
      [365,]  1.694252e-03
      [366,]  2.421517e-02
      [367,] -1.448532e-02
      [368,] -3.271302e-02
      [369,]  6.234291e-03
      [370,]  4.804818e-02
      [371,]  8.559206e-05
      [372,]  2.051229e-03
      [373,]  4.483748e-02
      [374,] -1.087038e-02
      [375,]  3.384040e-03
      [376,]  4.725878e-02
      [377,]  4.406941e-02
      [378,] -1.295361e-02
      [379,] -2.167122e-02
      [380,]  4.919681e-02
      [381,]  3.184544e-02
      [382,]  1.948746e-02
      [383,] -2.529822e-02
      [384,] -9.170931e-03
      [385,]  1.527652e-02
      [386,] -2.237138e-02
      [387,] -9.025664e-03
      [388,] -3.841776e-02
      [389,] -1.986252e-02
      [390,]  2.024381e-03
      [391,]  3.638958e-03
      [392,] -4.160269e-02
      [393,]  2.210917e-02
      [394,] -9.798289e-03
      [395,] -2.813212e-02
      [396,] -1.161731e-02
      [397,]  7.181504e-03
      [398,] -3.274150e-02
      [399,] -2.195759e-02
      [400,] -1.017579e-02
      [401,]  4.184624e-02
      [402,] -3.240644e-02
      [403,]  4.793698e-02
      [404,] -4.696704e-02
      [405,] -2.402314e-02
      [406,]  2.001644e-02
      [407,] -2.770050e-02
      [408,]  3.930738e-03
      [409,] -2.764713e-02
      [410,]  4.944980e-02
      [411,]  8.236953e-03
      [412,] -3.023053e-02
      [413,] -1.955693e-02
      [414,]  4.117295e-02
      [415,] -4.636580e-02
      [416,] -3.212397e-02
      [417,] -4.390859e-03
      [418,]  1.128168e-02
      [419,] -1.274856e-02
      [420,]  3.872981e-02
      [421,] -1.738305e-02
      [422,] -2.541680e-03
      [423,] -2.832790e-02
      [424,]  3.933804e-02
      [425,] -1.680248e-02
      [426,]  8.446755e-04
      [427,]  4.111465e-02
      [428,] -2.642885e-02
      [429,] -4.722976e-02
      [430,] -1.143594e-02
      [431,]  3.369414e-02
      [432,]  4.448640e-02
      [433,]  5.295939e-03
      [434,] -8.587251e-03
      [435,] -6.016336e-03
      [436,]  4.331658e-02
      [437,] -4.619585e-02
      [438,] -4.661723e-02
      [439,] -1.180746e-02
      [440,]  1.000135e-02
      [441,] -2.395831e-02
      [442,] -7.926267e-03
      [443,]  2.957340e-02
      [444,] -1.588908e-02
      [445,] -1.216441e-02
      [446,]  1.406608e-02
      [447,] -1.813453e-02
      [448,]  1.180972e-02
      [449,]  4.236208e-02
      [450,]  4.797558e-02
      [451,]  4.800309e-02
      [452,]  3.240149e-03
      [453,] -2.024942e-02
      [454,] -1.567020e-03
      [455,] -3.064822e-02
      [456,]  3.081816e-02
      [457,]  4.520892e-02
      [458,]  4.436592e-02
      [459,] -1.480271e-02
      [460,]  2.395036e-02
      [461,]  1.574961e-03
      [462,]  3.050621e-02
      [463,]  2.813635e-02
      [464,]  6.375915e-03
      [465,]  1.282854e-02
      [466,]  3.236524e-03
      [467,] -2.683606e-03
      [468,]  3.180316e-02
      [469,] -1.196132e-02
      [470,] -3.349630e-03
      [471,] -9.458663e-03
      [472,]  4.785613e-02
      [473,]  4.000756e-02
      [474,]  2.342327e-02
      [475,]  1.398042e-02
      [476,]  7.630326e-03
      [477,]  2.130766e-03
      [478,]  1.424578e-02
      [479,]  3.703061e-02
      [480,] -4.368189e-02
      [481,]  3.408686e-02
      [482,]  1.782028e-03
      [483,] -4.574857e-02
      [484,]  3.758198e-02
      [485,]  3.224220e-02
      [486,]  3.329519e-02
      [487,]  2.614621e-02
      [488,] -1.047185e-02
      [489,] -9.539057e-03
      [490,] -3.582947e-02
      [491,] -4.787654e-02
      [492,]  3.923594e-02
      [493,]  5.881421e-04
      [494,]  3.738044e-02
      [495,]  1.258585e-02
      [496,]  1.155495e-02
      [497,]  2.969666e-03
      [498,] -3.450479e-02
      [499,] -1.701318e-02
      [500,] -1.606255e-03
      [501,]  1.515195e-02
      [502,]  1.504552e-02
      [503,]  3.916970e-03
      [504,]  3.101151e-02
      [505,] -1.392381e-02
      [506,]  9.808695e-03
      [507,]  1.376565e-03
      [508,] -4.721620e-02
      [509,] -4.137618e-02
      [510,] -1.398072e-02
      [511,] -2.432093e-03
      [512,]  2.182356e-02
      [513,]  2.312348e-04
      [514,]  4.676903e-02
      [515,]  4.664230e-02
      [516,]  1.697943e-02
      [517,] -1.247595e-02
      [518,]  1.270305e-02
      [519,] -1.831584e-03
      [520,]  2.295712e-02
      [521,] -7.475937e-03
      [522,]  2.954348e-02
      [523,] -4.756168e-02
      [524,]  1.390950e-02
      [525,] -5.781383e-03
      [526,] -2.104691e-02
      [527,] -4.288171e-02
      [528,] -2.265591e-02
      [529,] -3.854656e-02
      [530,] -3.538895e-02
      [531,] -1.012173e-02
      [532,] -3.307285e-02
      [533,]  3.944466e-02
      [534,] -2.121629e-02
      [535,]  2.486890e-02
      [536,] -7.464143e-05
      [537,] -3.914577e-02
      [538,] -2.089173e-02
      [539,]  1.894828e-02
      [540,]  4.280163e-02
      [541,] -4.947531e-02
      [542,] -1.891325e-03
      [543,] -1.922574e-02
      [544,]  2.878356e-02
      [545,] -2.562035e-02
      [546,] -4.041058e-02
      [547,] -2.578040e-02
      [548,]  4.699994e-02
      [549,] -3.792324e-02
      [550,] -3.249542e-02
      [551,] -4.670734e-02
      [552,]  4.094721e-02
      [553,]  2.815265e-02
      [554,] -2.635475e-02
      [555,] -4.490325e-02
      [556,] -1.117406e-02
      [557,] -2.813520e-02
      [558,]  4.569216e-02
      [559,] -1.555211e-02
      [560,] -3.139715e-02
      [561,]  2.859112e-02
      [562,] -1.182557e-02
      [563,]  1.707904e-02
      [564,]  3.909184e-02
      [565,]  4.284323e-02
      [566,] -1.697390e-03
      [567,] -1.653476e-02
      [568,] -4.995363e-02
      [569,] -1.641861e-02
      [570,] -5.542426e-03
      [571,] -2.505893e-02
      [572,] -3.475889e-02
      [573,] -6.820234e-03
      [574,] -8.336465e-03
      [575,]  2.106332e-02
      [576,] -6.247264e-04
      [577,]  3.697544e-02
      [578,]  2.549011e-02
      [579,]  2.692062e-03
      [580,]  4.806504e-02
      [581,]  2.019991e-02
      [582,]  3.063711e-03
      [583,] -4.393639e-02
      [584,] -1.201383e-02
      [585,]  4.244301e-02
      [586,]  3.218874e-02
      [587,] -8.492386e-03
      [588,]  2.604337e-02
      [589,] -1.912451e-02
      [590,]  6.823914e-03
      [591,] -7.189237e-04
      [592,]  2.087572e-02
      [593,]  4.265772e-02
      [594,]  2.790086e-02
      [595,] -3.074746e-02
      [596,] -4.285247e-02
      [597,]  5.767070e-04
      [598,]  2.300305e-02
      [599,] -2.029363e-02
      [600,]  4.745385e-02
      [601,]  1.705410e-02
      [602,] -1.890293e-02
      [603,]  1.236857e-02
      [604,]  3.340483e-02
      [605,] -1.148428e-02
      [606,]  1.961427e-02
      [607,]  1.563474e-02
      [608,]  2.543063e-02
      [609,] -1.997720e-02
      [610,] -2.749464e-02
      [611,] -2.690204e-02
      [612,] -3.704098e-02
      [613,] -2.934588e-02
      [614,]  2.540732e-02
      [615,] -5.279571e-03
      [616,] -3.807583e-02
      [617,]  4.963515e-02
      [618,] -4.806631e-02
      [619,] -1.766202e-02
      [620,] -4.904982e-04
      [621,]  3.309283e-02
      [622,] -2.918599e-02
      [623,] -2.563736e-02
      [624,]  1.180737e-02
      [625,]  1.580594e-02
      [626,] -4.122989e-02
      [627,] -4.302583e-03
      [628,] -2.874878e-02
      [629,] -3.216237e-02
      [630,]  1.234710e-02
      [631,] -6.071669e-03
      [632,]  3.965713e-02
      [633,] -3.225420e-02
      [634,] -2.275280e-02
      [635,]  4.379803e-02
      [636,]  3.650069e-03
      [637,]  2.254789e-04
      [638,] -2.091612e-02
      [639,]  4.435780e-02
      [640,] -3.647009e-02
      [641,]  3.068151e-02
      [642,] -3.726166e-02
      [643,]  2.222062e-02
      [644,]  1.180547e-02
      [645,]  4.439201e-02
      [646,]  3.776503e-02
      [647,]  3.226880e-02
      [648,]  2.295346e-02
      [649,] -6.655193e-03
      [650,] -3.767581e-02
      [651,] -4.138408e-02
      [652,]  3.749861e-04
      [653,] -2.554590e-02
      [654,] -4.587207e-02
      [655,] -3.865607e-02
      [656,]  3.888366e-02
      [657,] -2.585429e-02
      [658,] -3.986343e-02
      [659,]  1.334919e-02
      [660,] -1.321781e-02
      [661,]  3.843992e-02
      [662,] -8.204084e-03
      [663,]  4.651237e-02
      [664,]  3.535699e-02
      [665,]  2.727869e-02
      [666,]  7.070095e-03
      [667,] -1.396984e-02
      [668,] -4.017218e-02
      [669,]  2.136979e-02
      [670,]  1.134227e-02
      [671,]  4.025717e-02
      [672,]  1.231432e-02
      [673,]  4.593196e-02
      [674,]  1.280777e-02
      [675,] -1.659563e-02
      [676,]  2.951029e-02
      [677,]  3.957487e-02
      [678,]  4.261148e-02
      [679,]  3.593054e-02
      [680,] -8.075021e-03
      [681,]  3.040882e-02
      [682,] -1.110145e-03
      [683,] -3.424502e-02
      [684,]  8.308103e-03
      [685,] -1.395520e-02
      [686,] -3.907406e-02
      [687,]  4.091924e-04
      [688,] -3.423203e-02
      [689,]  4.820397e-02
      [690,] -2.182712e-02
      [691,]  1.844037e-02
      [692,] -2.035590e-02
      [693,]  9.199083e-04
      [694,]  4.349411e-02
      [695,]  1.195387e-02
      [696,] -1.584331e-02
      [697,]  3.097637e-02
      [698,] -1.821427e-02
      [699,] -1.864395e-03
      [700,] -2.359111e-03
      [701,] -1.646955e-02
      [702,] -2.074100e-02
      [703,] -1.843426e-02
      [704,]  1.768110e-02
      [705,] -2.695115e-02
      [706,] -4.962866e-02
      [707,] -3.323244e-02
      [708,] -4.900636e-03
      [709,]  7.924833e-03
      [710,] -1.121300e-02
      [711,] -3.590300e-02
      [712,]  1.361298e-02
      [713,]  2.054805e-02
      [714,] -1.574631e-02
      [715,]  2.745160e-02
      [716,] -6.646649e-03
      [717,] -3.757337e-02
      [718,]  1.374055e-02
      [719,] -1.313869e-02
      [720,] -4.040160e-02
      [721,]  2.814390e-02
      [722,]  2.463870e-02
      
      $n
      [1] 722
      

---

    Code
      two_grid(n_value = 19, num_noise = 0)
    Output
      $df
             [,1]          [,2]          [,3]          [,4]
        [1,]    1  1.000000e+00  4.318207e-03 -1.727934e-03
        [2,]    2  1.000000e+00 -5.014277e-03  2.538549e-03
        [3,]    3  1.000000e+00  3.128414e-03 -7.040824e-03
        [4,]    4  1.000000e+00  1.009553e-03 -5.552805e-03
        [5,]    5  1.000000e+00  8.132217e-03 -5.059074e-03
        [6,]    6  1.000000e+00  6.895431e-03 -6.776385e-03
        [7,]    7  1.000000e+00 -9.431269e-03 -8.941309e-04
        [8,]    8  1.000000e+00 -5.893420e-03 -6.365114e-03
        [9,]    9  1.000000e+00 -7.969463e-03  4.116171e-03
       [10,]   10  1.000000e+00 -8.325680e-03 -1.059391e-03
       [11,]   11  1.000000e+00  3.225410e-03 -6.632596e-03
       [12,]   12  1.000000e+00 -2.348530e-03 -2.533842e-03
       [13,]   13  1.000000e+00  8.558339e-03 -7.792361e-03
       [14,]   14  1.000000e+00 -4.087117e-03  7.068927e-03
       [15,]   15  1.000000e+00 -4.183653e-03  7.877908e-03
       [16,]   16  1.000000e+00 -3.854917e-03 -8.727931e-03
       [17,]   17  1.000000e+00  9.006266e-03 -1.652197e-03
       [18,]   18  1.000000e+00  1.125337e-03  6.157735e-03
       [19,]   19  1.000000e+00  3.063034e-03  4.666967e-03
       [20,]    1  2.000000e+00  4.517526e-03  7.908198e-03
       [21,]    2  2.000000e+00  5.115989e-04 -7.559032e-03
       [22,]    3  2.000000e+00  6.590989e-03 -8.861068e-03
       [23,]    4  2.000000e+00  8.503098e-03 -4.734421e-03
       [24,]    5  2.000000e+00 -4.317138e-03  5.317661e-03
       [25,]    6  2.000000e+00  2.034422e-03  5.510919e-03
       [26,]    7  2.000000e+00  8.313641e-04 -4.384907e-04
       [27,]    8  2.000000e+00 -6.692724e-03 -8.286784e-03
       [28,]    9  2.000000e+00  7.670375e-04  3.569001e-03
       [29,]   10  2.000000e+00 -7.536520e-03  9.420413e-03
       [30,]   11  2.000000e+00  6.195663e-03  6.903162e-03
       [31,]   12  2.000000e+00  8.245863e-04  2.753076e-03
       [32,]   13  2.000000e+00 -4.375353e-03  4.718507e-03
       [33,]   14  2.000000e+00 -4.638812e-03 -3.590227e-03
       [34,]   15  2.000000e+00 -1.443628e-03 -4.475010e-03
       [35,]   16  2.000000e+00 -9.377432e-04  2.927126e-03
       [36,]   17  2.000000e+00 -9.911887e-03 -4.651651e-03
       [37,]   18  2.000000e+00 -2.437499e-03 -1.361660e-03
       [38,]   19  2.000000e+00  4.818803e-03 -4.833167e-03
       [39,]    1  3.000000e+00  5.149615e-03  9.223274e-03
       [40,]    2  3.000000e+00  2.578871e-03  3.870762e-03
       [41,]    3  3.000000e+00 -2.239737e-03  6.540468e-03
       [42,]    4  3.000000e+00  5.597098e-03  7.733212e-03
       [43,]    5  3.000000e+00 -9.431879e-03  4.004149e-03
       [44,]    6  3.000000e+00 -8.811039e-03 -6.099690e-03
       [45,]    7  3.000000e+00  5.989466e-03  5.369755e-03
       [46,]    8  3.000000e+00  3.138659e-03 -2.221183e-03
       [47,]    9  3.000000e+00  4.966656e-03 -5.471690e-03
       [48,]   10  3.000000e+00 -4.284337e-03  9.979162e-04
       [49,]   11  3.000000e+00 -8.809630e-03 -6.201991e-03
       [50,]   12  3.000000e+00 -3.780268e-03  7.829424e-03
       [51,]   13  3.000000e+00 -7.817862e-03  2.674850e-03
       [52,]   14  3.000000e+00 -3.379743e-03  8.801509e-03
       [53,]   15  3.000000e+00  7.400034e-03  3.300852e-03
       [54,]   16  3.000000e+00  8.230052e-03 -8.955374e-03
       [55,]   17  3.000000e+00  5.654979e-03 -9.538760e-03
       [56,]   18  3.000000e+00 -1.587339e-03  3.109444e-03
       [57,]   19  3.000000e+00 -4.608987e-03  4.449596e-04
       [58,]    1  4.000000e+00  9.366928e-03 -9.271129e-03
       [59,]    2  4.000000e+00 -1.565121e-03  5.867929e-04
       [60,]    3  4.000000e+00 -3.714648e-03 -7.694535e-03
       [61,]    4  4.000000e+00  6.507080e-03  7.691164e-03
       [62,]    5  4.000000e+00  8.726202e-03 -3.371477e-03
       [63,]    6  4.000000e+00 -9.873921e-03 -6.314257e-03
       [64,]    7  4.000000e+00  5.414256e-04 -5.549390e-03
       [65,]    8  4.000000e+00 -3.431614e-03  1.584710e-03
       [66,]    9  4.000000e+00 -3.534725e-03  6.143287e-03
       [67,]   10  4.000000e+00  9.745684e-03 -1.484577e-03
       [68,]   11  4.000000e+00 -5.029347e-03 -1.983140e-03
       [69,]   12  4.000000e+00 -7.456683e-03 -3.942279e-03
       [70,]   13  4.000000e+00 -7.719946e-03 -4.888981e-03
       [71,]   14  4.000000e+00 -2.055668e-03  4.860794e-04
       [72,]   15  4.000000e+00  1.187292e-03 -7.767198e-03
       [73,]   16  4.000000e+00  7.035581e-03  6.399903e-03
       [74,]   17  4.000000e+00  5.918766e-03  3.371805e-03
       [75,]   18  4.000000e+00  4.008930e-03  1.817182e-03
       [76,]   19  4.000000e+00  8.856092e-03 -6.683929e-04
       [77,]    1  5.000000e+00  5.523075e-03 -7.568055e-03
       [78,]    2  5.000000e+00  2.038119e-03 -2.898246e-04
       [79,]    3  5.000000e+00  7.072029e-03 -3.818729e-04
       [80,]    4  5.000000e+00  5.070276e-03  1.977739e-03
       [81,]    5  5.000000e+00  5.159883e-03 -8.298401e-03
       [82,]    6  5.000000e+00 -7.738500e-03 -7.021721e-04
       [83,]    7  5.000000e+00  1.693725e-03 -3.375534e-03
       [84,]    8  5.000000e+00 -2.977933e-03  5.383170e-03
       [85,]    9  5.000000e+00 -2.103322e-04  4.929268e-03
       [86,]   10  5.000000e+00  8.549309e-03 -9.147860e-03
       [87,]   11  5.000000e+00  4.744131e-03 -9.513210e-03
       [88,]   12  5.000000e+00 -8.117743e-03 -4.770894e-03
       [89,]   13  5.000000e+00 -5.304524e-03 -6.327508e-05
       [90,]   14  5.000000e+00 -2.411623e-03 -4.012731e-03
       [91,]   15  5.000000e+00  1.656437e-03  2.759261e-03
       [92,]   16  5.000000e+00 -1.968804e-03  9.489457e-03
       [93,]   17  5.000000e+00 -5.458459e-03  6.539132e-03
       [94,]   18  5.000000e+00  6.749275e-03 -9.688508e-03
       [95,]   19  5.000000e+00  1.559850e-03 -8.684711e-03
       [96,]    1  6.000000e+00 -9.666552e-03  2.415644e-04
       [97,]    2  6.000000e+00 -8.778931e-03  6.716591e-03
       [98,]    3  6.000000e+00 -9.355992e-03  5.681365e-03
       [99,]    4  6.000000e+00  5.713953e-03 -3.275019e-03
      [100,]    5  6.000000e+00 -9.685942e-03 -9.514032e-03
      [101,]    6  6.000000e+00  3.425631e-03 -8.166321e-03
      [102,]    7  6.000000e+00 -9.364930e-03  6.556459e-03
      [103,]    8  6.000000e+00  1.839037e-03 -2.681501e-03
      [104,]    9  6.000000e+00 -7.849828e-03 -6.525903e-03
      [105,]   10  6.000000e+00  2.005278e-03  7.687475e-03
      [106,]   11  6.000000e+00  8.222976e-03  9.073927e-03
      [107,]   12  6.000000e+00 -7.844037e-03  4.336201e-03
      [108,]   13  6.000000e+00 -8.979951e-03  6.162050e-03
      [109,]   14  6.000000e+00 -5.984375e-03  4.440193e-03
      [110,]   15  6.000000e+00 -8.011374e-04  8.696403e-03
      [111,]   16  6.000000e+00  7.519281e-03 -2.043275e-03
      [112,]   17  6.000000e+00  9.148335e-03 -8.428284e-03
      [113,]   18  6.000000e+00  4.188167e-03  6.395453e-03
      [114,]   19  6.000000e+00  6.237556e-03 -6.929888e-03
      [115,]    1  7.000000e+00  7.585733e-03 -8.096525e-03
      [116,]    2  7.000000e+00 -9.900460e-03 -1.275203e-03
      [117,]    3  7.000000e+00 -7.713664e-04 -9.337534e-03
      [118,]    4  7.000000e+00 -4.496571e-03 -3.827319e-03
      [119,]    5  7.000000e+00 -5.011896e-03  9.385912e-03
      [120,]    6  7.000000e+00  8.694785e-03 -9.209493e-03
      [121,]    7  7.000000e+00  4.374180e-03 -6.310944e-03
      [122,]    8  7.000000e+00  2.902813e-03  3.027458e-04
      [123,]    9  7.000000e+00  1.698621e-03 -2.580425e-03
      [124,]   10  7.000000e+00 -2.178288e-03  8.752242e-03
      [125,]   11  7.000000e+00  1.174163e-03  5.303817e-03
      [126,]   12  7.000000e+00  4.830029e-03 -5.734362e-03
      [127,]   13  7.000000e+00  2.282014e-03  3.436343e-03
      [128,]   14  7.000000e+00  9.344430e-03  7.799261e-04
      [129,]   15  7.000000e+00 -3.936642e-03  2.376206e-03
      [130,]   16  7.000000e+00 -9.141365e-03  1.847440e-04
      [131,]   17  7.000000e+00  2.388123e-03 -6.697714e-03
      [132,]   18  7.000000e+00  2.690018e-03 -9.806490e-03
      [133,]   19  7.000000e+00  9.405143e-03 -7.585167e-03
      [134,]    1  8.000000e+00  5.310218e-03 -6.109882e-03
      [135,]    2  8.000000e+00 -1.526045e-03  6.031884e-03
      [136,]    3  8.000000e+00 -9.850069e-03  8.674682e-03
      [137,]    4  8.000000e+00 -7.544293e-03 -3.257484e-03
      [138,]    5  8.000000e+00 -3.197345e-04 -7.650856e-03
      [139,]    6  8.000000e+00 -1.040122e-03  4.141237e-03
      [140,]    7  8.000000e+00  7.566940e-03  3.080811e-03
      [141,]    8  8.000000e+00  5.619232e-03  7.856771e-03
      [142,]    9  8.000000e+00 -2.914166e-03  8.090991e-03
      [143,]   10  8.000000e+00 -4.790615e-03 -3.399200e-03
      [144,]   11  8.000000e+00 -3.699629e-03  4.231450e-03
      [145,]   12  8.000000e+00 -8.629492e-03  1.349445e-03
      [146,]   13  8.000000e+00  7.622541e-04  4.357351e-03
      [147,]   14  8.000000e+00  6.189085e-03  6.107240e-05
      [148,]   15  8.000000e+00 -9.755846e-03  2.440887e-03
      [149,]   16  8.000000e+00  1.039448e-03 -3.493650e-03
      [150,]   17  8.000000e+00 -7.635843e-03 -9.604493e-03
      [151,]   18  8.000000e+00 -4.003784e-03  4.913861e-03
      [152,]   19  8.000000e+00 -1.702524e-03 -2.213574e-03
      [153,]    1  9.000000e+00 -1.210688e-03  6.328811e-03
      [154,]    2  9.000000e+00 -1.750320e-03  8.270322e-03
      [155,]    3  9.000000e+00 -6.722590e-03  2.294155e-04
      [156,]    4  9.000000e+00 -9.114641e-03  4.039734e-03
      [157,]    5  9.000000e+00  3.490724e-03  3.169417e-03
      [158,]    6  9.000000e+00  9.029288e-04 -7.981450e-03
      [159,]    7  9.000000e+00 -1.536896e-03  6.439623e-03
      [160,]    8  9.000000e+00 -4.761684e-03  1.763115e-03
      [161,]    9  9.000000e+00  4.915961e-03  1.398885e-03
      [162,]   10  9.000000e+00 -9.260445e-03  6.237303e-03
      [163,]   11  9.000000e+00  1.657056e-03 -7.742319e-03
      [164,]   12  9.000000e+00 -4.170287e-03  3.699419e-03
      [165,]   13  9.000000e+00  6.739996e-03  6.132446e-03
      [166,]   14  9.000000e+00  6.616977e-04 -3.266524e-03
      [167,]   15  9.000000e+00 -3.575818e-03  2.011923e-03
      [168,]   16  9.000000e+00  1.940534e-03  4.118482e-03
      [169,]   17  9.000000e+00 -1.102596e-03 -4.237199e-03
      [170,]   18  9.000000e+00 -4.566476e-03 -7.130887e-03
      [171,]   19  9.000000e+00 -4.549931e-03  2.285579e-03
      [172,]    1  1.000000e+01  2.141886e-03  8.706277e-03
      [173,]    2  1.000000e+01 -8.862154e-03 -9.027968e-03
      [174,]    3  1.000000e+01 -6.564107e-03  3.548944e-03
      [175,]    4  1.000000e+01 -9.333187e-03 -1.185107e-03
      [176,]    5  1.000000e+01 -9.291115e-03 -1.856505e-03
      [177,]    6  1.000000e+01  2.019941e-03 -6.953205e-03
      [178,]    7  1.000000e+01  2.675036e-03 -1.501933e-03
      [179,]    8  1.000000e+01  1.581819e-03  5.819971e-03
      [180,]    9  1.000000e+01  6.549505e-04 -3.359550e-03
      [181,]   10  1.000000e+01 -6.041018e-03  7.688294e-03
      [182,]   11  1.000000e+01 -9.300840e-03  7.478529e-03
      [183,]   12  1.000000e+01  1.538120e-03  5.203622e-03
      [184,]   13  1.000000e+01 -7.975673e-03 -4.811438e-03
      [185,]   14  1.000000e+01 -4.115275e-03  5.042863e-03
      [186,]   15  1.000000e+01  1.748107e-03 -5.388775e-03
      [187,]   16  1.000000e+01 -9.341977e-03 -1.372148e-03
      [188,]   17  1.000000e+01 -1.578949e-03 -2.440334e-03
      [189,]   18  1.000000e+01  6.231038e-03  5.292083e-03
      [190,]   19  1.000000e+01 -1.430671e-03 -9.037088e-03
      [191,]    1  1.100000e+01  7.361469e-03  4.576024e-03
      [192,]    2  1.100000e+01 -9.763088e-03 -5.250369e-03
      [193,]    3  1.100000e+01 -6.843959e-03 -1.370656e-03
      [194,]    4  1.100000e+01  2.320931e-03  9.335683e-03
      [195,]    5  1.100000e+01 -7.977474e-03  4.212255e-03
      [196,]    6  1.100000e+01  8.927923e-03 -8.174529e-03
      [197,]    7  1.100000e+01 -7.746394e-03 -9.757590e-03
      [198,]    8  1.100000e+01 -7.402710e-03 -4.210229e-03
      [199,]    9  1.100000e+01 -4.062592e-03  4.811481e-03
      [200,]   10  1.100000e+01 -1.816414e-03  9.959760e-03
      [201,]   11  1.100000e+01  8.375379e-03 -3.390418e-03
      [202,]   12  1.100000e+01 -9.059416e-03 -6.822729e-03
      [203,]   13  1.100000e+01 -7.106001e-03 -6.932619e-04
      [204,]   14  1.100000e+01  3.718575e-03 -1.150999e-03
      [205,]   15  1.100000e+01 -2.649399e-03 -8.712458e-03
      [206,]   16  1.100000e+01  8.528498e-04 -1.333334e-03
      [207,]   17  1.100000e+01  6.660353e-03 -9.124952e-03
      [208,]   18  1.100000e+01 -6.936341e-03 -1.477005e-03
      [209,]   19  1.100000e+01 -1.320773e-03 -1.544260e-03
      [210,]    1  1.200000e+01  7.280932e-03  2.190139e-03
      [211,]    2  1.200000e+01  9.061035e-03 -1.528617e-03
      [212,]    3  1.200000e+01  8.070126e-03  3.392823e-04
      [213,]    4  1.200000e+01 -8.130464e-03  1.150528e-03
      [214,]    5  1.200000e+01  5.615855e-04  1.247258e-03
      [215,]    6  1.200000e+01 -9.545975e-03 -9.664269e-03
      [216,]    7  1.200000e+01  2.405273e-03  2.689458e-03
      [217,]    8  1.200000e+01 -2.554902e-03 -4.705526e-04
      [218,]    9  1.200000e+01 -4.823770e-03  1.326393e-03
      [219,]   10  1.200000e+01 -8.103002e-03  3.609525e-03
      [220,]   11  1.200000e+01 -4.857521e-03  3.936982e-03
      [221,]   12  1.200000e+01  5.288052e-03 -6.046401e-03
      [222,]   13  1.200000e+01  3.383265e-03  2.317115e-03
      [223,]   14  1.200000e+01 -3.309380e-03 -5.552338e-03
      [224,]   15  1.200000e+01  3.693437e-03 -1.972514e-03
      [225,]   16  1.200000e+01  8.772617e-03  5.054104e-03
      [226,]   17  1.200000e+01  9.402479e-03  6.502717e-04
      [227,]   18  1.200000e+01 -4.405691e-03  4.319413e-03
      [228,]   19  1.200000e+01 -9.338690e-03  5.443830e-03
      [229,]    1  1.300000e+01 -8.727436e-03 -5.707564e-03
      [230,]    2  1.300000e+01 -2.976691e-04  8.333209e-03
      [231,]    3  1.300000e+01 -8.974922e-03 -9.592556e-03
      [232,]    4  1.300000e+01 -6.488389e-04 -2.078420e-03
      [233,]    5  1.300000e+01 -4.116556e-03 -7.861145e-03
      [234,]    6  1.300000e+01 -6.458419e-03 -9.223979e-03
      [235,]    7  1.300000e+01  9.762772e-03  9.978072e-03
      [236,]    8  1.300000e+01  1.032142e-03  7.226722e-03
      [237,]    9  1.300000e+01  4.625603e-03  3.862295e-03
      [238,]   10  1.300000e+01 -9.114172e-04 -3.328930e-03
      [239,]   11  1.300000e+01 -6.430813e-03  9.216959e-03
      [240,]   12  1.300000e+01 -9.190685e-03  9.208120e-04
      [241,]   13  1.300000e+01  3.184972e-03  5.284430e-03
      [242,]   14  1.300000e+01 -1.784771e-03 -1.243270e-03
      [243,]   15  1.300000e+01 -2.830853e-03 -6.218988e-03
      [244,]   16  1.300000e+01  3.867873e-03  3.818805e-03
      [245,]   17  1.300000e+01  1.900423e-03 -8.285421e-03
      [246,]   18  1.300000e+01  4.937636e-04  8.498277e-03
      [247,]   19  1.300000e+01  6.795110e-03 -4.472167e-03
      [248,]    1  1.400000e+01  8.369498e-04  5.073663e-03
      [249,]    2  1.400000e+01  1.222663e-03  3.556718e-03
      [250,]    3  1.400000e+01 -8.198330e-03 -1.040295e-03
      [251,]    4  1.400000e+01  2.378966e-03 -6.054491e-03
      [252,]    5  1.400000e+01 -9.425227e-03  6.860479e-03
      [253,]    6  1.400000e+01  9.932582e-03  5.719564e-03
      [254,]    7  1.400000e+01  3.582389e-03  3.781592e-03
      [255,]    8  1.400000e+01  4.313520e-03 -2.263806e-03
      [256,]    9  1.400000e+01  3.979110e-03  6.362663e-03
      [257,]   10  1.400000e+01 -9.637771e-03 -4.101150e-03
      [258,]   11  1.400000e+01  7.344954e-03 -3.095857e-03
      [259,]   12  1.400000e+01 -2.868821e-03  3.375007e-03
      [260,]   13  1.400000e+01 -4.784374e-03  2.985726e-03
      [261,]   14  1.400000e+01 -4.581171e-03 -3.613210e-03
      [262,]   15  1.400000e+01 -3.581588e-03 -6.449813e-03
      [263,]   16  1.400000e+01  4.569540e-03  6.108131e-03
      [264,]   17  1.400000e+01 -1.988341e-03  9.304417e-03
      [265,]   18  1.400000e+01 -5.237111e-04  4.502654e-03
      [266,]   19  1.400000e+01  3.764172e-03 -4.123643e-03
      [267,]    1  1.500000e+01  2.081444e-03 -9.545330e-03
      [268,]    2  1.500000e+01 -1.317421e-04 -7.592370e-03
      [269,]    3  1.500000e+01 -5.398300e-03 -4.044455e-03
      [270,]    4  1.500000e+01 -9.314329e-03 -7.884830e-04
      [271,]    5  1.500000e+01  2.121654e-03 -8.412743e-03
      [272,]    6  1.500000e+01 -9.626964e-03  6.003027e-03
      [273,]    7  1.500000e+01  8.584083e-04  7.642111e-03
      [274,]    8  1.500000e+01 -3.018427e-03 -3.262491e-03
      [275,]    9  1.500000e+01  2.347321e-03  3.197702e-03
      [276,]   10  1.500000e+01 -5.833486e-03 -8.351646e-03
      [277,]   11  1.500000e+01  5.281324e-03  6.657855e-03
      [278,]   12  1.500000e+01 -7.962887e-03  1.273490e-03
      [279,]   13  1.500000e+01 -4.694344e-04 -9.340298e-03
      [280,]   14  1.500000e+01 -4.301474e-03 -1.747156e-03
      [281,]   15  1.500000e+01  2.580439e-03  5.441714e-03
      [282,]   16  1.500000e+01 -7.128489e-03  3.343663e-03
      [283,]   17  1.500000e+01  6.080685e-03 -8.935107e-03
      [284,]   18  1.500000e+01  5.512142e-03  1.791975e-03
      [285,]   19  1.500000e+01  3.354923e-03 -7.431594e-03
      [286,]    1  1.600000e+01  4.601118e-03 -7.691856e-03
      [287,]    2  1.600000e+01  4.894913e-03  5.183896e-03
      [288,]    3  1.600000e+01 -9.152406e-03 -8.676849e-03
      [289,]    4  1.600000e+01  1.186820e-03  4.721703e-03
      [290,]    5  1.600000e+01 -4.529535e-03  1.697899e-03
      [291,]    6  1.600000e+01  3.796423e-05  5.277474e-03
      [292,]    7  1.600000e+01 -7.353961e-04  2.248332e-03
      [293,]    8  1.600000e+01 -5.913843e-03  8.847962e-03
      [294,]    9  1.600000e+01 -7.576224e-03 -5.947741e-03
      [295,]   10  1.600000e+01 -3.828463e-03  3.392391e-03
      [296,]   11  1.600000e+01  3.640489e-03 -5.792636e-03
      [297,]   12  1.600000e+01 -5.526776e-03  9.644602e-03
      [298,]   13  1.600000e+01 -2.298231e-03 -9.114209e-04
      [299,]   14  1.600000e+01 -6.066814e-03 -9.716976e-03
      [300,]   15  1.600000e+01  8.066366e-03 -3.019491e-03
      [301,]   16  1.600000e+01  1.719687e-03  2.614273e-04
      [302,]   17  1.600000e+01 -9.755713e-03  7.364655e-03
      [303,]   18  1.600000e+01 -4.923995e-03 -2.030242e-03
      [304,]   19  1.600000e+01 -1.390422e-03 -1.000638e-03
      [305,]    1  1.700000e+01 -3.368365e-03  3.314536e-03
      [306,]    2  1.700000e+01 -3.203563e-03  4.271218e-03
      [307,]    3  1.700000e+01  8.113302e-03 -3.541330e-03
      [308,]    4  1.700000e+01  2.330765e-03 -2.657621e-03
      [309,]    5  1.700000e+01 -4.280760e-03  4.007404e-03
      [310,]    6  1.700000e+01  2.895187e-03 -7.432791e-03
      [311,]    7  1.700000e+01 -7.371171e-03  8.098173e-03
      [312,]    8  1.700000e+01  6.217703e-04 -8.270033e-03
      [313,]    9  1.700000e+01 -8.255204e-03  7.795431e-03
      [314,]   10  1.700000e+01 -4.640750e-03 -2.397249e-03
      [315,]   11  1.700000e+01  3.553592e-03 -5.987828e-03
      [316,]   12  1.700000e+01  2.077234e-03  6.281456e-03
      [317,]   13  1.700000e+01  4.275235e-03 -5.413926e-03
      [318,]   14  1.700000e+01 -5.829650e-03 -5.201510e-03
      [319,]   15  1.700000e+01  5.330058e-03  4.466656e-03
      [320,]   16  1.700000e+01  7.123455e-03 -6.791473e-03
      [321,]   17  1.700000e+01 -1.719621e-03 -9.052912e-04
      [322,]   18  1.700000e+01  7.541020e-03 -2.457408e-03
      [323,]   19  1.700000e+01  6.189182e-03  6.104923e-04
      [324,]    1  1.800000e+01 -1.248858e-03 -4.366120e-03
      [325,]    2  1.800000e+01  8.208374e-03 -7.042850e-03
      [326,]    3  1.800000e+01  8.424003e-04  6.989098e-03
      [327,]    4  1.800000e+01 -3.818369e-03  2.780401e-03
      [328,]    5  1.800000e+01  3.699940e-03 -8.748042e-03
      [329,]    6  1.800000e+01 -3.431473e-03 -9.658786e-03
      [330,]    7  1.800000e+01  4.885898e-03 -1.304173e-03
      [331,]    8  1.800000e+01  9.816542e-03 -3.247268e-05
      [332,]    9  1.800000e+01 -5.239152e-03  1.677131e-03
      [333,]   10  1.800000e+01  9.450433e-03  6.379464e-03
      [334,]   11  1.800000e+01 -1.738194e-03  1.161123e-03
      [335,]   12  1.800000e+01 -5.930097e-03 -8.010053e-03
      [336,]   13  1.800000e+01  1.945464e-03 -4.623114e-03
      [337,]   14  1.800000e+01  3.887997e-03 -6.689154e-03
      [338,]   15  1.800000e+01 -2.641830e-03 -4.232689e-03
      [339,]   16  1.800000e+01  3.488224e-03 -7.567811e-03
      [340,]   17  1.800000e+01 -5.259013e-03 -1.197068e-04
      [341,]   18  1.800000e+01  8.919275e-03 -6.840355e-03
      [342,]   19  1.800000e+01 -8.831371e-03 -4.177836e-03
      [343,]    1  1.900000e+01 -6.477337e-03  1.220118e-03
      [344,]    2  1.900000e+01  2.679303e-03  4.480656e-03
      [345,]    3  1.900000e+01  7.351821e-04 -5.052322e-03
      [346,]    4  1.900000e+01 -6.119299e-03  7.177800e-03
      [347,]    5  1.900000e+01  1.991475e-04  1.052377e-03
      [348,]    6  1.900000e+01 -4.904193e-04  4.089693e-03
      [349,]    7  1.900000e+01  3.028367e-03 -5.672546e-03
      [350,]    8  1.900000e+01 -4.655981e-03  6.761809e-03
      [351,]    9  1.900000e+01 -5.949913e-03  2.319380e-03
      [352,]   10  1.900000e+01  1.973945e-03  5.578665e-03
      [353,]   11  1.900000e+01 -4.092107e-03  9.278042e-03
      [354,]   12  1.900000e+01 -7.653001e-03 -5.143563e-03
      [355,]   13  1.900000e+01  9.034908e-03  7.305634e-05
      [356,]   14  1.900000e+01 -2.106933e-03  2.121929e-03
      [357,]   15  1.900000e+01 -6.249831e-03  7.177255e-04
      [358,]   16  1.900000e+01  7.056352e-03 -5.022850e-03
      [359,]   17  1.900000e+01  2.457016e-03  6.701242e-03
      [360,]   18  1.900000e+01  4.664885e-03  8.720471e-03
      [361,]   19  1.900000e+01 -4.990221e-03  8.142817e-03
      [362,]    1  9.006865e-03  1.000000e+00 -1.055460e-03
      [363,]    2 -5.276212e-04  1.000000e+00  6.113849e-03
      [364,]    3  8.453327e-03  1.000000e+00 -7.112117e-03
      [365,]    4  1.746066e-03  1.000000e+00  5.821175e-03
      [366,]    5  6.128256e-03  1.000000e+00  9.296034e-03
      [367,]    6 -6.626446e-03  1.000000e+00 -5.181812e-04
      [368,]    7 -9.966574e-03  1.000000e+00 -6.908964e-03
      [369,]    8 -7.918321e-03  1.000000e+00 -3.875806e-03
      [370,]    9  4.059861e-03  1.000000e+00  9.851280e-03
      [371,]   10 -5.536629e-03  1.000000e+00 -7.654868e-03
      [372,]   11 -4.320585e-03  1.000000e+00  1.822035e-03
      [373,]   12  6.316321e-04  1.000000e+00 -4.703316e-03
      [374,]   13 -3.568474e-04  1.000000e+00 -8.521980e-03
      [375,]   14 -8.150595e-03  1.000000e+00 -7.877753e-03
      [376,]   15 -9.889579e-03  1.000000e+00 -3.800811e-03
      [377,]   16 -3.000832e-03  1.000000e+00  6.378134e-04
      [378,]   17 -6.630190e-03  1.000000e+00 -6.412767e-03
      [379,]   18 -3.234676e-03  1.000000e+00 -8.057261e-04
      [380,]   19  5.098747e-03  1.000000e+00  2.910583e-03
      [381,]    1 -5.489429e-03  2.000000e+00 -5.920544e-03
      [382,]    2 -8.648692e-03  2.000000e+00  4.635000e-03
      [383,]    3 -1.877966e-03  2.000000e+00 -4.225350e-03
      [384,]    4 -4.133990e-03  2.000000e+00  8.913467e-03
      [385,]    5 -8.186680e-03  2.000000e+00  6.577890e-03
      [386,]    6 -4.276877e-03  2.000000e+00 -4.809836e-03
      [387,]    7 -4.096385e-03  2.000000e+00 -4.216071e-03
      [388,]    8 -9.506258e-03  2.000000e+00  9.971599e-03
      [389,]    9 -6.610784e-03  2.000000e+00 -7.873486e-03
      [390,]   10  5.158960e-03  2.000000e+00 -9.132417e-03
      [391,]   11  1.376442e-03  2.000000e+00  4.824177e-03
      [392,]   12  1.363877e-03  2.000000e+00  7.017045e-05
      [393,]   13 -4.019996e-03  2.000000e+00  9.584510e-03
      [394,]   14  8.407613e-03  2.000000e+00 -9.661980e-03
      [395,]   15 -4.437197e-03  2.000000e+00  5.712856e-03
      [396,]   16  6.331365e-03  2.000000e+00 -8.668877e-03
      [397,]   17  4.321671e-03  2.000000e+00  8.997045e-03
      [398,]   18  2.848648e-04  2.000000e+00 -8.084611e-03
      [399,]   19 -4.028127e-03  2.000000e+00  5.990192e-03
      [400,]    1 -9.928776e-03  3.000000e+00  3.536526e-03
      [401,]    2  4.479770e-04  3.000000e+00 -3.419106e-03
      [402,]    3 -2.911798e-03  3.000000e+00 -4.655815e-03
      [403,]    4 -3.706954e-03  3.000000e+00  4.513435e-03
      [404,]    5 -9.734838e-03  3.000000e+00  3.221068e-03
      [405,]    6 -6.208268e-03  3.000000e+00  2.584264e-03
      [406,]    7 -6.984306e-03  3.000000e+00 -4.209850e-03
      [407,]    8 -4.736105e-03  3.000000e+00 -5.292373e-03
      [408,]    9  5.461884e-03  3.000000e+00  5.258628e-03
      [409,]   10  1.003259e-03  3.000000e+00  6.499618e-03
      [410,]   11  8.394438e-04  3.000000e+00  9.543656e-03
      [411,]   12  5.811110e-03  3.000000e+00  3.253984e-03
      [412,]   13  8.365271e-03  3.000000e+00  3.914567e-03
      [413,]   14 -8.300280e-03  3.000000e+00  7.045500e-03
      [414,]   15 -4.221612e-03  3.000000e+00  8.902125e-03
      [415,]   16  2.631122e-03  3.000000e+00 -9.737467e-03
      [416,]   17  6.981202e-03  3.000000e+00  5.239450e-03
      [417,]   18  4.891959e-04  3.000000e+00 -4.672078e-03
      [418,]   19  3.389927e-03  3.000000e+00 -2.387439e-03
      [419,]    1 -8.615601e-03  4.000000e+00 -9.782226e-03
      [420,]    2  3.965879e-04  4.000000e+00  5.015183e-03
      [421,]    3 -7.645488e-03  4.000000e+00  8.567356e-03
      [422,]    4 -1.726015e-03  4.000000e+00  9.942879e-03
      [423,]    5 -4.258192e-03  4.000000e+00  6.904071e-03
      [424,]    6  9.790826e-03  4.000000e+00  4.698146e-03
      [425,]    7 -1.311045e-03  4.000000e+00  6.998211e-03
      [426,]    8 -8.996123e-03  4.000000e+00  2.093504e-03
      [427,]    9 -9.561005e-03  4.000000e+00 -3.063568e-03
      [428,]   10 -2.759288e-03  4.000000e+00 -8.800523e-03
      [429,]   11 -9.028555e-03  4.000000e+00  9.002364e-03
      [430,]   12 -1.559225e-03  4.000000e+00  4.595029e-04
      [431,]   13 -4.310149e-04  4.000000e+00  1.262684e-03
      [432,]   14 -1.398961e-03  4.000000e+00  9.322067e-04
      [433,]   15 -5.557596e-03  4.000000e+00  6.749345e-03
      [434,]   16  9.470013e-03  4.000000e+00 -2.473565e-03
      [435,]   17  7.115265e-03  4.000000e+00 -5.430210e-03
      [436,]   18 -4.092617e-03  4.000000e+00  3.273295e-04
      [437,]   19  3.752588e-03  4.000000e+00 -8.169866e-03
      [438,]    1  4.539289e-03  5.000000e+00 -7.264754e-03
      [439,]    2  7.800752e-04  5.000000e+00  8.929334e-03
      [440,]    3 -7.118614e-03  5.000000e+00  8.021930e-03
      [441,]    4  3.812192e-04  5.000000e+00  6.053546e-03
      [442,]    5  7.511869e-03  5.000000e+00  9.258189e-03
      [443,]    6  7.045566e-03  5.000000e+00 -6.667754e-03
      [444,]    7 -8.702296e-03  5.000000e+00  9.198164e-03
      [445,]    8 -7.873425e-03  5.000000e+00 -2.051811e-04
      [446,]    9  9.424508e-03  5.000000e+00  7.273297e-03
      [447,]   10  5.575266e-03  5.000000e+00 -7.395843e-03
      [448,]   11 -8.546347e-03  5.000000e+00  6.799231e-03
      [449,]   12 -4.912079e-03  5.000000e+00  9.303600e-03
      [450,]   13  3.748280e-03  5.000000e+00  3.913390e-03
      [451,]   14  1.911528e-03  5.000000e+00  6.544692e-03
      [452,]   15  6.617395e-03  5.000000e+00  8.136373e-03
      [453,]   16  7.512354e-03  5.000000e+00 -3.606001e-03
      [454,]   17 -4.120283e-04  5.000000e+00  7.214162e-03
      [455,]   18 -6.926177e-03  5.000000e+00 -1.606442e-03
      [456,]   19  3.650928e-03  5.000000e+00  4.669375e-03
      [457,]    1  1.924326e-03  6.000000e+00  4.169181e-03
      [458,]    2 -8.409295e-03  6.000000e+00 -7.918093e-03
      [459,]    3 -1.854503e-03  6.000000e+00  6.049207e-03
      [460,]    4 -6.120283e-03  6.000000e+00  1.685054e-03
      [461,]    5  5.188902e-03  6.000000e+00  1.479270e-03
      [462,]    6 -2.461028e-03  6.000000e+00 -9.689868e-03
      [463,]    7 -3.936610e-04  6.000000e+00  7.259162e-03
      [464,]    8  9.478588e-03  6.000000e+00  2.282107e-03
      [465,]    9  4.206678e-05  6.000000e+00  3.242338e-03
      [466,]   10  9.368328e-03  6.000000e+00  9.213218e-03
      [467,]   11  2.617021e-03  6.000000e+00 -4.110272e-03
      [468,]   12 -4.834166e-03  6.000000e+00  4.103955e-03
      [469,]   13  4.297373e-03  6.000000e+00 -2.312700e-03
      [470,]   14  6.787159e-03  6.000000e+00  3.713015e-03
      [471,]   15  7.969026e-04  6.000000e+00 -6.028392e-03
      [472,]   16  3.609311e-03  6.000000e+00  8.722828e-03
      [473,]   17 -5.795634e-03  6.000000e+00 -5.788868e-03
      [474,]   18  9.268530e-03  6.000000e+00 -8.327079e-04
      [475,]   19  4.025004e-03  6.000000e+00  1.155900e-03
      [476,]    1  6.519440e-03  7.000000e+00 -3.109875e-03
      [477,]    2 -1.999739e-03  7.000000e+00  9.198084e-03
      [478,]    3 -4.832593e-03  7.000000e+00 -5.161406e-03
      [479,]    4 -1.143383e-03  7.000000e+00 -6.008527e-04
      [480,]    5  6.764279e-04  7.000000e+00  1.888249e-03
      [481,]    6 -4.347282e-03  7.000000e+00  2.939270e-03
      [482,]    7  4.281735e-03  7.000000e+00  7.183859e-04
      [483,]    8 -2.540374e-03  7.000000e+00  3.905064e-03
      [484,]    9 -7.332543e-03  7.000000e+00 -3.475813e-03
      [485,]   10  6.903049e-03  7.000000e+00  1.922110e-03
      [486,]   11  9.461492e-03  7.000000e+00  1.190280e-03
      [487,]   12 -8.677156e-03  7.000000e+00 -4.245605e-03
      [488,]   13 -1.303375e-03  7.000000e+00 -7.211773e-03
      [489,]   14  8.443216e-03  7.000000e+00 -6.199548e-03
      [490,]   15  7.230065e-03  7.000000e+00 -3.373726e-03
      [491,]   16 -5.598055e-03  7.000000e+00  6.722093e-03
      [492,]   17  4.462273e-03  7.000000e+00 -9.807842e-03
      [493,]   18 -4.463692e-03  7.000000e+00 -9.926264e-03
      [494,]   19 -6.835411e-03  7.000000e+00 -6.704588e-03
      [495,]    1  3.887958e-03  8.000000e+00 -9.059043e-03
      [496,]    2  8.547152e-03  8.000000e+00  5.541305e-03
      [497,]    3 -8.549003e-03  8.000000e+00  7.612777e-03
      [498,]    4 -8.566827e-03  8.000000e+00 -8.845007e-03
      [499,]    5  8.216974e-03  8.000000e+00 -2.118474e-03
      [500,]    6  5.980532e-03  8.000000e+00 -8.279688e-03
      [501,]    7 -9.679716e-03  8.000000e+00  7.734823e-04
      [502,]    8 -3.870236e-04  8.000000e+00  3.548674e-03
      [503,]    9 -2.375827e-03  8.000000e+00 -2.248864e-03
      [504,]   10 -1.880726e-03  8.000000e+00  4.106446e-03
      [505,]   11 -2.973401e-03  8.000000e+00  6.567651e-03
      [506,]   12 -5.800322e-04  8.000000e+00  2.141239e-03
      [507,]   13 -6.302401e-03  8.000000e+00 -3.218665e-03
      [508,]   14 -6.744759e-03  8.000000e+00 -6.010225e-03
      [509,]   15 -9.824055e-03  8.000000e+00  7.026419e-03
      [510,]   16  8.102109e-03  8.000000e+00  6.916125e-03
      [511,]   17 -5.713321e-03  8.000000e+00 -9.626905e-03
      [512,]   18  3.138548e-03  8.000000e+00 -7.826143e-03
      [513,]   19  3.570875e-03  8.000000e+00  8.177515e-03
      [514,]    1 -4.409578e-03  9.000000e+00  7.424497e-04
      [515,]    2 -2.448694e-03  9.000000e+00  9.502356e-04
      [516,]    3 -7.597739e-04  9.000000e+00 -2.997966e-03
      [517,]    4 -2.977037e-03  9.000000e+00  5.832234e-03
      [518,]    5  5.203076e-04  9.000000e+00  2.339605e-03
      [519,]    6  1.105711e-03  9.000000e+00  4.470669e-03
      [520,]    7  9.989525e-03  9.000000e+00  8.356761e-03
      [521,]    8 -7.383406e-03  9.000000e+00  4.726561e-03
      [522,]    9  3.913490e-03  9.000000e+00  8.359286e-03
      [523,]   10 -1.727158e-03  9.000000e+00  9.624377e-03
      [524,]   11  4.767243e-03  9.000000e+00  7.261509e-03
      [525,]   12 -5.101810e-03  9.000000e+00  4.176153e-03
      [526,]   13 -1.858359e-03  9.000000e+00 -7.889008e-03
      [527,]   14  4.183593e-03  9.000000e+00 -2.289903e-03
      [528,]   15 -9.706852e-03  9.000000e+00 -5.796897e-03
      [529,]   16  6.530195e-03  9.000000e+00  2.947882e-03
      [530,]   17 -4.461383e-03  9.000000e+00  1.070416e-03
      [531,]   18  4.563234e-03  9.000000e+00  6.881455e-03
      [532,]   19 -8.723894e-04  9.000000e+00 -1.346023e-03
      [533,]    1 -5.927138e-03  1.000000e+01 -6.230366e-03
      [534,]    2 -8.740541e-03  1.000000e+01  4.016245e-03
      [535,]    3  3.109339e-03  1.000000e+01  7.441935e-03
      [536,]    4 -4.916278e-03  1.000000e+01 -9.334358e-04
      [537,]    5 -8.861662e-03  1.000000e+01  4.104420e-03
      [538,]    6  5.233935e-03  1.000000e+01 -6.730337e-04
      [539,]    7  5.282385e-03  1.000000e+01 -7.241201e-03
      [540,]    8 -3.963320e-03  1.000000e+01  6.561149e-03
      [541,]    9  6.658569e-03  1.000000e+01  4.392188e-03
      [542,]   10  8.737708e-03  1.000000e+01 -4.016220e-03
      [543,]   11  8.698314e-03  1.000000e+01  4.117789e-03
      [544,]   12  5.816467e-04  1.000000e+01 -3.104162e-03
      [545,]   13 -8.789157e-03  1.000000e+01  2.750619e-03
      [546,]   14  3.554260e-03  1.000000e+01  7.304225e-03
      [547,]   15  8.869543e-03  1.000000e+01  5.164340e-03
      [548,]   16  5.634922e-03  1.000000e+01  8.604316e-03
      [549,]   17  4.670986e-03  1.000000e+01  7.206057e-04
      [550,]   18 -5.032498e-03  1.000000e+01 -5.821304e-03
      [551,]   19  4.113536e-03  1.000000e+01  3.659630e-03
      [552,]    1  6.418012e-03  1.100000e+01 -9.964243e-04
      [553,]    2 -3.970965e-03  1.100000e+01  3.747606e-03
      [554,]    3  8.042054e-03  1.100000e+01  2.644482e-04
      [555,]    4  1.585577e-03  1.100000e+01  8.886272e-03
      [556,]    5 -2.519366e-03  1.100000e+01 -1.960012e-03
      [557,]    6  8.563646e-03  1.100000e+01  5.402546e-03
      [558,]    7 -4.110760e-03  1.100000e+01  7.742462e-03
      [559,]    8  5.476376e-03  1.100000e+01 -2.012068e-03
      [560,]    9 -9.379309e-03  1.100000e+01  6.588322e-03
      [561,]   10 -2.124151e-03  1.100000e+01  8.066628e-03
      [562,]   11 -2.882654e-03  1.100000e+01  5.891470e-03
      [563,]   12 -5.531561e-03  1.100000e+01  7.579326e-03
      [564,]   13 -4.700064e-04  1.100000e+01  7.335699e-03
      [565,]   14  3.545618e-03  1.100000e+01  2.838007e-03
      [566,]   15 -1.509630e-03  1.100000e+01  7.690981e-03
      [567,]   16  1.807678e-03  1.100000e+01  3.485224e-03
      [568,]   17  4.292764e-03  1.100000e+01 -5.965911e-03
      [569,]   18 -9.143966e-03  1.100000e+01  5.713878e-03
      [570,]   19  2.939296e-03  1.100000e+01 -6.955339e-03
      [571,]    1  5.073075e-03  1.200000e+01  8.072360e-03
      [572,]    2 -1.389284e-05  1.200000e+01 -1.452915e-03
      [573,]    3  7.864159e-03  1.200000e+01  5.862731e-03
      [574,]    4 -7.803254e-03  1.200000e+01  3.571094e-03
      [575,]    5  3.693151e-03  1.200000e+01 -6.911151e-03
      [576,]    6 -6.619596e-03  1.200000e+01 -1.272586e-03
      [577,]    7  4.712939e-03  1.200000e+01 -1.125141e-05
      [578,]    8  4.759437e-03  1.200000e+01  8.418860e-04
      [579,]    9 -5.337837e-04  1.200000e+01  5.120748e-03
      [580,]   10 -3.183101e-03  1.200000e+01  9.935885e-03
      [581,]   11 -8.386912e-03  1.200000e+01 -4.980153e-03
      [582,]   12  1.425666e-03  1.200000e+01  1.393976e-03
      [583,]   13  9.179094e-03  1.200000e+01 -9.920490e-03
      [584,]   14  1.894249e-03  1.200000e+01 -4.694367e-03
      [585,]   15  8.831792e-03  1.200000e+01 -6.925754e-04
      [586,]   16 -3.358424e-03  1.200000e+01  7.991604e-03
      [587,]   17  4.163165e-03  1.200000e+01  1.501776e-03
      [588,]   18 -3.370142e-03  1.200000e+01  5.283847e-03
      [589,]   19  4.235783e-05  1.200000e+01 -8.174928e-03
      [590,]    1 -4.442855e-03  1.300000e+01  9.084640e-04
      [591,]    2  7.005960e-03  1.300000e+01 -4.940531e-03
      [592,]    3 -3.808874e-03  1.300000e+01 -9.567347e-03
      [593,]    4  1.499690e-03  1.300000e+01 -5.818145e-03
      [594,]    5 -1.776528e-04  1.300000e+01  8.129883e-03
      [595,]    6 -3.202583e-03  1.300000e+01 -5.110629e-03
      [596,]    7  6.515003e-03  1.300000e+01  3.232725e-03
      [597,]    8  2.290876e-03  1.300000e+01 -3.200639e-03
      [598,]    9  7.514732e-03  1.300000e+01 -5.606187e-04
      [599,]   10 -4.111522e-03  1.300000e+01 -3.884854e-03
      [600,]   11 -9.612284e-03  1.300000e+01 -4.009868e-03
      [601,]   12 -7.616018e-03  1.300000e+01  5.622378e-03
      [602,]   13  7.016511e-04  1.300000e+01  2.981654e-03
      [603,]   14  6.970002e-03  1.300000e+01  9.591531e-03
      [604,]   15 -5.069425e-03  1.300000e+01 -7.771123e-03
      [605,]   16  6.936777e-03  1.300000e+01 -4.856125e-04
      [606,]   17  4.135329e-03  1.300000e+01 -3.738037e-03
      [607,]   18  4.917398e-03  1.300000e+01 -8.869078e-03
      [608,]   19  9.177900e-03  1.300000e+01  9.901055e-03
      [609,]    1 -3.268838e-03  1.400000e+01  1.850748e-03
      [610,]    2  4.421995e-03  1.400000e+01 -5.363439e-03
      [611,]    3 -8.789514e-03  1.400000e+01 -3.046754e-03
      [612,]    4  3.354291e-03  1.400000e+01  1.194642e-03
      [613,]    5 -7.397009e-03  1.400000e+01 -5.922317e-03
      [614,]    6  3.921069e-03  1.400000e+01 -8.792359e-03
      [615,]    7 -7.903026e-03  1.400000e+01 -1.744017e-03
      [616,]    8  1.426786e-03  1.400000e+01  4.392012e-03
      [617,]    9  3.108232e-03  1.400000e+01  4.073092e-03
      [618,]   10  3.019674e-03  1.400000e+01  1.022582e-04
      [619,]   11 -9.349288e-03  1.400000e+01  6.439425e-03
      [620,]   12 -7.605698e-03  1.400000e+01  6.272703e-03
      [621,]   13 -2.659056e-03  1.400000e+01  5.869055e-04
      [622,]   14 -3.376067e-04  1.400000e+01  7.928915e-03
      [623,]   15 -8.280715e-03  1.400000e+01  9.410503e-03
      [624,]   16 -9.593145e-03  1.400000e+01  4.444309e-03
      [625,]   17 -9.646348e-03  1.400000e+01  8.751047e-03
      [626,]   18 -4.531150e-03  1.400000e+01  9.337149e-03
      [627,]   19 -4.447468e-03  1.400000e+01 -9.649057e-03
      [628,]    1  2.681334e-03  1.500000e+01  2.147377e-03
      [629,]    2 -9.007252e-03  1.500000e+01 -8.382143e-03
      [630,]    3 -3.111784e-03  1.500000e+01  2.023374e-03
      [631,]    4  8.534025e-03  1.500000e+01  2.693906e-03
      [632,]    5  9.102120e-03  1.500000e+01  9.951950e-03
      [633,]    6  5.451578e-03  1.500000e+01  9.927098e-03
      [634,]    7 -5.129142e-03  1.500000e+01 -6.704072e-03
      [635,]    8 -5.881152e-03  1.500000e+01 -3.695048e-03
      [636,]    9 -2.529080e-03  1.500000e+01  2.100981e-04
      [637,]   10  1.039863e-03  1.500000e+01 -4.125531e-03
      [638,]   11  3.230675e-03  1.500000e+01 -1.498415e-03
      [639,]   12 -4.545416e-03  1.500000e+01  6.643334e-05
      [640,]   13  4.650941e-03  1.500000e+01  3.525406e-04
      [641,]   14  3.474968e-03  1.500000e+01  5.284741e-03
      [642,]   15  7.769750e-03  1.500000e+01  2.033028e-03
      [643,]   16 -3.155940e-03  1.500000e+01 -5.330854e-03
      [644,]   17  2.089265e-03  1.500000e+01 -1.915860e-03
      [645,]   18 -8.302029e-03  1.500000e+01  7.237642e-03
      [646,]   19 -8.249036e-03  1.500000e+01 -5.468818e-03
      [647,]    1 -9.766233e-03  1.600000e+01 -5.715861e-03
      [648,]    2  9.040606e-03  1.600000e+01 -4.377442e-03
      [649,]    3 -3.771662e-03  1.600000e+01 -9.453852e-03
      [650,]    4  3.131677e-03  1.600000e+01 -5.986658e-03
      [651,]    5  6.937069e-04  1.600000e+01 -8.324898e-03
      [652,]    6  1.996483e-03  1.600000e+01 -2.211948e-03
      [653,]    7 -2.745436e-03  1.600000e+01 -1.984358e-03
      [654,]    8  7.071975e-03  1.600000e+01  6.486449e-03
      [655,]    9 -3.651398e-03  1.600000e+01  4.281898e-03
      [656,]   10  8.580609e-03  1.600000e+01 -3.944004e-03
      [657,]   11 -1.576731e-04  1.600000e+01 -7.402459e-03
      [658,]   12  4.389790e-03  1.600000e+01  5.194013e-03
      [659,]   13 -1.545708e-03  1.600000e+01  8.217856e-03
      [660,]   14  8.230493e-03  1.600000e+01  7.651260e-03
      [661,]   15  8.728467e-03  1.600000e+01  2.006282e-04
      [662,]   16 -8.663081e-03  1.600000e+01  8.372791e-03
      [663,]   17 -8.696382e-03  1.600000e+01 -5.858705e-03
      [664,]   18  6.802290e-03  1.600000e+01 -9.301810e-03
      [665,]   19 -5.270807e-03  1.600000e+01 -6.771793e-03
      [666,]    1  3.524243e-03  1.700000e+01 -8.059832e-03
      [667,]    2 -2.298680e-04  1.700000e+01 -2.343259e-03
      [668,]    3  7.298128e-03  1.700000e+01 -5.735992e-03
      [669,]    4  2.586667e-03  1.700000e+01  4.334163e-03
      [670,]    5  9.253138e-03  1.700000e+01  5.521389e-03
      [671,]    6 -8.189063e-03  1.700000e+01 -2.890214e-03
      [672,]    7 -4.133959e-03  1.700000e+01  4.583083e-03
      [673,]    8 -7.471047e-03  1.700000e+01  5.907029e-03
      [674,]    9 -9.359198e-04  1.700000e+01  7.095111e-03
      [675,]   10  7.369973e-03  1.700000e+01 -2.119707e-03
      [676,]   11  9.237157e-03  1.700000e+01 -7.261282e-03
      [677,]   12 -6.900391e-03  1.700000e+01  1.221298e-03
      [678,]   13  9.298242e-03  1.700000e+01 -4.484449e-03
      [679,]   14  9.245346e-03  1.700000e+01 -6.560985e-04
      [680,]   15 -7.996343e-03  1.700000e+01 -8.106086e-03
      [681,]   16 -1.812025e-03  1.700000e+01  9.381563e-03
      [682,]   17  4.236803e-03  1.700000e+01 -5.740884e-03
      [683,]   18 -5.057787e-03  1.700000e+01  3.516900e-03
      [684,]   19 -5.218042e-03  1.700000e+01 -1.345524e-03
      [685,]    1  7.201601e-03  1.800000e+01  5.144912e-03
      [686,]    2  5.409383e-03  1.800000e+01 -1.624020e-04
      [687,]    3 -2.410621e-03  1.800000e+01 -6.102145e-03
      [688,]    4 -9.081687e-03  1.800000e+01 -3.526650e-04
      [689,]    5 -9.415111e-04  1.800000e+01 -5.969799e-04
      [690,]    6 -2.533871e-03  1.800000e+01 -9.076817e-03
      [691,]    7 -7.226461e-03  1.800000e+01 -1.393639e-03
      [692,]    8 -2.035315e-03  1.800000e+01  2.651002e-03
      [693,]    9  8.105629e-03  1.800000e+01  5.884423e-03
      [694,]   10  1.663952e-03  1.800000e+01 -7.508874e-03
      [695,]   11 -4.050204e-03  1.800000e+01 -5.966597e-03
      [696,]   12  8.313085e-03  1.800000e+01 -6.417298e-03
      [697,]   13 -5.920375e-03  1.800000e+01 -7.164749e-03
      [698,]   14  6.152241e-03  1.800000e+01 -6.712967e-03
      [699,]   15  4.395076e-03  1.800000e+01  1.040416e-03
      [700,]   16 -7.594018e-04  1.800000e+01 -8.328761e-03
      [701,]   17  2.863143e-03  1.800000e+01 -9.972316e-03
      [702,]   18 -7.001002e-03  1.800000e+01 -6.607501e-03
      [703,]   19 -9.898367e-03  1.800000e+01 -3.348976e-03
      [704,]    1  9.057680e-03  1.900000e+01  7.640352e-03
      [705,]    2  3.596251e-03  1.900000e+01  9.647885e-03
      [706,]    3  1.179292e-03  1.900000e+01 -4.454675e-03
      [707,]    4 -5.853444e-04  1.900000e+01  7.837703e-03
      [708,]    5 -3.735205e-03  1.900000e+01  1.507108e-03
      [709,]    6  5.296973e-03  1.900000e+01  5.856891e-03
      [710,]    7 -1.195894e-03  1.900000e+01 -8.524661e-03
      [711,]    8 -5.363159e-03  1.900000e+01  3.881776e-03
      [712,]    9 -5.895203e-03  1.900000e+01 -6.872066e-03
      [713,]   10 -4.168772e-03  1.900000e+01  1.774802e-03
      [714,]   11  1.227053e-03  1.900000e+01  9.612082e-03
      [715,]   12 -9.721373e-03  1.900000e+01  6.501392e-03
      [716,]   13 -1.705232e-03  1.900000e+01 -9.586783e-03
      [717,]   14 -7.704716e-03  1.900000e+01 -5.411963e-03
      [718,]   15 -5.177250e-04  1.900000e+01 -4.589282e-03
      [719,]   16  9.875455e-04  1.900000e+01 -4.950314e-03
      [720,]   17 -7.022949e-03  1.900000e+01 -8.182665e-03
      [721,]   18  9.332961e-03  1.900000e+01  5.272614e-03
      [722,]   19 -1.656037e-03  1.900000e+01 -7.414172e-03
      
      $n
      [1] 722
      

# three_grid() works

    Code
      three_grid(n_value = 19, num_noise = 2, min_n = -0.05, max_n = 0.05)
    Output
      $df
              [,1]          [,2]          [,3]          [,4]          [,5]
         [1,]    1  1.000000e+00  8.124178e-03 -3.443638e-03 -4.595498e-02
         [2,]    2  1.000000e+00  1.391643e-03  6.891297e-03  2.671738e-02
         [3,]    3  1.000000e+00 -4.792298e-03 -2.910514e-03 -2.845164e-02
         [4,]    4  1.000000e+00 -2.867361e-03  4.812824e-04  3.757026e-02
         [5,]    5  1.000000e+00 -8.036624e-03  9.410904e-03  3.676504e-02
         [6,]    6  1.000000e+00  6.165649e-03 -8.592627e-03 -3.096397e-02
         [7,]    7  1.000000e+00  8.011420e-03  6.289616e-03 -3.713657e-03
         [8,]    8  1.000000e+00 -6.888202e-04 -9.385140e-03  3.178552e-02
         [9,]    9  1.000000e+00  2.941987e-03  1.344373e-03  2.245714e-02
        [10,]   10  1.000000e+00  1.179038e-03 -7.301414e-03  3.596595e-02
        [11,]   11  1.000000e+00 -1.225038e-03  2.961852e-03  4.486436e-02
        [12,]   12  1.000000e+00 -1.839802e-03 -5.763175e-03  3.970906e-03
        [13,]   13  1.000000e+00 -8.745087e-03 -7.878189e-03 -3.710219e-02
        [14,]   14  1.000000e+00 -6.555077e-03 -8.739905e-03  2.119106e-02
        [15,]   15  1.000000e+00  3.039685e-03 -9.304360e-03  2.193383e-02
        [16,]   16  1.000000e+00  1.968097e-03 -5.827845e-03  5.885119e-03
        [17,]   17  1.000000e+00 -3.576873e-03  2.297630e-03 -3.188463e-02
        [18,]   18  1.000000e+00 -6.256678e-04 -3.896577e-03  1.695252e-02
        [19,]   19  1.000000e+00  9.971103e-03 -9.706979e-03 -8.734928e-03
        [20,]    1  2.000000e+00  8.510168e-03 -1.943989e-03 -1.212618e-02
        [21,]    2  2.000000e+00  2.827139e-03 -8.956622e-04  1.270700e-03
        [22,]    3  2.000000e+00  7.983867e-03  7.329231e-03  1.922721e-02
        [23,]    4  2.000000e+00 -1.737718e-04 -7.901102e-03 -4.664516e-02
        [24,]    5  2.000000e+00 -9.383594e-03 -1.077499e-03  2.562518e-02
        [25,]    6  2.000000e+00  2.003639e-03  1.160693e-03 -4.805317e-02
        [26,]    7  2.000000e+00  8.235351e-03  1.219500e-03  1.788533e-02
        [27,]    8  2.000000e+00 -5.767927e-04 -4.683468e-03  1.558704e-02
        [28,]    9  2.000000e+00 -8.676813e-03  3.754727e-03  3.622353e-02
        [29,]   10  2.000000e+00 -3.896825e-03 -8.842582e-03  2.061816e-02
        [30,]   11  2.000000e+00  3.147099e-03 -8.387487e-03 -3.570716e-02
        [31,]   12  2.000000e+00  2.961373e-03 -9.978020e-03  4.006067e-02
        [32,]   13  2.000000e+00 -6.988682e-03  2.194821e-03  2.199711e-02
        [33,]   14  2.000000e+00 -2.446833e-03 -1.495039e-03  1.633653e-02
        [34,]   15  2.000000e+00 -8.064468e-03 -6.104260e-03 -1.958726e-02
        [35,]   16  2.000000e+00  2.668493e-03 -3.446854e-03 -2.113027e-02
        [36,]   17  2.000000e+00 -9.748668e-03 -8.139106e-04 -3.964192e-02
        [37,]   18  2.000000e+00  3.166965e-03  7.859061e-03 -1.109235e-02
        [38,]   19  2.000000e+00 -5.797137e-03  6.745224e-03 -3.918130e-02
        [39,]    1  3.000000e+00  6.729819e-03  3.801970e-03 -2.774248e-02
        [40,]    2  3.000000e+00 -6.948692e-03  2.917797e-03 -4.898508e-02
        [41,]    3  3.000000e+00  8.189429e-03 -5.731245e-03 -3.015235e-02
        [42,]    4  3.000000e+00 -5.131980e-03 -5.219563e-03  2.947018e-02
        [43,]    5  3.000000e+00 -6.812454e-03 -8.221478e-03 -4.472535e-02
        [44,]    6  3.000000e+00  3.855060e-04 -9.930245e-03  2.820021e-02
        [45,]    7  3.000000e+00 -1.202031e-03 -6.503715e-03  3.657595e-02
        [46,]    8  3.000000e+00 -1.031531e-03  4.562084e-03 -9.277405e-03
        [47,]    9  3.000000e+00 -8.157024e-03  9.377155e-03  3.195501e-02
        [48,]   10  3.000000e+00  1.718097e-03 -7.171829e-03  3.340519e-02
        [49,]   11  3.000000e+00  2.718980e-03  8.093255e-03  9.687616e-03
        [50,]   12  3.000000e+00  1.638941e-03 -2.179648e-03 -3.700694e-02
        [51,]   13  3.000000e+00  2.902901e-03 -6.827107e-03 -1.995895e-02
        [52,]   14  3.000000e+00  8.522091e-03 -6.179010e-03  1.891713e-03
        [53,]   15  3.000000e+00  8.789316e-04  8.049303e-03  2.204819e-03
        [54,]   16  3.000000e+00 -6.280160e-03 -5.638084e-03  1.688701e-02
        [55,]   17  3.000000e+00  1.079386e-03 -7.542908e-03 -4.745116e-02
        [56,]   18  3.000000e+00  8.364354e-03 -9.260504e-04  2.502368e-02
        [57,]   19  3.000000e+00 -6.203320e-03 -8.984751e-03 -2.910960e-02
        [58,]    1  4.000000e+00  7.675245e-03  2.722302e-03 -4.563196e-02
        [59,]    2  4.000000e+00  7.903686e-03 -5.522995e-03 -4.754595e-02
        [60,]    3  4.000000e+00  9.771334e-03  1.403361e-03  2.087470e-02
        [61,]    4  4.000000e+00 -1.551525e-03  1.446101e-03  1.125828e-02
        [62,]    5  4.000000e+00 -7.072805e-03  2.704042e-03  3.410738e-02
        [63,]    6  4.000000e+00 -6.294653e-03 -8.914038e-03  4.214554e-02
        [64,]    7  4.000000e+00 -6.929461e-03 -2.620067e-04  8.157021e-03
        [65,]    8  4.000000e+00  2.831100e-03 -1.902759e-03  1.975641e-02
        [66,]    9  4.000000e+00  2.649885e-03  6.007690e-03 -4.845060e-02
        [67,]   10  4.000000e+00  4.958013e-03  1.276564e-03 -3.203262e-02
        [68,]   11  4.000000e+00  8.854278e-03 -4.889959e-03  7.546765e-03
        [69,]   12  4.000000e+00  2.135294e-03 -5.354200e-03  3.530202e-02
        [70,]   13  4.000000e+00 -8.770339e-03  9.409730e-03  1.524499e-02
        [71,]   14  4.000000e+00 -3.288736e-03 -5.923561e-03  3.684505e-02
        [72,]   15  4.000000e+00  4.301946e-03  6.740342e-03 -4.847520e-02
        [73,]   16  4.000000e+00 -1.716214e-03  3.309367e-03 -1.452707e-02
        [74,]   17  4.000000e+00  5.049159e-03  3.666450e-03 -1.237406e-02
        [75,]   18  4.000000e+00  6.828386e-03 -7.733417e-04  4.071550e-02
        [76,]   19  4.000000e+00  8.071567e-03 -8.126574e-03 -8.268405e-03
        [77,]    1  5.000000e+00  4.154307e-03  6.802457e-03 -5.035731e-04
        [78,]    2  5.000000e+00 -8.071286e-03  8.911312e-04 -2.730288e-02
        [79,]    3  5.000000e+00 -6.193354e-03  4.675507e-03  1.616363e-02
        [80,]    4  5.000000e+00 -5.831866e-03  1.320145e-03 -2.584736e-02
        [81,]    5  5.000000e+00 -4.718525e-03  1.486074e-03 -3.883382e-02
        [82,]    6  5.000000e+00 -7.770217e-03 -8.726588e-03  2.295926e-02
        [83,]    7  5.000000e+00 -7.886724e-03  8.381871e-03 -1.241069e-02
        [84,]    8  5.000000e+00  4.969361e-03  6.850851e-03  1.361610e-02
        [85,]    9  5.000000e+00  9.433733e-03 -7.720366e-03  2.875965e-02
        [86,]   10  5.000000e+00  7.127383e-03 -1.487052e-03 -1.480032e-02
        [87,]   11  5.000000e+00  7.949668e-03  8.080831e-03 -2.705773e-02
        [88,]   12  5.000000e+00 -6.463802e-03 -8.553476e-03 -3.457750e-02
        [89,]   13  5.000000e+00 -7.948379e-03  5.989384e-03  2.935648e-02
        [90,]   14  5.000000e+00  2.833229e-03 -8.913970e-03 -3.339890e-02
        [91,]   15  5.000000e+00  5.804955e-03 -2.164222e-03  4.615371e-03
        [92,]   16  5.000000e+00  5.169622e-04 -2.483721e-03 -4.222585e-02
        [93,]   17  5.000000e+00 -1.410634e-03 -3.263303e-03  4.632158e-02
        [94,]   18  5.000000e+00 -7.895493e-04  6.081672e-04 -2.284979e-02
        [95,]   19  5.000000e+00  7.280306e-03 -8.055756e-03 -1.565798e-02
        [96,]    1  6.000000e+00 -6.290187e-03 -1.870207e-03 -3.394468e-02
        [97,]    2  6.000000e+00  2.585488e-03 -3.435507e-03 -3.091716e-02
        [98,]    3  6.000000e+00 -3.116154e-03 -1.427123e-03 -1.627463e-02
        [99,]    4  6.000000e+00  5.197285e-03 -6.670750e-03  2.070922e-02
       [100,]    5  6.000000e+00 -7.733727e-03  6.862231e-04  2.394215e-02
       [101,]    6  6.000000e+00  9.882231e-03  3.733012e-03 -9.716894e-04
       [102,]    7  6.000000e+00  1.908421e-03 -4.277005e-03  2.741069e-02
       [103,]    8  6.000000e+00  1.908479e-03  9.335539e-03 -3.801982e-02
       [104,]    9  6.000000e+00  1.132963e-03 -6.507916e-03 -4.852471e-02
       [105,]   10  6.000000e+00  7.232830e-03  5.609305e-03  1.795839e-02
       [106,]   11  6.000000e+00  2.758769e-03  1.801918e-03  1.712492e-02
       [107,]   12  6.000000e+00 -4.553525e-03 -5.976260e-03 -2.048495e-02
       [108,]   13  6.000000e+00 -9.725048e-03 -1.411748e-03  1.799800e-02
       [109,]   14  6.000000e+00  7.495971e-03  3.417429e-03 -3.501128e-02
       [110,]   15  6.000000e+00  1.202918e-03  5.132195e-03 -3.227235e-02
       [111,]   16  6.000000e+00 -2.447500e-03  6.410127e-03 -4.098759e-02
       [112,]   17  6.000000e+00  3.026401e-03  5.188265e-03  4.724632e-02
       [113,]   18  6.000000e+00  1.394902e-03 -7.606264e-03  1.349210e-02
       [114,]   19  6.000000e+00 -2.396136e-03 -8.758609e-03  3.256790e-03
       [115,]    1  7.000000e+00 -8.503313e-03  2.868308e-03  2.853291e-02
       [116,]    2  7.000000e+00  3.977120e-03  8.898322e-04  3.351378e-02
       [117,]    3  7.000000e+00 -6.830826e-03  1.500765e-03  4.236649e-02
       [118,]    4  7.000000e+00 -2.780382e-03  9.313555e-03 -1.341455e-02
       [119,]    5  7.000000e+00 -8.744064e-04  5.421682e-03 -4.583760e-02
       [120,]    6  7.000000e+00  7.252224e-03 -5.201622e-03 -1.674615e-02
       [121,]    7  7.000000e+00  1.828240e-03  6.568626e-03 -2.397815e-02
       [122,]    8  7.000000e+00 -7.502448e-03  8.958034e-03  4.026603e-02
       [123,]    9  7.000000e+00  4.108727e-03  6.354810e-03 -1.948318e-02
       [124,]   10  7.000000e+00 -1.934096e-03 -2.428218e-03  4.502416e-02
       [125,]   11  7.000000e+00  1.484930e-03  5.091455e-04 -2.955782e-02
       [126,]   12  7.000000e+00  7.904536e-03  6.739245e-03  3.472863e-02
       [127,]   13  7.000000e+00 -2.803204e-03  7.885662e-03 -1.236937e-02
       [128,]   14  7.000000e+00 -2.699075e-05 -2.144002e-03 -6.509437e-03
       [129,]   15  7.000000e+00 -7.918596e-03  8.369593e-03 -3.332570e-02
       [130,]   16  7.000000e+00  8.436244e-03  9.251521e-03  4.188470e-02
       [131,]   17  7.000000e+00  3.841216e-03  4.769873e-03  4.799588e-03
       [132,]   18  7.000000e+00 -6.599277e-03  4.059189e-03  9.816996e-03
       [133,]   19  7.000000e+00  8.836028e-03  6.178087e-06  2.299659e-02
       [134,]    1  8.000000e+00 -7.185206e-03  4.328919e-03 -4.505719e-02
       [135,]    2  8.000000e+00  4.310124e-03 -1.456172e-03  4.056851e-02
       [136,]    3  8.000000e+00  4.622817e-03  1.031921e-03  8.499063e-03
       [137,]    4  8.000000e+00  5.809397e-03 -9.143837e-03 -4.917396e-02
       [138,]    5  8.000000e+00 -6.931980e-03 -8.742367e-03 -3.052782e-02
       [139,]    6  8.000000e+00  4.908143e-03  1.693190e-03 -1.446719e-02
       [140,]    7  8.000000e+00 -8.764649e-03 -1.959514e-03  2.681782e-02
       [141,]    8  8.000000e+00 -3.807404e-03  4.845282e-03 -3.215182e-02
       [142,]    9  8.000000e+00  3.146600e-03 -6.554405e-03  1.510659e-02
       [143,]   10  8.000000e+00 -2.722901e-03  1.999421e-03  1.833131e-02
       [144,]   11  8.000000e+00  4.236341e-03  6.138640e-03  4.318452e-02
       [145,]   12  8.000000e+00  5.930592e-03 -2.953229e-03  3.499008e-02
       [146,]   13  8.000000e+00  7.717957e-03  3.678565e-03  4.141254e-02
       [147,]   14  8.000000e+00  2.287048e-03 -5.291641e-03 -1.362796e-03
       [148,]   15  8.000000e+00 -7.893594e-03 -2.556391e-03 -2.258668e-02
       [149,]   16  8.000000e+00  7.580571e-03  8.455372e-03  4.249389e-02
       [150,]   17  8.000000e+00 -1.732173e-03  1.921221e-03 -2.208354e-02
       [151,]   18  8.000000e+00 -7.956651e-03  5.660565e-03  1.138374e-03
       [152,]   19  8.000000e+00  7.793690e-03  8.362482e-03 -4.085769e-02
       [153,]    1  9.000000e+00  2.156789e-03 -2.622270e-03 -4.116320e-02
       [154,]    2  9.000000e+00 -4.598033e-03 -3.761914e-03 -2.550988e-02
       [155,]    3  9.000000e+00  6.403200e-04 -3.424589e-03 -4.932891e-02
       [156,]    4  9.000000e+00  3.778334e-03 -1.576951e-03 -1.927353e-02
       [157,]    5  9.000000e+00  8.123461e-03 -8.401258e-03  4.286371e-02
       [158,]    6  9.000000e+00 -4.365574e-03 -5.754086e-03  4.280882e-02
       [159,]    7  9.000000e+00  3.578512e-03 -6.457054e-03 -3.880552e-02
       [160,]    8  9.000000e+00 -8.379409e-03 -5.576639e-03 -1.205992e-02
       [161,]    9  9.000000e+00  5.790402e-03  3.483966e-03 -1.073886e-02
       [162,]   10  9.000000e+00 -3.646167e-03 -1.036426e-03 -2.577444e-02
       [163,]   11  9.000000e+00 -8.413463e-03  5.949426e-03  2.871906e-02
       [164,]   12  9.000000e+00  4.308330e-03 -4.055288e-03  4.814526e-02
       [165,]   13  9.000000e+00  6.575937e-04 -1.389019e-03 -4.392057e-02
       [166,]   14  9.000000e+00 -2.723460e-03  5.716461e-04  4.562522e-02
       [167,]   15  9.000000e+00  2.572123e-03 -9.628675e-03  4.109367e-02
       [168,]   16  9.000000e+00 -8.137307e-03  3.277114e-03  1.895656e-02
       [169,]   17  9.000000e+00  1.131358e-03  8.479375e-03 -1.107319e-02
       [170,]   18  9.000000e+00 -4.136042e-03 -4.065323e-03  1.482847e-02
       [171,]   19  9.000000e+00 -5.872791e-03 -9.048134e-04  4.451275e-02
       [172,]    1  1.000000e+01 -1.989274e-03 -3.425837e-03  2.103587e-02
       [173,]    2  1.000000e+01 -4.335368e-03 -8.000005e-03  6.460953e-03
       [174,]    3  1.000000e+01 -2.534346e-03  6.258925e-03 -4.273817e-02
       [175,]    4  1.000000e+01 -2.758228e-03  3.393085e-03  5.466591e-03
       [176,]    5  1.000000e+01  4.031213e-03  5.198048e-03 -4.124682e-02
       [177,]    6  1.000000e+01  9.489326e-03 -5.371736e-03 -3.103995e-02
       [178,]    7  1.000000e+01 -6.893556e-04 -6.351854e-03 -1.066735e-02
       [179,]    8  1.000000e+01  9.026438e-03  4.035104e-03  2.150426e-02
       [180,]    9  1.000000e+01 -8.990504e-03 -2.861124e-03 -8.867650e-03
       [181,]   10  1.000000e+01 -6.022869e-03  8.776436e-03 -1.321469e-02
       [182,]   11  1.000000e+01 -3.076065e-04 -9.409343e-03  2.521920e-02
       [183,]   12  1.000000e+01 -6.278473e-03  8.865740e-04  1.662150e-02
       [184,]   13  1.000000e+01 -2.855995e-03  7.323564e-03  4.737055e-02
       [185,]   14  1.000000e+01  6.847265e-03 -1.705751e-03  1.142768e-02
       [186,]   15  1.000000e+01  8.753897e-03  1.567409e-03 -2.584830e-02
       [187,]   16  1.000000e+01 -3.271805e-03  7.289348e-03 -4.873602e-02
       [188,]   17  1.000000e+01 -4.313401e-03 -6.672655e-03  5.080838e-03
       [189,]   18  1.000000e+01 -6.255453e-03  3.815950e-03 -3.556777e-02
       [190,]   19  1.000000e+01 -8.095944e-03  2.942335e-04  2.813483e-02
       [191,]    1  1.100000e+01 -3.959347e-03  2.685807e-03 -3.019307e-02
       [192,]    2  1.100000e+01  1.648695e-03 -7.040128e-03  2.647572e-02
       [193,]    3  1.100000e+01 -2.208860e-03  4.762521e-03  4.976672e-02
       [194,]    4  1.100000e+01 -1.732378e-03  5.323742e-03 -1.383833e-02
       [195,]    5  1.100000e+01 -7.560322e-03 -7.111525e-03 -1.702941e-02
       [196,]    6  1.100000e+01 -5.353250e-03 -7.190495e-03  1.053227e-02
       [197,]    7  1.100000e+01 -4.059257e-03  2.728205e-03  2.539950e-02
       [198,]    8  1.100000e+01  6.526559e-03 -9.750771e-03 -3.956183e-03
       [199,]    9  1.100000e+01  7.965984e-03 -4.987743e-03 -2.543802e-02
       [200,]   10  1.100000e+01 -9.313612e-03  9.793845e-04  2.756319e-04
       [201,]   11  1.100000e+01 -9.362255e-03  7.940113e-03  2.525965e-02
       [202,]   12  1.100000e+01  2.499252e-03 -1.744993e-03 -1.328972e-02
       [203,]   13  1.100000e+01  7.807261e-03 -3.194318e-03 -2.053304e-02
       [204,]   14  1.100000e+01 -2.422849e-03  4.039531e-03  3.446120e-02
       [205,]   15  1.100000e+01  1.555406e-03 -1.827810e-03 -3.502182e-02
       [206,]   16  1.100000e+01  8.662333e-03 -6.056735e-03  4.099398e-02
       [207,]   17  1.100000e+01 -1.923632e-03 -3.577160e-03  1.761458e-02
       [208,]   18  1.100000e+01 -8.089308e-03  8.580138e-03  4.481736e-02
       [209,]   19  1.100000e+01  9.949015e-03  4.404908e-03 -4.801782e-02
       [210,]    1  1.200000e+01  3.053061e-03 -1.333212e-03 -4.791488e-02
       [211,]    2  1.200000e+01 -7.314230e-03 -8.796207e-03 -4.679056e-02
       [212,]    3  1.200000e+01 -3.183824e-03 -5.968613e-03 -3.678429e-03
       [213,]    4  1.200000e+01  6.288714e-03 -9.336182e-04  2.845056e-02
       [214,]    5  1.200000e+01 -8.988095e-03  2.295755e-03 -2.379404e-02
       [215,]    6  1.200000e+01  5.787779e-03  5.862211e-03  3.424222e-02
       [216,]    7  1.200000e+01 -2.719086e-03  6.992313e-03  2.458123e-02
       [217,]    8  1.200000e+01 -4.737982e-04 -1.019514e-04 -3.856414e-02
       [218,]    9  1.200000e+01  6.114454e-03  2.215128e-03  2.316987e-02
       [219,]   10  1.200000e+01  3.687395e-03 -6.888008e-03 -3.928309e-02
       [220,]   11  1.200000e+01 -9.190662e-03 -3.442055e-04  3.849106e-02
       [221,]   12  1.200000e+01 -6.961224e-03 -1.021214e-03  1.099428e-03
       [222,]   13  1.200000e+01 -8.401188e-04  1.894261e-03  4.839619e-02
       [223,]   14  1.200000e+01  6.185991e-03 -4.569165e-03  3.353079e-02
       [224,]   15  1.200000e+01  4.665265e-03  7.422544e-03  1.667827e-02
       [225,]   16  1.200000e+01 -7.771238e-03 -8.863161e-03 -8.944256e-04
       [226,]   17  1.200000e+01 -7.201051e-03 -2.767813e-03 -3.905501e-02
       [227,]   18  1.200000e+01  1.109557e-03  7.980463e-03 -3.480769e-02
       [228,]   19  1.200000e+01 -2.159565e-03 -2.786208e-03  3.309222e-02
       [229,]    1  1.300000e+01 -5.927098e-03  9.337891e-04  9.116598e-03
       [230,]    2  1.300000e+01 -1.993570e-03 -2.674021e-03  2.761087e-03
       [231,]    3  1.300000e+01  1.291416e-03  6.161841e-03 -4.342722e-02
       [232,]    4  1.300000e+01  6.190910e-03 -2.380880e-03  1.726424e-02
       [233,]    5  1.300000e+01  5.017797e-03 -4.352470e-03  2.655819e-02
       [234,]    6  1.300000e+01 -6.386814e-03 -7.617288e-04 -2.533096e-02
       [235,]    7  1.300000e+01  7.080693e-03  4.045069e-03 -1.636529e-02
       [236,]    8  1.300000e+01  8.571925e-03  7.285794e-04  2.224537e-03
       [237,]    9  1.300000e+01  6.885707e-03 -1.112248e-03 -1.341185e-02
       [238,]   10  1.300000e+01 -6.832592e-03 -5.171503e-03 -1.857520e-02
       [239,]   11  1.300000e+01  9.081327e-03  3.161240e-03 -4.569429e-02
       [240,]   12  1.300000e+01 -2.452100e-03 -2.433089e-03  4.582746e-02
       [241,]   13  1.300000e+01 -4.505364e-04  4.876077e-03 -3.455254e-02
       [242,]   14  1.300000e+01 -9.730280e-04 -7.385134e-03  2.582430e-02
       [243,]   15  1.300000e+01 -7.420903e-03  2.459800e-03  1.039657e-02
       [244,]   16  1.300000e+01 -3.837808e-03 -9.085466e-03 -1.376949e-02
       [245,]   17  1.300000e+01 -3.389438e-03 -2.135503e-03 -4.073165e-02
       [246,]   18  1.300000e+01 -4.694906e-03  7.456168e-03  4.847071e-02
       [247,]   19  1.300000e+01  9.292101e-03  9.269159e-03 -2.970373e-02
       [248,]    1  1.400000e+01  2.809439e-03  7.010324e-03  6.991699e-05
       [249,]    2  1.400000e+01  5.548812e-04 -9.771664e-03  2.383065e-02
       [250,]    3  1.400000e+01 -4.395632e-03 -9.475544e-03 -4.223552e-02
       [251,]    4  1.400000e+01 -2.919785e-04  2.088122e-03  1.261618e-02
       [252,]    5  1.400000e+01  6.536049e-03  9.110802e-03  4.623033e-02
       [253,]    6  1.400000e+01  1.390530e-03  2.931319e-03 -2.674662e-02
       [254,]    7  1.400000e+01 -9.811379e-03 -3.037637e-03  4.767000e-02
       [255,]    8  1.400000e+01  7.485827e-03 -1.958815e-03 -2.139238e-02
       [256,]    9  1.400000e+01 -8.037336e-03 -4.180963e-04  6.776200e-03
       [257,]   10  1.400000e+01 -7.564791e-03 -3.345936e-03  2.578724e-02
       [258,]   11  1.400000e+01  2.760285e-03  2.106166e-03  4.627391e-02
       [259,]   12  1.400000e+01 -2.836160e-03 -5.138136e-03  4.988278e-03
       [260,]   13  1.400000e+01 -3.222136e-03 -3.903976e-03  1.933860e-02
       [261,]   14  1.400000e+01 -9.139869e-03 -5.951670e-03 -2.677462e-02
       [262,]   15  1.400000e+01  3.456228e-03 -2.219871e-03 -1.975191e-02
       [263,]   16  1.400000e+01  4.444186e-03  2.983104e-03  4.798282e-02
       [264,]   17  1.400000e+01 -9.760273e-03 -3.237790e-03 -7.112537e-03
       [265,]   18  1.400000e+01 -1.491733e-03 -9.473253e-03  8.021953e-03
       [266,]   19  1.400000e+01  6.685134e-03  5.490189e-03  4.239841e-03
       [267,]    1  1.500000e+01  7.112059e-03  8.317638e-04  2.394034e-02
       [268,]    2  1.500000e+01 -9.339865e-03 -6.732507e-03  3.145418e-03
       [269,]    3  1.500000e+01 -4.245543e-03  7.125508e-03 -2.163410e-02
       [270,]    4  1.500000e+01 -5.747640e-03  4.033672e-03 -2.126563e-03
       [271,]    5  1.500000e+01  9.762612e-03  7.948379e-04  2.195558e-02
       [272,]    6  1.500000e+01  5.082966e-03  3.780131e-03  3.284489e-03
       [273,]    7  1.500000e+01  8.992155e-03  6.789074e-03  4.787364e-02
       [274,]    8  1.500000e+01  6.584313e-03 -7.909685e-03  4.729554e-02
       [275,]    9  1.500000e+01 -8.053304e-04  7.031569e-03 -1.139702e-02
       [276,]   10  1.500000e+01 -2.856928e-03  2.369103e-03 -1.521704e-02
       [277,]   11  1.500000e+01  6.592752e-03 -5.785696e-04  2.190798e-02
       [278,]   12  1.500000e+01 -9.892893e-03 -8.320918e-03 -1.470256e-02
       [279,]   13  1.500000e+01  7.213955e-03  2.671022e-03 -2.105489e-02
       [280,]   14  1.500000e+01 -4.057860e-03 -7.259535e-03  4.948568e-02
       [281,]   15  1.500000e+01 -7.326619e-03 -6.283451e-03 -4.643196e-02
       [282,]   16  1.500000e+01  5.982906e-03 -3.549791e-03  2.906671e-02
       [283,]   17  1.500000e+01 -7.121738e-03  1.624180e-03 -4.218292e-02
       [284,]   18  1.500000e+01 -6.153689e-03 -3.173237e-03  4.991574e-02
       [285,]   19  1.500000e+01 -4.530639e-03 -1.837188e-03 -4.200190e-02
       [286,]    1  1.600000e+01 -2.977271e-03  5.819077e-03 -1.333662e-02
       [287,]    2  1.600000e+01  6.951713e-04 -4.107218e-03 -2.654866e-02
       [288,]    3  1.600000e+01 -4.301289e-03  1.612727e-03 -2.783990e-02
       [289,]    4  1.600000e+01 -6.387494e-03 -3.106765e-03 -4.780630e-02
       [290,]    5  1.600000e+01  7.432062e-03 -5.205726e-03  4.970827e-02
       [291,]    6  1.600000e+01 -9.960357e-03  8.921946e-03  3.006407e-03
       [292,]    7  1.600000e+01 -2.554415e-03 -9.041786e-03  8.176925e-03
       [293,]    8  1.600000e+01 -1.175548e-03 -4.654371e-04  4.956267e-02
       [294,]    9  1.600000e+01 -5.152251e-03  7.707501e-03 -1.627479e-02
       [295,]   10  1.600000e+01 -5.468458e-03  1.476067e-03 -1.695537e-03
       [296,]   11  1.600000e+01  7.078435e-03  4.465915e-03 -4.294849e-02
       [297,]   12  1.600000e+01 -3.612173e-03  1.213135e-03 -1.343644e-02
       [298,]   13  1.600000e+01  8.896829e-04  2.518088e-03 -2.834701e-02
       [299,]   14  1.600000e+01  9.429478e-03 -8.665436e-03  2.343479e-02
       [300,]   15  1.600000e+01  3.597598e-03 -4.726525e-03 -3.167909e-02
       [301,]   16  1.600000e+01 -7.940527e-03  4.317620e-03  1.233606e-02
       [302,]   17  1.600000e+01  5.815264e-03  2.468865e-04 -1.595814e-02
       [303,]   18  1.600000e+01  8.447204e-03 -7.573496e-03 -2.958210e-03
       [304,]   19  1.600000e+01 -4.286200e-03  1.197882e-03  3.158711e-02
       [305,]    1  1.700000e+01 -9.988666e-03 -9.394548e-03  1.725153e-02
       [306,]    2  1.700000e+01 -7.137036e-03  9.222476e-03  3.596430e-03
       [307,]    3  1.700000e+01  3.127460e-04 -1.127845e-04  4.273322e-02
       [308,]    4  1.700000e+01 -2.467935e-03  7.690986e-03 -4.458161e-02
       [309,]    5  1.700000e+01 -5.686786e-03  1.632591e-03 -3.275242e-02
       [310,]    6  1.700000e+01 -7.016596e-03 -8.785331e-03  1.450788e-02
       [311,]    7  1.700000e+01 -7.068782e-03 -5.418908e-03 -2.351118e-03
       [312,]    8  1.700000e+01  8.462850e-03  3.673432e-03 -1.977617e-02
       [313,]    9  1.700000e+01 -1.039249e-03 -1.276375e-03  3.313871e-02
       [314,]   10  1.700000e+01 -7.789385e-03  3.980618e-03 -2.347922e-02
       [315,]   11  1.700000e+01 -1.731518e-03 -5.461563e-03 -8.599617e-03
       [316,]   12  1.700000e+01  4.640812e-03 -8.452436e-03 -4.361080e-02
       [317,]   13  1.700000e+01 -4.913826e-03 -9.329997e-03  3.581735e-02
       [318,]   14  1.700000e+01 -6.317783e-03 -4.233597e-03 -2.593632e-02
       [319,]   15  1.700000e+01  4.546898e-03  8.618832e-03  1.919897e-02
       [320,]   16  1.700000e+01 -7.329898e-03  3.841355e-03 -3.999030e-02
       [321,]   17  1.700000e+01  3.156973e-03  4.485796e-03  1.818160e-03
       [322,]   18  1.700000e+01  1.402710e-03 -8.383547e-03  3.022244e-02
       [323,]   19  1.700000e+01  4.163981e-03 -7.348133e-04  3.515036e-02
       [324,]    1  1.800000e+01 -3.784492e-03  8.886913e-03  4.743709e-02
       [325,]    2  1.800000e+01  6.764322e-03  3.720362e-03 -4.547735e-02
       [326,]    3  1.800000e+01 -9.219848e-03 -4.350904e-03 -4.286151e-02
       [327,]    4  1.800000e+01  8.947567e-03  4.360508e-03 -3.121946e-02
       [328,]    5  1.800000e+01  5.449948e-03 -8.184809e-03 -4.569175e-03
       [329,]    6  1.800000e+01 -3.219428e-03  2.312188e-03  5.641874e-03
       [330,]    7  1.800000e+01  9.288966e-03 -8.782262e-03  4.250327e-02
       [331,]    8  1.800000e+01  3.586987e-03 -6.843370e-03  3.357234e-03
       [332,]    9  1.800000e+01 -4.147651e-03 -8.441619e-03 -5.549375e-04
       [333,]   10  1.800000e+01  7.488758e-04  8.044291e-03 -2.555933e-02
       [334,]   11  1.800000e+01 -2.371676e-03 -8.593162e-03  2.165986e-02
       [335,]   12  1.800000e+01  1.274808e-03  9.048052e-03  2.600802e-02
       [336,]   13  1.800000e+01 -5.957310e-03  5.022304e-03 -4.266945e-02
       [337,]   14  1.800000e+01 -8.669652e-03  5.813386e-03  1.312419e-02
       [338,]   15  1.800000e+01 -3.270653e-03 -4.978115e-04 -3.457974e-02
       [339,]   16  1.800000e+01  7.198392e-03 -3.781265e-03  3.813075e-02
       [340,]   17  1.800000e+01 -7.418030e-03 -5.854440e-03  4.583308e-02
       [341,]   18  1.800000e+01 -9.927640e-03 -8.185530e-03  3.153494e-02
       [342,]   19  1.800000e+01  2.289039e-03 -6.097144e-03 -1.656454e-02
       [343,]    1  1.900000e+01 -3.153726e-03 -6.614133e-03  4.074052e-02
       [344,]    2  1.900000e+01 -9.654501e-03 -7.498770e-03 -5.229591e-03
       [345,]    3  1.900000e+01  8.348924e-03  6.822533e-03  4.289947e-02
       [346,]    4  1.900000e+01  9.815200e-03  6.410245e-03 -4.693646e-02
       [347,]    5  1.900000e+01 -2.868335e-03 -7.715640e-03  4.079205e-02
       [348,]    6  1.900000e+01 -7.793873e-03  5.352304e-03  4.593775e-02
       [349,]    7  1.900000e+01 -1.010439e-03 -4.011615e-03 -3.207291e-02
       [350,]    8  1.900000e+01 -6.769806e-03  7.927158e-03 -4.309148e-02
       [351,]    9  1.900000e+01  1.441549e-04  8.928919e-03  4.208677e-02
       [352,]   10  1.900000e+01  7.171226e-03 -6.519079e-03  3.084040e-02
       [353,]   11  1.900000e+01 -6.868655e-03 -8.631516e-03 -3.804917e-03
       [354,]   12  1.900000e+01  7.618252e-03  8.646982e-03 -1.082145e-02
       [355,]   13  1.900000e+01 -3.530397e-04  2.897096e-03 -8.248837e-03
       [356,]   14  1.900000e+01  5.424616e-03 -4.434600e-03 -2.394960e-02
       [357,]   15  1.900000e+01 -3.073482e-03  2.054127e-03 -4.812042e-02
       [358,]   16  1.900000e+01 -8.715833e-03 -8.993642e-03  4.655695e-02
       [359,]   17  1.900000e+01 -1.407769e-04 -5.311832e-03  4.746066e-02
       [360,]   18  1.900000e+01 -8.524857e-04  1.610883e-03 -1.690880e-02
       [361,]   19  1.900000e+01  6.141171e-03  8.784747e-03 -3.542551e-02
       [362,]    1  4.719050e-03  1.000000e+00  7.121565e-03 -2.490102e-02
       [363,]    2  2.184780e-03  1.000000e+00 -9.518970e-03 -4.686855e-02
       [364,]    3 -9.260203e-03  1.000000e+00 -4.829693e-03  4.568508e-02
       [365,]    4 -5.324397e-03  1.000000e+00 -7.505171e-03 -1.694252e-03
       [366,]    5  8.527036e-04  1.000000e+00 -9.361616e-03 -2.421517e-02
       [367,]    6  5.223168e-03  1.000000e+00  7.557629e-03  1.448532e-02
       [368,]    7 -8.710902e-03  1.000000e+00  9.807455e-03  3.271302e-02
       [369,]    8  2.249607e-03  1.000000e+00  3.393233e-04 -6.234291e-03
       [370,]    9  5.734180e-03  1.000000e+00  3.515476e-03 -4.804818e-02
       [371,]   10 -2.970875e-03  1.000000e+00 -2.117157e-03 -8.559206e-05
       [372,]   11 -8.248991e-03  1.000000e+00  7.559761e-03 -2.051229e-03
       [373,]   12  7.699294e-03  1.000000e+00  1.834826e-03 -4.483748e-02
       [374,]   13  8.070712e-03  1.000000e+00 -9.057311e-03  1.087038e-02
       [375,]   14 -8.876201e-03  1.000000e+00 -5.255012e-03 -3.384040e-03
       [376,]   15 -3.828059e-03  1.000000e+00  4.960460e-03 -4.725878e-02
       [377,]   16  1.765430e-03  1.000000e+00  3.727356e-03 -4.406941e-02
       [378,]   17 -1.381279e-03  1.000000e+00  8.856493e-03  1.295361e-02
       [379,]   18  5.000991e-03  1.000000e+00  6.618167e-03  2.167122e-02
       [380,]   19 -6.972830e-03  1.000000e+00  1.241114e-04 -4.919681e-02
       [381,]    1 -6.414732e-03  2.000000e+00  2.549877e-03 -3.184544e-02
       [382,]    2 -2.952841e-03  2.000000e+00  5.113155e-03 -1.948746e-02
       [383,]    3  2.974263e-04  2.000000e+00 -5.408926e-04  2.529822e-02
       [384,]    4  6.229766e-03  2.000000e+00 -3.431356e-03  9.170931e-03
       [385,]    5 -7.861248e-03  2.000000e+00  5.106738e-03 -1.527652e-02
       [386,]    6  2.584182e-03  2.000000e+00 -2.684442e-03  2.237138e-02
       [387,]    7  6.876220e-03  2.000000e+00 -4.270484e-03  9.025664e-03
       [388,]    8 -7.346659e-03  2.000000e+00 -8.871276e-03  3.841776e-02
       [389,]    9  1.557158e-03  2.000000e+00 -6.960300e-03  1.986252e-02
       [390,]   10 -7.551974e-03  2.000000e+00  1.468553e-03 -2.024381e-03
       [391,]   11  5.635559e-03  2.000000e+00 -1.502855e-03 -3.638958e-03
       [392,]   12 -2.129707e-03  2.000000e+00  3.995790e-03  4.160269e-02
       [393,]   13 -8.844936e-03  2.000000e+00  4.274365e-03 -2.210917e-02
       [394,]   14 -8.818969e-04  2.000000e+00 -1.741195e-03  9.798289e-03
       [395,]   15 -5.531683e-03  2.000000e+00  3.463503e-03  2.813212e-02
       [396,]   16 -1.328320e-03  2.000000e+00 -8.955959e-03  1.161731e-02
       [397,]   17  5.024899e-03  2.000000e+00  8.380865e-03 -7.181504e-03
       [398,]   18  9.911261e-03  2.000000e+00  4.015975e-03  3.274150e-02
       [399,]   19  6.293679e-04  2.000000e+00 -6.231887e-03  2.195759e-02
       [400,]    1 -1.966258e-03  3.000000e+00 -4.617252e-03  1.017579e-02
       [401,]    2  5.428778e-03  3.000000e+00  6.661480e-03 -4.184624e-02
       [402,]    3  8.004948e-03  3.000000e+00  8.831003e-03  3.240644e-02
       [403,]    4 -6.835594e-03  3.000000e+00 -7.669115e-03 -4.793698e-02
       [404,]    5 -1.138257e-03  3.000000e+00  4.618348e-03  4.696704e-02
       [405,]    6 -4.319614e-03  3.000000e+00 -1.667781e-03  2.402314e-02
       [406,]    7  1.614245e-03  3.000000e+00  7.624110e-03 -2.001644e-02
       [407,]    8 -8.782634e-04  3.000000e+00  7.467307e-06  2.770050e-02
       [408,]    9  9.543025e-04  3.000000e+00 -9.448559e-03 -3.930738e-03
       [409,]   10 -3.174142e-03  3.000000e+00 -3.788072e-03  2.764713e-02
       [410,]   11 -7.271945e-03  3.000000e+00  1.586975e-03 -4.944980e-02
       [411,]   12  2.266740e-03  3.000000e+00  4.942988e-03 -8.236953e-03
       [412,]   13 -4.577580e-03  3.000000e+00 -1.803178e-03  3.023053e-02
       [413,]   14  1.332218e-03  3.000000e+00 -4.238139e-04  1.955693e-02
       [414,]   15  7.189330e-03  3.000000e+00  5.725031e-03 -4.117295e-02
       [415,]   16  6.919522e-03  3.000000e+00 -9.874436e-03  4.636580e-02
       [416,]   17  1.159072e-03  3.000000e+00  2.379983e-04  3.212397e-02
       [417,]   18 -3.313073e-03  3.000000e+00 -2.104690e-03  4.390859e-03
       [418,]   19 -2.030413e-03  3.000000e+00  2.838945e-03 -1.128168e-02
       [419,]    1  9.740572e-03  4.000000e+00 -7.790841e-03  1.274856e-02
       [420,]    2  2.305015e-03  4.000000e+00  3.215552e-03 -3.872981e-02
       [421,]    3  8.888612e-03  4.000000e+00  7.039901e-03  1.738305e-02
       [422,]    4  1.654222e-03  4.000000e+00 -8.612470e-03  2.541680e-03
       [423,]    5 -7.208670e-03  4.000000e+00 -5.355847e-03  2.832790e-02
       [424,]    6 -8.384901e-03  4.000000e+00  6.740230e-03 -3.933804e-02
       [425,]    7 -6.927158e-03  4.000000e+00 -1.525651e-03  1.680248e-02
       [426,]    8 -1.125888e-03  4.000000e+00  2.949451e-04 -8.446755e-04
       [427,]    9 -7.473087e-04  4.000000e+00  4.238079e-03 -4.111465e-02
       [428,]   10 -2.935396e-03  4.000000e+00  2.536762e-03  2.642885e-02
       [429,]   11 -4.377720e-04  4.000000e+00  2.692013e-03  4.722976e-02
       [430,]   12 -4.500235e-04  4.000000e+00 -3.097492e-03  1.143594e-02
       [431,]   13  1.673121e-03  4.000000e+00 -4.615636e-03 -3.369414e-02
       [432,]   14  4.696026e-03  4.000000e+00  8.435945e-03 -4.448640e-02
       [433,]   15  3.010851e-03  4.000000e+00  9.658966e-03 -5.295939e-03
       [434,]   16  3.697113e-03  4.000000e+00  4.144166e-03  8.587251e-03
       [435,]   17 -7.912113e-03  4.000000e+00  7.400118e-03  6.016336e-03
       [436,]   18  6.952831e-03  4.000000e+00 -5.365917e-03 -4.331658e-02
       [437,]   19 -8.033111e-03  4.000000e+00  1.002052e-03  4.619585e-02
       [438,]    1  6.784981e-03  5.000000e+00  4.277629e-03  4.661723e-02
       [439,]    2 -1.878618e-03  5.000000e+00  6.768426e-03  1.180746e-02
       [440,]    3 -2.787606e-03  5.000000e+00 -4.763285e-03 -1.000135e-02
       [441,]    4 -4.451094e-03  5.000000e+00 -7.483446e-03  2.395831e-02
       [442,]    5 -5.476424e-03  5.000000e+00 -4.971694e-03  7.926267e-03
       [443,]    6  6.146959e-03  5.000000e+00 -2.919472e-04 -2.957340e-02
       [444,]    7 -4.991987e-03  5.000000e+00 -9.370885e-04  1.588908e-02
       [445,]    8 -8.048586e-03  5.000000e+00 -8.042054e-03  1.216441e-02
       [446,]    9  9.243947e-03  5.000000e+00  8.624782e-03 -1.406608e-02
       [447,]   10 -7.864473e-03  5.000000e+00  2.990224e-03  1.813453e-02
       [448,]   11  4.798042e-03  5.000000e+00 -2.245910e-03 -1.180972e-02
       [449,]   12 -9.752597e-03  5.000000e+00  9.442817e-03 -4.236208e-02
       [450,]   13 -1.114155e-03  5.000000e+00 -9.408891e-03 -4.797558e-02
       [451,]   14  7.438722e-03  5.000000e+00  1.368544e-03 -4.800309e-02
       [452,]   15  8.728125e-03  5.000000e+00  2.573295e-03 -3.240149e-03
       [453,]   16  7.815505e-03  5.000000e+00 -6.719574e-03  2.024942e-02
       [454,]   17  4.549356e-03  5.000000e+00 -8.968097e-03  1.567020e-03
       [455,]   18 -5.528222e-03  5.000000e+00 -8.482178e-03  3.064822e-02
       [456,]   19  8.937630e-03  5.000000e+00 -6.742824e-03 -3.081816e-02
       [457,]    1  3.269954e-04  6.000000e+00 -3.318038e-03 -4.520892e-02
       [458,]    2 -4.802787e-03  6.000000e+00 -4.000088e-03 -4.436592e-02
       [459,]    3  3.625321e-03  6.000000e+00  3.380679e-03  1.480271e-02
       [460,]    4 -9.844647e-03  6.000000e+00 -1.992372e-03 -2.395036e-02
       [461,]    5 -6.598407e-03  6.000000e+00 -5.776684e-03 -1.574961e-03
       [462,]    6  1.294873e-03  6.000000e+00 -5.860409e-03 -3.050621e-02
       [463,]    7  8.447220e-03  6.000000e+00 -8.677449e-03 -2.813635e-02
       [464,]    8 -6.896963e-03  6.000000e+00  2.050726e-04 -6.375915e-03
       [465,]    9  6.105331e-03  6.000000e+00  1.389486e-03 -1.282854e-02
       [466,]   10  4.623349e-03  6.000000e+00 -6.214614e-03 -3.236524e-03
       [467,]   11 -3.885720e-03  6.000000e+00 -5.966119e-03  2.683606e-03
       [468,]   12 -3.437781e-05  6.000000e+00 -7.174928e-04 -3.180316e-02
       [469,]   13  6.809614e-03  6.000000e+00  7.325672e-03  1.196132e-02
       [470,]   14 -4.743897e-03  6.000000e+00 -5.114260e-03  3.349630e-03
       [471,]   15  8.685195e-05  6.000000e+00 -9.641201e-03  9.458663e-03
       [472,]   16 -9.647035e-03  6.000000e+00 -9.941167e-03 -4.785613e-02
       [473,]   17 -3.929841e-03  6.000000e+00  2.424278e-03 -4.000756e-02
       [474,]   18  3.896715e-03  6.000000e+00  6.588650e-03 -2.342327e-02
       [475,]   19 -3.184997e-03  6.000000e+00  2.516530e-03 -1.398042e-02
       [476,]    1  4.913338e-03  7.000000e+00 -3.139829e-05 -7.630326e-03
       [477,]    2 -9.575573e-03  7.000000e+00 -3.082767e-03 -2.130766e-03
       [478,]    3  4.386039e-04  7.000000e+00  6.712303e-03 -1.424578e-02
       [479,]    4  8.335769e-03  7.000000e+00 -1.373662e-03 -3.703061e-02
       [480,]    5 -4.632210e-03  7.000000e+00  5.228171e-03  4.368189e-02
       [481,]    6 -5.246019e-03  7.000000e+00  4.642238e-03 -3.408686e-02
       [482,]    7  7.406355e-03  7.000000e+00 -8.303129e-03 -1.782028e-03
       [483,]    8  6.926338e-03  7.000000e+00  1.372496e-03  4.574857e-02
       [484,]    9 -8.203907e-03  7.000000e+00  7.645477e-03 -3.758198e-02
       [485,]   10 -3.321042e-03  7.000000e+00  5.363035e-03 -3.224220e-02
       [486,]   11  6.110416e-03  7.000000e+00 -7.033514e-03 -3.329519e-02
       [487,]   12  4.913510e-03  7.000000e+00  8.350512e-04 -2.614621e-02
       [488,]   13  6.909102e-03  7.000000e+00 -9.245942e-03  1.047185e-02
       [489,]   14  7.017190e-05  7.000000e+00  6.386577e-03  9.539057e-03
       [490,]   15  6.811405e-04  7.000000e+00 -3.352984e-03  3.582947e-02
       [491,]   16  2.372507e-04  7.000000e+00  7.053812e-03  4.787654e-02
       [492,]   17  2.192069e-03  7.000000e+00  6.175208e-03 -3.923594e-02
       [493,]   18 -4.243876e-03  7.000000e+00  2.140159e-03 -5.881421e-04
       [494,]   19  4.351080e-03  7.000000e+00  6.459496e-03 -3.738044e-02
       [495,]    1  3.834150e-03  8.000000e+00  9.084246e-03 -1.258585e-02
       [496,]    2 -8.846689e-03  8.000000e+00  3.311787e-03 -1.155495e-02
       [497,]    3  4.390183e-03  8.000000e+00  3.495426e-04 -2.969666e-03
       [498,]    4  9.906225e-03  8.000000e+00 -6.588879e-03  3.450479e-02
       [499,]    5 -2.276813e-03  8.000000e+00  9.126518e-03  1.701318e-02
       [500,]    6 -3.101797e-03  8.000000e+00  7.070281e-04  1.606255e-03
       [501,]    7  8.020438e-03  8.000000e+00  3.157866e-03 -1.515195e-02
       [502,]    8 -3.269894e-03  8.000000e+00  8.565903e-03 -1.504552e-02
       [503,]    9  8.507957e-03  8.000000e+00 -9.754369e-03 -3.916970e-03
       [504,]   10 -9.617963e-03  8.000000e+00 -2.401945e-03 -3.101151e-02
       [505,]   11 -6.162168e-03  8.000000e+00  5.827555e-03  1.392381e-02
       [506,]   12  1.438103e-03  8.000000e+00 -2.448532e-03 -9.808695e-03
       [507,]   13 -8.255804e-03  8.000000e+00  3.493280e-03 -1.376565e-03
       [508,]   14  4.809198e-03  8.000000e+00 -2.991725e-03  4.721620e-02
       [509,]   15  3.867533e-03  8.000000e+00  6.365806e-03  4.137618e-02
       [510,]   16 -8.479927e-03  8.000000e+00  2.170962e-05  1.398072e-02
       [511,]   17  3.699545e-03  8.000000e+00  6.600702e-03  2.432093e-03
       [512,]   18  3.979691e-03  8.000000e+00 -7.106479e-03 -2.182356e-02
       [513,]   19  2.338595e-03  8.000000e+00  4.711215e-04 -2.312348e-04
       [514,]    1 -4.645510e-03  9.000000e+00 -4.962766e-03 -4.676903e-02
       [515,]    2  3.854042e-03  9.000000e+00  8.889458e-03 -4.664230e-02
       [516,]    3  6.402538e-03  9.000000e+00  6.769537e-03 -1.697943e-02
       [517,]    4  1.639111e-03  9.000000e+00  7.970074e-03  1.247595e-02
       [518,]    5  6.270930e-03  9.000000e+00  4.434012e-03 -1.270305e-02
       [519,]    6 -4.885500e-03  9.000000e+00  4.801545e-03  1.831584e-03
       [520,]    7  3.035768e-03  9.000000e+00  7.213759e-04 -2.295712e-02
       [521,]    8  7.028179e-03  9.000000e+00 -6.160456e-03  7.475937e-03
       [522,]    9 -4.301648e-03  9.000000e+00 -5.073485e-03 -2.954348e-02
       [523,]   10 -5.456970e-04  9.000000e+00 -2.694222e-03  4.756168e-02
       [524,]   11 -7.742404e-03  9.000000e+00 -8.088663e-03 -1.390950e-02
       [525,]   12 -4.556764e-03  9.000000e+00 -1.192388e-03  5.781383e-03
       [526,]   13 -5.024815e-03  9.000000e+00  8.739367e-03  2.104691e-02
       [527,]   14  9.298652e-03  9.000000e+00  7.057752e-03  4.288171e-02
       [528,]   15 -3.990156e-03  9.000000e+00 -7.934177e-03  2.265591e-02
       [529,]   16  5.130297e-03  9.000000e+00 -2.562161e-03  3.854656e-02
       [530,]   17  8.117338e-03  9.000000e+00 -1.268018e-03  3.538895e-02
       [531,]   18 -5.746332e-04  9.000000e+00 -4.271594e-03  1.012173e-02
       [532,]   19 -8.885512e-03  9.000000e+00  3.726241e-03  3.307285e-02
       [533,]    1  9.822231e-03  1.000000e+01  4.895750e-03 -3.944466e-02
       [534,]    2  8.330926e-03  1.000000e+01 -7.469659e-03  2.121629e-02
       [535,]    3  6.839723e-03  1.000000e+01  8.677236e-04 -2.486890e-02
       [536,]    4  1.726179e-03  1.000000e+01  8.563107e-03  7.464143e-05
       [537,]    5 -2.154987e-03  1.000000e+01 -1.048945e-04  3.914577e-02
       [538,]    6 -3.003085e-03  1.000000e+01  3.856202e-03  2.089173e-02
       [539,]    7 -6.499698e-03  1.000000e+01 -7.136235e-03 -1.894828e-02
       [540,]    8  7.152015e-03  1.000000e+01 -4.451619e-03 -4.280163e-02
       [541,]    9  3.701359e-03  1.000000e+01  7.964761e-03  4.947531e-02
       [542,]   10 -5.421063e-03  1.000000e+01  8.340821e-03  1.891325e-03
       [543,]   11 -4.471364e-03  1.000000e+01  7.430361e-03  1.922574e-02
       [544,]   12 -7.201184e-03  1.000000e+01 -8.440140e-03 -2.878356e-02
       [545,]   13  2.140482e-03  1.000000e+01  5.037655e-04  2.562035e-02
       [546,]   14 -3.637172e-03  1.000000e+01 -7.318078e-03  4.041058e-02
       [547,]   15 -5.631340e-03  1.000000e+01  7.433207e-03  2.578040e-02
       [548,]   16  7.657615e-04  1.000000e+01 -6.436257e-03 -4.699994e-02
       [549,]   17  8.188556e-03  1.000000e+01  5.501597e-03  3.792324e-02
       [550,]   18 -6.501867e-03  1.000000e+01 -3.402120e-03  3.249542e-02
       [551,]   19  4.106512e-03  1.000000e+01  6.117549e-03  4.670734e-02
       [552,]    1  7.118616e-03  1.100000e+01  5.083098e-03 -4.094721e-02
       [553,]    2 -9.756129e-03  1.100000e+01 -5.289158e-03 -2.815265e-02
       [554,]    3 -8.963838e-03  1.100000e+01  7.593421e-04  2.635475e-02
       [555,]    4  8.795104e-03  1.100000e+01 -4.482100e-03  4.490325e-02
       [556,]    5 -7.220617e-03  1.100000e+01 -6.551829e-03  1.117406e-02
       [557,]    6  4.262828e-03  1.100000e+01 -2.060307e-03  2.813520e-02
       [558,]    7 -7.273596e-04  1.100000e+01 -5.697836e-03 -4.569216e-02
       [559,]    8 -6.804379e-03  1.100000e+01  9.617557e-03  1.555211e-02
       [560,]    9 -6.098874e-03  1.100000e+01  6.183346e-03  3.139715e-02
       [561,]   10  1.704101e-03  1.100000e+01 -5.558815e-03 -2.859112e-02
       [562,]   11 -7.345323e-03  1.100000e+01 -3.214119e-03  1.182557e-02
       [563,]   12 -5.284339e-03  1.100000e+01  8.890253e-05 -1.707904e-02
       [564,]   13 -1.828949e-03  1.100000e+01  1.070092e-03 -3.909184e-02
       [565,]   14  1.189915e-03  1.100000e+01 -6.296524e-03 -4.284323e-02
       [566,]   15 -5.632388e-03  1.100000e+01 -3.371627e-03  1.697390e-03
       [567,]   16  3.453919e-04  1.100000e+01  2.421324e-04  1.653476e-02
       [568,]   17 -5.139669e-03  1.100000e+01  9.700813e-03  4.995363e-02
       [569,]   18 -9.934118e-03  1.100000e+01  7.281134e-03  1.641861e-02
       [570,]   19  1.027050e-03  1.100000e+01 -8.911240e-03  5.542426e-03
       [571,]    1 -5.471567e-03  1.200000e+01 -1.243818e-03  2.505893e-02
       [572,]    2 -2.318309e-03  1.200000e+01 -8.190202e-04  3.475889e-02
       [573,]    3  5.281280e-03  1.200000e+01 -1.302994e-03  6.820234e-03
       [574,]    4  3.970587e-03  1.200000e+01  7.214195e-03  8.336465e-03
       [575,]    5 -4.877196e-05  1.200000e+01 -7.223807e-03 -2.106332e-02
       [576,]    6 -1.061936e-03  1.200000e+01  8.354762e-03  6.247264e-04
       [577,]    7 -7.244590e-03  1.200000e+01 -7.374214e-03 -3.697544e-02
       [578,]    8 -3.877052e-03  1.200000e+01 -6.179174e-03 -2.549011e-02
       [579,]    9  1.865031e-03  1.200000e+01 -9.683892e-03 -2.692062e-03
       [580,]   10 -4.974391e-03  1.200000e+01 -6.959177e-03 -4.806504e-02
       [581,]   11  9.461054e-03  1.200000e+01 -1.553048e-03 -2.019991e-02
       [582,]   12  4.779549e-03  1.200000e+01  1.698602e-03 -3.063711e-03
       [583,]   13 -5.295543e-03  1.200000e+01 -8.734675e-03  4.393639e-02
       [584,]   14 -3.781181e-03  1.200000e+01  3.466970e-03  1.201383e-02
       [585,]   15 -6.995083e-03  1.200000e+01 -4.154600e-03 -4.244301e-02
       [586,]   16  9.143709e-03  1.200000e+01 -3.162253e-04 -3.218874e-02
       [587,]   17  2.161069e-03  1.200000e+01  5.157060e-03  8.492386e-03
       [588,]   18 -8.553565e-03  1.200000e+01 -8.317120e-03 -2.604337e-02
       [589,]   19  3.107808e-03  1.200000e+01  6.478801e-03  1.912451e-02
       [590,]    1 -2.052549e-03  1.300000e+01 -7.142680e-04 -6.823914e-03
       [591,]    2 -5.087794e-03  1.300000e+01  5.609875e-03  7.189237e-04
       [592,]    3 -3.561989e-03  1.300000e+01 -3.271278e-03 -2.087572e-02
       [593,]    4 -2.106730e-03  1.300000e+01  2.918022e-03 -4.265772e-02
       [594,]    5 -5.939605e-03  1.300000e+01 -3.792883e-03 -2.790086e-02
       [595,]    6 -2.636468e-03  1.300000e+01  1.611428e-03  3.074746e-02
       [596,]    7 -4.422069e-03  1.300000e+01  8.387588e-03  4.285247e-02
       [597,]    8 -3.899120e-03  1.300000e+01  1.877439e-03 -5.767070e-04
       [598,]    9  6.862048e-03  1.300000e+01  1.470605e-03 -2.300305e-02
       [599,]   10 -7.095820e-03  1.300000e+01  8.098518e-03  2.029363e-02
       [600,]   11 -9.110619e-03  1.300000e+01  2.971400e-03 -4.745385e-02
       [601,]   12  8.892672e-03  1.300000e+01 -4.607844e-03 -1.705410e-02
       [602,]   13 -5.563822e-03  1.300000e+01 -3.916161e-03  1.890293e-02
       [603,]   14 -2.004112e-03  1.300000e+01  4.878608e-03 -1.236857e-02
       [604,]   15  4.158302e-03  1.300000e+01 -2.415293e-03 -3.340483e-02
       [605,]   16  3.880426e-03  1.300000e+01  2.993973e-03  1.148428e-02
       [606,]   17 -8.405715e-03  1.300000e+01  4.469117e-04 -1.961427e-02
       [607,]   18  2.874731e-03  1.300000e+01 -5.673328e-03 -1.563474e-02
       [608,]   19  9.423332e-03  1.300000e+01 -9.762122e-03 -2.543063e-02
       [609,]    1  2.221175e-04  1.400000e+01  9.870467e-03  1.997720e-02
       [610,]    2  6.478035e-03  1.400000e+01  2.828163e-03  2.749464e-02
       [611,]    3  2.678459e-03  1.400000e+01  1.433900e-03  2.690204e-02
       [612,]    4  9.290593e-03  1.400000e+01 -6.081174e-03  3.704098e-02
       [613,]    5  2.385461e-03  1.400000e+01 -6.402705e-03  2.934588e-02
       [614,]    6  4.232371e-03  1.400000e+01 -8.205720e-03 -2.540732e-02
       [615,]    7  3.263288e-03  1.400000e+01  8.022395e-03  5.279571e-03
       [616,]    8  3.093206e-03  1.400000e+01  7.646953e-04  3.807583e-02
       [617,]    9 -1.388316e-04  1.400000e+01 -2.980328e-03 -4.963515e-02
       [618,]   10  5.319908e-03  1.400000e+01 -9.875608e-03  4.806631e-02
       [619,]   11 -3.293430e-03  1.400000e+01  5.951792e-03  1.766202e-02
       [620,]   12  8.678982e-03  1.400000e+01 -9.768151e-03  4.904982e-04
       [621,]   13 -4.291879e-03  1.400000e+01 -3.717920e-03 -3.309283e-02
       [622,]   14  1.195546e-03  1.400000e+01  1.760280e-03  2.918599e-02
       [623,]   15 -6.637059e-03  1.400000e+01  2.678552e-04  2.563736e-02
       [624,]   16 -2.499874e-03  1.400000e+01  3.529488e-03 -1.180737e-02
       [625,]   17  1.306013e-03  1.400000e+01  5.404252e-04 -1.580594e-02
       [626,]   18 -8.228348e-03  1.400000e+01 -8.181239e-03  4.122989e-02
       [627,]   19 -4.956899e-03  1.400000e+01 -1.277069e-03  4.302583e-03
       [628,]    1  8.705372e-03  1.500000e+01 -7.371809e-03  2.874878e-02
       [629,]    2 -9.178463e-03  1.500000e+01  7.006224e-03  3.216237e-02
       [630,]    3  9.234017e-04  1.500000e+01 -1.645596e-03 -1.234710e-02
       [631,]    4  9.015292e-03  1.500000e+01  8.636643e-03  6.071669e-03
       [632,]    5  1.188030e-03  1.500000e+01 -8.537773e-03 -3.965713e-02
       [633,]    6 -1.637673e-03  1.500000e+01  7.090920e-03  3.225420e-02
       [634,]    7 -6.092026e-03  1.500000e+01 -4.619721e-03  2.275280e-02
       [635,]    8 -4.165926e-04  1.500000e+01 -6.754211e-03 -4.379803e-02
       [636,]    9 -6.095632e-03  1.500000e+01 -7.426737e-03 -3.650069e-03
       [637,]   10  8.515316e-03  1.500000e+01 -5.008155e-03 -2.254789e-04
       [638,]   11 -2.283199e-03  1.500000e+01 -4.404289e-03  2.091612e-02
       [639,]   12 -4.674814e-03  1.500000e+01  5.152397e-03 -4.435780e-02
       [640,]   13  6.781931e-03  1.500000e+01  8.216286e-03  3.647009e-02
       [641,]   14 -8.287549e-03  1.500000e+01  9.773805e-03 -3.068151e-02
       [642,]   15 -7.483058e-03  1.500000e+01 -4.140785e-03  3.726166e-02
       [643,]   16  8.078887e-03  1.500000e+01  4.958551e-03 -2.222062e-02
       [644,]   17  5.690709e-03  1.500000e+01  7.507370e-03 -1.180547e-02
       [645,]   18  2.868031e-03  1.500000e+01 -8.948176e-03 -4.439201e-02
       [646,]   19  3.017950e-03  1.500000e+01 -9.643118e-03 -3.776503e-02
       [647,]    1 -5.893326e-03  1.600000e+01 -7.598340e-03 -3.226880e-02
       [648,]    2 -5.374545e-03  1.600000e+01 -4.929457e-03 -2.295346e-02
       [649,]    3  4.900201e-03  1.600000e+01 -1.677600e-03  6.655193e-03
       [650,]    4  6.472190e-03  1.600000e+01 -5.322725e-03  3.767581e-02
       [651,]    5 -5.668141e-03  1.600000e+01  3.588168e-03  4.138408e-02
       [652,]    6  2.035218e-03  1.600000e+01  7.774503e-03 -3.749861e-04
       [653,]    7 -9.902021e-04  1.600000e+01 -8.749547e-03  2.554590e-02
       [654,]    8 -1.865827e-03  1.600000e+01 -5.359288e-03  4.587207e-02
       [655,]    9  1.847140e-03  1.600000e+01 -7.466373e-03  3.865607e-02
       [656,]   10  2.848897e-03  1.600000e+01  2.593664e-03 -3.888366e-02
       [657,]   11  5.531873e-03  1.600000e+01 -7.577421e-03  2.585429e-02
       [658,]   12 -4.715045e-03  1.600000e+01  3.095226e-03  3.986343e-02
       [659,]   13 -1.849421e-04  1.600000e+01  9.396330e-03 -1.334919e-02
       [660,]   14  4.453066e-03  1.600000e+01  7.712582e-03  1.321781e-02
       [661,]   15  2.175273e-03  1.600000e+01 -1.751532e-03 -3.843992e-02
       [662,]   16 -9.811651e-04  1.600000e+01 -5.722064e-03  8.204084e-03
       [663,]   17 -4.910103e-03  1.600000e+01  5.681892e-03 -4.651237e-02
       [664,]   18 -3.290559e-04  1.600000e+01  1.073915e-03 -3.535699e-02
       [665,]   19 -4.676059e-03  1.600000e+01 -6.454179e-03 -2.727869e-02
       [666,]    1 -9.207879e-03  1.700000e+01 -7.085446e-03 -7.070095e-03
       [667,]    2  6.657348e-03  1.700000e+01 -7.078398e-04  1.396984e-02
       [668,]    3  8.129148e-03  1.700000e+01 -2.797693e-03  4.017218e-02
       [669,]    4 -2.596368e-03  1.700000e+01 -7.216217e-03 -2.136979e-02
       [670,]    5 -2.762491e-04  1.700000e+01  9.874102e-04 -1.134227e-02
       [671,]    6 -1.982836e-03  1.700000e+01  9.791371e-03 -4.025717e-02
       [672,]    7 -5.061052e-04  1.700000e+01 -7.394795e-03 -1.231432e-02
       [673,]    8 -5.459230e-03  1.700000e+01  5.363622e-03 -4.593196e-02
       [674,]    9  9.954721e-03  1.700000e+01  7.615855e-03 -1.280777e-02
       [675,]   10 -7.476966e-03  1.700000e+01 -1.539400e-03  1.659563e-02
       [676,]   11 -3.563791e-03  1.700000e+01 -4.610645e-03 -2.951029e-02
       [677,]   12  5.819334e-03  1.700000e+01 -8.600674e-03 -3.957487e-02
       [678,]   13  7.531427e-03  1.700000e+01  9.691225e-03 -4.261148e-02
       [679,]   14 -2.444505e-03  1.700000e+01  5.139707e-03 -3.593054e-02
       [680,]   15 -4.150418e-03  1.700000e+01  2.085742e-03  8.075021e-03
       [681,]   16  9.797493e-03  1.700000e+01  8.876084e-03 -3.040882e-02
       [682,]   17 -6.385459e-03  1.700000e+01  1.506199e-03  1.110145e-03
       [683,]   18  4.694689e-03  1.700000e+01  5.739632e-03  3.424502e-02
       [684,]   19  7.855978e-03  1.700000e+01 -2.028377e-04 -8.308103e-03
       [685,]    1  8.243424e-03  1.800000e+01  1.635366e-03  1.395520e-02
       [686,]    2 -7.856995e-03  1.800000e+01  9.383784e-03  3.907406e-02
       [687,]    3  7.405071e-03  1.800000e+01  2.009945e-04 -4.091924e-04
       [688,]    4  2.907912e-03  1.800000e+01 -1.518133e-03  3.423203e-02
       [689,]    5  3.023339e-03  1.800000e+01 -2.358417e-03 -4.820397e-02
       [690,]    6 -4.170171e-03  1.800000e+01 -6.236670e-03  2.182712e-02
       [691,]    7  5.262552e-03  1.800000e+01 -9.911832e-03 -1.844037e-02
       [692,]    8  7.848877e-03  1.800000e+01  3.946121e-03  2.035590e-02
       [693,]    9  7.925215e-03  1.800000e+01 -2.150619e-03 -9.199083e-04
       [694,]   10  7.203589e-03  1.800000e+01  7.207185e-03 -4.349411e-02
       [695,]   11 -4.264818e-03  1.800000e+01  7.184857e-03 -1.195387e-02
       [696,]   12 -9.599149e-03  1.800000e+01  5.410525e-03  1.584331e-02
       [697,]   13 -7.910131e-03  1.800000e+01 -9.435210e-03 -3.097637e-02
       [698,]   14 -6.707357e-03  1.800000e+01  7.709262e-03  1.821427e-02
       [699,]   15  7.498116e-04  1.800000e+01 -9.692423e-03  1.864395e-03
       [700,]   16  5.123847e-03  1.800000e+01 -8.176556e-03  2.359111e-03
       [701,]   17 -8.656108e-03  1.800000e+01  2.490836e-03  1.646955e-02
       [702,]   18 -5.314485e-03  1.800000e+01 -6.138091e-03  2.074100e-02
       [703,]   19 -4.965873e-04  1.800000e+01  3.633123e-03  1.843426e-02
       [704,]    1  4.134976e-03  1.900000e+01 -1.308641e-03 -1.768110e-02
       [705,]    2 -5.819660e-03  1.900000e+01  5.221317e-03  2.695115e-02
       [706,]    3  1.052388e-03  1.900000e+01  7.136652e-03  4.962866e-02
       [707,]    4  2.450621e-04  1.900000e+01  4.050678e-03  3.323244e-02
       [708,]    5 -5.147957e-03  1.900000e+01  9.966920e-04  4.900636e-03
       [709,]    6 -9.840423e-03  1.900000e+01  1.957858e-03 -7.924833e-03
       [710,]    7  7.656225e-04  1.900000e+01  5.066012e-03  1.121300e-02
       [711,]    8 -9.680266e-03  1.900000e+01  8.429543e-03  3.590300e-02
       [712,]    9  3.244842e-03  1.900000e+01 -2.673356e-03 -1.361298e-02
       [713,]   10  9.410919e-03  1.900000e+01  1.888618e-03 -2.054805e-02
       [714,]   11 -1.116688e-03  1.900000e+01 -7.363031e-03  1.574631e-02
       [715,]   12 -3.712378e-03  1.900000e+01  9.088602e-03 -2.745160e-02
       [716,]   13 -7.863819e-03  1.900000e+01 -9.374634e-03  6.646649e-03
       [717,]   14 -4.261928e-03  1.900000e+01  7.319134e-03  3.757337e-02
       [718,]   15  4.685481e-03  1.900000e+01 -8.152783e-03 -1.374055e-02
       [719,]   16  5.867284e-03  1.900000e+01 -3.829878e-03  1.313869e-02
       [720,]   17 -5.342292e-03  1.900000e+01  1.492620e-03  4.040160e-02
       [721,]   18 -5.748868e-04  1.900000e+01 -5.505340e-03 -2.814390e-02
       [722,]   19 -8.671432e-03  1.900000e+01 -7.006433e-03 -2.463870e-02
       [723,]    1  8.418178e-03  9.874226e-03  1.000000e+00  3.547120e-02
       [724,]    2  6.371708e-03  5.233020e-03  1.000000e+00  3.341442e-02
       [725,]    3  7.127153e-03 -3.171882e-03  1.000000e+00 -2.429026e-02
       [726,]    4 -2.103639e-03 -7.069478e-03  1.000000e+00 -1.993372e-02
       [727,]    5 -7.878935e-03  9.788304e-03  1.000000e+00 -1.338825e-02
       [728,]    6 -9.733100e-03 -3.823116e-03  1.000000e+00 -4.514059e-02
       [729,]    7  3.174678e-03  8.060303e-03  1.000000e+00  3.350452e-02
       [730,]    8  6.793681e-03 -9.193862e-03  1.000000e+00  1.250297e-02
       [731,]    9  1.036740e-03  8.764185e-03  1.000000e+00  1.774048e-02
       [732,]   10 -1.178854e-03 -5.112082e-03  1.000000e+00  4.320934e-02
       [733,]   11  4.080185e-03  3.641166e-03  1.000000e+00 -2.429277e-02
       [734,]   12  6.058044e-03 -6.627908e-03  1.000000e+00 -3.501206e-02
       [735,]   13  5.050518e-03 -5.032779e-03  1.000000e+00 -4.045311e-02
       [736,]   14 -7.618555e-03 -2.422864e-03  1.000000e+00  3.129198e-02
       [737,]   15 -3.444424e-03  2.716772e-03  1.000000e+00  1.935798e-02
       [738,]   16  1.059139e-03  1.289683e-03  1.000000e+00 -1.037647e-03
       [739,]   17 -6.505885e-03 -5.980759e-03  1.000000e+00 -4.306777e-02
       [740,]   18 -7.762007e-03  4.260543e-03  1.000000e+00 -3.460671e-02
       [741,]   19  6.864325e-03 -8.953455e-03  1.000000e+00 -4.177815e-02
       [742,]    1 -6.615466e-04  8.084754e-03  2.000000e+00  8.869496e-03
       [743,]    2  7.729484e-03 -6.553089e-04  2.000000e+00  3.471472e-02
       [744,]    3 -5.870296e-03 -3.019085e-03  2.000000e+00  3.079085e-02
       [745,]    4  6.748294e-03  6.295110e-03  2.000000e+00 -2.586799e-02
       [746,]    5 -8.917300e-03  4.538513e-03  2.000000e+00 -1.473175e-02
       [747,]    6 -2.155571e-03 -2.830505e-03  2.000000e+00  1.238128e-02
       [748,]    7 -5.115548e-03  2.238200e-05  2.000000e+00  2.117140e-02
       [749,]    8 -8.666317e-03 -4.086983e-03  2.000000e+00  1.160142e-02
       [750,]    9  4.002192e-03 -9.776966e-03  2.000000e+00  3.765488e-02
       [751,]   10  1.417515e-03 -4.291739e-03  2.000000e+00 -6.447285e-03
       [752,]   11 -7.843698e-03 -3.065229e-03  2.000000e+00 -3.134232e-02
       [753,]   12 -3.383654e-03 -3.912031e-03  2.000000e+00  3.567554e-03
       [754,]   13  5.261601e-03  4.154205e-03  2.000000e+00  4.305765e-02
       [755,]   14 -8.186237e-03  5.797433e-03  2.000000e+00  3.287951e-02
       [756,]   15  9.134794e-03  8.597864e-03  2.000000e+00 -2.894529e-02
       [757,]   16  4.736658e-03 -8.573975e-03  2.000000e+00  3.999188e-02
       [758,]   17  5.612908e-03  1.954309e-04  2.000000e+00  3.823197e-02
       [759,]   18  4.426879e-03 -3.901417e-03  2.000000e+00  3.094601e-02
       [760,]   19 -8.371086e-04  1.870572e-03  2.000000e+00 -4.190498e-02
       [761,]    1 -7.317145e-03  8.616173e-03  3.000000e+00  4.235367e-02
       [762,]    2 -8.753197e-03  9.354180e-03  3.000000e+00 -3.708997e-02
       [763,]    3 -3.565478e-03  6.952329e-03  3.000000e+00  2.700184e-03
       [764,]    4  8.172221e-03 -1.746174e-03  3.000000e+00  2.154518e-02
       [765,]    5 -8.600331e-03  9.008143e-03  3.000000e+00 -3.521341e-02
       [766,]    6 -5.542899e-03 -1.356061e-03  3.000000e+00  4.113018e-02
       [767,]    7  8.969759e-04 -5.765045e-03  3.000000e+00 -2.685297e-02
       [768,]    8  2.649003e-04  7.633204e-04  3.000000e+00  2.965704e-02
       [769,]    9  6.319983e-03 -9.722112e-03  3.000000e+00 -1.825985e-02
       [770,]   10 -5.501618e-03 -4.320201e-04  3.000000e+00  7.389881e-03
       [771,]   11 -9.097185e-03  1.387228e-03  3.000000e+00  2.757974e-02
       [772,]   12 -1.562598e-03  4.546905e-03  3.000000e+00  4.603738e-03
       [773,]   13  3.781837e-03 -4.086098e-03  3.000000e+00 -8.885216e-04
       [774,]   14  6.676765e-03  1.736256e-03  3.000000e+00  3.778235e-02
       [775,]   15  2.871410e-03  3.525322e-03  3.000000e+00  3.089138e-02
       [776,]   16 -9.614953e-03  8.931835e-03  3.000000e+00 -3.559450e-03
       [777,]   17 -1.769026e-03 -2.330168e-03  3.000000e+00  4.653795e-02
       [778,]   18  1.766283e-03 -7.303112e-03  3.000000e+00 -2.192818e-02
       [779,]   19 -9.128308e-03  8.214986e-03  3.000000e+00 -2.271448e-02
       [780,]    1 -7.316170e-03 -6.978052e-05  4.000000e+00 -1.962436e-02
       [781,]    2  1.784292e-03  1.669922e-03  4.000000e+00  3.174975e-02
       [782,]    3 -6.702685e-03 -1.855650e-03  4.000000e+00  4.505909e-02
       [783,]    4 -4.145140e-03 -8.520004e-03  4.000000e+00 -1.530852e-02
       [784,]    5 -1.608556e-03 -5.100815e-03  4.000000e+00 -4.522111e-02
       [785,]    6  8.332041e-03 -3.456176e-05  4.000000e+00 -2.363636e-02
       [786,]    7  4.988867e-03 -5.793903e-04  4.000000e+00  6.830867e-04
       [787,]    8 -9.107235e-03 -9.868424e-03  4.000000e+00 -3.961406e-02
       [788,]    9  3.430959e-03 -1.758524e-03  4.000000e+00 -1.772474e-02
       [789,]   10 -3.476740e-03 -6.469695e-03  4.000000e+00  4.463025e-02
       [790,]   11  6.725628e-03 -7.778733e-03  4.000000e+00  1.259472e-02
       [791,]   12 -8.606445e-03 -3.228411e-03  4.000000e+00  5.567049e-04
       [792,]   13  6.700559e-03 -8.102733e-03  4.000000e+00 -8.778661e-03
       [793,]   14 -3.873678e-03 -6.802622e-03  4.000000e+00  1.659580e-03
       [794,]   15 -3.888507e-03 -3.298732e-03  4.000000e+00  1.191862e-02
       [795,]   16 -3.818160e-03  8.849527e-03  4.000000e+00  3.202104e-02
       [796,]   17  6.085470e-03  5.548212e-03  4.000000e+00 -2.628882e-03
       [797,]   18  7.684851e-03  7.458924e-03  4.000000e+00 -2.443555e-02
       [798,]   19 -6.931949e-03 -5.852982e-03  4.000000e+00 -2.574609e-02
       [799,]    1  8.708093e-04 -8.378869e-03  5.000000e+00  4.289312e-02
       [800,]    2  2.029225e-03 -3.535548e-03  5.000000e+00 -7.759684e-03
       [801,]    3 -7.846030e-03  3.581210e-03  5.000000e+00 -3.906299e-02
       [802,]    4 -3.536761e-04  2.127145e-04  5.000000e+00  2.608614e-02
       [803,]    5 -8.804081e-04  3.907957e-03  5.000000e+00 -4.270295e-02
       [804,]    6  7.721261e-03  1.210487e-03  5.000000e+00  1.387756e-02
       [805,]    7  5.528604e-03  4.016883e-03  5.000000e+00  1.974681e-02
       [806,]    8  4.635936e-03  1.277035e-03  5.000000e+00  1.468811e-02
       [807,]    9  7.980022e-03  9.579999e-03  5.000000e+00 -3.571725e-02
       [808,]   10 -5.043649e-03 -2.227314e-03  5.000000e+00  2.849413e-02
       [809,]   11 -5.433775e-03 -7.271333e-03  5.000000e+00  1.622426e-02
       [810,]   12 -8.117363e-03 -5.084751e-03  5.000000e+00 -4.297363e-02
       [811,]   13 -9.233020e-03 -4.429561e-03  5.000000e+00  2.848153e-02
       [812,]   14 -4.793723e-03 -1.661987e-03  5.000000e+00  1.093619e-02
       [813,]   15 -5.687105e-03 -5.396547e-03  5.000000e+00  2.283338e-02
       [814,]   16 -8.644735e-03  3.782149e-03  5.000000e+00  3.871867e-02
       [815,]   17 -1.688951e-04  7.301706e-03  5.000000e+00 -1.886178e-02
       [816,]   18 -8.626050e-03  7.878061e-03  5.000000e+00 -3.420622e-02
       [817,]   19 -2.702766e-03 -7.002534e-03  5.000000e+00  1.994977e-02
       [818,]    1 -4.807017e-03  8.007125e-03  6.000000e+00 -3.164221e-02
       [819,]    2 -5.244299e-03 -4.678686e-03  6.000000e+00  3.328469e-02
       [820,]    3  5.075688e-03 -6.263430e-03  6.000000e+00  3.784973e-02
       [821,]    4 -8.033669e-03  7.686993e-03  6.000000e+00  2.611218e-02
       [822,]    5  2.964037e-03  7.701355e-04  6.000000e+00 -2.860999e-02
       [823,]    6  2.913973e-03 -6.015660e-03  6.000000e+00  2.366030e-02
       [824,]    7 -8.555142e-03 -1.601373e-03  6.000000e+00  2.996860e-02
       [825,]    8 -5.896084e-03  7.762220e-03  6.000000e+00 -7.427214e-03
       [826,]    9 -2.135097e-03 -4.484656e-03  6.000000e+00 -3.970157e-02
       [827,]   10  9.027325e-03 -5.817924e-04  6.000000e+00 -2.195209e-02
       [828,]   11 -9.074257e-03  4.203732e-03  6.000000e+00 -3.600596e-02
       [829,]   12  7.568855e-03  9.744418e-03  6.000000e+00 -4.273254e-02
       [830,]   13 -6.757193e-03 -1.267061e-03  6.000000e+00 -4.676937e-02
       [831,]   14  8.345460e-03 -4.833458e-03  6.000000e+00  3.858613e-02
       [832,]   15 -7.450560e-03  8.207915e-04  6.000000e+00 -2.336692e-02
       [833,]   16  5.925311e-03 -7.441632e-03  6.000000e+00 -1.325866e-02
       [834,]   17 -9.576564e-03  4.728414e-03  6.000000e+00 -2.264760e-02
       [835,]   18 -8.095627e-03  1.527558e-04  6.000000e+00  1.070925e-02
       [836,]   19  4.141652e-03 -3.265277e-03  6.000000e+00 -3.631726e-02
       [837,]    1 -1.934282e-03  9.716016e-03  7.000000e+00 -3.484990e-02
       [838,]    2  8.542863e-05 -6.924941e-03  7.000000e+00 -1.177247e-02
       [839,]    3 -8.296134e-03  6.489421e-03  7.000000e+00  3.835105e-02
       [840,]    4  5.219655e-04  5.612785e-04  7.000000e+00  1.108216e-02
       [841,]    5  2.409001e-03  7.316882e-03  7.000000e+00 -4.821762e-02
       [842,]    6  3.037067e-03  1.908742e-03  7.000000e+00  1.746505e-03
       [843,]    7  8.091607e-03 -6.406542e-03  7.000000e+00 -3.477552e-02
       [844,]    8 -8.129465e-03 -1.888560e-03  7.000000e+00  3.907354e-02
       [845,]    9 -9.084222e-03  3.354252e-03  7.000000e+00 -1.879682e-02
       [846,]   10  4.656716e-03 -9.117263e-03  7.000000e+00  3.501518e-02
       [847,]   11 -3.202231e-03 -8.476181e-03  7.000000e+00 -4.304542e-02
       [848,]   12 -1.922597e-03 -3.697073e-03  7.000000e+00 -1.301408e-02
       [849,]   13  6.729032e-03  4.463077e-03  7.000000e+00 -2.313740e-02
       [850,]   14  7.350128e-03  9.514821e-03  7.000000e+00 -3.353284e-02
       [851,]   15  9.996406e-03 -2.135579e-03  7.000000e+00 -2.160113e-02
       [852,]   16  9.004911e-03 -8.085401e-03  7.000000e+00 -1.430172e-02
       [853,]   17 -6.518709e-03 -8.069320e-04  7.000000e+00 -7.034689e-03
       [854,]   18 -2.846843e-03 -7.741853e-03  7.000000e+00 -8.910901e-03
       [855,]   19  8.371930e-03  6.715547e-03  7.000000e+00  2.081789e-02
       [856,]    1  5.478929e-03  6.976160e-03  8.000000e+00 -4.947695e-03
       [857,]    2 -5.819187e-03  4.827511e-03  8.000000e+00  1.802991e-02
       [858,]    3  8.815224e-03 -7.680407e-03  8.000000e+00  2.044523e-02
       [859,]    4  5.044006e-03 -2.969991e-03  8.000000e+00  2.454755e-02
       [860,]    5 -6.403191e-04 -8.180815e-03  8.000000e+00 -3.253221e-02
       [861,]    6  6.688153e-03  6.478838e-03  8.000000e+00 -4.553061e-02
       [862,]    7  2.018944e-03  9.925982e-03  8.000000e+00  2.788077e-02
       [863,]    8 -6.104885e-03  2.108393e-03  8.000000e+00  4.046501e-02
       [864,]    9  2.321193e-03  6.418279e-03  8.000000e+00  3.395781e-02
       [865,]   10 -7.584225e-03 -7.184891e-03  8.000000e+00  2.557479e-02
       [866,]   11  6.316232e-03 -7.453126e-03  8.000000e+00 -1.000378e-02
       [867,]   12 -2.889475e-07  5.322298e-03  8.000000e+00  4.550585e-02
       [868,]   13 -9.561405e-03 -9.887934e-04  8.000000e+00  3.844611e-02
       [869,]   14  3.573121e-03  7.380376e-03  8.000000e+00  1.537560e-02
       [870,]   15 -1.657902e-03 -5.117242e-03  8.000000e+00 -4.000024e-02
       [871,]   16  8.284473e-04 -5.385996e-03  8.000000e+00 -1.469586e-03
       [872,]   17  5.756071e-03  5.523195e-03  8.000000e+00 -3.681870e-02
       [873,]   18  9.356224e-03  2.997087e-03  8.000000e+00 -1.466488e-02
       [874,]   19  1.449756e-03  6.890859e-03  8.000000e+00  2.420848e-02
       [875,]    1  4.774053e-03  5.406825e-03  9.000000e+00  1.353138e-02
       [876,]    2  5.576625e-03 -5.624780e-03  9.000000e+00  4.877531e-02
       [877,]    3 -4.711577e-03  9.138922e-03  9.000000e+00 -4.254274e-02
       [878,]    4 -1.814793e-03 -5.597052e-03  9.000000e+00 -4.889923e-02
       [879,]    5 -2.771913e-03  4.932953e-03  9.000000e+00  4.762569e-02
       [880,]    6 -9.133286e-03 -8.893492e-03  9.000000e+00  3.349131e-02
       [881,]    7 -2.435664e-03 -8.704432e-03  9.000000e+00 -4.260858e-02
       [882,]    8  4.273178e-03  1.767015e-03  9.000000e+00  3.526805e-02
       [883,]    9  8.201059e-04 -6.526650e-03  9.000000e+00 -2.304562e-02
       [884,]   10  6.726725e-03  1.567832e-03  9.000000e+00  2.399438e-02
       [885,]   11 -2.059461e-04 -1.266342e-03  9.000000e+00  8.116533e-03
       [886,]   12 -1.528113e-03 -4.452849e-03  9.000000e+00 -2.592272e-02
       [887,]   13 -4.444573e-03 -2.841891e-03  9.000000e+00 -1.569113e-02
       [888,]   14 -1.190156e-03 -9.387541e-03  9.000000e+00  3.998552e-02
       [889,]   15 -6.645194e-03 -6.651406e-03  9.000000e+00  2.996438e-02
       [890,]   16  5.155482e-03  3.539096e-03  9.000000e+00 -1.043166e-02
       [891,]   17  9.627298e-04 -3.143322e-03  9.000000e+00  4.730283e-02
       [892,]   18  3.620473e-03 -6.937758e-03  9.000000e+00 -4.521949e-02
       [893,]   19 -7.805396e-03 -8.927833e-03  9.000000e+00  4.130218e-02
       [894,]    1 -2.872391e-03  2.963614e-03  1.000000e+01 -1.689480e-02
       [895,]    2 -5.179339e-03  1.672481e-03  1.000000e+01 -2.171310e-02
       [896,]    3 -7.983316e-03  8.094120e-03  1.000000e+01 -4.840171e-02
       [897,]    4 -6.948620e-03 -4.212314e-04  1.000000e+01 -3.251228e-02
       [898,]    5 -4.357475e-03 -6.852107e-03  1.000000e+01 -1.780468e-02
       [899,]    6 -2.782787e-03  7.944183e-03  1.000000e+01  3.433109e-02
       [900,]    7  3.245281e-03 -4.482163e-03  1.000000e+01  1.985564e-02
       [901,]    8  8.431883e-03  1.485074e-04  1.000000e+01 -2.030982e-02
       [902,]    9  3.089068e-03 -3.954935e-03  1.000000e+01  1.429721e-02
       [903,]   10  8.581568e-03  4.800100e-03  1.000000e+01 -2.616847e-02
       [904,]   11  8.024913e-04 -1.697953e-03  1.000000e+01  2.214478e-02
       [905,]   12  2.414034e-03  3.723093e-03  1.000000e+01  1.510479e-02
       [906,]   13 -4.784999e-03  3.932135e-03  1.000000e+01  1.032917e-02
       [907,]   14  6.674164e-03  9.534661e-03  1.000000e+01 -2.107918e-02
       [908,]   15  2.901029e-03  1.595777e-03  1.000000e+01  1.073048e-02
       [909,]   16  8.555052e-03  1.927200e-03  1.000000e+01  1.430194e-02
       [910,]   17  5.914284e-03 -8.456987e-03  1.000000e+01  4.986980e-02
       [911,]   18 -3.729403e-03 -1.926907e-03  1.000000e+01  4.584313e-02
       [912,]   19 -1.173164e-03 -2.344593e-03  1.000000e+01  4.544493e-02
       [913,]    1  1.818492e-03  7.026226e-03  1.100000e+01  1.146844e-02
       [914,]    2  2.928133e-03 -1.048463e-03  1.100000e+01 -4.664870e-03
       [915,]    3 -1.311911e-04  7.073814e-03  1.100000e+01  2.416372e-03
       [916,]    4 -1.824795e-04  2.906735e-03  1.100000e+01  2.758989e-02
       [917,]    5 -3.976408e-03 -5.171525e-03  1.100000e+01  2.726220e-02
       [918,]    6 -4.634903e-03 -7.471631e-03  1.100000e+01  3.642935e-02
       [919,]    7 -3.873971e-03 -9.660182e-03  1.100000e+01  3.093274e-02
       [920,]    8 -2.042103e-03  7.996044e-03  1.100000e+01 -2.965200e-02
       [921,]    9  4.443782e-03  9.218790e-03  1.100000e+01 -2.059500e-02
       [922,]   10  3.106501e-03 -8.062854e-03  1.100000e+01 -4.592277e-02
       [923,]   11 -5.969514e-03  1.391963e-03  1.100000e+01 -4.779043e-02
       [924,]   12 -6.822768e-04  1.694874e-03  1.100000e+01  4.052452e-02
       [925,]   13 -1.702835e-03 -2.476641e-03  1.100000e+01 -3.048503e-02
       [926,]   14 -4.805151e-03  7.927006e-03  1.100000e+01  1.572632e-02
       [927,]   15  2.758698e-03 -5.164104e-03  1.100000e+01 -3.920567e-02
       [928,]   16  3.135789e-03 -7.332289e-03  1.100000e+01  3.728933e-03
       [929,]   17  7.607304e-03  3.464311e-03  1.100000e+01 -2.167777e-02
       [930,]   18 -3.253354e-03 -4.680090e-03  1.100000e+01  3.968817e-02
       [931,]   19  5.826511e-03 -4.539150e-03  1.100000e+01 -3.668741e-02
       [932,]    1  6.233085e-03 -7.595865e-04  1.200000e+01 -1.926713e-02
       [933,]    2 -9.074114e-04 -2.725547e-03  1.200000e+01 -1.630780e-02
       [934,]    3  5.506149e-03 -8.071617e-03  1.200000e+01 -4.784731e-02
       [935,]    4  5.956223e-03  7.267679e-03  1.200000e+01 -3.982798e-02
       [936,]    5 -6.779641e-03  7.355439e-03  1.200000e+01  4.764616e-02
       [937,]    6  7.225592e-03 -3.101711e-03  1.200000e+01 -1.157311e-02
       [938,]    7  1.140536e-03 -6.732661e-03  1.200000e+01 -4.808318e-02
       [939,]    8  3.673408e-03  2.610557e-03  1.200000e+01 -2.383648e-02
       [940,]    9  9.096824e-03  8.945560e-03  1.200000e+01 -1.295351e-02
       [941,]   10  9.877305e-03  8.315454e-03  1.200000e+01  4.364595e-03
       [942,]   11 -1.353424e-03 -7.309495e-03  1.200000e+01  4.909807e-03
       [943,]   12 -9.151178e-03 -1.678332e-03  1.200000e+01 -2.498835e-02
       [944,]   13 -6.052484e-03  6.151415e-03  1.200000e+01 -1.098128e-02
       [945,]   14  4.406545e-03 -9.165595e-03  1.200000e+01 -1.091051e-02
       [946,]   15  5.144215e-03  4.257476e-03  1.200000e+01 -9.878649e-03
       [947,]   16  3.473737e-03  6.593700e-03  1.200000e+01  4.918562e-02
       [948,]   17  1.650987e-03 -2.395240e-03  1.200000e+01  9.310190e-03
       [949,]   18  5.256711e-04 -5.922047e-03  1.200000e+01  1.742485e-02
       [950,]   19 -2.104814e-03  4.415178e-03  1.200000e+01  4.614595e-02
       [951,]    1  9.312075e-03 -2.147733e-03  1.300000e+01 -4.270106e-02
       [952,]    2 -5.493203e-03 -9.829086e-03  1.300000e+01 -1.187365e-02
       [953,]    3  6.610695e-03  2.664128e-03  1.300000e+01 -2.402401e-02
       [954,]    4 -4.116141e-03  6.013614e-03  1.300000e+01  1.862677e-02
       [955,]    5  4.487776e-03 -7.202602e-03  1.300000e+01  4.585270e-02
       [956,]    6 -8.415479e-03 -7.666323e-03  1.300000e+01  1.531746e-02
       [957,]    7  2.784945e-03  2.053057e-03  1.300000e+01  2.940779e-02
       [958,]    8  4.283962e-03 -2.579672e-03  1.300000e+01 -9.566742e-03
       [959,]    9  1.404238e-03 -8.814970e-03  1.300000e+01  4.091344e-02
       [960,]   10 -9.196774e-03  9.765602e-03  1.300000e+01  7.878831e-03
       [961,]   11  2.757855e-03 -7.524518e-03  1.300000e+01  3.487817e-02
       [962,]   12 -3.938986e-03 -7.109186e-03  1.300000e+01  4.939430e-02
       [963,]   13 -6.966994e-03  7.197041e-03  1.300000e+01 -3.605566e-02
       [964,]   14 -5.814768e-03  8.251355e-03  1.300000e+01 -1.045699e-02
       [965,]   15 -2.742251e-03 -3.409663e-03  1.300000e+01 -3.516674e-02
       [966,]   16  4.026530e-03 -4.464283e-03  1.300000e+01 -1.165258e-02
       [967,]   17  6.168054e-03 -7.978688e-03  1.300000e+01  7.742667e-04
       [968,]   18  7.736905e-03 -6.071947e-03  1.300000e+01  3.969746e-02
       [969,]   19 -3.452651e-04  5.382973e-03  1.300000e+01  2.716516e-02
       [970,]    1 -6.032109e-03 -6.504694e-03  1.400000e+01  3.128856e-02
       [971,]    2 -7.895923e-03  8.121052e-03  1.400000e+01  2.852643e-02
       [972,]    3 -5.224800e-03 -8.590341e-03  1.400000e+01 -3.967787e-02
       [973,]    4 -7.660326e-03 -7.460789e-03  1.400000e+01  4.609427e-02
       [974,]    5 -8.060702e-03 -4.712357e-03  1.400000e+01  4.098808e-02
       [975,]    6  6.150429e-03 -9.314355e-03  1.400000e+01 -1.253396e-02
       [976,]    7 -5.651128e-03 -7.179587e-03  1.400000e+01 -2.478128e-02
       [977,]    8 -7.374462e-04 -3.870578e-03  1.400000e+01 -1.693925e-02
       [978,]    9 -1.187464e-03 -1.875406e-03  1.400000e+01  4.952603e-02
       [979,]   10  7.782446e-03  7.641839e-04  1.400000e+01 -3.273443e-02
       [980,]   11  9.830652e-03  7.530213e-03  1.400000e+01  1.105781e-02
       [981,]   12 -2.298624e-03  9.413888e-03  1.400000e+01 -9.797727e-03
       [982,]   13  3.416932e-03  4.508791e-03  1.400000e+01 -8.993372e-03
       [983,]   14 -4.291821e-04  6.189419e-04  1.400000e+01  1.232336e-02
       [984,]   15  4.448861e-03 -4.174262e-03  1.400000e+01  2.363708e-02
       [985,]   16  7.495962e-03 -8.263734e-03  1.400000e+01  3.148082e-02
       [986,]   17  5.873161e-03  2.572353e-04  1.400000e+01 -5.276410e-03
       [987,]   18  4.904083e-03 -2.394142e-03  1.400000e+01 -2.455066e-02
       [988,]   19  3.723501e-03 -1.905897e-03  1.400000e+01  2.951740e-02
       [989,]    1 -6.454152e-03  9.124407e-03  1.500000e+01  3.411212e-02
       [990,]    2 -3.396292e-03  6.606785e-03  1.500000e+01  2.938309e-02
       [991,]    3 -8.105398e-03  5.049311e-03  1.500000e+01 -4.299533e-02
       [992,]    4  1.859781e-03  3.152312e-03  1.500000e+01  2.380976e-02
       [993,]    5  3.102750e-04 -1.174184e-03  1.500000e+01 -4.055621e-03
       [994,]    6  2.198128e-03  5.978106e-03  1.500000e+01  2.909217e-02
       [995,]    7 -8.285061e-03  9.423439e-03  1.500000e+01 -2.827466e-02
       [996,]    8  4.893654e-03  2.796925e-03  1.500000e+01 -1.575698e-02
       [997,]    9  9.517211e-03 -4.386596e-03  1.500000e+01  1.939740e-02
       [998,]   10  9.302805e-05 -3.706117e-03  1.500000e+01  7.942185e-03
       [999,]   11  9.492665e-03 -5.188722e-03  1.500000e+01 -4.879194e-02
      [1000,]   12 -6.081180e-03  6.414325e-03  1.500000e+01 -3.059342e-02
      [1001,]   13  9.436660e-03  2.457169e-03  1.500000e+01  1.088248e-02
      [1002,]   14 -2.989624e-03  1.512805e-03  1.500000e+01  8.504821e-04
      [1003,]   15  8.443475e-04  7.220107e-03  1.500000e+01  1.704174e-02
      [1004,]   16 -7.462067e-03 -4.419188e-03  1.500000e+01  4.641843e-02
      [1005,]   17  8.667500e-03 -2.960530e-03  1.500000e+01  1.181983e-02
      [1006,]   18  1.135952e-03  1.359418e-03  1.500000e+01  2.232652e-02
      [1007,]   19 -2.697369e-03 -2.452750e-03  1.500000e+01  1.656900e-02
      [1008,]    1 -2.970038e-03 -4.286440e-05  1.600000e+01 -1.718387e-02
      [1009,]    2  9.002440e-03 -1.905229e-03  1.600000e+01  4.218505e-03
      [1010,]    3 -2.866219e-03  7.670229e-03  1.600000e+01 -2.493596e-02
      [1011,]    4 -2.911962e-03 -5.707502e-03  1.600000e+01 -2.989692e-02
      [1012,]    5  7.459886e-03 -3.157665e-03  1.600000e+01  1.096747e-02
      [1013,]    6  7.328162e-03  1.017760e-03  1.600000e+01 -3.270537e-03
      [1014,]    7  8.131205e-03 -6.906663e-03  1.600000e+01  1.454428e-02
      [1015,]    8  1.259575e-03 -9.112396e-03  1.600000e+01 -1.605151e-02
      [1016,]    9  9.251623e-03  1.937749e-03  1.600000e+01  1.954708e-02
      [1017,]   10  7.426411e-03 -3.465658e-03  1.600000e+01 -4.529496e-03
      [1018,]   11 -2.785255e-03  2.325506e-03  1.600000e+01  4.801258e-02
      [1019,]   12  5.421727e-03 -2.241820e-03  1.600000e+01 -1.892677e-03
      [1020,]   13  3.819043e-03 -8.375677e-03  1.600000e+01 -3.194203e-02
      [1021,]   14  6.666528e-03  5.320735e-04  1.600000e+01 -1.833696e-02
      [1022,]   15  4.701778e-03  7.450842e-03  1.600000e+01  4.592616e-02
      [1023,]   16 -6.310753e-03  8.669006e-03  1.600000e+01  2.088440e-02
      [1024,]   17 -4.448198e-03 -3.848070e-03  1.600000e+01 -1.499548e-02
      [1025,]   18 -9.307321e-03  6.761805e-03  1.600000e+01 -2.472399e-02
      [1026,]   19 -6.461049e-03  8.077509e-03  1.600000e+01  2.648046e-02
      [1027,]    1 -3.320958e-03 -5.612646e-04  1.700000e+01 -1.399525e-02
      [1028,]    2 -5.806853e-04 -5.965035e-03  1.700000e+01 -2.076573e-02
      [1029,]    3 -6.768188e-03 -6.564719e-04  1.700000e+01  2.984799e-02
      [1030,]    4 -7.933360e-03  4.886949e-04  1.700000e+01  4.681770e-02
      [1031,]    5 -4.628290e-03  7.501554e-03  1.700000e+01 -4.677849e-02
      [1032,]    6  1.723719e-05 -9.327148e-03  1.700000e+01  2.299711e-02
      [1033,]    7  8.059760e-03 -6.642379e-03  1.700000e+01  2.901108e-02
      [1034,]    8 -9.961998e-03  8.894364e-03  1.700000e+01 -1.630308e-02
      [1035,]    9 -3.544780e-03  3.240848e-03  1.700000e+01 -3.599302e-02
      [1036,]   10  8.440027e-05  5.948172e-03  1.700000e+01 -3.918291e-02
      [1037,]   11 -8.380443e-04  9.988957e-03  1.700000e+01  7.797753e-04
      [1038,]   12 -6.405191e-03  2.642254e-03  1.700000e+01  2.577055e-02
      [1039,]   13  6.516927e-03 -2.059626e-03  1.700000e+01  3.595334e-04
      [1040,]   14  5.004854e-03 -6.478144e-03  1.700000e+01  3.178662e-02
      [1041,]   15 -4.456271e-03  9.625548e-03  1.700000e+01 -7.585459e-03
      [1042,]   16 -4.938625e-03 -7.063196e-03  1.700000e+01 -3.691689e-02
      [1043,]   17  4.893097e-03  5.806222e-03  1.700000e+01 -4.718490e-02
      [1044,]   18 -8.180000e-03  7.407756e-03  1.700000e+01  4.481854e-02
      [1045,]   19  5.007976e-03  5.405599e-03  1.700000e+01  2.436853e-02
      [1046,]    1 -7.134562e-04  8.301387e-03  1.800000e+01 -3.060729e-02
      [1047,]    2  9.989207e-03  5.028366e-03  1.800000e+01  2.048290e-02
      [1048,]    3 -6.902568e-04 -9.520854e-03  1.800000e+01  2.862096e-02
      [1049,]    4  5.137314e-03  8.278235e-04  1.800000e+01 -4.418984e-02
      [1050,]    5 -3.331670e-03  6.075980e-03  1.800000e+01 -2.498735e-02
      [1051,]    6  1.556938e-04 -1.210801e-03  1.800000e+01  4.451613e-02
      [1052,]    7 -9.600339e-04 -4.218492e-03  1.800000e+01 -3.179419e-02
      [1053,]    8  2.535382e-03  6.607533e-03  1.800000e+01 -1.485832e-02
      [1054,]    9 -4.326004e-03  5.849615e-03  1.800000e+01 -8.252546e-03
      [1055,]   10  8.443764e-03 -8.715622e-03  1.800000e+01 -8.421781e-03
      [1056,]   11 -1.277512e-03 -2.876393e-03  1.800000e+01  1.256780e-02
      [1057,]   12  5.511081e-03 -6.438400e-03  1.800000e+01  4.420336e-02
      [1058,]   13  3.674864e-03 -4.853327e-03  1.800000e+01  1.088326e-02
      [1059,]   14 -4.785298e-03  4.999530e-03  1.800000e+01 -3.578172e-02
      [1060,]   15 -7.029393e-04 -3.544895e-03  1.800000e+01  4.271624e-02
      [1061,]   16 -6.238216e-03  8.804209e-04  1.800000e+01 -1.916452e-02
      [1062,]   17  1.108086e-03  7.387884e-03  1.800000e+01 -4.085929e-02
      [1063,]   18 -3.236950e-03  2.897092e-03  1.800000e+01  4.610020e-02
      [1064,]   19 -1.891267e-03 -1.755821e-03  1.800000e+01  1.714363e-03
      [1065,]    1 -9.915529e-03 -4.992563e-03  1.900000e+01 -2.044679e-02
      [1066,]    2 -1.269518e-03  3.199242e-04  1.900000e+01  3.624885e-02
      [1067,]    3  1.362679e-03  8.316670e-03  1.900000e+01 -4.726878e-03
      [1068,]    4  4.340921e-03  7.607336e-03  1.900000e+01  3.928569e-02
      [1069,]    5  2.027933e-03  9.316697e-03  1.900000e+01 -3.161577e-02
      [1070,]    6  1.230003e-03 -8.001769e-04  1.900000e+01  1.160764e-02
      [1071,]    7 -3.161999e-03  1.523003e-03  1.900000e+01  6.790474e-03
      [1072,]    8  7.039033e-04 -4.061142e-03  1.900000e+01 -3.732703e-02
      [1073,]    9  2.844952e-03 -3.971636e-03  1.900000e+01  1.869526e-02
      [1074,]   10  8.967116e-04  9.530039e-03  1.900000e+01 -5.586400e-03
      [1075,]   11  6.446204e-03 -2.518027e-03  1.900000e+01  2.672071e-02
      [1076,]   12 -8.459764e-03  5.114750e-03  1.900000e+01 -4.769695e-02
      [1077,]   13 -4.875961e-03 -3.427449e-03  1.900000e+01  4.083277e-02
      [1078,]   14  7.542220e-03  5.805901e-03  1.900000e+01  3.007395e-02
      [1079,]   15  4.929327e-03 -1.196826e-03  1.900000e+01 -1.283097e-02
      [1080,]   16 -5.734380e-03 -4.452097e-03  1.900000e+01  2.549982e-02
      [1081,]   17 -1.807518e-03 -2.195427e-03  1.900000e+01 -3.680391e-02
      [1082,]   18  6.202702e-03  9.380822e-03  1.900000e+01 -4.044520e-02
      [1083,]   19 -2.778889e-03 -5.115943e-03  1.900000e+01 -1.140706e-02
                       [,6]
         [1,]  0.0360081776
         [2,] -0.0224193861
         [3,]  0.0301543643
         [4,]  0.0140020505
         [5,] -0.0193725071
         [6,] -0.0198374213
         [7,] -0.0299423354
         [8,]  0.0043765077
         [9,]  0.0130153314
        [10,]  0.0445957415
        [11,]  0.0165921058
        [12,]  0.0144059786
        [13,] -0.0286737445
        [14,] -0.0459265233
        [15,] -0.0494955947
        [16,] -0.0204653413
        [17,] -0.0353885247
        [18,]  0.0312724704
        [19,]  0.0357693285
        [20,]  0.0068128975
        [21,] -0.0420383352
        [22,]  0.0426482607
        [23,] -0.0064203122
        [24,]  0.0222017498
        [25,]  0.0466327467
        [26,] -0.0067406867
        [27,] -0.0113580145
        [28,]  0.0248535921
        [29,] -0.0002419315
        [30,]  0.0468074596
        [31,]  0.0074736375
        [32,] -0.0229902867
        [33,]  0.0332021134
        [34,] -0.0387170729
        [35,]  0.0421645744
        [36,]  0.0494321901
        [37,]  0.0222273530
        [38,] -0.0264308586
        [39,] -0.0093039250
        [40,]  0.0273933636
        [41,] -0.0434736632
        [42,] -0.0186634808
        [43,] -0.0220876258
        [44,] -0.0226503788
        [45,]  0.0242954168
        [46,]  0.0355783315
        [47,]  0.0459465368
        [48,] -0.0320236968
        [49,] -0.0205145546
        [50,]  0.0152705015
        [51,] -0.0153252888
        [52,] -0.0225046200
        [53,] -0.0195495758
        [54,] -0.0171381534
        [55,] -0.0072901649
        [56,]  0.0311489899
        [57,]  0.0439051131
        [58,]  0.0053917592
        [59,]  0.0416760790
        [60,] -0.0113264317
        [61,]  0.0259034847
        [62,]  0.0065685699
        [63,] -0.0435717741
        [64,] -0.0070676897
        [65,]  0.0130117224
        [66,] -0.0492103347
        [67,]  0.0424193460
        [68,] -0.0080156112
        [69,]  0.0247982748
        [70,] -0.0494386119
        [71,] -0.0031001754
        [72,]  0.0384837404
        [73,] -0.0133946033
        [74,] -0.0444344055
        [75,] -0.0412088149
        [76,]  0.0482690136
        [77,]  0.0288730615
        [78,]  0.0473867274
        [79,] -0.0318573298
        [80,] -0.0127151501
        [81,]  0.0310874645
        [82,] -0.0415701205
        [83,]  0.0046033602
        [84,]  0.0110073412
        [85,] -0.0042060562
        [86,]  0.0147514978
        [87,]  0.0460891930
        [88,] -0.0059436755
        [89,]  0.0396971727
        [90,]  0.0243395832
        [91,] -0.0275306388
        [92,] -0.0312191814
        [93,] -0.0077302772
        [94,]  0.0090521603
        [95,] -0.0129959400
        [96,]  0.0053369763
        [97,]  0.0006899428
        [98,]  0.0433534647
        [99,]  0.0023328541
       [100,] -0.0130878423
       [101,]  0.0149118887
       [102,]  0.0128667695
       [103,]  0.0430241688
       [104,] -0.0143187563
       [105,]  0.0044628767
       [106,] -0.0243798140
       [107,] -0.0206240318
       [108,] -0.0043487728
       [109,]  0.0313727285
       [110,] -0.0423568445
       [111,]  0.0010548269
       [112,]  0.0006496763
       [113,]  0.0024959060
       [114,]  0.0079855336
       [115,] -0.0123126329
       [116,]  0.0042613463
       [117,]  0.0414011640
       [118,] -0.0006285924
       [119,]  0.0025430988
       [120,] -0.0426988430
       [121,] -0.0421615363
       [122,]  0.0132318267
       [123,] -0.0466696334
       [124,] -0.0381274384
       [125,]  0.0132470521
       [126,] -0.0021247955
       [127,] -0.0453311742
       [128,]  0.0213985977
       [129,]  0.0243783228
       [130,]  0.0044371279
       [131,]  0.0043813414
       [132,]  0.0180668992
       [133,] -0.0206689905
       [134,] -0.0256352488
       [135,]  0.0212119147
       [136,] -0.0097237010
       [137,] -0.0313594255
       [138,]  0.0109449895
       [139,] -0.0033475545
       [140,]  0.0386246506
       [141,] -0.0446871840
       [142,]  0.0402139632
       [143,] -0.0127152335
       [144,] -0.0414065541
       [145,]  0.0302830698
       [146,] -0.0372908417
       [147,]  0.0277323624
       [148,]  0.0431726661
       [149,] -0.0251979483
       [150,]  0.0287492317
       [151,]  0.0066199879
       [152,] -0.0483327051
       [153,]  0.0357602461
       [154,] -0.0237214818
       [155,] -0.0463125654
       [156,] -0.0298931180
       [157,] -0.0498597955
       [158,]  0.0498459771
       [159,] -0.0469167612
       [160,] -0.0229818524
       [161,]  0.0283170298
       [162,] -0.0256745207
       [163,] -0.0342376382
       [164,] -0.0452259197
       [165,]  0.0384821494
       [166,] -0.0076103407
       [167,]  0.0369772738
       [168,] -0.0314044803
       [169,]  0.0197319452
       [170,] -0.0414765459
       [171,] -0.0477895960
       [172,] -0.0459068536
       [173,] -0.0185632379
       [174,] -0.0345583691
       [175,]  0.0376880390
       [176,] -0.0183102126
       [177,] -0.0464615169
       [178,] -0.0308249471
       [179,]  0.0477240694
       [180,] -0.0427803583
       [181,]  0.0302785476
       [182,]  0.0466766430
       [183,] -0.0421236453
       [184,]  0.0232422486
       [185,]  0.0065203519
       [186,] -0.0272725250
       [187,]  0.0246959622
       [188,]  0.0273174587
       [189,]  0.0295885132
       [190,]  0.0476735735
       [191,] -0.0172092482
       [192,]  0.0248672731
       [193,] -0.0302728377
       [194,]  0.0442896850
       [195,] -0.0436296382
       [196,]  0.0290978932
       [197,]  0.0489810087
       [198,] -0.0472368702
       [199,]  0.0007372304
       [200,]  0.0162147226
       [201,]  0.0069884475
       [202,] -0.0126957817
       [203,] -0.0207508626
       [204,]  0.0396806562
       [205,] -0.0114937411
       [206,]  0.0252508688
       [207,]  0.0396966532
       [208,] -0.0247620318
       [209,] -0.0230056412
       [210,] -0.0455540400
       [211,] -0.0089315842
       [212,]  0.0397695648
       [213,]  0.0485527028
       [214,]  0.0212572423
       [215,] -0.0015459983
       [216,]  0.0273074393
       [217,]  0.0243289019
       [218,] -0.0302957357
       [219,] -0.0434862528
       [220,] -0.0417276127
       [221,] -0.0214424367
       [222,] -0.0167204565
       [223,] -0.0073230340
       [224,]  0.0107139109
       [225,] -0.0348785687
       [226,]  0.0377071361
       [227,]  0.0191097278
       [228,] -0.0092591256
       [229,]  0.0352319249
       [230,] -0.0361107086
       [231,]  0.0016365814
       [232,] -0.0357929136
       [233,]  0.0036173277
       [234,]  0.0490100167
       [235,]  0.0381735008
       [236,] -0.0065597456
       [237,] -0.0234647081
       [238,]  0.0341191301
       [239,]  0.0264865382
       [240,]  0.0159871888
       [241,]  0.0231319534
       [242,] -0.0280873668
       [243,]  0.0180703882
       [244,] -0.0064256240
       [245,]  0.0111786412
       [246,] -0.0463510622
       [247,]  0.0089371387
       [248,]  0.0275398864
       [249,] -0.0408656812
       [250,]  0.0472839592
       [251,]  0.0195624441
       [252,] -0.0244766761
       [253,]  0.0053734576
       [254,] -0.0094885572
       [255,]  0.0343428181
       [256,]  0.0009376471
       [257,] -0.0360802436
       [258,]  0.0446025453
       [259,]  0.0450157726
       [260,] -0.0139321176
       [261,]  0.0203976764
       [262,] -0.0126082447
       [263,]  0.0461121622
       [264,]  0.0479281968
       [265,]  0.0157145554
       [266,] -0.0302659268
       [267,]  0.0080713003
       [268,]  0.0267913693
       [269,]  0.0166274108
       [270,]  0.0249728224
       [271,] -0.0171969758
       [272,]  0.0482995042
       [273,] -0.0352094295
       [274,]  0.0213022456
       [275,] -0.0138682634
       [276,]  0.0390272422
       [277,]  0.0040549630
       [278,] -0.0291478295
       [279,] -0.0347272362
       [280,] -0.0288602716
       [281,] -0.0499461943
       [282,]  0.0350972506
       [283,]  0.0355795055
       [284,]  0.0105960785
       [285,]  0.0230840914
       [286,]  0.0054424388
       [287,]  0.0021116634
       [288,]  0.0225366552
       [289,] -0.0042736926
       [290,]  0.0374822610
       [291,]  0.0120773189
       [292,] -0.0426886674
       [293,] -0.0442100232
       [294,] -0.0103077525
       [295,] -0.0337946883
       [296,] -0.0362450532
       [297,]  0.0133359334
       [298,] -0.0016571980
       [299,] -0.0002469047
       [300,] -0.0337113976
       [301,] -0.0014563282
       [302,] -0.0437713026
       [303,] -0.0358254800
       [304,] -0.0154345437
       [305,] -0.0496529681
       [306,]  0.0480151394
       [307,] -0.0492496840
       [308,] -0.0280839966
       [309,]  0.0376185214
       [310,]  0.0311636561
       [311,] -0.0383112867
       [312,] -0.0320685174
       [313,]  0.0393998234
       [314,] -0.0292636265
       [315,] -0.0472320024
       [316,]  0.0267783721
       [317,] -0.0090592828
       [318,]  0.0137783547
       [319,] -0.0103359589
       [320,] -0.0452758347
       [321,] -0.0116192605
       [322,] -0.0384730642
       [323,] -0.0258117034
       [324,] -0.0096875740
       [325,] -0.0423080660
       [326,] -0.0312945098
       [327,]  0.0122278057
       [328,]  0.0231889707
       [329,] -0.0071398405
       [330,] -0.0384482094
       [331,] -0.0338895001
       [332,]  0.0271819704
       [333,]  0.0273003266
       [334,] -0.0391067472
       [335,]  0.0181239964
       [336,]  0.0375134063
       [337,] -0.0393063551
       [338,]  0.0206675111
       [339,] -0.0401219919
       [340,] -0.0308955889
       [341,]  0.0336780538
       [342,] -0.0369213085
       [343,]  0.0286272308
       [344,] -0.0281960141
       [345,]  0.0234851779
       [346,]  0.0184172086
       [347,] -0.0233295335
       [348,]  0.0229673963
       [349,] -0.0069681013
       [350,] -0.0227114360
       [351,] -0.0122387226
       [352,] -0.0454699713
       [353,] -0.0278107758
       [354,]  0.0182650794
       [355,]  0.0233770639
       [356,] -0.0419600051
       [357,]  0.0358260987
       [358,]  0.0434728231
       [359,]  0.0339682872
       [360,]  0.0223456543
       [361,] -0.0480838691
       [362,] -0.0186019200
       [363,]  0.0021891248
       [364,] -0.0286534895
       [365,]  0.0426012113
       [366,]  0.0472591315
       [367,] -0.0446095075
       [368,] -0.0118993945
       [369,]  0.0346750762
       [370,] -0.0011571342
       [371,]  0.0375055467
       [372,] -0.0110466035
       [373,] -0.0422951483
       [374,] -0.0259430340
       [375,] -0.0175417706
       [376,] -0.0360627378
       [377,] -0.0216988620
       [378,] -0.0097494817
       [379,]  0.0250557348
       [380,] -0.0488264570
       [381,]  0.0385003785
       [382,]  0.0086049601
       [383,]  0.0039979489
       [384,]  0.0305361871
       [385,] -0.0103045935
       [386,] -0.0111885274
       [387,] -0.0194391182
       [388,]  0.0177664547
       [389,]  0.0047821336
       [390,] -0.0263023578
       [391,]  0.0457994790
       [392,]  0.0286195565
       [393,] -0.0448301831
       [394,]  0.0297265657
       [395,] -0.0228803106
       [396,] -0.0464948675
       [397,]  0.0321041915
       [398,]  0.0283149217
       [399,] -0.0273754125
       [400,]  0.0133892791
       [401,] -0.0299700973
       [402,]  0.0103543116
       [403,] -0.0036961856
       [404,]  0.0319266365
       [405,]  0.0361515193
       [406,]  0.0403837138
       [407,]  0.0319668279
       [408,]  0.0424192730
       [409,] -0.0052324366
       [410,]  0.0391176392
       [411,] -0.0308104230
       [412,] -0.0113062888
       [413,]  0.0317451806
       [414,] -0.0381190123
       [415,] -0.0372705338
       [416,] -0.0122616475
       [417,] -0.0117000077
       [418,] -0.0278764592
       [419,]  0.0147691548
       [420,]  0.0051004100
       [421,]  0.0126961445
       [422,] -0.0207732450
       [423,] -0.0200881377
       [424,] -0.0090530590
       [425,]  0.0427385204
       [426,]  0.0231872070
       [427,] -0.0338549325
       [428,] -0.0103117034
       [429,] -0.0382265334
       [430,]  0.0039828484
       [431,] -0.0261988359
       [432,]  0.0054243475
       [433,]  0.0360136640
       [434,]  0.0250549288
       [435,]  0.0465260323
       [436,] -0.0358493101
       [437,]  0.0357465198
       [438,]  0.0167808782
       [439,] -0.0223033675
       [440,]  0.0035612491
       [441,]  0.0159403007
       [442,]  0.0213623951
       [443,] -0.0496237982
       [444,] -0.0491231042
       [445,]  0.0030399055
       [446,] -0.0323651782
       [447,] -0.0181941361
       [448,]  0.0470080843
       [449,]  0.0193337502
       [450,]  0.0229093032
       [451,] -0.0283505697
       [452,] -0.0385602572
       [453,] -0.0438696750
       [454,]  0.0076111420
       [455,] -0.0165481713
       [456,] -0.0330893505
       [457,] -0.0238789355
       [458,] -0.0394945391
       [459,] -0.0468400013
       [460,] -0.0105065495
       [461,]  0.0254667256
       [462,]  0.0474034305
       [463,] -0.0304892378
       [464,] -0.0294995918
       [465,] -0.0140611462
       [466,]  0.0331667699
       [467,]  0.0249892669
       [468,] -0.0443338630
       [469,] -0.0034853082
       [470,]  0.0292903203
       [471,]  0.0020995703
       [472,] -0.0417909439
       [473,] -0.0393646501
       [474,] -0.0364414532
       [475,]  0.0494153826
       [476,]  0.0098536590
       [477,]  0.0122078126
       [478,] -0.0183048289
       [479,]  0.0293500639
       [480,]  0.0298496166
       [481,]  0.0009871742
       [482,]  0.0319117798
       [483,] -0.0447861338
       [484,]  0.0376506117
       [485,]  0.0421038849
       [486,] -0.0375801469
       [487,] -0.0360514234
       [488,] -0.0447320385
       [489,]  0.0487984729
       [490,]  0.0278718080
       [491,]  0.0145755523
       [492,] -0.0283425041
       [493,] -0.0314372709
       [494,]  0.0235572706
       [495,] -0.0220768404
       [496,] -0.0477736241
       [497,] -0.0138437658
       [498,]  0.0167624947
       [499,] -0.0277741424
       [500,]  0.0288008057
       [501,] -0.0363385358
       [502,] -0.0189887146
       [503,] -0.0137734955
       [504,] -0.0478930199
       [505,]  0.0117170841
       [506,]  0.0252673091
       [507,]  0.0456749357
       [508,] -0.0405517242
       [509,] -0.0039266809
       [510,]  0.0310922803
       [511,]  0.0302557959
       [512,]  0.0031932980
       [513,] -0.0422008535
       [514,]  0.0351417393
       [515,]  0.0498009565
       [516,] -0.0146315253
       [517,] -0.0096379571
       [518,]  0.0370232024
       [519,] -0.0167045433
       [520,] -0.0322707794
       [521,] -0.0179057525
       [522,] -0.0356876918
       [523,] -0.0491421592
       [524,] -0.0034444314
       [525,]  0.0431239444
       [526,]  0.0184773289
       [527,] -0.0214480726
       [528,]  0.0039396212
       [529,] -0.0321544330
       [530,] -0.0045817754
       [531,] -0.0473943979
       [532,]  0.0071764838
       [533,]  0.0405699224
       [534,]  0.0243596796
       [535,] -0.0139811878
       [536,] -0.0304546448
       [537,] -0.0104742536
       [538,] -0.0405562304
       [539,] -0.0066032809
       [540,]  0.0367787153
       [541,]  0.0165217568
       [542,]  0.0159038847
       [543,] -0.0210098319
       [544,] -0.0086848693
       [545,] -0.0085650964
       [546,]  0.0351366563
       [547,] -0.0390131298
       [548,] -0.0148358829
       [549,] -0.0370112603
       [550,]  0.0299610219
       [551,] -0.0227505828
       [552,]  0.0023537656
       [553,] -0.0202086667
       [554,] -0.0229325502
       [555,] -0.0285129161
       [556,] -0.0109742342
       [557,] -0.0246443385
       [558,]  0.0378809836
       [559,]  0.0043263618
       [560,] -0.0021737599
       [561,] -0.0116372551
       [562,]  0.0063890605
       [563,] -0.0234760207
       [564,]  0.0165029785
       [565,]  0.0244400954
       [566,]  0.0377864259
       [567,]  0.0125167999
       [568,] -0.0288294572
       [569,] -0.0005588992
       [570,]  0.0396701198
       [571,] -0.0355235342
       [572,]  0.0488566168
       [573,]  0.0306863854
       [574,]  0.0332294965
       [575,] -0.0159922303
       [576,] -0.0063363806
       [577,]  0.0221094545
       [578,]  0.0319584466
       [579,]  0.0147328255
       [580,]  0.0046867761
       [581,]  0.0456596915
       [582,] -0.0280311702
       [583,] -0.0445009897
       [584,]  0.0285561670
       [585,] -0.0174528039
       [586,]  0.0265721347
       [587,] -0.0404213407
       [588,]  0.0240711657
       [589,] -0.0382431513
       [590,]  0.0272634924
       [591,] -0.0391933819
       [592,] -0.0333356429
       [593,]  0.0203458758
       [594,]  0.0317576088
       [595,]  0.0168068055
       [596,] -0.0495184334
       [597,] -0.0340103626
       [598,]  0.0495090221
       [599,] -0.0067927132
       [600,]  0.0454822187
       [601,]  0.0455490139
       [602,]  0.0234323308
       [603,]  0.0180964782
       [604,] -0.0238754119
       [605,]  0.0267226202
       [606,]  0.0157516812
       [607,] -0.0092611417
       [608,] -0.0371690986
       [609,] -0.0215685857
       [610,]  0.0057153021
       [611,] -0.0181335367
       [612,]  0.0008270615
       [613,]  0.0221203280
       [614,]  0.0089697792
       [615,]  0.0184873088
       [616,] -0.0044518304
       [617,]  0.0134616330
       [618,]  0.0081428607
       [619,] -0.0216416175
       [620,] -0.0189556189
       [621,]  0.0378057358
       [622,] -0.0480461512
       [623,]  0.0381279632
       [624,] -0.0199171046
       [625,] -0.0040971001
       [626,] -0.0473993108
       [627,]  0.0378264694
       [628,] -0.0374183131
       [629,]  0.0149352954
       [630,]  0.0301842002
       [631,]  0.0050910465
       [632,] -0.0404882460
       [633,]  0.0163872222
       [634,]  0.0213582122
       [635,]  0.0239104756
       [636,]  0.0466961040
       [637,] -0.0147770010
       [638,]  0.0047623601
       [639,] -0.0361832076
       [640,]  0.0057247489
       [641,]  0.0192149301
       [642,]  0.0485318382
       [643,]  0.0211568187
       [644,]  0.0256750039
       [645,] -0.0415075377
       [646,] -0.0014992020
       [647,] -0.0440246237
       [648,] -0.0115535300
       [649,]  0.0094685840
       [650,] -0.0308369652
       [651,] -0.0372050841
       [652,]  0.0447508821
       [653,] -0.0019355883
       [654,]  0.0356580262
       [655,] -0.0070626808
       [656,] -0.0326783209
       [657,]  0.0033434652
       [658,]  0.0374764030
       [659,] -0.0002425560
       [660,] -0.0121341058
       [661,] -0.0021605209
       [662,] -0.0041230764
       [663,]  0.0020533215
       [664,]  0.0128588187
       [665,]  0.0262427827
       [666,] -0.0180606284
       [667,]  0.0332408979
       [668,] -0.0313106603
       [669,] -0.0252807128
       [670,]  0.0340357163
       [671,]  0.0148256515
       [672,]  0.0289218798
       [673,]  0.0404034142
       [674,]  0.0341126797
       [675,] -0.0481067907
       [676,]  0.0381767643
       [677,]  0.0024647791
       [678,]  0.0486691287
       [679,] -0.0447890904
       [680,]  0.0434614059
       [681,] -0.0476655861
       [682,] -0.0323759506
       [683,]  0.0481960721
       [684,] -0.0357497556
       [685,]  0.0240873739
       [686,] -0.0411740734
       [687,] -0.0131928147
       [688,]  0.0206003706
       [689,] -0.0163254672
       [690,]  0.0344169003
       [691,] -0.0145707705
       [692,]  0.0439335123
       [693,]  0.0236824496
       [694,] -0.0443057064
       [695,] -0.0352155169
       [696,] -0.0451604840
       [697,] -0.0368181931
       [698,] -0.0361767955
       [699,] -0.0178727972
       [700,] -0.0117487694
       [701,] -0.0074288770
       [702,] -0.0050437279
       [703,] -0.0235458253
       [704,] -0.0460284576
       [705,] -0.0331662704
       [706,] -0.0413235605
       [707,] -0.0337843216
       [708,]  0.0457194595
       [709,]  0.0396562419
       [710,]  0.0432316922
       [711,]  0.0213184044
       [712,] -0.0185876067
       [713,] -0.0168925647
       [714,] -0.0344679947
       [715,]  0.0443521362
       [716,] -0.0127077339
       [717,] -0.0316858062
       [718,] -0.0496898152
       [719,] -0.0383714422
       [720,]  0.0179363494
       [721,]  0.0145006229
       [722,] -0.0100292620
       [723,] -0.0087647789
       [724,]  0.0232130204
       [725,]  0.0482281497
       [726,]  0.0177722458
       [727,]  0.0484181462
       [728,]  0.0018852996
       [729,] -0.0484040677
       [730,]  0.0219025641
       [731,] -0.0448206488
       [732,]  0.0019625368
       [733,] -0.0221990925
       [734,]  0.0161041779
       [735,] -0.0482553899
       [736,]  0.0384755546
       [737,]  0.0364846878
       [738,]  0.0405275994
       [739,]  0.0104522991
       [740,]  0.0318824909
       [741,] -0.0452825597
       [742,]  0.0412930056
       [743,] -0.0029700580
       [744,] -0.0296049030
       [745,] -0.0346257976
       [746,] -0.0298931300
       [747,] -0.0280175163
       [748,]  0.0488728838
       [749,] -0.0385496345
       [750,] -0.0237733764
       [751,]  0.0215514072
       [752,]  0.0379760035
       [753,]  0.0361577343
       [754,] -0.0093108524
       [755,] -0.0295295400
       [756,] -0.0145944843
       [757,]  0.0369442605
       [758,] -0.0233984392
       [759,]  0.0203286116
       [760,]  0.0193158545
       [761,] -0.0166681225
       [762,] -0.0042781141
       [763,] -0.0069307584
       [764,] -0.0050247361
       [765,] -0.0328895615
       [766,] -0.0214719620
       [767,] -0.0154110126
       [768,] -0.0273178134
       [769,]  0.0389716067
       [770,] -0.0264587402
       [771,]  0.0260141017
       [772,] -0.0454146732
       [773,] -0.0343617160
       [774,] -0.0393893886
       [775,] -0.0062888798
       [776,] -0.0026580849
       [777,] -0.0232452503
       [778,]  0.0472530056
       [779,]  0.0491323636
       [780,]  0.0457078692
       [781,] -0.0339180249
       [782,]  0.0134880540
       [783,]  0.0298509193
       [784,]  0.0023079393
       [785,] -0.0027118025
       [786,]  0.0114181349
       [787,] -0.0177017732
       [788,]  0.0413969031
       [789,]  0.0051335554
       [790,]  0.0336220825
       [791,]  0.0478982451
       [792,]  0.0117290431
       [793,] -0.0013139883
       [794,]  0.0227216205
       [795,] -0.0087150672
       [796,] -0.0296174343
       [797,] -0.0140012085
       [798,]  0.0439492659
       [799,] -0.0338465700
       [800,] -0.0264507694
       [801,] -0.0474960129
       [802,]  0.0160985956
       [803,] -0.0133054836
       [804,]  0.0264024789
       [805,] -0.0086709876
       [806,] -0.0254857665
       [807,] -0.0301387348
       [808,] -0.0046650829
       [809,] -0.0447167940
       [810,] -0.0213253971
       [811,] -0.0069320709
       [812,] -0.0295811104
       [813,]  0.0009706396
       [814,] -0.0400468783
       [815,]  0.0182469598
       [816,] -0.0121749337
       [817,]  0.0141001274
       [818,] -0.0292279188
       [819,]  0.0033596433
       [820,] -0.0280103731
       [821,]  0.0045063278
       [822,] -0.0134750763
       [823,]  0.0406903448
       [824,] -0.0209627424
       [825,] -0.0116895677
       [826,]  0.0103836846
       [827,] -0.0188758440
       [828,] -0.0189502850
       [829,]  0.0176795577
       [830,] -0.0139887957
       [831,] -0.0215361432
       [832,]  0.0042168261
       [833,] -0.0388852667
       [834,] -0.0056271989
       [835,] -0.0469597559
       [836,]  0.0423056992
       [837,]  0.0390516727
       [838,] -0.0286652839
       [839,]  0.0154136852
       [840,]  0.0443061021
       [841,] -0.0053298225
       [842,] -0.0102889067
       [843,] -0.0245657971
       [844,] -0.0173880970
       [845,]  0.0200900385
       [846,]  0.0194947439
       [847,]  0.0130977940
       [848,] -0.0480340153
       [849,]  0.0022504559
       [850,]  0.0488592336
       [851,]  0.0378799118
       [852,]  0.0218869541
       [853,]  0.0129173539
       [854,]  0.0092266964
       [855,] -0.0372895366
       [856,] -0.0137674590
       [857,]  0.0278156454
       [858,]  0.0456893251
       [859,]  0.0001768397
       [860,]  0.0336549876
       [861,] -0.0318783273
       [862,]  0.0111533530
       [863,]  0.0045731035
       [864,] -0.0252514735
       [865,]  0.0350508495
       [866,] -0.0373531871
       [867,] -0.0014118751
       [868,]  0.0453174137
       [869,] -0.0197025774
       [870,] -0.0195495500
       [871,] -0.0380183200
       [872,]  0.0187042085
       [873,] -0.0222184018
       [874,]  0.0140707038
       [875,]  0.0112861754
       [876,] -0.0222395406
       [877,]  0.0209093200
       [878,]  0.0083202234
       [879,]  0.0250237585
       [880,] -0.0150936648
       [881,] -0.0104048419
       [882,] -0.0430860533
       [883,]  0.0025755372
       [884,] -0.0091987251
       [885,] -0.0017729475
       [886,]  0.0372498903
       [887,] -0.0423379148
       [888,] -0.0290062681
       [889,] -0.0103902874
       [890,] -0.0035560063
       [891,]  0.0204650939
       [892,] -0.0250808826
       [893,]  0.0174296475
       [894,]  0.0356213159
       [895,]  0.0278715261
       [896,]  0.0139720533
       [897,]  0.0255247075
       [898,] -0.0139820670
       [899,] -0.0217718749
       [900,]  0.0451613329
       [901,] -0.0446505623
       [902,] -0.0283791387
       [903,] -0.0257101081
       [904,] -0.0293783641
       [905,] -0.0096341679
       [906,] -0.0348973636
       [907,]  0.0371261847
       [908,] -0.0157328642
       [909,] -0.0025874279
       [910,] -0.0134835460
       [911,] -0.0338723596
       [912,] -0.0192605419
       [913,] -0.0199280063
       [914,]  0.0129719234
       [915,]  0.0323237238
       [916,] -0.0067859094
       [917,]  0.0054356229
       [918,]  0.0474930444
       [919,] -0.0270282324
       [920,] -0.0077156487
       [921,]  0.0088484018
       [922,] -0.0452644059
       [923,]  0.0304960245
       [924,]  0.0228934910
       [925,]  0.0198053666
       [926,] -0.0408287793
       [927,] -0.0143772170
       [928,]  0.0092087369
       [929,]  0.0498617874
       [930,]  0.0335616037
       [931,]  0.0363604510
       [932,]  0.0357161639
       [933,]  0.0441446407
       [934,] -0.0404902818
       [935,]  0.0065377037
       [936,]  0.0227164871
       [937,] -0.0210590304
       [938,] -0.0342689266
       [939,] -0.0327470155
       [940,] -0.0030714599
       [941,]  0.0334580794
       [942,] -0.0137151065
       [943,]  0.0182450222
       [944,]  0.0134774551
       [945,] -0.0316772129
       [946,] -0.0354377435
       [947,] -0.0044295490
       [948,]  0.0151557766
       [949,]  0.0238141339
       [950,]  0.0334685093
       [951,]  0.0434049783
       [952,] -0.0007106366
       [953,] -0.0171111830
       [954,]  0.0473312337
       [955,] -0.0101159023
       [956,]  0.0214548121
       [957,] -0.0421975019
       [958,]  0.0228116331
       [959,] -0.0197400328
       [960,] -0.0035815288
       [961,] -0.0385405106
       [962,] -0.0482304695
       [963,]  0.0462302168
       [964,]  0.0240893557
       [965,] -0.0205424204
       [966,] -0.0065573546
       [967,]  0.0479245009
       [968,]  0.0173260434
       [969,]  0.0447383445
       [970,] -0.0280071997
       [971,]  0.0061455539
       [972,] -0.0084954639
       [973,]  0.0187425969
       [974,] -0.0150997127
       [975,] -0.0367337222
       [976,]  0.0032590873
       [977,]  0.0303861127
       [978,]  0.0382213809
       [979,] -0.0373286230
       [980,] -0.0030723074
       [981,]  0.0266269531
       [982,] -0.0295527448
       [983,]  0.0468163874
       [984,]  0.0177916961
       [985,] -0.0035939700
       [986,] -0.0101570216
       [987,] -0.0074270217
       [988,]  0.0081223728
       [989,]  0.0033838045
       [990,] -0.0056762039
       [991,]  0.0334687594
       [992,]  0.0391721934
       [993,]  0.0059298047
       [994,] -0.0219297039
       [995,] -0.0151391702
       [996,]  0.0368233143
       [997,]  0.0194195292
       [998,] -0.0295807796
       [999,]  0.0048198993
      [1000,] -0.0368540985
      [1001,]  0.0405031252
      [1002,] -0.0095898091
      [1003,]  0.0387617312
      [1004,]  0.0145959996
      [1005,] -0.0050830929
      [1006,] -0.0056587452
      [1007,] -0.0099708847
      [1008,] -0.0097391307
      [1009,] -0.0084277920
      [1010,]  0.0124065980
      [1011,]  0.0217121138
      [1012,] -0.0453222483
      [1013,]  0.0436806978
      [1014,]  0.0460134654
      [1015,]  0.0249971886
      [1016,] -0.0302970471
      [1017,] -0.0109802886
      [1018,]  0.0208104842
      [1019,] -0.0015315269
      [1020,] -0.0406956684
      [1021,] -0.0341847328
      [1022,] -0.0370141670
      [1023,] -0.0036075814
      [1024,] -0.0393441307
      [1025,]  0.0425841593
      [1026,] -0.0191586666
      [1027,]  0.0066981854
      [1028,]  0.0352346117
      [1029,] -0.0282534044
      [1030,]  0.0189838755
      [1031,] -0.0129009847
      [1032,] -0.0293045085
      [1033,] -0.0054965031
      [1034,] -0.0260949588
      [1035,]  0.0234771331
      [1036,] -0.0248285655
      [1037,]  0.0424153037
      [1038,] -0.0368149740
      [1039,] -0.0158439272
      [1040,]  0.0489428563
      [1041,] -0.0359202764
      [1042,] -0.0410000905
      [1043,] -0.0126812249
      [1044,]  0.0448643980
      [1045,] -0.0409048510
      [1046,]  0.0018212875
      [1047,]  0.0184167661
      [1048,]  0.0049897156
      [1049,] -0.0364817734
      [1050,]  0.0420345180
      [1051,] -0.0223294745
      [1052,]  0.0290742344
      [1053,] -0.0419317768
      [1054,]  0.0379528061
      [1055,] -0.0062474437
      [1056,] -0.0204189867
      [1057,] -0.0149722386
      [1058,]  0.0045026269
      [1059,]  0.0433678795
      [1060,] -0.0407109458
      [1061,]  0.0329637993
      [1062,] -0.0337952730
      [1063,]  0.0004645721
      [1064,] -0.0216316602
      [1065,] -0.0439910822
      [1066,]  0.0281893408
      [1067,]  0.0483460100
      [1068,]  0.0337764774
      [1069,]  0.0083785767
      [1070,]  0.0436409210
      [1071,]  0.0470512570
      [1072,]  0.0405179870
      [1073,]  0.0304588867
      [1074,]  0.0076829123
      [1075,] -0.0194542199
      [1076,] -0.0483425215
      [1077,]  0.0492780290
      [1078,] -0.0050210585
      [1079,] -0.0388071269
      [1080,]  0.0117742238
      [1081,]  0.0032593460
      [1082,] -0.0230332233
      [1083,] -0.0281853233
      
      $n
      [1] 1083
      

---

    Code
      three_grid(n_value = 19, num_noise = 0)
    Output
      $df
              [,1]          [,2]          [,3]          [,4]
         [1,]    1  1.000000e+00 -6.865618e-03  4.937218e-04
         [2,]    2  1.000000e+00 -9.589329e-04  8.660501e-03
         [3,]    3  1.000000e+00 -1.805451e-03  3.815862e-03
         [4,]    4  1.000000e+00  7.697980e-03 -2.035336e-03
         [5,]    5  1.000000e+00 -6.644168e-03  2.463518e-03
         [6,]    6  1.000000e+00 -2.838727e-03  2.470521e-03
         [7,]    7  1.000000e+00  7.819936e-03 -8.256855e-03
         [8,]    8  1.000000e+00 -8.205031e-03  3.824324e-03
         [9,]    9  1.000000e+00  6.138831e-03 -2.408975e-03
        [10,]   10  1.000000e+00  5.713133e-03  9.183258e-03
        [11,]   11  1.000000e+00 -5.478099e-03  5.067508e-03
        [12,]   12  1.000000e+00 -2.638489e-03  1.189236e-03
        [13,]   13  1.000000e+00  2.378815e-03  9.542694e-03
        [14,]   14  1.000000e+00  8.217854e-03 -2.890412e-03
        [15,]   15  1.000000e+00  1.032469e-03 -4.401323e-03
        [16,]   16  1.000000e+00 -9.371777e-03 -7.930025e-03
        [17,]   17  1.000000e+00 -7.548838e-03  6.813907e-03
        [18,]   18  1.000000e+00  8.345839e-03 -6.766256e-03
        [19,]   19  1.000000e+00  7.144540e-03  2.056166e-03
        [20,]    1  2.000000e+00  3.023899e-03 -9.291058e-03
        [21,]    2  2.000000e+00 -3.486740e-03 -6.745104e-03
        [22,]    3  2.000000e+00 -9.446115e-03 -3.316142e-05
        [23,]    4  2.000000e+00  9.765867e-03 -9.608151e-03
        [24,]    5  2.000000e+00  4.127300e-03 -9.618789e-03
        [25,]    6  2.000000e+00  4.619379e-04 -4.564095e-03
        [26,]    7  2.000000e+00 -8.921216e-03  8.662677e-03
        [27,]    8  2.000000e+00  2.633608e-03  3.780169e-03
        [28,]    9  2.000000e+00  9.697909e-06 -7.609369e-05
        [29,]   10  2.000000e+00 -2.228445e-03 -9.515313e-03
        [30,]   11  2.000000e+00 -6.132588e-03 -6.788334e-03
        [31,]   12  2.000000e+00  2.496374e-04  6.941212e-03
        [32,]   13  2.000000e+00 -8.694111e-03 -2.662687e-03
        [33,]   14  2.000000e+00  7.612292e-03 -8.446090e-03
        [34,]   15  2.000000e+00 -7.960107e-03 -5.012108e-04
        [35,]   16  2.000000e+00  8.140694e-03  2.848931e-03
        [36,]   17  2.000000e+00 -1.953268e-04  8.474805e-03
        [37,]   18  2.000000e+00 -3.141167e-03  5.439713e-04
        [38,]   19  2.000000e+00 -8.533321e-03  9.613054e-03
        [39,]    1  3.000000e+00 -6.904121e-03  4.235414e-03
        [40,]    2  3.000000e+00  4.777274e-03 -3.964001e-04
        [41,]    3  3.000000e+00 -2.729960e-03 -9.756398e-03
        [42,]    4  3.000000e+00  7.684434e-03 -3.359275e-03
        [43,]    5  3.000000e+00  6.417297e-03  4.706790e-03
        [44,]    6  3.000000e+00 -5.381806e-03 -6.557307e-03
        [45,]    7  3.000000e+00 -8.489609e-04  1.798351e-03
        [46,]    8  3.000000e+00 -2.881003e-03 -4.718014e-03
        [47,]    9  3.000000e+00 -5.267970e-03  3.443757e-03
        [48,]   10  3.000000e+00 -1.285990e-03 -4.161731e-04
        [49,]   11  3.000000e+00 -3.408942e-03 -1.074777e-04
        [50,]   12  3.000000e+00 -8.484678e-03 -2.248087e-03
        [51,]   13  3.000000e+00 -2.370740e-03 -8.246888e-03
        [52,]   14  3.000000e+00  9.878355e-03 -6.824519e-03
        [53,]   15  3.000000e+00 -1.179717e-03  4.151737e-03
        [54,]   16  3.000000e+00 -2.250299e-03  2.352127e-03
        [55,]   17  3.000000e+00  3.184384e-03 -6.818963e-03
        [56,]   18  3.000000e+00  6.637119e-03 -9.573452e-03
        [57,]   19  3.000000e+00  1.729308e-03 -2.063413e-03
        [58,]    1  4.000000e+00 -6.769437e-03  8.655546e-04
        [59,]    2  4.000000e+00  4.008773e-03  3.552230e-03
        [60,]    3  4.000000e+00  8.444523e-03 -1.846170e-03
        [61,]    4  4.000000e+00 -3.373085e-03  3.973422e-03
        [62,]    5  4.000000e+00 -9.963242e-03 -7.356947e-03
        [63,]    6  4.000000e+00 -2.150915e-03 -8.959492e-03
        [64,]    7  4.000000e+00 -1.812146e-03  3.246789e-03
        [65,]    8  4.000000e+00  6.724096e-03  3.596310e-03
        [66,]    9  4.000000e+00  5.581117e-04  1.612437e-03
        [67,]   10  4.000000e+00 -7.682475e-03  4.717522e-03
        [68,]   11  4.000000e+00 -4.604613e-03  7.113085e-03
        [69,]   12  4.000000e+00  5.477122e-03  3.429135e-03
        [70,]   13  4.000000e+00 -8.740256e-03  4.785211e-03
        [71,]   14  4.000000e+00  6.771486e-03 -8.082122e-04
        [72,]   15  4.000000e+00 -9.573028e-03 -8.189892e-03
        [73,]   16  4.000000e+00  9.260091e-03  7.611064e-03
        [74,]   17  4.000000e+00 -2.764410e-03 -3.784158e-03
        [75,]   18  4.000000e+00 -8.065914e-03  9.451335e-03
        [76,]   19  4.000000e+00  5.779914e-03 -9.427818e-03
        [77,]    1  5.000000e+00 -1.827782e-03 -7.304134e-04
        [78,]    2  5.000000e+00 -5.603719e-03  8.662987e-03
        [79,]    3  5.000000e+00  2.167762e-03  7.128692e-03
        [80,]    4  5.000000e+00  4.599329e-03 -3.474842e-03
        [81,]    5  5.000000e+00 -2.451273e-03 -3.256184e-03
        [82,]    6  5.000000e+00 -9.277105e-03 -4.000095e-03
        [83,]    7  5.000000e+00 -6.776437e-03 -2.711418e-03
        [84,]    8  5.000000e+00  9.176536e-03  5.788796e-03
        [85,]    9  5.000000e+00  8.753760e-03  8.936354e-03
        [86,]   10  5.000000e+00  3.224613e-03  5.100479e-03
        [87,]   11  5.000000e+00  4.535249e-04  3.171056e-03
        [88,]   12  5.000000e+00  1.985216e-03  2.863497e-03
        [89,]   13  5.000000e+00  6.711806e-03 -4.468056e-03
        [90,]   14  5.000000e+00  9.877616e-03  5.639494e-03
        [91,]   15  5.000000e+00 -8.048051e-03 -4.302945e-03
        [92,]   16  5.000000e+00  2.406502e-03 -1.569637e-03
        [93,]   17  5.000000e+00  1.562226e-03  7.207722e-03
        [94,]   18  5.000000e+00  2.195082e-03  3.766890e-03
        [95,]   19  5.000000e+00  1.867799e-03 -3.090183e-05
        [96,]    1  6.000000e+00 -3.168955e-03 -7.411625e-03
        [97,]    2  6.000000e+00 -5.131267e-03 -3.541978e-03
        [98,]    3  6.000000e+00 -7.913450e-03 -2.834675e-04
        [99,]    4  6.000000e+00  8.901396e-03  6.620505e-03
       [100,]    5  6.000000e+00  8.897318e-04  8.079551e-03
       [101,]    6  6.000000e+00  9.918990e-03 -4.486030e-03
       [102,]    7  6.000000e+00  1.393117e-03  3.395123e-03
       [103,]    8  6.000000e+00 -7.770077e-03  7.687903e-03
       [104,]    9  6.000000e+00 -8.129907e-03 -1.689097e-03
       [105,]   10  6.000000e+00 -2.793547e-03  3.715000e-03
       [106,]   11  6.000000e+00  3.162008e-03 -4.808750e-03
       [107,]   12  6.000000e+00  3.001489e-03 -9.430423e-03
       [108,]   13  6.000000e+00  5.854690e-03  8.412942e-03
       [109,]   14  6.000000e+00 -5.617674e-03 -4.993742e-03
       [110,]   15  6.000000e+00  3.659676e-03 -6.797681e-03
       [111,]   16  6.000000e+00 -7.259868e-03 -3.856087e-03
       [112,]   17  6.000000e+00 -9.578240e-03 -4.215716e-03
       [113,]   18  6.000000e+00 -3.660035e-03  1.834227e-04
       [114,]   19  6.000000e+00  7.455647e-03 -1.801613e-03
       [115,]    1  7.000000e+00  4.648827e-03  3.476851e-03
       [116,]    2  7.000000e+00  7.871243e-03 -5.127493e-03
       [117,]    3  7.000000e+00 -3.969700e-03  8.138883e-03
       [118,]    4  7.000000e+00  5.883811e-03 -1.708298e-03
       [119,]    5  7.000000e+00  5.531505e-03  9.353598e-03
       [120,]    6  7.000000e+00 -8.575009e-03  2.688717e-03
       [121,]    7  7.000000e+00  4.818385e-03  8.291691e-03
       [122,]    8  7.000000e+00  7.254437e-03 -5.869617e-03
       [123,]    9  7.000000e+00  4.277098e-03 -8.883173e-03
       [124,]   10  7.000000e+00  3.059319e-04 -1.957541e-03
       [125,]   11  7.000000e+00  4.979566e-03  7.097762e-03
       [126,]   12  7.000000e+00 -5.845912e-03 -7.756975e-03
       [127,]   13  7.000000e+00 -8.581222e-03 -4.448971e-03
       [128,]   14  7.000000e+00 -6.434207e-04  1.842872e-03
       [129,]   15  7.000000e+00 -7.405063e-03 -8.544339e-03
       [130,]   16  7.000000e+00 -9.245304e-03 -8.036445e-03
       [131,]   17  7.000000e+00 -3.505730e-03  4.452544e-03
       [132,]   18  7.000000e+00 -9.388424e-03  2.072202e-03
       [133,]   19  7.000000e+00  3.357893e-03  9.161954e-03
       [134,]    1  8.000000e+00  2.827269e-03  5.471958e-03
       [135,]    2  8.000000e+00 -1.260270e-03 -1.787777e-03
       [136,]    3  8.000000e+00 -3.653013e-03  7.759229e-03
       [137,]    4  8.000000e+00  2.911953e-03 -1.099078e-03
       [138,]    5  8.000000e+00 -2.022803e-03 -6.557693e-03
       [139,]    6  8.000000e+00  4.078601e-03 -5.317449e-03
       [140,]    7  8.000000e+00 -5.045567e-03  4.621998e-03
       [141,]    8  8.000000e+00  4.668051e-04 -7.044979e-03
       [142,]    9  8.000000e+00 -4.417820e-04 -5.493449e-03
       [143,]   10  8.000000e+00  4.713328e-03 -5.438687e-03
       [144,]   11  8.000000e+00  4.723901e-03  9.805906e-03
       [145,]   12  8.000000e+00 -2.694839e-03 -2.117999e-03
       [146,]   13  8.000000e+00  9.735825e-03  8.752895e-03
       [147,]   14  8.000000e+00 -7.644922e-04 -4.646166e-03
       [148,]   15  8.000000e+00 -9.187791e-03 -6.774511e-03
       [149,]   16  8.000000e+00  4.816160e-03 -7.670784e-03
       [150,]   17  8.000000e+00 -5.493061e-03 -8.894544e-03
       [151,]   18  8.000000e+00 -3.220990e-03 -2.296649e-03
       [152,]   19  8.000000e+00  9.829070e-03 -8.281935e-04
       [153,]    1  9.000000e+00 -9.481364e-03 -7.780032e-04
       [154,]    2  9.000000e+00  3.165624e-03  4.307255e-03
       [155,]    3  9.000000e+00 -2.454520e-03 -7.308789e-03
       [156,]    4  9.000000e+00  2.123429e-03  2.137699e-03
       [157,]    5  9.000000e+00  5.446629e-03 -3.978009e-03
       [158,]    6  9.000000e+00  6.076391e-04 -1.251897e-03
       [159,]    7  9.000000e+00  6.234536e-03  4.340761e-03
       [160,]    8  9.000000e+00  4.483198e-03 -7.612568e-03
       [161,]    9  9.000000e+00  9.039982e-03 -2.671642e-03
       [162,]   10  9.000000e+00  4.774900e-03 -7.259614e-03
       [163,]   11  9.000000e+00 -7.157066e-03 -3.491960e-03
       [164,]   12  9.000000e+00 -4.459487e-03 -4.429673e-03
       [165,]   13  9.000000e+00  4.670311e-03 -8.071325e-03
       [166,]   14  9.000000e+00  6.247431e-03 -4.792553e-03
       [167,]   15  9.000000e+00  1.031497e-03 -8.292449e-03
       [168,]   16  9.000000e+00  6.666834e-03  4.508074e-03
       [169,]   17  9.000000e+00  5.893442e-03  5.929432e-03
       [170,]   18  9.000000e+00 -8.983851e-03  1.487654e-03
       [171,]   19  9.000000e+00 -5.742828e-03  1.121037e-03
       [172,]    1  1.000000e+01 -9.787058e-03  4.928885e-03
       [173,]    2  1.000000e+01 -9.084053e-03 -9.134483e-03
       [174,]    3  1.000000e+01 -1.144450e-03 -8.658149e-03
       [175,]    4  1.000000e+01  2.330997e-04 -3.698691e-04
       [176,]    5  1.000000e+01  8.553621e-03  1.235763e-03
       [177,]    6  1.000000e+01 -4.404603e-03 -2.588290e-03
       [178,]    7  1.000000e+01  8.613836e-04 -8.484468e-03
       [179,]    8  1.000000e+01  2.961226e-03  7.258637e-04
       [180,]    9  1.000000e+01 -9.711444e-03 -7.769701e-03
       [181,]   10  1.000000e+01  5.406769e-03  4.991074e-03
       [182,]   11  1.000000e+01 -6.834119e-03 -6.522443e-03
       [183,]   12  1.000000e+01  5.365711e-03  5.682448e-03
       [184,]   13  1.000000e+01  3.166072e-03 -3.713042e-03
       [185,]   14  1.000000e+01  8.587582e-03 -4.553069e-04
       [186,]   15  1.000000e+01  8.297681e-03 -7.875349e-03
       [187,]   16  1.000000e+01 -4.795257e-03 -4.036501e-03
       [188,]   17  1.000000e+01  6.722824e-03  3.432125e-03
       [189,]   18  1.000000e+01  1.382386e-03 -7.203297e-03
       [190,]   19  1.000000e+01  6.219656e-03  1.755088e-03
       [191,]    1  1.100000e+01 -5.169354e-04  8.341343e-03
       [192,]    2  1.100000e+01  1.202758e-03  5.896952e-03
       [193,]    3  1.100000e+01  4.163301e-03  8.080124e-03
       [194,]    4  1.100000e+01 -9.718517e-04 -9.992820e-03
       [195,]    5  1.100000e+01  3.644927e-03  6.254712e-03
       [196,]    6  1.100000e+01  3.686637e-03  2.261027e-03
       [197,]    7  1.100000e+01 -9.188615e-03 -1.748748e-03
       [198,]    8  1.100000e+01  9.064328e-03  8.212700e-03
       [199,]    9  1.100000e+01 -1.186874e-03 -1.561327e-03
       [200,]   10  1.100000e+01 -1.445055e-03  6.384607e-03
       [201,]   11  1.100000e+01  3.374941e-03  8.472284e-03
       [202,]   12  1.100000e+01 -9.473245e-03  2.890353e-03
       [203,]   13  1.100000e+01  3.178017e-03  4.626708e-06
       [204,]   14  1.100000e+01 -4.342632e-03 -3.554288e-03
       [205,]   15  1.100000e+01 -5.895462e-03  7.093995e-03
       [206,]   16  1.100000e+01 -4.367438e-03 -1.443225e-03
       [207,]   17  1.100000e+01 -5.719786e-03  7.107894e-04
       [208,]   18  1.100000e+01 -1.887350e-03  6.536594e-04
       [209,]   19  1.100000e+01 -6.380428e-03  3.114759e-03
       [210,]    1  1.200000e+01  6.147799e-03  7.179903e-04
       [211,]    2  1.200000e+01 -5.108284e-03 -4.735508e-03
       [212,]    3  1.200000e+01  9.269735e-03 -7.081485e-03
       [213,]    4  1.200000e+01  3.922238e-03  8.298240e-03
       [214,]    5  1.200000e+01 -3.446336e-03  2.768186e-03
       [215,]    6  1.200000e+01 -4.091918e-03 -2.374364e-04
       [216,]    7  1.200000e+01  2.008702e-03 -7.995896e-03
       [217,]    8  1.200000e+01  2.133978e-03 -1.241753e-03
       [218,]    9  1.200000e+01 -3.105897e-03  3.335917e-03
       [219,]   10  1.200000e+01  6.791611e-03 -7.057150e-03
       [220,]   11  1.200000e+01 -3.255646e-03  3.777640e-03
       [221,]   12  1.200000e+01  2.092681e-03 -9.925323e-03
       [222,]   13  1.200000e+01  2.331082e-03 -7.350997e-04
       [223,]   14  1.200000e+01  2.276014e-03 -5.602993e-03
       [224,]   15  1.200000e+01  6.614481e-03  5.319941e-03
       [225,]   16  1.200000e+01  7.222526e-03  2.340157e-03
       [226,]   17  1.200000e+01 -3.481421e-03 -6.053510e-03
       [227,]   18  1.200000e+01 -1.348861e-03 -6.370103e-03
       [228,]   19  1.200000e+01  7.191194e-03 -5.559253e-03
       [229,]    1  1.300000e+01  1.239531e-03 -5.957793e-03
       [230,]    2  1.300000e+01 -9.543798e-03 -4.062814e-03
       [231,]    3  1.300000e+01  6.184325e-03  9.539900e-03
       [232,]    4  1.300000e+01  7.466985e-04 -9.074746e-03
       [233,]    5  1.300000e+01  3.922733e-03 -3.746173e-03
       [234,]    6  1.300000e+01  7.165817e-03 -1.701244e-03
       [235,]    7  1.300000e+01  3.195183e-03 -7.031147e-04
       [236,]    8  1.300000e+01 -9.889474e-03  2.436659e-03
       [237,]    9  1.300000e+01  6.897147e-03 -1.524674e-03
       [238,]   10  1.300000e+01  3.269418e-03 -5.612695e-03
       [239,]   11  1.300000e+01  1.261341e-03  7.620769e-03
       [240,]   12  1.300000e+01 -1.757673e-04  8.573333e-03
       [241,]   13  1.300000e+01  3.286236e-03  6.765914e-04
       [242,]   14  1.300000e+01 -9.617872e-03  6.000582e-03
       [243,]   15  1.300000e+01 -8.690581e-03  4.253109e-03
       [244,]   16  1.300000e+01  7.148407e-04  6.025158e-03
       [245,]   17  1.300000e+01 -4.752214e-03  8.610279e-03
       [246,]   18  1.300000e+01  9.113451e-03 -6.734500e-03
       [247,]   19  1.300000e+01 -5.199797e-04 -1.688508e-03
       [248,]    1  1.400000e+01 -1.601542e-03  9.093883e-03
       [249,]    2  1.400000e+01 -6.370087e-03  9.079738e-03
       [250,]    3  1.400000e+01  3.117208e-03 -2.891972e-03
       [251,]    4  1.400000e+01  8.088143e-03 -1.715125e-03
       [252,]    5  1.400000e+01  8.940039e-03  9.536845e-03
       [253,]    6  1.400000e+01  2.705165e-03  9.160710e-03
       [254,]    7  1.400000e+01 -8.645098e-05 -7.296252e-03
       [255,]    8  1.400000e+01  8.998226e-04 -1.322515e-03
       [256,]    9  1.400000e+01  3.260393e-03 -5.384716e-03
       [257,]   10  1.400000e+01 -9.368576e-03 -7.223243e-04
       [258,]   11  1.400000e+01  1.574375e-03  5.606613e-03
       [259,]   12  1.400000e+01  9.934207e-03 -1.296130e-03
       [260,]   13  1.400000e+01  1.001285e-03 -6.540620e-03
       [261,]   14  1.400000e+01 -1.505821e-03 -2.303730e-03
       [262,]   15  1.400000e+01 -6.184619e-03 -5.935624e-03
       [263,]   16  1.400000e+01  2.051796e-03  2.381458e-03
       [264,]   17  1.400000e+01 -9.487190e-03  1.782010e-03
       [265,]   18  1.400000e+01 -4.447812e-03  8.422752e-04
       [266,]   19  1.400000e+01  6.739813e-03  6.840945e-03
       [267,]    1  1.500000e+01 -8.795683e-03 -4.803342e-03
       [268,]    2  1.500000e+01 -7.848986e-03  4.577202e-03
       [269,]    3  1.500000e+01  6.952434e-03  7.616076e-03
       [270,]    4  1.500000e+01  7.104875e-04  7.092617e-03
       [271,]    5  1.500000e+01 -6.000986e-03 -8.984291e-03
       [272,]    6  1.500000e+01 -4.829978e-03  4.705853e-03
       [273,]    7  1.500000e+01 -9.967385e-03  7.970574e-03
       [274,]    8  1.500000e+01 -6.775119e-03  6.975765e-03
       [275,]    9  1.500000e+01 -5.673986e-03 -1.897079e-03
       [276,]   10  1.500000e+01  5.976678e-03  3.158162e-03
       [277,]   11  1.500000e+01  5.484029e-03 -2.154549e-03
       [278,]   12  1.500000e+01  4.930744e-03 -8.135738e-03
       [279,]   13  1.500000e+01 -4.961322e-03 -3.718161e-03
       [280,]   14  1.500000e+01 -3.633235e-03 -8.876585e-03
       [281,]   15  1.500000e+01 -2.346215e-03  7.006552e-03
       [282,]   16  1.500000e+01  9.993431e-03  2.119492e-04
       [283,]   17  1.500000e+01 -7.145006e-03  1.446857e-03
       [284,]   18  1.500000e+01  5.182751e-03  8.467737e-04
       [285,]   19  1.500000e+01  3.721005e-03 -2.431512e-03
       [286,]    1  1.600000e+01 -7.669394e-03 -1.736947e-03
       [287,]    2  1.600000e+01 -1.579699e-03  6.967313e-03
       [288,]    3  1.600000e+01  1.574772e-03  2.576700e-03
       [289,]    4  1.600000e+01  8.004861e-03  2.986459e-03
       [290,]    5  1.600000e+01  3.680070e-03 -9.341807e-03
       [291,]    6  1.600000e+01  9.693314e-03  2.055041e-03
       [292,]    7  1.600000e+01  1.977373e-03 -2.789338e-03
       [293,]    8  1.600000e+01 -5.543045e-03 -2.142374e-03
       [294,]    9  1.600000e+01 -7.445856e-03 -7.990537e-03
       [295,]   10  1.600000e+01 -4.743842e-03  1.194329e-03
       [296,]   11  1.600000e+01 -2.680858e-03  5.953467e-03
       [297,]   12  1.600000e+01 -7.197657e-03  6.116707e-03
       [298,]   13  1.600000e+01 -1.382992e-03  8.646890e-03
       [299,]   14  1.600000e+01 -6.476656e-03 -1.399267e-03
       [300,]   15  1.600000e+01  1.855532e-03  7.819654e-03
       [301,]   16  1.600000e+01 -1.767056e-03  3.573189e-03
       [302,]   17  1.600000e+01 -4.068246e-03  4.358277e-03
       [303,]   18  1.600000e+01 -2.915258e-03  9.609984e-03
       [304,]   19  1.600000e+01 -2.113384e-03 -3.999779e-03
       [305,]    1  1.700000e+01  7.990180e-03  1.091580e-03
       [306,]    2  1.700000e+01  8.745119e-03 -4.213034e-04
       [307,]    3  1.700000e+01 -8.052032e-03 -9.414273e-03
       [308,]    4  1.700000e+01  2.096944e-03  7.299974e-03
       [309,]    5  1.700000e+01 -1.809335e-03 -4.817126e-03
       [310,]    6  1.700000e+01 -9.235525e-03 -4.535247e-03
       [311,]    7  1.700000e+01 -4.161215e-03 -8.182640e-03
       [312,]    8  1.700000e+01 -8.557443e-03 -7.352544e-03
       [313,]    9  1.700000e+01 -1.433945e-03  6.363135e-03
       [314,]   10  1.700000e+01  5.768171e-03  9.395644e-05
       [315,]   11  1.700000e+01  9.611480e-03 -7.833690e-03
       [316,]   12  1.700000e+01 -5.510632e-03 -1.973236e-03
       [317,]   13  1.700000e+01  7.100297e-03  3.382192e-03
       [318,]   14  1.700000e+01  6.132849e-04  9.979512e-04
       [319,]   15  1.700000e+01 -2.362856e-03  3.567346e-03
       [320,]   16  1.700000e+01 -9.982595e-04 -4.956136e-03
       [321,]   17  1.700000e+01 -8.028435e-03 -9.959593e-03
       [322,]   18  1.700000e+01  3.448036e-03 -5.063996e-03
       [323,]   19  1.700000e+01  4.724950e-03  2.681853e-03
       [324,]    1  1.800000e+01  2.816246e-03 -9.766320e-03
       [325,]    2  1.800000e+01 -9.261248e-03  6.794124e-03
       [326,]    3  1.800000e+01  1.179902e-03 -6.114456e-04
       [327,]    4  1.800000e+01 -1.845013e-03  8.920444e-03
       [328,]    5  1.800000e+01  4.570496e-03 -3.058482e-03
       [329,]    6  1.800000e+01  8.280794e-03  6.582173e-03
       [330,]    7  1.800000e+01  7.037853e-03  8.999968e-03
       [331,]    8  1.800000e+01 -9.537632e-03  4.865862e-03
       [332,]    9  1.800000e+01 -8.912425e-03  1.018749e-04
       [333,]   10  1.800000e+01 -4.725652e-04 -9.985462e-03
       [334,]   11  1.800000e+01 -4.742654e-03  6.035343e-06
       [335,]   12  1.800000e+01 -8.484325e-03 -5.105650e-03
       [336,]   13  1.800000e+01  7.824235e-03 -6.603295e-03
       [337,]   14  1.800000e+01 -5.725531e-03 -3.438792e-03
       [338,]   15  1.800000e+01  4.170937e-03  1.142219e-03
       [339,]   16  1.800000e+01 -4.685466e-03 -7.896140e-03
       [340,]   17  1.800000e+01 -1.539516e-03  5.048907e-03
       [341,]   18  1.800000e+01 -9.769796e-04  1.587220e-03
       [342,]   19  1.800000e+01 -5.761327e-03 -7.871088e-03
       [343,]    1  1.900000e+01  5.430234e-03 -7.846381e-03
       [344,]    2  1.900000e+01 -1.364611e-03  9.344191e-03
       [345,]    3  1.900000e+01  2.193855e-03  7.598653e-03
       [346,]    4  1.900000e+01 -1.171873e-03 -2.101351e-03
       [347,]    5  1.900000e+01 -6.015058e-04  3.278910e-05
       [348,]    6  1.900000e+01 -3.972683e-03 -8.552771e-05
       [349,]    7  1.900000e+01 -3.843195e-03  5.310672e-03
       [350,]    8  1.900000e+01  3.825142e-03  2.285356e-03
       [351,]    9  1.900000e+01  3.669856e-03 -3.354770e-03
       [352,]   10  1.900000e+01  5.518439e-03  8.842681e-03
       [353,]   11  1.900000e+01 -5.325851e-03  4.742014e-03
       [354,]   12  1.900000e+01 -3.503872e-03  3.163454e-03
       [355,]   13  1.900000e+01 -7.282962e-03  3.049557e-03
       [356,]   14  1.900000e+01  8.577399e-03 -1.366275e-03
       [357,]   15  1.900000e+01  9.901594e-03  3.923611e-03
       [358,]   16  1.900000e+01  4.225606e-03 -2.741412e-03
       [359,]   17  1.900000e+01  2.531718e-03 -9.491326e-03
       [360,]   18  1.900000e+01 -1.889917e-03 -2.350225e-04
       [361,]   19  1.900000e+01  7.135425e-04 -5.174990e-03
       [362,]    1 -1.514639e-03  1.000000e+00 -7.818967e-03
       [363,]    2  1.129359e-03  1.000000e+00  2.171943e-04
       [364,]    3 -2.858727e-03  1.000000e+00  3.868331e-03
       [365,]    4 -7.743494e-03  1.000000e+00 -3.661668e-03
       [366,]    5  9.500059e-04  1.000000e+00  7.830233e-03
       [367,]    6  8.184879e-03  1.000000e+00 -6.933033e-03
       [368,]    7  4.742921e-03  1.000000e+00 -4.377252e-03
       [369,]    8 -4.633994e-03  1.000000e+00  1.601965e-03
       [370,]    9 -6.686205e-03  1.000000e+00  2.475504e-03
       [371,]   10  3.706802e-03  1.000000e+00  6.879744e-03
       [372,]   11 -9.550191e-03  1.000000e+00 -6.437342e-03
       [373,]   12  7.096454e-04  1.000000e+00  2.325583e-03
       [374,]   13  3.801626e-03  1.000000e+00  7.149465e-04
       [375,]   14 -1.270784e-03  1.000000e+00 -4.133470e-03
       [376,]   15 -2.792066e-03  1.000000e+00  5.833907e-03
       [377,]   16  4.719857e-03  1.000000e+00  4.130869e-03
       [378,]   17 -1.572567e-03  1.000000e+00  4.159931e-03
       [379,]   18 -8.197752e-03  1.000000e+00  4.229721e-03
       [380,]   19  1.939279e-03  1.000000e+00  1.060395e-03
       [381,]    1 -9.720951e-03  2.000000e+00  4.205743e-03
       [382,]    2 -2.984254e-04  2.000000e+00  4.102854e-03
       [383,]    3  1.877243e-04  2.000000e+00  1.208162e-03
       [384,]    4  2.078001e-03  2.000000e+00  6.015378e-03
       [385,]    5 -4.583380e-03  2.000000e+00  1.237888e-04
       [386,]    6 -8.104494e-03  2.000000e+00 -3.821924e-03
       [387,]    7 -8.310843e-03  2.000000e+00  8.618477e-03
       [388,]    8 -6.408238e-03  2.000000e+00 -7.021572e-03
       [389,]    9  3.493527e-03  2.000000e+00  9.585036e-03
       [390,]   10 -5.522661e-03  2.000000e+00 -2.681782e-03
       [391,]   11 -4.517366e-03  2.000000e+00  9.654176e-03
       [392,]   12  2.046364e-03  2.000000e+00  5.091722e-03
       [393,]   13  7.505486e-03  2.000000e+00  2.819704e-03
       [394,]   14  3.497232e-03  2.000000e+00 -4.673873e-04
       [395,]   15  9.054001e-03  2.000000e+00  8.319909e-03
       [396,]   16  6.507024e-04  2.000000e+00 -8.360893e-03
       [397,]   17  4.526878e-04  2.000000e+00 -2.286557e-03
       [398,]   18  1.584256e-03  2.000000e+00 -3.804753e-03
       [399,]   19 -1.284447e-03  2.000000e+00  6.005804e-03
       [400,]    1  5.425770e-03  3.000000e+00 -1.295580e-03
       [401,]    2 -2.838337e-04  3.000000e+00  6.297318e-04
       [402,]    3 -6.015184e-03  3.000000e+00 -3.460679e-03
       [403,]    4  2.245814e-03  3.000000e+00  9.068973e-03
       [404,]    5  9.439250e-03  3.000000e+00  1.461629e-03
       [405,]    6 -4.247468e-03  3.000000e+00 -8.992798e-03
       [406,]    7 -9.643858e-03  3.000000e+00 -5.541553e-03
       [407,]    8 -4.555615e-03  3.000000e+00 -2.215122e-04
       [408,]    9  5.057174e-03  3.000000e+00  1.913433e-03
       [409,]   10 -6.366022e-03  3.000000e+00  2.905966e-03
       [410,]   11  1.332123e-03  3.000000e+00  9.227510e-03
       [411,]   12 -8.126832e-03  3.000000e+00  4.120478e-03
       [412,]   13 -4.024356e-03  3.000000e+00  1.714528e-03
       [413,]   14  9.009014e-03  3.000000e+00  8.363731e-03
       [414,]   15  1.410055e-04  3.000000e+00  4.849577e-03
       [415,]   16 -6.689662e-04  3.000000e+00 -5.237740e-03
       [416,]   17  5.937635e-03  3.000000e+00  9.681207e-03
       [417,]   18  9.518172e-04  3.000000e+00  1.473868e-03
       [418,]   19  2.393047e-03  3.000000e+00 -8.020082e-03
       [419,]    1  7.149370e-03  4.000000e+00 -7.684544e-03
       [420,]    2  3.656881e-03  4.000000e+00 -1.544789e-03
       [421,]    3 -1.817625e-03  4.000000e+00  7.464550e-03
       [422,]    4  9.301228e-03  4.000000e+00  7.433166e-03
       [423,]    5 -1.506072e-03  4.000000e+00 -3.999600e-03
       [424,]    6  9.072464e-04  4.000000e+00  6.084514e-03
       [425,]    7  9.872176e-03  4.000000e+00 -4.585396e-03
       [426,]    8  4.298318e-03  4.000000e+00  7.106914e-03
       [427,]    9  1.319262e-03  4.000000e+00 -8.474393e-03
       [428,]   10 -9.689765e-03  4.000000e+00  1.002870e-03
       [429,]   11  9.268688e-03  4.000000e+00 -8.888697e-03
       [430,]   12  6.408099e-03  4.000000e+00 -5.351882e-03
       [431,]   13 -2.995913e-03  4.000000e+00  3.964492e-03
       [432,]   14  5.020847e-03  4.000000e+00  6.889248e-03
       [433,]   15  5.209462e-03  4.000000e+00 -8.644847e-04
       [434,]   16  6.366560e-03  4.000000e+00 -5.102723e-04
       [435,]   17 -6.873991e-04  4.000000e+00  2.535362e-03
       [436,]   18  7.749930e-03  4.000000e+00 -7.665994e-05
       [437,]   19 -3.375136e-03  4.000000e+00  5.645537e-03
       [438,]    1 -2.414444e-03  5.000000e+00 -1.670534e-03
       [439,]    2 -9.033433e-03  5.000000e+00 -6.248816e-03
       [440,]    3  7.994993e-03  5.000000e+00 -7.920491e-03
       [441,]    4 -8.096556e-03  5.000000e+00 -2.274575e-03
       [442,]    5  6.141918e-03  5.000000e+00  8.582510e-03
       [443,]    6 -7.800240e-03  5.000000e+00  9.347271e-03
       [444,]    7  7.556540e-03  5.000000e+00 -9.419458e-03
       [445,]    8 -2.339087e-03  5.000000e+00  3.463178e-03
       [446,]    9 -5.861546e-03  5.000000e+00  9.064855e-03
       [447,]   10 -6.414332e-03  5.000000e+00 -9.199996e-03
       [448,]   11  6.947349e-03  5.000000e+00 -2.363937e-03
       [449,]   12  4.456851e-03  5.000000e+00  1.272396e-03
       [450,]   13  6.360376e-03  5.000000e+00  3.299589e-03
       [451,]   14  9.192803e-03  5.000000e+00 -5.144516e-03
       [452,]   15  4.545742e-04  5.000000e+00 -1.430802e-03
       [453,]   16  8.732535e-04  5.000000e+00  6.623670e-03
       [454,]   17 -7.413502e-03  5.000000e+00  8.626371e-03
       [455,]   18 -6.137139e-03  5.000000e+00  3.572584e-03
       [456,]   19 -5.546591e-04  5.000000e+00  7.612859e-03
       [457,]    1  3.377191e-03  6.000000e+00 -7.778999e-03
       [458,]    2 -6.474646e-03  6.000000e+00  4.964468e-03
       [459,]    3 -2.683366e-03  6.000000e+00 -8.704284e-03
       [460,]    4  9.334524e-03  6.000000e+00 -8.203929e-03
       [461,]    5 -8.284300e-03  6.000000e+00 -5.944420e-03
       [462,]    6 -9.668320e-03  6.000000e+00 -7.461365e-04
       [463,]    7 -3.764571e-03  6.000000e+00 -1.435876e-03
       [464,]    8  7.452158e-03  6.000000e+00 -1.005641e-03
       [465,]    9 -7.851915e-03  6.000000e+00 -7.462506e-03
       [466,]   10  1.811373e-03  6.000000e+00  6.462279e-03
       [467,]   11  1.421870e-03  6.000000e+00  9.909425e-03
       [468,]   12 -3.390793e-03  6.000000e+00 -7.955222e-03
       [469,]   13  9.792445e-03  6.000000e+00 -8.775228e-03
       [470,]   14  7.143655e-03  6.000000e+00 -6.328739e-03
       [471,]   15  3.614815e-03  6.000000e+00  4.174053e-03
       [472,]   16 -3.791312e-03  6.000000e+00 -7.996966e-03
       [473,]   17  7.406782e-03  6.000000e+00 -1.764176e-03
       [474,]   18  7.844388e-03  6.000000e+00  3.661015e-03
       [475,]   19  7.361640e-03  6.000000e+00  1.499414e-03
       [476,]    1  4.561349e-03  7.000000e+00  6.135113e-03
       [477,]    2 -1.356668e-03  7.000000e+00  5.046125e-03
       [478,]    3 -1.493686e-03  7.000000e+00  8.784306e-03
       [479,]    4  5.822551e-04  7.000000e+00 -9.202641e-03
       [480,]    5 -3.845948e-03  7.000000e+00 -8.520032e-03
       [481,]    6 -9.010228e-03  7.000000e+00  2.088120e-04
       [482,]    7  4.370994e-03  7.000000e+00 -3.475056e-04
       [483,]    8 -3.404043e-03  7.000000e+00 -9.930138e-03
       [484,]    9  2.428872e-03  7.000000e+00 -6.785571e-03
       [485,]   10 -5.399913e-03  7.000000e+00 -1.996379e-03
       [486,]   11  2.825662e-03  7.000000e+00 -1.511931e-03
       [487,]   12 -3.145785e-03  7.000000e+00  3.519218e-03
       [488,]   13  5.625956e-03  7.000000e+00 -2.567353e-03
       [489,]   14  7.378241e-03  7.000000e+00 -1.091666e-03
       [490,]   15  8.431403e-03  7.000000e+00 -9.518561e-04
       [491,]   16  5.621968e-03  7.000000e+00  3.533562e-03
       [492,]   17 -3.229803e-03  7.000000e+00 -6.680934e-03
       [493,]   18 -1.939086e-03  7.000000e+00 -3.812740e-03
       [494,]   19 -6.704480e-03  7.000000e+00 -3.360464e-03
       [495,]    1 -7.470824e-03  8.000000e+00 -4.672958e-03
       [496,]    2  2.331598e-03  8.000000e+00 -4.769689e-03
       [497,]    3 -4.106347e-03  8.000000e+00  3.319569e-03
       [498,]    4  7.382342e-03  8.000000e+00  3.813881e-03
       [499,]    5 -3.123650e-03  8.000000e+00  3.825034e-03
       [500,]    6 -9.366893e-03  8.000000e+00  4.442671e-03
       [501,]    7 -8.308074e-03  8.000000e+00  5.768142e-03
       [502,]    8 -8.188933e-03  8.000000e+00 -6.290610e-03
       [503,]    9  6.693192e-03  8.000000e+00 -1.393620e-03
       [504,]   10  2.394744e-03  8.000000e+00  6.585658e-03
       [505,]   11 -9.721842e-04  8.000000e+00  9.629557e-04
       [506,]   12  5.977139e-03  8.000000e+00 -5.147127e-03
       [507,]   13  8.311131e-03  8.000000e+00 -8.653587e-03
       [508,]   14 -9.495198e-03  8.000000e+00  4.046329e-03
       [509,]   15 -3.423712e-04  8.000000e+00  6.395928e-03
       [510,]   16 -2.334263e-03  8.000000e+00  6.439585e-03
       [511,]   17  7.884008e-03  8.000000e+00 -3.999299e-03
       [512,]   18 -3.092428e-03  8.000000e+00 -8.510974e-03
       [513,]   19 -1.714707e-03  8.000000e+00  7.980032e-03
       [514,]    1  5.870030e-03  9.000000e+00  6.718565e-03
       [515,]    2  2.407878e-03  9.000000e+00  3.334180e-03
       [516,]    3 -9.734346e-03  9.000000e+00  3.456054e-03
       [517,]    4  2.547870e-03  9.000000e+00 -2.018611e-03
       [518,]    5  4.241410e-03  9.000000e+00 -3.200437e-03
       [519,]    6  5.515709e-03  9.000000e+00  3.933883e-03
       [520,]    7 -5.826850e-03  9.000000e+00 -5.494973e-03
       [521,]    8  8.414061e-03  9.000000e+00  4.334987e-03
       [522,]    9 -6.926193e-03  9.000000e+00 -9.058547e-03
       [523,]   10  8.371756e-03  9.000000e+00 -8.406556e-03
       [524,]   11  2.675973e-05  9.000000e+00  5.005482e-03
       [525,]   12  7.356857e-03  9.000000e+00 -5.842432e-03
       [526,]   13  6.328948e-03  9.000000e+00 -9.445393e-03
       [527,]   14 -6.723153e-03  9.000000e+00 -7.677030e-03
       [528,]   15 -8.805976e-03  9.000000e+00 -7.382433e-03
       [529,]   16 -6.071596e-03  9.000000e+00  5.265859e-03
       [530,]   17  1.304182e-03  9.000000e+00  7.745794e-03
       [531,]   18  6.043275e-03  9.000000e+00  5.981978e-03
       [532,]   19 -4.669870e-03  9.000000e+00 -3.328604e-03
       [533,]    1  7.036828e-03  1.000000e+01 -5.850249e-03
       [534,]    2 -1.072742e-03  1.000000e+01  4.066368e-03
       [535,]    3 -4.691953e-04  1.000000e+01  4.583678e-03
       [536,]    4  3.513930e-03  1.000000e+01 -2.211619e-03
       [537,]    5 -8.526486e-03  1.000000e+01  1.835143e-03
       [538,]    6 -3.476767e-03  1.000000e+01  2.200454e-03
       [539,]    7  2.216516e-03  1.000000e+01  5.860077e-03
       [540,]    8 -3.309815e-04  1.000000e+01 -4.846364e-03
       [541,]    9 -7.391005e-03  1.000000e+01  2.656146e-03
       [542,]   10  4.698884e-03  1.000000e+01 -2.322947e-03
       [543,]   11  3.313625e-03  1.000000e+01 -7.675057e-04
       [544,]   12 -4.993905e-03  1.000000e+01  2.219414e-03
       [545,]   13  8.137131e-03  1.000000e+01  9.425413e-03
       [546,]   14 -5.868855e-03  1.000000e+01  5.063809e-03
       [547,]   15  3.956301e-03  1.000000e+01  9.260509e-04
       [548,]   16 -8.370759e-03  1.000000e+01  3.444183e-03
       [549,]   17 -5.663923e-03  1.000000e+01  5.202556e-03
       [550,]   18 -9.136182e-03  1.000000e+01  9.220389e-03
       [551,]   19 -9.623279e-03  1.000000e+01 -2.517377e-04
       [552,]    1  9.378649e-04  1.100000e+01  5.454168e-03
       [553,]    2  5.256164e-03  1.100000e+01 -6.245995e-03
       [554,]    3 -1.339244e-04  1.100000e+01  3.433323e-03
       [555,]    4  8.248408e-03  1.100000e+01 -9.934076e-03
       [556,]    5  3.984536e-03  1.100000e+01  6.092882e-03
       [557,]    6 -8.039022e-03  1.100000e+01  6.398962e-03
       [558,]    7  4.286521e-03  1.100000e+01 -4.977315e-03
       [559,]    8 -2.770355e-03  1.100000e+01  7.958531e-03
       [560,]    9  1.420523e-03  1.100000e+01 -3.109912e-03
       [561,]   10  9.379130e-03  1.100000e+01 -5.543267e-03
       [562,]   11 -2.975800e-04  1.100000e+01  8.820410e-03
       [563,]   12 -5.015300e-03  1.100000e+01 -8.187146e-03
       [564,]   13 -8.980095e-03  1.100000e+01  1.041431e-03
       [565,]   14  3.213592e-03  1.100000e+01  4.843148e-03
       [566,]   15  8.563003e-03  1.100000e+01 -9.287982e-03
       [567,]   16 -9.193723e-03  1.100000e+01  1.168808e-03
       [568,]   17  8.694306e-04  1.100000e+01 -7.132538e-04
       [569,]   18 -5.090997e-03  1.100000e+01  8.832472e-03
       [570,]   19 -2.035660e-03  1.100000e+01 -7.507244e-03
       [571,]    1  8.694454e-03  1.200000e+01 -7.718353e-03
       [572,]    2 -9.656351e-03  1.200000e+01  2.610320e-03
       [573,]    3  1.334872e-03  1.200000e+01  3.284253e-03
       [574,]    4  3.860447e-03  1.200000e+01  3.950855e-03
       [575,]    5  7.348957e-03  1.200000e+01 -7.359147e-03
       [576,]    6 -2.916728e-03  1.200000e+01  1.294591e-03
       [577,]    7  1.448680e-03  1.200000e+01  5.432582e-04
       [578,]    8 -2.958232e-03  1.200000e+01 -3.249560e-03
       [579,]    9 -6.536744e-03  1.200000e+01 -4.068013e-03
       [580,]   10  3.981587e-03  1.200000e+01 -8.731195e-03
       [581,]   11  5.619398e-03  1.200000e+01 -2.517044e-03
       [582,]   12 -1.028173e-03  1.200000e+01  6.116325e-03
       [583,]   13  1.559199e-03  1.200000e+01 -1.797146e-03
       [584,]   14 -5.369193e-05  1.200000e+01 -5.078432e-04
       [585,]   15 -5.482066e-03  1.200000e+01  6.999721e-03
       [586,]   16  5.108734e-03  1.200000e+01 -7.095246e-03
       [587,]   17  7.022519e-03  1.200000e+01 -2.087956e-03
       [588,]   18  4.269307e-03  1.200000e+01  6.099924e-04
       [589,]   19 -4.972259e-03  1.200000e+01 -7.263584e-03
       [590,]    1 -9.434262e-03  1.300000e+01 -9.419967e-03
       [591,]    2 -6.582502e-03  1.300000e+01  6.713776e-03
       [592,]    3 -4.947348e-03  1.300000e+01 -4.856251e-03
       [593,]    4  2.395007e-03  1.300000e+01 -3.570467e-03
       [594,]    5  9.431442e-03  1.300000e+01 -9.677139e-03
       [595,]    6 -9.344926e-03  1.300000e+01 -9.930134e-03
       [596,]    7 -1.844053e-03  1.300000e+01  8.169667e-03
       [597,]    8 -1.950429e-03  1.300000e+01  4.024689e-03
       [598,]    9  8.118667e-03  1.300000e+01 -7.302422e-03
       [599,]   10  5.148639e-03  1.300000e+01 -6.474253e-03
       [600,]   11 -2.345842e-03  1.300000e+01 -8.663890e-03
       [601,]   12  1.699184e-03  1.300000e+01  6.632666e-03
       [602,]   13  5.512346e-03  1.300000e+01 -6.095590e-03
       [603,]   14 -2.484522e-03  1.300000e+01 -7.364402e-03
       [604,]   15 -8.837480e-03  1.300000e+01  6.862723e-03
       [605,]   16 -9.377627e-03  1.300000e+01  6.132796e-03
       [606,]   17  1.481132e-03  1.300000e+01 -3.022990e-03
       [607,]   18 -6.208304e-03  1.300000e+01  4.189772e-03
       [608,]   19  6.972727e-03  1.300000e+01  2.483313e-03
       [609,]    1  9.758161e-03  1.400000e+01 -7.131582e-03
       [610,]    2  7.996285e-03  1.400000e+01  7.156155e-03
       [611,]    3  1.737410e-03  1.400000e+01 -3.319171e-05
       [612,]    4 -8.821805e-03  1.400000e+01 -3.816848e-03
       [613,]    5 -9.988857e-03  1.400000e+01  7.205711e-03
       [614,]    6 -2.455788e-03  1.400000e+01 -2.129170e-03
       [615,]    7  3.060451e-03  1.400000e+01 -1.907699e-03
       [616,]    8  4.552967e-03  1.400000e+01  2.287730e-03
       [617,]    9  6.330896e-03  1.400000e+01 -8.536495e-03
       [618,]   10  8.077501e-03  1.400000e+01  9.589929e-03
       [619,]   11 -3.757156e-03  1.400000e+01  2.175441e-03
       [620,]   12 -9.826896e-03  1.400000e+01  5.313360e-03
       [621,]   13 -7.094333e-03  1.400000e+01 -5.351659e-03
       [622,]   14 -1.025417e-03  1.400000e+01  2.095308e-03
       [623,]   15 -7.858553e-03  1.400000e+01  9.868957e-03
       [624,]   16  9.613187e-03  1.400000e+01  4.997341e-03
       [625,]   17  4.237220e-03  1.400000e+01 -4.307116e-03
       [626,]   18  3.251131e-03  1.400000e+01 -2.550119e-03
       [627,]   19  9.763486e-03  1.400000e+01 -5.219109e-03
       [628,]    1  4.739358e-03  1.500000e+01 -1.380394e-03
       [629,]    2 -2.667196e-03  1.500000e+01  9.657040e-03
       [630,]    3 -7.022480e-03  1.500000e+01 -5.712438e-03
       [631,]    4 -9.728358e-03  1.500000e+01  9.995269e-03
       [632,]    5  9.413269e-03  1.500000e+01  1.160166e-03
       [633,]    6 -5.928242e-03  1.500000e+01 -8.860867e-03
       [634,]    7 -1.159321e-03  1.500000e+01 -4.884273e-03
       [635,]    8 -6.016258e-03  1.500000e+01 -5.014312e-03
       [636,]    9  6.584448e-03  1.500000e+01  8.438664e-03
       [637,]   10  7.931317e-03  1.500000e+01 -5.434842e-03
       [638,]   11 -7.571017e-03  1.500000e+01 -9.817954e-03
       [639,]   12 -4.549249e-04  1.500000e+01  8.402968e-03
       [640,]   13  3.168797e-03  1.500000e+01  1.127891e-03
       [641,]   14  1.192391e-03  1.500000e+01  7.209200e-03
       [642,]   15 -3.174335e-03  1.500000e+01 -4.391058e-03
       [643,]   16  5.077333e-03  1.500000e+01 -3.312013e-03
       [644,]   17  3.939195e-03  1.500000e+01 -7.782295e-03
       [645,]   18 -8.845371e-03  1.500000e+01 -9.004994e-03
       [646,]   19  3.563358e-04  1.500000e+01  9.272063e-03
       [647,]    1  4.002948e-05  1.600000e+01  9.488620e-03
       [648,]    2 -1.973886e-03  1.600000e+01 -5.178722e-04
       [649,]    3 -4.631040e-03  1.600000e+01 -1.902752e-05
       [650,]    4 -8.114653e-03  1.600000e+01 -9.455199e-03
       [651,]    5  4.026348e-04  1.600000e+01 -1.372910e-03
       [652,]    6 -8.567693e-03  1.600000e+01  3.229762e-03
       [653,]    7  7.837312e-03  1.600000e+01 -8.904819e-03
       [654,]    8 -7.358550e-03  1.600000e+01  6.794431e-03
       [655,]    9 -9.005218e-03  1.600000e+01 -2.036140e-03
       [656,]   10 -7.096317e-03  1.600000e+01  9.420494e-04
       [657,]   11  8.699126e-03  1.600000e+01  7.502485e-03
       [658,]   12  9.721442e-03  1.600000e+01  4.917834e-03
       [659,]   13  3.489198e-03  1.600000e+01  5.123213e-03
       [660,]   14 -3.777503e-03  1.600000e+01 -7.649312e-03
       [661,]   15 -9.710821e-03  1.600000e+01  5.043266e-03
       [662,]   16 -9.937281e-03  1.600000e+01 -6.288234e-03
       [663,]   17  5.830326e-03  1.600000e+01  4.102124e-03
       [664,]   18 -5.587580e-03  1.600000e+01  7.716527e-03
       [665,]   19 -3.898778e-05  1.600000e+01  1.810928e-03
       [666,]    1  9.547218e-03  1.700000e+01  5.710789e-03
       [667,]    2  1.689961e-03  1.700000e+01  9.198077e-03
       [668,]    3 -1.082555e-03  1.700000e+01  3.468324e-03
       [669,]    4 -3.342383e-03  1.700000e+01  3.974577e-03
       [670,]    5 -9.758188e-03  1.700000e+01 -3.676702e-03
       [671,]    6 -3.751754e-03  1.700000e+01 -4.726103e-03
       [672,]    7  2.073592e-03  1.700000e+01  1.768128e-03
       [673,]    8  8.313548e-05  1.700000e+01 -3.348529e-03
       [674,]    9  7.596541e-03  1.700000e+01  2.905625e-03
       [675,]   10  9.707441e-03  1.700000e+01  2.444307e-03
       [676,]   11 -3.484863e-03  1.700000e+01  5.450390e-03
       [677,]   12 -3.753623e-03  1.700000e+01 -8.709605e-03
       [678,]   13 -4.427393e-03  1.700000e+01 -9.495157e-03
       [679,]   14 -2.598299e-03  1.700000e+01 -7.373840e-03
       [680,]   15 -6.626554e-03  1.700000e+01 -2.119970e-04
       [681,]   16  5.431592e-03  1.700000e+01  7.450353e-03
       [682,]   17 -1.002208e-04  1.700000e+01  9.342739e-03
       [683,]   18 -4.293071e-03  1.700000e+01  8.999555e-03
       [684,]   19 -4.450306e-03  1.700000e+01 -1.796325e-03
       [685,]    1  4.013700e-03  1.800000e+01  1.276366e-03
       [686,]    2 -5.183392e-03  1.800000e+01  4.692679e-03
       [687,]    3  8.009443e-03  1.800000e+01  2.401896e-04
       [688,]    4  8.239373e-03  1.800000e+01 -9.295847e-03
       [689,]    5 -1.343002e-03  1.800000e+01  1.635174e-03
       [690,]    6  1.345690e-04  1.800000e+01 -6.673213e-03
       [691,]    7 -7.451741e-03  1.800000e+01 -8.151149e-03
       [692,]    8 -1.940768e-03  1.800000e+01 -5.905443e-03
       [693,]    9 -1.026976e-03  1.800000e+01 -6.765051e-03
       [694,]   10 -9.582917e-03  1.800000e+01 -1.674974e-03
       [695,]   11 -2.789257e-03  1.800000e+01  1.451764e-03
       [696,]   12 -8.015405e-03  1.800000e+01  5.175744e-03
       [697,]   13  1.822143e-05  1.800000e+01 -8.545495e-03
       [698,]   14  1.072417e-03  1.800000e+01  2.468499e-04
       [699,]   15 -7.125205e-03  1.800000e+01  4.099477e-03
       [700,]   16  4.291188e-03  1.800000e+01  8.971692e-03
       [701,]   17  1.273691e-03  1.800000e+01 -9.786922e-03
       [702,]   18 -7.153886e-03  1.800000e+01  1.617862e-03
       [703,]   19  7.481813e-03  1.800000e+01 -2.661097e-03
       [704,]    1  5.045734e-03  1.900000e+01 -4.159930e-03
       [705,]    2 -9.936414e-03  1.900000e+01  8.725871e-03
       [706,]    3  7.478514e-04  1.900000e+01 -5.106836e-03
       [707,]    4 -3.977015e-03  1.900000e+01 -4.447832e-03
       [708,]    5 -3.665668e-03  1.900000e+01  3.735082e-03
       [709,]    6  9.338025e-04  1.900000e+01 -4.224107e-06
       [710,]    7  4.724130e-03  1.900000e+01 -5.016098e-03
       [711,]    8  9.318408e-03  1.900000e+01  3.140476e-03
       [712,]    9 -8.295729e-03  1.900000e+01  8.245212e-03
       [713,]   10  2.692959e-03  1.900000e+01  8.655298e-03
       [714,]   11 -8.417939e-03  1.900000e+01  1.143882e-03
       [715,]   12 -1.998032e-03  1.900000e+01 -1.320761e-03
       [716,]   13  1.911291e-03  1.900000e+01  2.958040e-03
       [717,]   14  2.158594e-03  1.900000e+01  3.620044e-03
       [718,]   15  3.972498e-04  1.900000e+01 -3.318495e-03
       [719,]   16  4.694456e-04  1.900000e+01 -5.341092e-03
       [720,]   17  9.567456e-03  1.900000e+01  2.653026e-03
       [721,]   18  3.421084e-03  1.900000e+01  9.896175e-03
       [722,]   19  2.190885e-03  1.900000e+01  9.194863e-03
       [723,]    1  1.014618e-03  9.186011e-03  1.000000e+00
       [724,]    2  9.340171e-03 -9.722741e-03  1.000000e+00
       [725,]    3  9.265941e-03 -4.195334e-03  1.000000e+00
       [726,]    4 -5.309869e-03  4.087549e-03  1.000000e+00
       [727,]    5 -9.443939e-03 -6.114835e-03  1.000000e+00
       [728,]    6  6.957283e-04 -2.166505e-03  1.000000e+00
       [729,]    7 -3.324053e-03 -2.538579e-03  1.000000e+00
       [730,]    8  8.612888e-03 -7.370547e-03  1.000000e+00
       [731,]    9  5.621640e-03 -4.001295e-03  1.000000e+00
       [732,]   10 -9.860255e-04 -4.717177e-03  1.000000e+00
       [733,]   11 -6.738348e-03  5.798367e-03  1.000000e+00
       [734,]   12 -7.926646e-04 -3.786978e-03  1.000000e+00
       [735,]   13  2.649448e-03  8.118507e-03  1.000000e+00
       [736,]   14 -6.622285e-04 -5.130869e-03  1.000000e+00
       [737,]   15  5.726545e-03  6.065134e-04  1.000000e+00
       [738,]   16 -4.628910e-03  4.746155e-04  1.000000e+00
       [739,]   17  2.738525e-03  9.188317e-03  1.000000e+00
       [740,]   18 -9.337045e-03  3.947560e-03  1.000000e+00
       [741,]   19 -1.086947e-03 -2.003150e-03  1.000000e+00
       [742,]    1  9.503381e-04  4.150652e-03  2.000000e+00
       [743,]    2 -5.620795e-03 -1.466438e-04  2.000000e+00
       [744,]    3  9.948543e-04 -1.883615e-03  2.000000e+00
       [745,]    4 -5.594727e-03 -2.599026e-03  2.000000e+00
       [746,]    5  3.776805e-03  2.611096e-03  2.000000e+00
       [747,]    6 -9.983501e-05  5.256408e-03  2.000000e+00
       [748,]    7 -1.488218e-03  2.764518e-03  2.000000e+00
       [749,]    8  5.131778e-03 -5.356961e-03  2.000000e+00
       [750,]    9 -9.413560e-03  5.562610e-03  2.000000e+00
       [751,]   10  2.311599e-03 -4.267989e-04  2.000000e+00
       [752,]   11 -1.256174e-03  2.236314e-03  2.000000e+00
       [753,]   12  2.948589e-03  6.486918e-04  2.000000e+00
       [754,]   13 -2.535728e-03 -8.686962e-03  2.000000e+00
       [755,]   14 -9.451070e-03 -2.301668e-03  2.000000e+00
       [756,]   15  1.558365e-03  9.311493e-03  2.000000e+00
       [757,]   16  1.736297e-03  3.096141e-03  2.000000e+00
       [758,]   17 -5.821904e-03  6.532695e-03  2.000000e+00
       [759,]   18  2.577183e-03  7.585003e-03  2.000000e+00
       [760,]   19  2.764046e-03  4.838569e-03  2.000000e+00
       [761,]    1  6.338097e-03 -8.889155e-03  3.000000e+00
       [762,]    2  8.985460e-03 -7.165587e-03  3.000000e+00
       [763,]    3  4.097580e-04 -9.628855e-04  3.000000e+00
       [764,]    4  4.551828e-03 -4.331429e-03  3.000000e+00
       [765,]    5  4.233383e-03  9.704442e-03  3.000000e+00
       [766,]    6  3.712968e-03 -3.424027e-03  3.000000e+00
       [767,]    7 -6.435128e-03 -8.358247e-03  3.000000e+00
       [768,]    8  2.247108e-03 -1.162273e-03  3.000000e+00
       [769,]    9 -5.462135e-03 -8.675614e-03  3.000000e+00
       [770,]   10  3.293965e-03  2.072951e-03  3.000000e+00
       [771,]   11 -4.490885e-03 -9.162508e-03  3.000000e+00
       [772,]   12 -8.725371e-03  6.644969e-03  3.000000e+00
       [773,]   13 -6.322597e-03  8.279636e-03  3.000000e+00
       [774,]   14 -8.105387e-03  6.475584e-03  3.000000e+00
       [775,]   15 -1.007688e-03 -5.512156e-03  3.000000e+00
       [776,]   16 -3.150141e-03 -9.676184e-03  3.000000e+00
       [777,]   17 -1.925376e-03  7.806123e-03  3.000000e+00
       [778,]   18 -2.555597e-03 -8.579418e-03  3.000000e+00
       [779,]   19 -9.070293e-03  4.593259e-03  3.000000e+00
       [780,]    1 -5.763700e-03 -3.850202e-03  4.000000e+00
       [781,]    2 -2.982881e-03 -9.184177e-03  4.000000e+00
       [782,]    3 -2.574160e-03  6.311586e-03  4.000000e+00
       [783,]    4  8.686563e-03 -4.254804e-03  4.000000e+00
       [784,]    5 -9.848439e-03  9.315043e-03  4.000000e+00
       [785,]    6  3.449311e-03 -4.535519e-03  4.000000e+00
       [786,]    7  9.529410e-03  6.081369e-03  4.000000e+00
       [787,]    8 -1.064547e-03  1.853454e-03  4.000000e+00
       [788,]    9 -2.907655e-03  8.991241e-04  4.000000e+00
       [789,]   10 -5.688085e-03  5.268209e-04  4.000000e+00
       [790,]   11  6.285495e-04 -5.087112e-03  4.000000e+00
       [791,]   12  7.942543e-03  7.262772e-03  4.000000e+00
       [792,]   13 -1.633781e-03 -3.258660e-05  4.000000e+00
       [793,]   14 -1.674250e-03 -9.392286e-03  4.000000e+00
       [794,]   15 -4.115065e-03 -4.593376e-03  4.000000e+00
       [795,]   16 -9.071850e-03  8.775854e-03  4.000000e+00
       [796,]   17 -4.476072e-03  9.525211e-03  4.000000e+00
       [797,]   18 -4.362249e-03 -7.117281e-03  4.000000e+00
       [798,]   19 -7.709954e-03 -7.116165e-03  4.000000e+00
       [799,]    1  1.286927e-03  6.445600e-03  5.000000e+00
       [800,]    2 -6.748801e-03 -3.241670e-03  5.000000e+00
       [801,]    3  8.714049e-03  1.389663e-03  5.000000e+00
       [802,]    4 -7.074642e-03  4.685740e-03  5.000000e+00
       [803,]    5  2.262060e-04 -9.691459e-03  5.000000e+00
       [804,]    6  8.540175e-03  6.533400e-03  5.000000e+00
       [805,]    7  4.391507e-03  7.857337e-03  5.000000e+00
       [806,]    8 -3.258226e-03 -7.700537e-03  5.000000e+00
       [807,]    9 -6.355804e-03 -1.674967e-03  5.000000e+00
       [808,]   10  6.717720e-04 -5.128532e-03  5.000000e+00
       [809,]   11  5.732965e-03  4.440519e-03  5.000000e+00
       [810,]   12  4.514764e-03 -7.773411e-03  5.000000e+00
       [811,]   13  7.419920e-03  2.096658e-04  5.000000e+00
       [812,]   14 -8.134186e-03  5.080020e-03  5.000000e+00
       [813,]   15 -9.019127e-03 -2.795926e-03  5.000000e+00
       [814,]   16 -9.823309e-03 -4.780042e-03  5.000000e+00
       [815,]   17  5.616457e-03 -9.682544e-03  5.000000e+00
       [816,]   18 -6.146755e-03 -3.445824e-03  5.000000e+00
       [817,]   19 -6.650175e-03  5.922832e-03  5.000000e+00
       [818,]    1 -9.554635e-03  8.645966e-03  6.000000e+00
       [819,]    2  4.004368e-03  6.193722e-03  6.000000e+00
       [820,]    3 -7.712714e-03  4.660381e-05  6.000000e+00
       [821,]    4 -5.822632e-03 -7.860417e-03  6.000000e+00
       [822,]    5  1.486424e-03 -3.582723e-03  6.000000e+00
       [823,]    6  5.298339e-03  2.575250e-03  6.000000e+00
       [824,]    7  8.833526e-03 -9.488283e-03  6.000000e+00
       [825,]    8  5.869920e-04  7.250967e-03  6.000000e+00
       [826,]    9  9.034928e-03  3.042973e-03  6.000000e+00
       [827,]   10  1.513114e-03 -9.605569e-03  6.000000e+00
       [828,]   11  2.376040e-04 -7.972887e-03  6.000000e+00
       [829,]   12 -8.853108e-03 -5.946616e-03  6.000000e+00
       [830,]   13 -8.813045e-03 -5.872209e-04  6.000000e+00
       [831,]   14  1.719215e-03  5.504098e-03  6.000000e+00
       [832,]   15  1.552236e-03  9.472254e-03  6.000000e+00
       [833,]   16  6.137658e-03  2.302139e-03  6.000000e+00
       [834,]   17 -6.915009e-04  1.697338e-03  6.000000e+00
       [835,]   18 -8.166510e-03  5.563087e-03  6.000000e+00
       [836,]   19 -1.235666e-03  9.682675e-03  6.000000e+00
       [837,]    1  4.000082e-03 -1.289777e-03  7.000000e+00
       [838,]    2  8.445860e-03  8.344922e-04  7.000000e+00
       [839,]    3  9.784399e-03 -6.287432e-03  7.000000e+00
       [840,]    4 -3.236113e-03  8.275214e-03  7.000000e+00
       [841,]    5 -7.184847e-03 -5.447121e-03  7.000000e+00
       [842,]    6 -2.125272e-04 -5.838640e-03  7.000000e+00
       [843,]    7  9.510528e-04 -5.087534e-03  7.000000e+00
       [844,]    8 -6.149931e-03  1.867296e-03  7.000000e+00
       [845,]    9  8.533286e-03  3.663539e-03  7.000000e+00
       [846,]   10 -9.165481e-03 -1.420587e-03  7.000000e+00
       [847,]   11  2.448954e-04  3.998778e-03  7.000000e+00
       [848,]   12 -6.633185e-03  3.171687e-03  7.000000e+00
       [849,]   13  3.987675e-03  2.337343e-03  7.000000e+00
       [850,]   14 -5.163624e-03 -1.496653e-03  7.000000e+00
       [851,]   15 -3.031251e-03 -5.078258e-04  7.000000e+00
       [852,]   16  6.497661e-03  3.676716e-03  7.000000e+00
       [853,]   17  8.136805e-03  4.616407e-04  7.000000e+00
       [854,]   18  8.154363e-03  2.220221e-03  7.000000e+00
       [855,]   19 -8.196508e-03  9.857499e-03  7.000000e+00
       [856,]    1  5.812320e-03 -3.873539e-03  8.000000e+00
       [857,]    2  3.562204e-03 -3.518858e-03  8.000000e+00
       [858,]    3  7.650516e-04  6.436117e-03  8.000000e+00
       [859,]    4  2.673335e-03 -8.406609e-03  8.000000e+00
       [860,]    5  6.287795e-03  2.875807e-03  8.000000e+00
       [861,]    6 -2.225308e-03  8.902648e-03  8.000000e+00
       [862,]    7 -2.982172e-04 -6.466980e-03  8.000000e+00
       [863,]    8  9.779100e-03  3.742636e-03  8.000000e+00
       [864,]    9 -3.601581e-03 -4.872791e-03  8.000000e+00
       [865,]   10  4.245169e-04  1.976942e-03  8.000000e+00
       [866,]   11  5.179446e-04 -5.100682e-03  8.000000e+00
       [867,]   12 -3.371931e-03 -9.214798e-03  8.000000e+00
       [868,]   13  7.307133e-03  9.103602e-03  8.000000e+00
       [869,]   14  1.239392e-03  2.421462e-04  8.000000e+00
       [870,]   15 -6.748496e-03 -9.801878e-03  8.000000e+00
       [871,]   16  6.379511e-03 -9.476231e-03  8.000000e+00
       [872,]   17 -6.931970e-03 -7.108889e-03  8.000000e+00
       [873,]   18  5.017025e-03 -4.505534e-03  8.000000e+00
       [874,]   19 -9.818783e-03  1.157651e-03  8.000000e+00
       [875,]    1 -5.874048e-03 -6.084779e-03  9.000000e+00
       [876,]    2  1.512240e-03 -2.187737e-03  9.000000e+00
       [877,]    3  3.394280e-03  9.850058e-03  9.000000e+00
       [878,]    4  4.305433e-03 -1.949961e-03  9.000000e+00
       [879,]    5  7.690804e-03 -2.305933e-03  9.000000e+00
       [880,]    6  6.589502e-03 -2.512495e-03  9.000000e+00
       [881,]    7  4.838586e-03  8.622402e-03  9.000000e+00
       [882,]    8 -1.372597e-03 -9.354250e-03  9.000000e+00
       [883,]    9 -6.518811e-03 -3.013847e-03  9.000000e+00
       [884,]   10  5.882660e-03  5.657258e-03  9.000000e+00
       [885,]   11 -5.366790e-04 -5.114647e-03  9.000000e+00
       [886,]   12 -3.092654e-03 -6.323639e-03  9.000000e+00
       [887,]   13  5.140159e-04  5.179015e-03  9.000000e+00
       [888,]   14 -3.634252e-03 -8.788781e-03  9.000000e+00
       [889,]   15 -2.981277e-03 -5.075042e-03  9.000000e+00
       [890,]   16 -2.896646e-03  5.535010e-03  9.000000e+00
       [891,]   17  5.308863e-03  2.452438e-03  9.000000e+00
       [892,]   18 -8.689029e-03 -6.840791e-03  9.000000e+00
       [893,]   19 -9.167320e-03  7.717563e-03  9.000000e+00
       [894,]    1  3.931284e-03  5.453047e-03  1.000000e+01
       [895,]    2 -5.279978e-03 -6.733362e-03  1.000000e+01
       [896,]    3  7.077328e-03 -8.357410e-04  1.000000e+01
       [897,]    4  9.123115e-03 -1.710021e-03  1.000000e+01
       [898,]    5  1.473288e-03  6.088802e-03  1.000000e+01
       [899,]    6 -4.840937e-03 -2.151158e-03  1.000000e+01
       [900,]    7  6.399104e-03 -5.979491e-03  1.000000e+01
       [901,]    8  1.080366e-03  9.157594e-03  1.000000e+01
       [902,]    9  1.347608e-03 -8.561134e-03  1.000000e+01
       [903,]   10 -7.554982e-03  6.957487e-03  1.000000e+01
       [904,]   11  1.321466e-03 -7.411872e-03  1.000000e+01
       [905,]   12  8.054156e-03  2.746896e-03  1.000000e+01
       [906,]   13  8.719519e-03  5.895595e-03  1.000000e+01
       [907,]   14 -7.171825e-03  1.614242e-03  1.000000e+01
       [908,]   15 -9.981364e-03  7.309903e-03  1.000000e+01
       [909,]   16 -3.491967e-03 -6.948164e-03  1.000000e+01
       [910,]   17  2.808849e-03 -1.614583e-04  1.000000e+01
       [911,]   18 -1.816505e-03  9.570532e-03  1.000000e+01
       [912,]   19 -4.576255e-03 -1.540560e-03  1.000000e+01
       [913,]    1  2.940296e-03 -1.409976e-03  1.100000e+01
       [914,]    2 -2.042753e-03  4.135519e-03  1.100000e+01
       [915,]    3  2.014485e-03 -8.647533e-03  1.100000e+01
       [916,]    4 -3.109244e-04 -4.226677e-03  1.100000e+01
       [917,]    5 -9.413132e-03 -7.816017e-03  1.100000e+01
       [918,]    6 -1.159424e-03  2.799404e-03  1.100000e+01
       [919,]    7 -7.078115e-03  3.980306e-03  1.100000e+01
       [920,]    8 -5.946151e-03  9.243910e-03  1.100000e+01
       [921,]    9 -3.662705e-03 -1.359738e-03  1.100000e+01
       [922,]   10  3.111694e-03 -8.441544e-03  1.100000e+01
       [923,]   11 -4.900500e-03  1.984362e-03  1.100000e+01
       [924,]   12  9.552674e-03  7.486333e-04  1.100000e+01
       [925,]   13 -6.688013e-03 -8.279233e-03  1.100000e+01
       [926,]   14  6.512355e-03 -1.418685e-03  1.100000e+01
       [927,]   15 -3.237023e-03 -5.049577e-03  1.100000e+01
       [928,]   16  8.282975e-03 -5.681297e-03  1.100000e+01
       [929,]   17  7.209921e-04 -3.985817e-03  1.100000e+01
       [930,]   18 -2.837206e-03  9.406889e-03  1.100000e+01
       [931,]   19  4.983364e-03 -4.154329e-03  1.100000e+01
       [932,]    1 -3.910774e-03 -8.639858e-03  1.200000e+01
       [933,]    2 -4.580598e-03 -6.967895e-03  1.200000e+01
       [934,]    3 -4.403638e-03 -2.803306e-03  1.200000e+01
       [935,]    4  8.420307e-03  2.519248e-03  1.200000e+01
       [936,]    5  4.127130e-03  2.122425e-03  1.200000e+01
       [937,]    6 -3.450323e-03 -2.455132e-03  1.200000e+01
       [938,]    7 -4.350478e-03  5.653542e-03  1.200000e+01
       [939,]    8  1.994778e-03 -3.218158e-03  1.200000e+01
       [940,]    9 -3.354611e-03  9.075990e-03  1.200000e+01
       [941,]   10  3.430081e-03 -3.202968e-03  1.200000e+01
       [942,]   11  1.721891e-03  4.764860e-03  1.200000e+01
       [943,]   12  2.745099e-03  5.969527e-03  1.200000e+01
       [944,]   13  9.035865e-03 -5.585678e-03  1.200000e+01
       [945,]   14 -9.789998e-03  6.308012e-03  1.200000e+01
       [946,]   15  4.314451e-03  3.077230e-03  1.200000e+01
       [947,]   16  5.781924e-03  1.063397e-03  1.200000e+01
       [948,]   17 -9.247128e-03 -8.824437e-03  1.200000e+01
       [949,]   18  3.004085e-03  9.958072e-03  1.200000e+01
       [950,]   19 -6.495059e-03  5.347251e-03  1.200000e+01
       [951,]    1 -5.381749e-03 -9.216413e-03  1.300000e+01
       [952,]    2  9.481161e-03  3.095653e-03  1.300000e+01
       [953,]    3 -8.615913e-04 -2.540502e-03  1.300000e+01
       [954,]    4 -2.377270e-03 -1.408885e-03  1.300000e+01
       [955,]    5  7.143187e-03 -8.940538e-03  1.300000e+01
       [956,]    6  4.474088e-03 -7.733078e-03  1.300000e+01
       [957,]    7 -4.565370e-03 -1.080300e-03  1.300000e+01
       [958,]    8 -5.532324e-03 -4.638185e-03  1.300000e+01
       [959,]    9  8.542073e-03  8.206346e-03  1.300000e+01
       [960,]   10 -4.923809e-03 -1.769196e-03  1.300000e+01
       [961,]   11 -9.385138e-03  8.255013e-03  1.300000e+01
       [962,]   12  7.869331e-03 -3.128339e-03  1.300000e+01
       [963,]   13  7.478183e-03 -9.684493e-03  1.300000e+01
       [964,]   14  6.923126e-03 -8.186804e-03  1.300000e+01
       [965,]   15 -7.258004e-03  6.693559e-03  1.300000e+01
       [966,]   16  5.689571e-04 -3.489531e-03  1.300000e+01
       [967,]   17 -6.031020e-03 -3.882416e-03  1.300000e+01
       [968,]   18  3.744710e-03  8.757870e-03  1.300000e+01
       [969,]   19 -9.505959e-03  9.279483e-03  1.300000e+01
       [970,]    1  1.667596e-03  1.223762e-03  1.400000e+01
       [971,]    2  3.049548e-03  1.485729e-03  1.400000e+01
       [972,]    3 -1.067758e-03  5.949317e-03  1.400000e+01
       [973,]    4  4.213350e-03  9.125816e-03  1.400000e+01
       [974,]    5  4.259946e-04 -1.054889e-03  1.400000e+01
       [975,]    6 -2.642664e-03 -7.680132e-03  1.400000e+01
       [976,]    7 -2.672755e-03 -2.915463e-03  1.400000e+01
       [977,]    8 -2.161764e-03 -2.635669e-03  1.400000e+01
       [978,]    9 -7.055329e-04 -9.820721e-03  1.400000e+01
       [979,]   10  7.882656e-03 -8.157084e-04  1.400000e+01
       [980,]   11 -7.846106e-03  2.186006e-03  1.400000e+01
       [981,]   12  5.106194e-03 -3.251622e-03  1.400000e+01
       [982,]   13  3.142532e-03 -5.713845e-03  1.400000e+01
       [983,]   14  7.729546e-03 -2.793081e-04  1.400000e+01
       [984,]   15  1.140734e-03 -4.327633e-03  1.400000e+01
       [985,]   16 -1.028122e-03  4.741352e-03  1.400000e+01
       [986,]   17 -2.059145e-03  1.885938e-03  1.400000e+01
       [987,]   18  2.542499e-03 -3.451249e-03  1.400000e+01
       [988,]   19  9.824530e-03 -6.993391e-03  1.400000e+01
       [989,]    1 -4.326560e-03 -7.718900e-03  1.500000e+01
       [990,]    2 -7.069937e-03  7.360661e-03  1.500000e+01
       [991,]    3  6.744249e-03  6.606866e-03  1.500000e+01
       [992,]    4  6.385719e-03 -8.793804e-03  1.500000e+01
       [993,]    5 -8.560330e-03 -5.162275e-03  1.500000e+01
       [994,]    6 -4.555045e-03 -5.239813e-05  1.500000e+01
       [995,]    7 -3.590747e-03 -4.841632e-03  1.500000e+01
       [996,]    8 -2.330865e-03 -5.056016e-03  1.500000e+01
       [997,]    9  8.995599e-03  7.263755e-03  1.500000e+01
       [998,]   10 -7.052011e-03 -4.569031e-03  1.500000e+01
       [999,]   11 -1.849110e-03 -3.602879e-03  1.500000e+01
      [1000,]   12  9.529030e-03 -8.699647e-03  1.500000e+01
      [1001,]   13 -2.324956e-03  2.894494e-03  1.500000e+01
      [1002,]   14  8.322114e-03 -1.963420e-03  1.500000e+01
      [1003,]   15  5.364062e-03 -3.712807e-03  1.500000e+01
      [1004,]   16 -4.096979e-03 -8.050273e-03  1.500000e+01
      [1005,]   17 -3.171743e-03 -8.306714e-03  1.500000e+01
      [1006,]   18  9.358666e-03  4.756304e-03  1.500000e+01
      [1007,]   19 -3.487062e-03 -7.564647e-03  1.500000e+01
      [1008,]    1  7.407524e-03 -7.866492e-03  1.600000e+01
      [1009,]    2 -2.627803e-03  3.542760e-04  1.600000e+01
      [1010,]    3  6.942147e-03 -8.711816e-03  1.600000e+01
      [1011,]    4 -7.253408e-03 -7.264634e-03  1.600000e+01
      [1012,]    5 -3.078553e-03  8.357271e-03  1.600000e+01
      [1013,]    6  1.482361e-03  4.783867e-03  1.600000e+01
      [1014,]    7  7.657368e-03  8.878954e-04  1.600000e+01
      [1015,]    8  6.482359e-04 -1.933725e-03  1.600000e+01
      [1016,]    9 -2.431773e-03 -5.034137e-03  1.600000e+01
      [1017,]   10  7.355621e-03 -3.957190e-03  1.600000e+01
      [1018,]   11  4.613107e-03  7.707181e-03  1.600000e+01
      [1019,]   12  9.251895e-04  7.641485e-03  1.600000e+01
      [1020,]   13 -9.632923e-03 -7.491183e-03  1.600000e+01
      [1021,]   14  9.796800e-03  7.092813e-03  1.600000e+01
      [1022,]   15 -4.468537e-03  8.326733e-03  1.600000e+01
      [1023,]   16 -5.146439e-03 -4.182301e-04  1.600000e+01
      [1024,]   17 -8.415018e-03  1.115827e-03  1.600000e+01
      [1025,]   18 -3.479052e-03 -4.356257e-03  1.600000e+01
      [1026,]   19 -5.135343e-03  2.394962e-03  1.600000e+01
      [1027,]    1 -5.010306e-03  5.633653e-03  1.700000e+01
      [1028,]    2  3.151718e-03  9.020756e-03  1.700000e+01
      [1029,]    3 -8.262731e-03 -5.608304e-03  1.700000e+01
      [1030,]    4  2.531016e-03 -4.895467e-03  1.700000e+01
      [1031,]    5  2.602438e-03  4.535393e-03  1.700000e+01
      [1032,]    6  9.044111e-03 -6.288449e-03  1.700000e+01
      [1033,]    7  4.684313e-03  1.665559e-03  1.700000e+01
      [1034,]    8 -7.557259e-03  4.812689e-03  1.700000e+01
      [1035,]    9 -2.431863e-04 -9.612995e-03  1.700000e+01
      [1036,]   10 -4.393885e-03  1.882406e-03  1.700000e+01
      [1037,]   11  7.451536e-03  5.271580e-03  1.700000e+01
      [1038,]   12 -4.198826e-03 -1.381880e-03  1.700000e+01
      [1039,]   13  7.317580e-03 -8.922816e-03  1.700000e+01
      [1040,]   14 -9.767762e-03 -7.841364e-04  1.700000e+01
      [1041,]   15 -6.788523e-03  7.738347e-03  1.700000e+01
      [1042,]   16  3.531948e-03 -1.723580e-03  1.700000e+01
      [1043,]   17 -3.387178e-04 -7.649831e-03  1.700000e+01
      [1044,]   18 -6.028725e-03 -5.096080e-03  1.700000e+01
      [1045,]   19 -6.227400e-03  4.593129e-03  1.700000e+01
      [1046,]    1  8.353503e-03  9.073793e-03  1.800000e+01
      [1047,]    2 -4.699259e-03  4.673516e-03  1.800000e+01
      [1048,]    3 -4.500101e-03  1.626416e-04  1.800000e+01
      [1049,]    4 -7.011487e-03 -4.158739e-03  1.800000e+01
      [1050,]    5 -3.464040e-03  9.809232e-03  1.800000e+01
      [1051,]    6  1.603357e-04  5.209924e-03  1.800000e+01
      [1052,]    7  2.301342e-03 -3.689977e-03  1.800000e+01
      [1053,]    8  6.156976e-04  5.527994e-03  1.800000e+01
      [1054,]    9 -7.148553e-03  6.395740e-03  1.800000e+01
      [1055,]   10  2.520839e-03 -4.690562e-03  1.800000e+01
      [1056,]   11 -7.763222e-03 -4.518627e-03  1.800000e+01
      [1057,]   12 -2.533444e-03 -9.113898e-03  1.800000e+01
      [1058,]   13 -4.673325e-04 -7.069085e-03  1.800000e+01
      [1059,]   14 -2.429596e-03 -4.351422e-03  1.800000e+01
      [1060,]   15 -6.748403e-03  3.236525e-03  1.800000e+01
      [1061,]   16 -7.804871e-03 -8.207616e-03  1.800000e+01
      [1062,]   17 -7.632923e-04  6.098116e-03  1.800000e+01
      [1063,]   18 -6.445040e-03  2.451669e-03  1.800000e+01
      [1064,]   19  5.639877e-03  7.534431e-03  1.800000e+01
      [1065,]    1 -3.647773e-03  2.300209e-03  1.900000e+01
      [1066,]    2  9.366414e-04  9.021642e-03  1.900000e+01
      [1067,]    3 -6.862168e-03  6.291184e-03  1.900000e+01
      [1068,]    4  6.184344e-03  3.525849e-03  1.900000e+01
      [1069,]    5  7.997041e-03  2.920074e-03  1.900000e+01
      [1070,]    6  5.541200e-03  9.627113e-03  1.900000e+01
      [1071,]    7 -7.917141e-03  4.440214e-03  1.900000e+01
      [1072,]    8  5.493196e-03  6.856570e-03  1.900000e+01
      [1073,]    9 -3.972135e-03  6.863346e-03  1.900000e+01
      [1074,]   10  6.362566e-03  3.933188e-03  1.900000e+01
      [1075,]   11 -5.769056e-03 -9.401240e-03  1.900000e+01
      [1076,]   12 -6.404215e-03 -3.715431e-03  1.900000e+01
      [1077,]   13 -1.227431e-03  9.443103e-03  1.900000e+01
      [1078,]   14  8.999379e-03  3.066979e-03  1.900000e+01
      [1079,]   15  9.045837e-03 -8.528359e-03  1.900000e+01
      [1080,]   16  6.109681e-03  2.645094e-03  1.900000e+01
      [1081,]   17 -1.757850e-03 -1.286436e-03  1.900000e+01
      [1082,]   18 -3.460761e-03 -2.285188e-03  1.900000e+01
      [1083,]   19 -8.035493e-03 -5.670197e-03  1.900000e+01
      
      $n
      [1] 1083
      

# one_grid_bkg() works

    Code
      one_grid_bkg(n_value = 10, num_noise = 2, min_n = -0.05, max_n = 0.05)
    Output
      $df
                   [,1]        [,2]         [,3]          [,4]
        [1,]  1.0000000  1.00000000 -0.040620890  0.0494111540
        [2,]  2.0000000  1.00000000 -0.006958216  0.0095421034
        [3,]  3.0000000  1.00000000  0.023961491  0.0095423958
        [4,]  4.0000000  1.00000000  0.014336807  0.0056648134
        [5,]  5.0000000  1.00000000  0.040183118  0.0361641475
        [6,]  6.0000000  1.00000000 -0.030828246  0.0137938427
        [7,]  7.0000000  1.00000000 -0.040057099 -0.0227676261
        [8,]  8.0000000  1.00000000  0.003444101 -0.0486252397
        [9,]  9.0000000  1.00000000 -0.014709934  0.0374798555
       [10,] 10.0000000  1.00000000 -0.005895188  0.0060145900
       [11,]  1.0000000  2.00000000  0.006125192 -0.0122375009
       [12,]  2.0000000  2.00000000  0.009199008  0.0151320067
       [13,]  3.0000000  2.00000000  0.043725434  0.0069745122
       [14,]  4.0000000  2.00000000  0.032775383 -0.0119806817
       [15,]  5.0000000  2.00000000 -0.015198423 -0.0425165671
       [16,]  6.0000000  2.00000000 -0.009840486  0.0198855986
       [17,]  7.0000000  2.00000000  0.017884363 -0.0341541310
       [18,]  8.0000000  2.00000000  0.003128339 -0.0139019090
       [19,]  9.0000000  2.00000000 -0.049855517 -0.0043720318
       [20,] 10.0000000  2.00000000 -0.042550838  0.0362611223
       [21,]  1.0000000  3.00000000 -0.014135695  0.0091411981
       [22,]  2.0000000  3.00000000 -0.039919336 -0.0375122381
       [23,]  3.0000000  3.00000000  0.000868859  0.0205436346
       [24,]  4.0000000  3.00000000  0.046917972 -0.0096704798
       [25,]  5.0000000  3.00000000 -0.010018197  0.0074246488
       [26,]  6.0000000  3.00000000 -0.041176753  0.0395226781
       [27,]  7.0000000  3.00000000  0.002883964 -0.0140160184
       [28,]  8.0000000  3.00000000  0.043384065 -0.0001349537
       [29,]  9.0000000  3.00000000  0.019484127 -0.0395929786
       [30,] 10.0000000  3.00000000 -0.015735495  0.0421812224
       [31,]  1.0000000  4.00000000 -0.014806867  0.0192060802
       [32,]  2.0000000  4.00000000  0.034943412 -0.0329963851
       [33,]  3.0000000  4.00000000  0.012234167  0.0441801412
       [34,]  4.0000000  4.00000000  0.040322342 -0.0359260298
       [35,]  5.0000000  4.00000000 -0.013342465  0.0215506210
       [36,]  6.0000000  4.00000000  0.048743341  0.0231140854
       [37,]  7.0000000  4.00000000 -0.015834825  0.0290469873
       [38,]  8.0000000  4.00000000  0.028985684 -0.0346599014
       [39,]  9.0000000  4.00000000 -0.033649094  0.0245407152
       [40,] 10.0000000  4.00000000  0.034743458 -0.0438232428
       [41,]  1.0000000  5.00000000 -0.040947145 -0.0190370204
       [42,]  2.0000000  5.00000000  0.025659902  0.0157330000
       [43,]  3.0000000  5.00000000  0.034062270 -0.0136145061
       [44,]  4.0000000  5.00000000 -0.001927530  0.0211817049
       [45,]  5.0000000  5.00000000  0.006010157  0.0296529576
       [46,]  6.0000000  5.00000000  0.005157653  0.0385897858
       [47,]  7.0000000  5.00000000  0.040785119  0.0114352393
       [48,]  8.0000000  5.00000000 -0.008590486 -0.0394679684
       [49,]  9.0000000  5.00000000 -0.013594900  0.0379028531
       [50,] 10.0000000  5.00000000 -0.008194703 -0.0086608654
       [51,]  1.0000000  6.00000000 -0.014514506 -0.0397832549
       [52,]  2.0000000  6.00000000 -0.042610457  0.0389684510
       [53,]  3.0000000  6.00000000 -0.004394658  0.0107839450
       [54,]  4.0000000  6.00000000  0.031400799 -0.0229901668
       [55,]  5.0000000  6.00000000 -0.005396931  0.0032016000
       [56,]  6.0000000  6.00000000 -0.041821771  0.0188916723
       [57,]  7.0000000  6.00000000  0.031016598  0.0406173033
       [58,]  8.0000000  6.00000000 -0.038376223 -0.0218278701
       [59,]  9.0000000  6.00000000 -0.039518429  0.0178925602
       [60,] 10.0000000  6.00000000 -0.048856669 -0.0418970450
       [61,]  1.0000000  7.00000000  0.007757624  0.0289520095
       [62,]  2.0000000  7.00000000  0.035364025 -0.0182308341
       [63,]  3.0000000  7.00000000  0.031473265 -0.0420673159
       [64,]  4.0000000  7.00000000  0.034647305  0.0215416480
       [65,]  5.0000000  7.00000000 -0.014155501  0.0032879685
       [66,]  6.0000000  7.00000000 -0.013249423 -0.0136172979
       [67,]  7.0000000  7.00000000 -0.024790063  0.0128606171
       [68,]  8.0000000  7.00000000 -0.044271391 -0.0406865353
       [69,]  9.0000000  7.00000000 -0.010676471  0.0056567913
       [70,] 10.0000000  7.00000000  0.043851697 -0.0206802091
       [71,]  1.0000000  8.00000000  0.016443681 -0.0293639539
       [72,]  2.0000000  8.00000000 -0.021509732 -0.0099463716
       [73,]  3.0000000  8.00000000  0.008581070 -0.0216768384
       [74,]  4.0000000  8.00000000 -0.025245797 -0.0126717287
       [75,]  5.0000000  8.00000000 -0.034141930 -0.0137911398
       [76,]  6.0000000  8.00000000 -0.040357834  0.0201560635
       [77,]  7.0000000  8.00000000 -0.020771534  0.0474466317
       [78,]  8.0000000  8.00000000  0.040356428 -0.0034467781
       [79,]  9.0000000  8.00000000  0.030966772  0.0451321898
       [80,] 10.0000000  8.00000000  0.029159332 -0.0449525188
       [81,]  1.0000000  9.00000000  0.023592625 -0.0301143471
       [82,]  2.0000000  9.00000000  0.038851087 -0.0015380326
       [83,]  3.0000000  9.00000000  0.039433618 -0.0313923658
       [84,]  4.0000000  9.00000000 -0.024846803 -0.0142799772
       [85,]  5.0000000  9.00000000 -0.047168665  0.0342363236
       [86,]  6.0000000  9.00000000 -0.035636917  0.0437694831
       [87,]  7.0000000  9.00000000 -0.039748340 -0.0163590239
       [88,]  8.0000000  9.00000000  0.032319008 -0.0215670073
       [89,]  9.0000000  9.00000000  0.039741895 -0.0312772650
       [90,] 10.0000000  9.00000000 -0.014166147 -0.0404797181
       [91,]  1.0000000 10.00000000 -0.029024773 -0.0197967365
       [92,]  2.0000000 10.00000000 -0.002584811  0.0082434738
       [93,]  3.0000000 10.00000000  0.007053171 -0.0110442976
       [94,]  4.0000000 10.00000000  0.003947746 -0.0086618911
       [95,]  5.0000000 10.00000000 -0.036401528 -0.0378016111
       [96,]  6.0000000 10.00000000  0.031450933 -0.0267662517
       [97,]  7.0000000 10.00000000 -0.012927440 -0.0202962862
       [98,]  8.0000000 10.00000000  0.015580769  0.0326327926
       [99,]  9.0000000 10.00000000 -0.025986426  0.0398299208
      [100,] 10.0000000 10.00000000  0.038668635 -0.0465680600
      [101,] -3.5612581 -1.79436411  3.122742227  1.2556672678
      [102,]  5.6853836  6.26338301 -0.128357628 -0.8355840128
      [103,]  2.5885781 -7.76538284 -6.094032182  4.5999382238
      [104,]  1.2695727  2.11762085  3.821268298  3.4361362053
      [105,] 10.4022259 -0.36079756 -1.222037101  1.0217485367
      [106,] -1.3190362 -1.15389394  1.169996504  2.7294938096
      [107,]  4.6830838  1.60813678 -0.622106142  6.1776911578
      [108,]  4.4129084  1.34376301 -0.335921190  0.5286207180
      [109,]  1.8217498  0.01702395  1.651024899  1.4031616764
      [110,]  3.4398605  3.81440739  3.044281028 -0.3954430253
      [111,] -1.0844604  3.21979646  2.530406087 -0.3047628099
      [112,]  4.6259543  3.64439310  3.036989915  1.6092073857
      [113,] -1.6567474  4.96145779  1.901469256  0.4028964059
      [114,]  2.4185407  6.85984608  4.528986324  2.2151197942
      [115,] -0.4860154  0.75465284  0.028174862  3.2690275209
      [116,]  2.4877047  3.39764041  7.663975920  0.3985469989
      [117,]  4.0318778  2.28198767  4.946816686  0.6695505339
      [118,]  5.1616871  2.48137806  3.431030067  4.6664171676
      [119,]  5.0366824 -2.50672357 -1.955443492  4.1179657574
      [120,]  7.0568866  5.23987458  2.335759870 -0.7186872081
      [121,]  1.8305108 -6.05735225  2.498653737  0.9000801365
      [122,] -1.3940364  0.78152962 -2.574013163 -3.6631121406
      [123,]  0.6846337  6.16429047  5.014887481  5.3255158816
      [124,]  7.4204685  0.89717967  1.437600335  2.5931792775
      [125,]  2.2088006  1.61905966 -2.376048174 -0.9058616254
      [126,]  1.8901933  2.05420440 -2.813511959  2.1106551899
      [127,]  2.5255063 -1.02600030  1.050519083 -1.1352321905
      [128,]  5.4407412  1.86721577  2.228889187  4.1790424373
      [129,] -1.4986939  0.81422310  1.290247040 -1.2345596633
      [130,]  0.9101129  1.94706596  1.460516406 -4.7277885598
      [131,] -3.1504430  4.60132393  2.258334870  2.3691726025
      [132,]  3.7682518  5.04019243  0.305995520  1.3385726958
      [133,]  1.4358087  2.18106931 -0.808377542  3.5902813738
      [134,]  5.1823120 -2.41915308  2.683375148 -0.5553926408
      [135,]  0.3198517 -3.60995287  1.466390611  6.4053037836
      [136,]  8.7839898 -1.31016498  4.086315563  1.4963641594
      [137,]  6.9231865 -0.40014646  4.113248971 -0.5080863063
      [138,]  1.6966844 -2.59008786 -2.612889610  2.8754590172
      [139,]  4.8582021 -0.43378439  2.335268349  5.1043591659
      [140,]  5.2503787  0.47124538  7.462257312  2.8438730373
      [141,] -1.3276402  1.26168562 -0.119690599  1.8705405152
      [142,] -1.1887072  5.32945754  6.874520420  2.7190570618
      [143,]  0.1929271  1.59362742  1.072434830  5.3952068143
      [144,]  2.2617120  2.46032497  4.946148297  0.9375190943
      [145,] -0.7389539  3.46833243  1.183913470  0.9301514244
      [146,] -6.6429775 -2.20262710  7.344185347  0.9749847306
      [147,]  1.5563893  2.83593267  3.598794013  1.0910872952
      [148,] -0.2505004 -0.58117030  3.716947219  1.7131579110
      [149,]  0.5917958  1.69344165  2.389084243  2.2743234636
      [150,]  7.7087324  4.94979141 -2.593073887 -0.1051796509
      
      $n
      [1] 150
      

---

    Code
      one_grid_bkg(n_value = 10, num_noise = 0)
    Output
      $df
                   [,1]        [,2]
        [1,]  1.0000000  1.00000000
        [2,]  2.0000000  1.00000000
        [3,]  3.0000000  1.00000000
        [4,]  4.0000000  1.00000000
        [5,]  5.0000000  1.00000000
        [6,]  6.0000000  1.00000000
        [7,]  7.0000000  1.00000000
        [8,]  8.0000000  1.00000000
        [9,]  9.0000000  1.00000000
       [10,] 10.0000000  1.00000000
       [11,]  1.0000000  2.00000000
       [12,]  2.0000000  2.00000000
       [13,]  3.0000000  2.00000000
       [14,]  4.0000000  2.00000000
       [15,]  5.0000000  2.00000000
       [16,]  6.0000000  2.00000000
       [17,]  7.0000000  2.00000000
       [18,]  8.0000000  2.00000000
       [19,]  9.0000000  2.00000000
       [20,] 10.0000000  2.00000000
       [21,]  1.0000000  3.00000000
       [22,]  2.0000000  3.00000000
       [23,]  3.0000000  3.00000000
       [24,]  4.0000000  3.00000000
       [25,]  5.0000000  3.00000000
       [26,]  6.0000000  3.00000000
       [27,]  7.0000000  3.00000000
       [28,]  8.0000000  3.00000000
       [29,]  9.0000000  3.00000000
       [30,] 10.0000000  3.00000000
       [31,]  1.0000000  4.00000000
       [32,]  2.0000000  4.00000000
       [33,]  3.0000000  4.00000000
       [34,]  4.0000000  4.00000000
       [35,]  5.0000000  4.00000000
       [36,]  6.0000000  4.00000000
       [37,]  7.0000000  4.00000000
       [38,]  8.0000000  4.00000000
       [39,]  9.0000000  4.00000000
       [40,] 10.0000000  4.00000000
       [41,]  1.0000000  5.00000000
       [42,]  2.0000000  5.00000000
       [43,]  3.0000000  5.00000000
       [44,]  4.0000000  5.00000000
       [45,]  5.0000000  5.00000000
       [46,]  6.0000000  5.00000000
       [47,]  7.0000000  5.00000000
       [48,]  8.0000000  5.00000000
       [49,]  9.0000000  5.00000000
       [50,] 10.0000000  5.00000000
       [51,]  1.0000000  6.00000000
       [52,]  2.0000000  6.00000000
       [53,]  3.0000000  6.00000000
       [54,]  4.0000000  6.00000000
       [55,]  5.0000000  6.00000000
       [56,]  6.0000000  6.00000000
       [57,]  7.0000000  6.00000000
       [58,]  8.0000000  6.00000000
       [59,]  9.0000000  6.00000000
       [60,] 10.0000000  6.00000000
       [61,]  1.0000000  7.00000000
       [62,]  2.0000000  7.00000000
       [63,]  3.0000000  7.00000000
       [64,]  4.0000000  7.00000000
       [65,]  5.0000000  7.00000000
       [66,]  6.0000000  7.00000000
       [67,]  7.0000000  7.00000000
       [68,]  8.0000000  7.00000000
       [69,]  9.0000000  7.00000000
       [70,] 10.0000000  7.00000000
       [71,]  1.0000000  8.00000000
       [72,]  2.0000000  8.00000000
       [73,]  3.0000000  8.00000000
       [74,]  4.0000000  8.00000000
       [75,]  5.0000000  8.00000000
       [76,]  6.0000000  8.00000000
       [77,]  7.0000000  8.00000000
       [78,]  8.0000000  8.00000000
       [79,]  9.0000000  8.00000000
       [80,] 10.0000000  8.00000000
       [81,]  1.0000000  9.00000000
       [82,]  2.0000000  9.00000000
       [83,]  3.0000000  9.00000000
       [84,]  4.0000000  9.00000000
       [85,]  5.0000000  9.00000000
       [86,]  6.0000000  9.00000000
       [87,]  7.0000000  9.00000000
       [88,]  8.0000000  9.00000000
       [89,]  9.0000000  9.00000000
       [90,] 10.0000000  9.00000000
       [91,]  1.0000000 10.00000000
       [92,]  2.0000000 10.00000000
       [93,]  3.0000000 10.00000000
       [94,]  4.0000000 10.00000000
       [95,]  5.0000000 10.00000000
       [96,]  6.0000000 10.00000000
       [97,]  7.0000000 10.00000000
       [98,]  8.0000000 10.00000000
       [99,]  9.0000000 10.00000000
      [100,] 10.0000000 10.00000000
      [101,]  1.4809326 -4.44789271
      [102,]  3.8576381  1.41232611
      [103,]  2.5186223 -2.58375857
      [104,]  4.1983207  0.35970430
      [105,]  2.3145498  4.09823886
      [106,]  4.7384309  4.79145599
      [107,]  5.1441290  4.32158570
      [108,]  2.8145876  3.12283279
      [109,]  7.0614359  2.61006629
      [110,]  2.1314680  2.71254950
      [111,]  7.1286644  5.93042278
      [112,]  3.2201610  0.15800137
      [113,] -4.7446141  3.96653119
      [114,]  4.4336330  3.15352096
      [115,]  3.3584866 -0.35390723
      [116,]  4.7266064  9.45515553
      [117,]  4.8629116  2.54207331
      [118,]  2.1772420 -0.74764227
      [119,]  6.7804181  5.86387434
      [120,]  5.8192155  0.85200094
      [121,]  3.9307506  4.49912721
      [122,] -0.6119001  0.54724797
      [123,]  0.9669287  2.10073093
      [124,]  1.5499871  2.20335238
      [125,]  5.1466956  1.51776070
      [126,]  1.0194603  5.11330709
      [127,]  0.3083810  6.46872865
      [128,]  3.9745281  5.16839569
      [129,]  2.3269049 -0.95527563
      [130,]  1.9605592 -0.02732035
      [131,] -1.1983127  4.09600026
      [132,]  5.8147271  8.83940437
      [133,]  5.4007891  4.00394703
      [134,]  2.1895389 -2.86069677
      [135,]  5.4028244 -1.52371595
      [136,]  4.2670440  1.36451143
      [137,]  4.5884126  3.39813544
      [138,] -0.1621484 -2.60180880
      [139,]  0.2147600 -1.42665910
      [140,]  1.2165205 -1.50808566
      [141,]  8.2166790  7.63431154
      [142,] -0.2957710  1.33605360
      [143,]  2.0334275  4.35829043
      [144,] -0.6874674 -0.77721447
      [145,]  2.0910544  1.73350623
      [146,]  5.2961849 -1.25190844
      [147,]  1.5304213  8.93136890
      [148,]  1.5078837  4.19860976
      [149,] -1.2570489  1.41755617
      [150,] -1.3609518 -2.42812584
      
      $n
      [1] 150
      

# two_grid_comb_bkg() works

    Code
      two_grid_comb_bkg(n_value = 10, num_noise = 2, min_n = -0.05, max_n = 0.05)
    Output
      $df
                    [,1]       [,2]          [,3]          [,4]
        [1,]   1.0000000  1.0000000 -0.0406208903 -0.0468112729
        [2,]   2.0000000  1.0000000 -0.0069582161  0.0124962581
        [3,]   3.0000000  1.0000000  0.0239614908  0.0390363060
        [4,]   4.0000000  1.0000000  0.0143368074 -0.0121142437
        [5,]   5.0000000  1.0000000  0.0401831183  0.0077770323
        [6,]   6.0000000  1.0000000 -0.0308282462  0.0433116644
        [7,]   7.0000000  1.0000000 -0.0400570993 -0.0096181576
        [8,]   8.0000000  1.0000000  0.0034441012 -0.0404465381
        [9,]   9.0000000  1.0000000 -0.0147099345  0.0497450735
       [10,]  10.0000000  1.0000000 -0.0058951876  0.0152653055
       [11,]   1.0000000  2.0000000  0.0061251915 -0.0365711479
       [12,]   2.0000000  2.0000000  0.0091990083 -0.0159191196
       [13,]   3.0000000  2.0000000  0.0437254337  0.0314435686
       [14,]   4.0000000  2.0000000  0.0327753831 -0.0449404774
       [15,]   5.0000000  2.0000000 -0.0151984228  0.0289388946
       [16,]   6.0000000  2.0000000 -0.0098404858 -0.0135954321
       [17,]   7.0000000  2.0000000  0.0178843632 -0.0023689911
       [18,]   8.0000000  2.0000000  0.0031283391  0.0305722723
       [19,]   9.0000000  2.0000000 -0.0498555169  0.0184369768
       [20,]  10.0000000  2.0000000 -0.0425508382 -0.0459533107
       [21,]   1.0000000  3.0000000 -0.0141356953 -0.0348061180
       [22,]   2.0000000  3.0000000 -0.0399193364 -0.0042005939
       [23,]   3.0000000  3.0000000  0.0008688590  0.0309299566
       [24,]   4.0000000  3.0000000  0.0469179725  0.0233263229
       [25,]   5.0000000  3.0000000 -0.0100181968 -0.0388561925
       [26,]   6.0000000  3.0000000 -0.0411767531 -0.0360052565
       [27,]   7.0000000  3.0000000  0.0028839635  0.0055477833
       [28,]   8.0000000  3.0000000  0.0433840647 -0.0107978261
       [29,]   9.0000000  3.0000000  0.0194841265 -0.0296354921
       [30,]  10.0000000  3.0000000 -0.0157354954 -0.0099678486
       [31,]   1.0000000  4.0000000 -0.0148068666  0.0064570792
       [32,]   2.0000000  4.0000000  0.0349434115  0.0309545504
       [33,]   3.0000000  4.0000000  0.0122341669  0.0250889844
       [34,]   4.0000000  4.0000000  0.0403223421 -0.0319340720
       [35,]   5.0000000  4.0000000 -0.0133424654  0.0354034658
       [36,]   6.0000000  4.0000000  0.0487433413  0.0428596250
       [37,]   7.0000000  4.0000000 -0.0158348253  0.0344285349
       [38,]   8.0000000  4.0000000  0.0289856836 -0.0341629610
       [39,]   9.0000000  4.0000000 -0.0336490937  0.0454066350
       [40,]  10.0000000  4.0000000  0.0347434584 -0.0122605025
       [41,]   1.0000000  5.0000000 -0.0409471453 -0.0022526822
       [42,]   2.0000000  5.0000000  0.0256599021 -0.0048651400
       [43,]   3.0000000  5.0000000  0.0340622700 -0.0371045142
       [44,]   4.0000000  5.0000000 -0.0019275298 -0.0191890407
       [45,]   5.0000000  5.0000000  0.0060101570 -0.0169471913
       [46,]   6.0000000  5.0000000  0.0051576530 -0.0234745285
       [47,]   7.0000000  5.0000000  0.0407851192  0.0464605047
       [48,]   8.0000000  5.0000000 -0.0085904858  0.0140471952
       [49,]   9.0000000  5.0000000 -0.0135948996  0.0027744060
       [50,]  10.0000000  5.0000000 -0.0081947034 -0.0219781587
       [51,]   1.0000000  6.0000000 -0.0145145064 -0.0014598926
       [52,]   2.0000000  6.0000000 -0.0426104567  0.0326802443
       [53,]   3.0000000  6.0000000 -0.0043946581  0.0069526496
       [54,]   4.0000000  6.0000000  0.0314007990 -0.0490568970
       [55,]   5.0000000  6.0000000 -0.0053969306  0.0374291364
       [56,]   6.0000000  6.0000000 -0.0418217706 -0.0401866821
       [57,]   7.0000000  6.0000000  0.0310165984 -0.0378239532
       [58,]   8.0000000  6.0000000 -0.0383762233  0.0138014233
       [59,]   9.0000000  6.0000000 -0.0395184289 -0.0141808003
       [60,]  10.0000000  6.0000000 -0.0488566692 -0.0161106778
       [61,]   1.0000000  7.0000000  0.0077576239 -0.0456993452
       [62,]   2.0000000  7.0000000  0.0353640246  0.0172811388
       [63,]   3.0000000  7.0000000  0.0314732646  0.0222209299
       [64,]   4.0000000  7.0000000  0.0346473052 -0.0488013647
       [65,]   5.0000000  7.0000000 -0.0141555009 -0.0074586672
       [66,]   6.0000000  7.0000000 -0.0132494227  0.0334256714
       [67,]   7.0000000  7.0000000 -0.0247900630  0.0355602939
       [68,]   8.0000000  7.0000000 -0.0442713907 -0.0466993265
       [69,]   9.0000000  7.0000000 -0.0106764714 -0.0212277140
       [70,]  10.0000000  7.0000000  0.0438516971 -0.0287382015
       [71,]   1.0000000  8.0000000  0.0164436805  0.0488130579
       [72,]   2.0000000  8.0000000 -0.0215097323  0.0254148313
       [73,]   3.0000000  8.0000000  0.0085810695  0.0449607738
       [74,]   4.0000000  8.0000000 -0.0252457969  0.0329215669
       [75,]   5.0000000  8.0000000 -0.0341419302 -0.0040266522
       [76,]   6.0000000  8.0000000 -0.0403578342 -0.0142846406
       [77,]   7.0000000  8.0000000 -0.0207715337  0.0329637585
       [78,]   8.0000000  8.0000000  0.0403564284 -0.0494644662
       [79,]   9.0000000  8.0000000  0.0309667719  0.0360697758
       [80,]  10.0000000  8.0000000  0.0291593320 -0.0202892990
       [81,]   1.0000000  9.0000000  0.0235926253 -0.0366330932
       [82,]   2.0000000  9.0000000  0.0388510874  0.0299145314
       [83,]   3.0000000  9.0000000  0.0394336176 -0.0356086889
       [84,]   4.0000000  9.0000000 -0.0248468031 -0.0307684459
       [85,]   5.0000000  9.0000000 -0.0471686648 -0.0226531942
       [86,]   6.0000000  9.0000000 -0.0356369173 -0.0148863554
       [87,]   7.0000000  9.0000000 -0.0397483398  0.0034758566
       [88,]   8.0000000  9.0000000  0.0323190081 -0.0215064450
       [89,]   9.0000000  9.0000000  0.0397418948 -0.0319374689
       [90,]  10.0000000  9.0000000 -0.0141661465  0.0371603101
       [91,]   1.0000000 10.0000000 -0.0290247731 -0.0498017874
       [92,]   2.0000000 10.0000000 -0.0025848112 -0.0127720742
       [93,]   3.0000000 10.0000000  0.0070531712 -0.0058777411
       [94,]   4.0000000 10.0000000  0.0039477463 -0.0257612543
       [95,]   5.0000000 10.0000000 -0.0364015279 -0.0273422876
       [96,]   6.0000000 10.0000000  0.0314509333  0.0353921735
       [97,]   7.0000000 10.0000000 -0.0129274398 -0.0180608628
       [98,]   8.0000000 10.0000000  0.0155807688  0.0044484145
       [99,]   9.0000000 10.0000000 -0.0259864262  0.0471473908
      [100,]  10.0000000 10.0000000  0.0386686355  0.0179879901
      [101,]   6.0000000  6.0000000 -0.0494111540 -0.0397026339
      [102,]   7.0000000  6.0000000 -0.0095421034  0.0290763175
      [103,]   8.0000000  6.0000000 -0.0095423958  0.0422360181
      [104,]   9.0000000  6.0000000 -0.0056648134 -0.0214310022
      [105,]  10.0000000  6.0000000 -0.0361641475 -0.0499433291
      [106,]  11.0000000  6.0000000 -0.0137938427 -0.0356851794
      [107,]  12.0000000  6.0000000  0.0227676261  0.0015637302
      [108,]  13.0000000  6.0000000  0.0486252397 -0.0123396746
      [109,]  14.0000000  6.0000000 -0.0374798555 -0.0284339315
      [110,]  15.0000000  6.0000000 -0.0060145900 -0.0350829806
      [111,]   6.0000000  7.0000000  0.0122375009 -0.0353439124
      [112,]   7.0000000  7.0000000 -0.0151320067  0.0423142502
      [113,]   8.0000000  7.0000000 -0.0069745122 -0.0051962465
      [114,]   9.0000000  7.0000000  0.0119806817 -0.0389469245
      [115,]  10.0000000  7.0000000  0.0425165671 -0.0086575911
      [116,]  11.0000000  7.0000000 -0.0198855986  0.0232040592
      [117,]  12.0000000  7.0000000  0.0341541310 -0.0245691278
      [118,]  13.0000000  7.0000000  0.0139019090 -0.0315889175
      [119,]  14.0000000  7.0000000  0.0043720318  0.0227344875
      [120,]  15.0000000  7.0000000 -0.0362611223 -0.0366494890
      [121,]   6.0000000  8.0000000 -0.0091411981  0.0157848667
      [122,]   7.0000000  8.0000000  0.0375122381  0.0070135517
      [123,]   8.0000000  8.0000000 -0.0205436346  0.0208199039
      [124,]   9.0000000  8.0000000  0.0096704798 -0.0189224581
      [125,]  10.0000000  8.0000000 -0.0074246488  0.0338216087
      [126,]  11.0000000  8.0000000 -0.0395226781 -0.0460992394
      [127,]  12.0000000  8.0000000  0.0140160184  0.0447378346
      [128,]  13.0000000  8.0000000  0.0001349537  0.0272497393
      [129,]  14.0000000  8.0000000  0.0395929786 -0.0160971409
      [130,]  15.0000000  8.0000000 -0.0421812224  0.0464448324
      [131,]   6.0000000  9.0000000 -0.0192060802  0.0179349351
      [132,]   7.0000000  9.0000000  0.0329963851 -0.0207382537
      [133,]   8.0000000  9.0000000 -0.0441801412  0.0037443788
      [134,]   9.0000000  9.0000000  0.0359260298 -0.0118583800
      [135,]  10.0000000  9.0000000 -0.0215506210  0.0063740385
      [136,]  11.0000000  9.0000000 -0.0231140854 -0.0297865495
      [137,]  12.0000000  9.0000000 -0.0290469873 -0.0433482581
      [138,]  13.0000000  9.0000000  0.0346599014 -0.0163532625
      [139,]  14.0000000  9.0000000 -0.0245407152  0.0359919606
      [140,]  15.0000000  9.0000000  0.0438232428 -0.0370901504
      [141,]   6.0000000 10.0000000  0.0190370204 -0.0496382012
      [142,]   7.0000000 10.0000000 -0.0157330000  0.0114451926
      [143,]   8.0000000 10.0000000  0.0136145061 -0.0157686300
      [144,]   9.0000000 10.0000000 -0.0211817049 -0.0482725061
      [145,]  10.0000000 10.0000000 -0.0296529576  0.0417446218
      [146,]  11.0000000 10.0000000 -0.0385897858  0.0490760001
      [147,]  12.0000000 10.0000000 -0.0114352393 -0.0143416769
      [148,]  13.0000000 10.0000000  0.0394679684 -0.0389693632
      [149,]  14.0000000 10.0000000 -0.0379028531 -0.0050521928
      [150,]  15.0000000 10.0000000  0.0086608654 -0.0338490285
      [151,]   6.0000000 11.0000000  0.0397832549  0.0007207744
      [152,]   7.0000000 11.0000000 -0.0389684510  0.0358561296
      [153,]   8.0000000 11.0000000 -0.0107839450 -0.0343432767
      [154,]   9.0000000 11.0000000  0.0229901668  0.0380912595
      [155,]  10.0000000 11.0000000 -0.0032016000 -0.0017651984
      [156,]  11.0000000 11.0000000 -0.0188916723  0.0271230818
      [157,]  12.0000000 11.0000000 -0.0406173033 -0.0153674109
      [158,]  13.0000000 11.0000000  0.0218278701 -0.0435791666
      [159,]  14.0000000 11.0000000 -0.0178925602 -0.0007038843
      [160,]  15.0000000 11.0000000  0.0418970450 -0.0042624283
      [161,]   6.0000000 12.0000000 -0.0289520095  0.0307058573
      [162,]   7.0000000 12.0000000  0.0182308341 -0.0172181919
      [163,]   8.0000000 12.0000000  0.0420673159  0.0344564827
      [164,]   9.0000000 12.0000000 -0.0215416480 -0.0145525717
      [165,]  10.0000000 12.0000000 -0.0032879685  0.0024064121
      [166,]  11.0000000 12.0000000  0.0136172979  0.0470545179
      [167,]  12.0000000 12.0000000 -0.0128606171 -0.0429631366
      [168,]  13.0000000 12.0000000  0.0406865353  0.0314480813
      [169,]  14.0000000 12.0000000 -0.0056567913 -0.0469257004
      [170,]  15.0000000 12.0000000  0.0206802091  0.0067218661
      [171,]   6.0000000 13.0000000  0.0293639539 -0.0365070718
      [172,]   7.0000000 13.0000000  0.0099463716  0.0148092618
      [173,]   8.0000000 13.0000000  0.0216768384 -0.0288158743
      [174,]   9.0000000 13.0000000  0.0126717287 -0.0393909458
      [175,]  10.0000000 13.0000000  0.0137911398 -0.0436995254
      [176,]  11.0000000 13.0000000 -0.0201560635 -0.0465217978
      [177,]  12.0000000 13.0000000 -0.0474466317 -0.0291392233
      [178,]  13.0000000 13.0000000  0.0034467781  0.0114881480
      [179,]  14.0000000 13.0000000 -0.0451321898 -0.0194828836
      [180,]  15.0000000 13.0000000  0.0449525188 -0.0485348954
      [181,]   6.0000000 14.0000000  0.0301143471 -0.0097199444
      [182,]   7.0000000 14.0000000  0.0015380326 -0.0044783109
      [183,]   8.0000000 14.0000000  0.0313923658  0.0366461525
      [184,]   9.0000000 14.0000000  0.0142799772 -0.0395055116
      [185,]  10.0000000 14.0000000 -0.0342363236 -0.0053874930
      [186,]  11.0000000 14.0000000 -0.0437694831  0.0058034629
      [187,]  12.0000000 14.0000000  0.0163590239  0.0060975001
      [188,]  13.0000000 14.0000000  0.0215670073 -0.0234173421
      [189,]  14.0000000 14.0000000  0.0312772650  0.0187736356
      [190,]  15.0000000 14.0000000  0.0404797181 -0.0442129100
      [191,]   6.0000000 15.0000000  0.0197967365 -0.0419374371
      [192,]   7.0000000 15.0000000 -0.0082434738 -0.0498900986
      [193,]   8.0000000 15.0000000  0.0110442976  0.0109741065
      [194,]   9.0000000 15.0000000  0.0086618911 -0.0074751925
      [195,]  10.0000000 15.0000000  0.0378016111 -0.0305212979
      [196,]  11.0000000 15.0000000  0.0267662517 -0.0172342707
      [197,]  12.0000000 15.0000000  0.0202962862 -0.0040695532
      [198,]  13.0000000 15.0000000 -0.0326327926  0.0392953042
      [199,]  14.0000000 15.0000000 -0.0398299208  0.0337261188
      [200,]  15.0000000 15.0000000  0.0465680600  0.0190098491
      [201,]   4.8712370 -0.8412713 -2.4689567544  1.7550866245
      [202,]  -0.5472627  2.3486790  0.6965492697  9.4148125967
      [203,] -10.4900536  0.3381607  0.9559306593  2.2842666069
      [204,]   6.0354472  3.3585330  7.0486767958  4.0185796655
      [205,]  -2.3700618  5.1150459  4.0176082849  3.5994533535
      [206,]   1.6166608  0.3309117 -0.5361186335 -2.4831237744
      [207,]  -1.3701769  0.7825842 -5.3272903421 -0.0471310516
      [208,]  -0.8932020  7.4440286  9.0114670253  8.3896275378
      [209,]   2.4183748  6.5299429  5.9633018724  3.7289143272
      [210,]   4.7404684 -1.5311453  4.6051264778  1.7135746338
      [211,]   3.8840101  1.1668002 -0.1603014199  4.4651547289
      [212,]   4.7283165 -6.4385202  3.1547378544  4.0441702975
      [213,]   2.8357821  8.5425265  3.7535034451 -4.0000570189
      [214,]   7.2149772  3.9886321 11.8193934905  2.2920966028
      [215,]  -0.2863752 -1.8431027  8.9902004332  1.1169292043
      [216,]  12.4399599  3.1844253 -4.7432286123  2.7178399201
      [217,]   7.9113611 -2.2253870  5.3899534180  6.1369975370
      [218,]   5.3850501  6.6317374  5.6080762420  5.4066024714
      [219,]  -3.5924058 -2.3909328 -4.1146506227  8.1318533403
      [220,]   3.5595998 -8.2129809  0.2085059073  7.9568809766
      [221,]   3.8310896  3.6152877  5.5085997131  1.2159855810
      [222,]  -4.6233553  1.8976212 -3.9977977271 -0.7574515354
      [223,]   8.0248125  5.6504690 10.9616917905 -0.3661473811
      [224,]   2.0626672 -1.2589877  0.1221777651 11.8838748502
      [225,]  -4.2934136 10.3421730 -3.6804622783  6.2152182107
      [226,]  -5.0225199  2.1606069 -4.7368546590  2.2995221315
      [227,]   1.4175318 -1.1801438 -4.0960448664 10.6264363346
      [228,]   3.3814820  4.4590984 -4.3662464445  6.0258622729
      [229,]   1.8170784  8.1739319  6.3900168806 11.0767019499
      [230,]   2.1008607  4.4064551  2.6878402118 -0.2188752919
      [231,]   3.4305581  2.7842342 -1.0795117926 -9.0982663264
      [232,]   0.1766592  4.1984284 -1.2954981262  3.8150367312
      [233,]  -1.6806292  8.6586780 -2.7502527537 -2.0729252340
      [234,]   4.1389586  1.2291985  7.5865951973  6.0817383774
      [235,]   2.1106510  1.2169190  6.6550778552  2.9784568747
      [236,]   6.4771926  1.2916412  9.3053418835 -0.1736056861
      [237,]   6.5220816  1.4851455 -1.6914824285 -7.5247049726
      [238,]  -4.6881494  2.5219299 10.4675866992  5.5480228595
      [239,]   3.5587806  3.4572058  0.0600575708  6.3045797472
      [240,]  12.1037622 -0.5086328 -5.2088952980  3.2749928035
      [241,]  -0.5328177  1.4508554  4.0164289066 -0.0884556489
      [242,]  11.1242007 -2.6144219  6.1545834542  8.6394725451
      [243,]   1.4540581 -5.4389015 -5.9336960237 -3.7097950163
      [244,]   7.9102472  8.6988375  3.5353740653  7.3075393966
      [245,]   1.6398558  8.1932494 -4.5920748434  8.0856686425
      [246,]  11.9069756 -6.6972892  6.9752711387  3.4273612873
      [247,]   5.6646567 11.5056160 -3.7799724551  4.3914283116
      [248,]   5.8615787  1.0479698  9.5098181331  5.8779522079
      [249,]   3.6484737  2.7378770  0.5008451031 -4.8733837012
      [250,]  -4.6551231  4.3355568  2.1300423448 15.9898720342
      [251,]   1.7594454  0.4467943 -2.1531218547  1.0045052983
      [252,]  -1.7259734  1.5904526  1.1051888742  0.8899012480
      [253,]   7.3332304  0.9118731  7.4169699023 -7.3633122743
      [254,]   5.3935603  6.7689019  4.6487968809  3.9061329364
      [255,]   1.3695809 -1.9034125 -2.5693604617  6.2238194084
      [256,]   4.2158230  5.6462446 -2.8153312911 -4.1623861165
      [257,]   9.9628186  5.4651819  1.6491487704  5.6074108462
      [258,]   0.5477012 -3.2811654  2.4462229918 -0.0985478911
      [259,]   2.0052695  4.5071295  2.1637163585  7.5792442363
      [260,]  -0.9924050 -3.8947815 16.0843656750  7.4552065490
      
      $n
      [1] 260
      

---

    Code
      two_grid_comb_bkg(n_value = 10, num_noise = 0)
    Output
      $df
                     [,1]        [,2]
        [1,]   1.00000000  1.00000000
        [2,]   2.00000000  1.00000000
        [3,]   3.00000000  1.00000000
        [4,]   4.00000000  1.00000000
        [5,]   5.00000000  1.00000000
        [6,]   6.00000000  1.00000000
        [7,]   7.00000000  1.00000000
        [8,]   8.00000000  1.00000000
        [9,]   9.00000000  1.00000000
       [10,]  10.00000000  1.00000000
       [11,]   1.00000000  2.00000000
       [12,]   2.00000000  2.00000000
       [13,]   3.00000000  2.00000000
       [14,]   4.00000000  2.00000000
       [15,]   5.00000000  2.00000000
       [16,]   6.00000000  2.00000000
       [17,]   7.00000000  2.00000000
       [18,]   8.00000000  2.00000000
       [19,]   9.00000000  2.00000000
       [20,]  10.00000000  2.00000000
       [21,]   1.00000000  3.00000000
       [22,]   2.00000000  3.00000000
       [23,]   3.00000000  3.00000000
       [24,]   4.00000000  3.00000000
       [25,]   5.00000000  3.00000000
       [26,]   6.00000000  3.00000000
       [27,]   7.00000000  3.00000000
       [28,]   8.00000000  3.00000000
       [29,]   9.00000000  3.00000000
       [30,]  10.00000000  3.00000000
       [31,]   1.00000000  4.00000000
       [32,]   2.00000000  4.00000000
       [33,]   3.00000000  4.00000000
       [34,]   4.00000000  4.00000000
       [35,]   5.00000000  4.00000000
       [36,]   6.00000000  4.00000000
       [37,]   7.00000000  4.00000000
       [38,]   8.00000000  4.00000000
       [39,]   9.00000000  4.00000000
       [40,]  10.00000000  4.00000000
       [41,]   1.00000000  5.00000000
       [42,]   2.00000000  5.00000000
       [43,]   3.00000000  5.00000000
       [44,]   4.00000000  5.00000000
       [45,]   5.00000000  5.00000000
       [46,]   6.00000000  5.00000000
       [47,]   7.00000000  5.00000000
       [48,]   8.00000000  5.00000000
       [49,]   9.00000000  5.00000000
       [50,]  10.00000000  5.00000000
       [51,]   1.00000000  6.00000000
       [52,]   2.00000000  6.00000000
       [53,]   3.00000000  6.00000000
       [54,]   4.00000000  6.00000000
       [55,]   5.00000000  6.00000000
       [56,]   6.00000000  6.00000000
       [57,]   7.00000000  6.00000000
       [58,]   8.00000000  6.00000000
       [59,]   9.00000000  6.00000000
       [60,]  10.00000000  6.00000000
       [61,]   1.00000000  7.00000000
       [62,]   2.00000000  7.00000000
       [63,]   3.00000000  7.00000000
       [64,]   4.00000000  7.00000000
       [65,]   5.00000000  7.00000000
       [66,]   6.00000000  7.00000000
       [67,]   7.00000000  7.00000000
       [68,]   8.00000000  7.00000000
       [69,]   9.00000000  7.00000000
       [70,]  10.00000000  7.00000000
       [71,]   1.00000000  8.00000000
       [72,]   2.00000000  8.00000000
       [73,]   3.00000000  8.00000000
       [74,]   4.00000000  8.00000000
       [75,]   5.00000000  8.00000000
       [76,]   6.00000000  8.00000000
       [77,]   7.00000000  8.00000000
       [78,]   8.00000000  8.00000000
       [79,]   9.00000000  8.00000000
       [80,]  10.00000000  8.00000000
       [81,]   1.00000000  9.00000000
       [82,]   2.00000000  9.00000000
       [83,]   3.00000000  9.00000000
       [84,]   4.00000000  9.00000000
       [85,]   5.00000000  9.00000000
       [86,]   6.00000000  9.00000000
       [87,]   7.00000000  9.00000000
       [88,]   8.00000000  9.00000000
       [89,]   9.00000000  9.00000000
       [90,]  10.00000000  9.00000000
       [91,]   1.00000000 10.00000000
       [92,]   2.00000000 10.00000000
       [93,]   3.00000000 10.00000000
       [94,]   4.00000000 10.00000000
       [95,]   5.00000000 10.00000000
       [96,]   6.00000000 10.00000000
       [97,]   7.00000000 10.00000000
       [98,]   8.00000000 10.00000000
       [99,]   9.00000000 10.00000000
      [100,]  10.00000000 10.00000000
      [101,]   6.00000000  6.00000000
      [102,]   7.00000000  6.00000000
      [103,]   8.00000000  6.00000000
      [104,]   9.00000000  6.00000000
      [105,]  10.00000000  6.00000000
      [106,]  11.00000000  6.00000000
      [107,]  12.00000000  6.00000000
      [108,]  13.00000000  6.00000000
      [109,]  14.00000000  6.00000000
      [110,]  15.00000000  6.00000000
      [111,]   6.00000000  7.00000000
      [112,]   7.00000000  7.00000000
      [113,]   8.00000000  7.00000000
      [114,]   9.00000000  7.00000000
      [115,]  10.00000000  7.00000000
      [116,]  11.00000000  7.00000000
      [117,]  12.00000000  7.00000000
      [118,]  13.00000000  7.00000000
      [119,]  14.00000000  7.00000000
      [120,]  15.00000000  7.00000000
      [121,]   6.00000000  8.00000000
      [122,]   7.00000000  8.00000000
      [123,]   8.00000000  8.00000000
      [124,]   9.00000000  8.00000000
      [125,]  10.00000000  8.00000000
      [126,]  11.00000000  8.00000000
      [127,]  12.00000000  8.00000000
      [128,]  13.00000000  8.00000000
      [129,]  14.00000000  8.00000000
      [130,]  15.00000000  8.00000000
      [131,]   6.00000000  9.00000000
      [132,]   7.00000000  9.00000000
      [133,]   8.00000000  9.00000000
      [134,]   9.00000000  9.00000000
      [135,]  10.00000000  9.00000000
      [136,]  11.00000000  9.00000000
      [137,]  12.00000000  9.00000000
      [138,]  13.00000000  9.00000000
      [139,]  14.00000000  9.00000000
      [140,]  15.00000000  9.00000000
      [141,]   6.00000000 10.00000000
      [142,]   7.00000000 10.00000000
      [143,]   8.00000000 10.00000000
      [144,]   9.00000000 10.00000000
      [145,]  10.00000000 10.00000000
      [146,]  11.00000000 10.00000000
      [147,]  12.00000000 10.00000000
      [148,]  13.00000000 10.00000000
      [149,]  14.00000000 10.00000000
      [150,]  15.00000000 10.00000000
      [151,]   6.00000000 11.00000000
      [152,]   7.00000000 11.00000000
      [153,]   8.00000000 11.00000000
      [154,]   9.00000000 11.00000000
      [155,]  10.00000000 11.00000000
      [156,]  11.00000000 11.00000000
      [157,]  12.00000000 11.00000000
      [158,]  13.00000000 11.00000000
      [159,]  14.00000000 11.00000000
      [160,]  15.00000000 11.00000000
      [161,]   6.00000000 12.00000000
      [162,]   7.00000000 12.00000000
      [163,]   8.00000000 12.00000000
      [164,]   9.00000000 12.00000000
      [165,]  10.00000000 12.00000000
      [166,]  11.00000000 12.00000000
      [167,]  12.00000000 12.00000000
      [168,]  13.00000000 12.00000000
      [169,]  14.00000000 12.00000000
      [170,]  15.00000000 12.00000000
      [171,]   6.00000000 13.00000000
      [172,]   7.00000000 13.00000000
      [173,]   8.00000000 13.00000000
      [174,]   9.00000000 13.00000000
      [175,]  10.00000000 13.00000000
      [176,]  11.00000000 13.00000000
      [177,]  12.00000000 13.00000000
      [178,]  13.00000000 13.00000000
      [179,]  14.00000000 13.00000000
      [180,]  15.00000000 13.00000000
      [181,]   6.00000000 14.00000000
      [182,]   7.00000000 14.00000000
      [183,]   8.00000000 14.00000000
      [184,]   9.00000000 14.00000000
      [185,]  10.00000000 14.00000000
      [186,]  11.00000000 14.00000000
      [187,]  12.00000000 14.00000000
      [188,]  13.00000000 14.00000000
      [189,]  14.00000000 14.00000000
      [190,]  15.00000000 14.00000000
      [191,]   6.00000000 15.00000000
      [192,]   7.00000000 15.00000000
      [193,]   8.00000000 15.00000000
      [194,]   9.00000000 15.00000000
      [195,]  10.00000000 15.00000000
      [196,]  11.00000000 15.00000000
      [197,]  12.00000000 15.00000000
      [198,]  13.00000000 15.00000000
      [199,]  14.00000000 15.00000000
      [200,]  15.00000000 15.00000000
      [201,]   7.68938859 -1.07823709
      [202,]   0.04389882  0.70646913
      [203,]   6.28881580  3.13331492
      [204,]   6.37872596  3.76149381
      [205,]  19.34499849  3.80371099
      [206,]   6.48127970  1.58559856
      [207,]   3.09757282 -0.43942745
      [208,]   4.61654156  1.95085577
      [209,]  10.09972647  5.46661007
      [210,]   6.78631809  9.23777702
      [211,]  -0.20540428  9.41792094
      [212,]  -1.42479772 -1.44822038
      [213,]   0.91244700  3.48336262
      [214,] -10.16827998  1.98965439
      [215,]   3.85812667  0.02268775
      [216,]   4.28481908  5.76964977
      [217,]   0.96358464  2.20262038
      [218,]   4.82236500  3.51526532
      [219,]   7.62102469  6.16174719
      [220,]  -0.27549587  0.89306346
      [221,]   6.31705545 -2.10234691
      [222,]   1.85743980  3.35201979
      [223,]   1.22180596  4.20776975
      [224,]   6.55811669  1.80524765
      [225,]  -2.25724729 -5.52287572
      [226,]   0.50435434  0.59342550
      [227,]  -5.73567839 12.86402089
      [228,]  -0.46115910 -3.53136278
      [229,]  -1.79847089 -3.05605246
      [230,]   1.45757696  8.15667210
      [231,]   3.81174076 -2.97663546
      [232,]   5.81124956 -3.67435541
      [233,]   9.53041038 16.39103286
      [234,]   1.06051011  7.59426891
      [235,]   6.01770592 -2.69518910
      [236,]   3.01402588  2.37877100
      [237,]  -8.42580731 -0.46526916
      [238,]   1.02929616  6.79643796
      [239,]   5.73353928  8.06652916
      [240,]  10.37497993 -0.88192200
      [241,]   3.12248038 -0.85847698
      [242,]   4.18315709 -4.97637477
      [243,]  12.24070449  4.11652240
      [244,]   1.89686316  3.98890271
      [245,]   2.14608208  0.04645288
      [246,]   3.47907208 -6.35858104
      [247,]   2.72913917  5.29600075
      [248,]   6.02401816 -2.11588481
      [249,]   4.09676925  4.90206666
      [250,]  11.06334303  9.54420854
      [251,]  -2.51889717 -2.02611665
      [252,]   2.95627096  0.02455248
      [253,]   1.82645732  0.41034566
      [254,]  -0.45219198  1.92780474
      [255,]   2.63660125  5.57332962
      [256,]   1.88893204  4.00676663
      [257,]  -3.10446266 -4.12250878
      [258,]  -3.55694064  1.50893547
      [259,]   0.87013002  2.34107078
      [260,]   6.81738676  4.86380376
      
      $n
      [1] 260
      

# two_grid_comb() works

    Code
      two_grid_comb(n_value = 10, num_noise = 2, min_n = -0.05, max_n = 0.05)
    Output
      $df
             [,1] [,2]          [,3]          [,4]
        [1,]    1    1 -0.0406208903 -0.0468112729
        [2,]    2    1 -0.0069582161  0.0124962581
        [3,]    3    1  0.0239614908  0.0390363060
        [4,]    4    1  0.0143368074 -0.0121142437
        [5,]    5    1  0.0401831183  0.0077770323
        [6,]    6    1 -0.0308282462  0.0433116644
        [7,]    7    1 -0.0400570993 -0.0096181576
        [8,]    8    1  0.0034441012 -0.0404465381
        [9,]    9    1 -0.0147099345  0.0497450735
       [10,]   10    1 -0.0058951876  0.0152653055
       [11,]    1    2  0.0061251915 -0.0365711479
       [12,]    2    2  0.0091990083 -0.0159191196
       [13,]    3    2  0.0437254337  0.0314435686
       [14,]    4    2  0.0327753831 -0.0449404774
       [15,]    5    2 -0.0151984228  0.0289388946
       [16,]    6    2 -0.0098404858 -0.0135954321
       [17,]    7    2  0.0178843632 -0.0023689911
       [18,]    8    2  0.0031283391  0.0305722723
       [19,]    9    2 -0.0498555169  0.0184369768
       [20,]   10    2 -0.0425508382 -0.0459533107
       [21,]    1    3 -0.0141356953 -0.0348061180
       [22,]    2    3 -0.0399193364 -0.0042005939
       [23,]    3    3  0.0008688590  0.0309299566
       [24,]    4    3  0.0469179725  0.0233263229
       [25,]    5    3 -0.0100181968 -0.0388561925
       [26,]    6    3 -0.0411767531 -0.0360052565
       [27,]    7    3  0.0028839635  0.0055477833
       [28,]    8    3  0.0433840647 -0.0107978261
       [29,]    9    3  0.0194841265 -0.0296354921
       [30,]   10    3 -0.0157354954 -0.0099678486
       [31,]    1    4 -0.0148068666  0.0064570792
       [32,]    2    4  0.0349434115  0.0309545504
       [33,]    3    4  0.0122341669  0.0250889844
       [34,]    4    4  0.0403223421 -0.0319340720
       [35,]    5    4 -0.0133424654  0.0354034658
       [36,]    6    4  0.0487433413  0.0428596250
       [37,]    7    4 -0.0158348253  0.0344285349
       [38,]    8    4  0.0289856836 -0.0341629610
       [39,]    9    4 -0.0336490937  0.0454066350
       [40,]   10    4  0.0347434584 -0.0122605025
       [41,]    1    5 -0.0409471453 -0.0022526822
       [42,]    2    5  0.0256599021 -0.0048651400
       [43,]    3    5  0.0340622700 -0.0371045142
       [44,]    4    5 -0.0019275298 -0.0191890407
       [45,]    5    5  0.0060101570 -0.0169471913
       [46,]    6    5  0.0051576530 -0.0234745285
       [47,]    7    5  0.0407851192  0.0464605047
       [48,]    8    5 -0.0085904858  0.0140471952
       [49,]    9    5 -0.0135948996  0.0027744060
       [50,]   10    5 -0.0081947034 -0.0219781587
       [51,]    1    6 -0.0145145064 -0.0014598926
       [52,]    2    6 -0.0426104567  0.0326802443
       [53,]    3    6 -0.0043946581  0.0069526496
       [54,]    4    6  0.0314007990 -0.0490568970
       [55,]    5    6 -0.0053969306  0.0374291364
       [56,]    6    6 -0.0418217706 -0.0401866821
       [57,]    7    6  0.0310165984 -0.0378239532
       [58,]    8    6 -0.0383762233  0.0138014233
       [59,]    9    6 -0.0395184289 -0.0141808003
       [60,]   10    6 -0.0488566692 -0.0161106778
       [61,]    1    7  0.0077576239 -0.0456993452
       [62,]    2    7  0.0353640246  0.0172811388
       [63,]    3    7  0.0314732646  0.0222209299
       [64,]    4    7  0.0346473052 -0.0488013647
       [65,]    5    7 -0.0141555009 -0.0074586672
       [66,]    6    7 -0.0132494227  0.0334256714
       [67,]    7    7 -0.0247900630  0.0355602939
       [68,]    8    7 -0.0442713907 -0.0466993265
       [69,]    9    7 -0.0106764714 -0.0212277140
       [70,]   10    7  0.0438516971 -0.0287382015
       [71,]    1    8  0.0164436805  0.0488130579
       [72,]    2    8 -0.0215097323  0.0254148313
       [73,]    3    8  0.0085810695  0.0449607738
       [74,]    4    8 -0.0252457969  0.0329215669
       [75,]    5    8 -0.0341419302 -0.0040266522
       [76,]    6    8 -0.0403578342 -0.0142846406
       [77,]    7    8 -0.0207715337  0.0329637585
       [78,]    8    8  0.0403564284 -0.0494644662
       [79,]    9    8  0.0309667719  0.0360697758
       [80,]   10    8  0.0291593320 -0.0202892990
       [81,]    1    9  0.0235926253 -0.0366330932
       [82,]    2    9  0.0388510874  0.0299145314
       [83,]    3    9  0.0394336176 -0.0356086889
       [84,]    4    9 -0.0248468031 -0.0307684459
       [85,]    5    9 -0.0471686648 -0.0226531942
       [86,]    6    9 -0.0356369173 -0.0148863554
       [87,]    7    9 -0.0397483398  0.0034758566
       [88,]    8    9  0.0323190081 -0.0215064450
       [89,]    9    9  0.0397418948 -0.0319374689
       [90,]   10    9 -0.0141661465  0.0371603101
       [91,]    1   10 -0.0290247731 -0.0498017874
       [92,]    2   10 -0.0025848112 -0.0127720742
       [93,]    3   10  0.0070531712 -0.0058777411
       [94,]    4   10  0.0039477463 -0.0257612543
       [95,]    5   10 -0.0364015279 -0.0273422876
       [96,]    6   10  0.0314509333  0.0353921735
       [97,]    7   10 -0.0129274398 -0.0180608628
       [98,]    8   10  0.0155807688  0.0044484145
       [99,]    9   10 -0.0259864262  0.0471473908
      [100,]   10   10  0.0386686355  0.0179879901
      [101,]    4    4 -0.0494111540 -0.0397026339
      [102,]    5    4 -0.0095421034  0.0290763175
      [103,]    6    4 -0.0095423958  0.0422360181
      [104,]    7    4 -0.0056648134 -0.0214310022
      [105,]    8    4 -0.0361641475 -0.0499433291
      [106,]    9    4 -0.0137938427 -0.0356851794
      [107,]   10    4  0.0227676261  0.0015637302
      [108,]   11    4  0.0486252397 -0.0123396746
      [109,]   12    4 -0.0374798555 -0.0284339315
      [110,]   13    4 -0.0060145900 -0.0350829806
      [111,]    4    5  0.0122375009 -0.0353439124
      [112,]    5    5 -0.0151320067  0.0423142502
      [113,]    6    5 -0.0069745122 -0.0051962465
      [114,]    7    5  0.0119806817 -0.0389469245
      [115,]    8    5  0.0425165671 -0.0086575911
      [116,]    9    5 -0.0198855986  0.0232040592
      [117,]   10    5  0.0341541310 -0.0245691278
      [118,]   11    5  0.0139019090 -0.0315889175
      [119,]   12    5  0.0043720318  0.0227344875
      [120,]   13    5 -0.0362611223 -0.0366494890
      [121,]    4    6 -0.0091411981  0.0157848667
      [122,]    5    6  0.0375122381  0.0070135517
      [123,]    6    6 -0.0205436346  0.0208199039
      [124,]    7    6  0.0096704798 -0.0189224581
      [125,]    8    6 -0.0074246488  0.0338216087
      [126,]    9    6 -0.0395226781 -0.0460992394
      [127,]   10    6  0.0140160184  0.0447378346
      [128,]   11    6  0.0001349537  0.0272497393
      [129,]   12    6  0.0395929786 -0.0160971409
      [130,]   13    6 -0.0421812224  0.0464448324
      [131,]    4    7 -0.0192060802  0.0179349351
      [132,]    5    7  0.0329963851 -0.0207382537
      [133,]    6    7 -0.0441801412  0.0037443788
      [134,]    7    7  0.0359260298 -0.0118583800
      [135,]    8    7 -0.0215506210  0.0063740385
      [136,]    9    7 -0.0231140854 -0.0297865495
      [137,]   10    7 -0.0290469873 -0.0433482581
      [138,]   11    7  0.0346599014 -0.0163532625
      [139,]   12    7 -0.0245407152  0.0359919606
      [140,]   13    7  0.0438232428 -0.0370901504
      [141,]    4    8  0.0190370204 -0.0496382012
      [142,]    5    8 -0.0157330000  0.0114451926
      [143,]    6    8  0.0136145061 -0.0157686300
      [144,]    7    8 -0.0211817049 -0.0482725061
      [145,]    8    8 -0.0296529576  0.0417446218
      [146,]    9    8 -0.0385897858  0.0490760001
      [147,]   10    8 -0.0114352393 -0.0143416769
      [148,]   11    8  0.0394679684 -0.0389693632
      [149,]   12    8 -0.0379028531 -0.0050521928
      [150,]   13    8  0.0086608654 -0.0338490285
      [151,]    4    9  0.0397832549  0.0007207744
      [152,]    5    9 -0.0389684510  0.0358561296
      [153,]    6    9 -0.0107839450 -0.0343432767
      [154,]    7    9  0.0229901668  0.0380912595
      [155,]    8    9 -0.0032016000 -0.0017651984
      [156,]    9    9 -0.0188916723  0.0271230818
      [157,]   10    9 -0.0406173033 -0.0153674109
      [158,]   11    9  0.0218278701 -0.0435791666
      [159,]   12    9 -0.0178925602 -0.0007038843
      [160,]   13    9  0.0418970450 -0.0042624283
      [161,]    4   10 -0.0289520095  0.0307058573
      [162,]    5   10  0.0182308341 -0.0172181919
      [163,]    6   10  0.0420673159  0.0344564827
      [164,]    7   10 -0.0215416480 -0.0145525717
      [165,]    8   10 -0.0032879685  0.0024064121
      [166,]    9   10  0.0136172979  0.0470545179
      [167,]   10   10 -0.0128606171 -0.0429631366
      [168,]   11   10  0.0406865353  0.0314480813
      [169,]   12   10 -0.0056567913 -0.0469257004
      [170,]   13   10  0.0206802091  0.0067218661
      [171,]    4   11  0.0293639539 -0.0365070718
      [172,]    5   11  0.0099463716  0.0148092618
      [173,]    6   11  0.0216768384 -0.0288158743
      [174,]    7   11  0.0126717287 -0.0393909458
      [175,]    8   11  0.0137911398 -0.0436995254
      [176,]    9   11 -0.0201560635 -0.0465217978
      [177,]   10   11 -0.0474466317 -0.0291392233
      [178,]   11   11  0.0034467781  0.0114881480
      [179,]   12   11 -0.0451321898 -0.0194828836
      [180,]   13   11  0.0449525188 -0.0485348954
      [181,]    4   12  0.0301143471 -0.0097199444
      [182,]    5   12  0.0015380326 -0.0044783109
      [183,]    6   12  0.0313923658  0.0366461525
      [184,]    7   12  0.0142799772 -0.0395055116
      [185,]    8   12 -0.0342363236 -0.0053874930
      [186,]    9   12 -0.0437694831  0.0058034629
      [187,]   10   12  0.0163590239  0.0060975001
      [188,]   11   12  0.0215670073 -0.0234173421
      [189,]   12   12  0.0312772650  0.0187736356
      [190,]   13   12  0.0404797181 -0.0442129100
      [191,]    4   13  0.0197967365 -0.0419374371
      [192,]    5   13 -0.0082434738 -0.0498900986
      [193,]    6   13  0.0110442976  0.0109741065
      [194,]    7   13  0.0086618911 -0.0074751925
      [195,]    8   13  0.0378016111 -0.0305212979
      [196,]    9   13  0.0267662517 -0.0172342707
      [197,]   10   13  0.0202962862 -0.0040695532
      [198,]   11   13 -0.0326327926  0.0392953042
      [199,]   12   13 -0.0398299208  0.0337261188
      [200,]   13   13  0.0465680600  0.0190098491
      
      $n
      [1] 200
      

---

    Code
      two_grid_comb(n_value = 10, num_noise = 0)
    Output
      $df
             [,1] [,2]
        [1,]    1    1
        [2,]    2    1
        [3,]    3    1
        [4,]    4    1
        [5,]    5    1
        [6,]    6    1
        [7,]    7    1
        [8,]    8    1
        [9,]    9    1
       [10,]   10    1
       [11,]    1    2
       [12,]    2    2
       [13,]    3    2
       [14,]    4    2
       [15,]    5    2
       [16,]    6    2
       [17,]    7    2
       [18,]    8    2
       [19,]    9    2
       [20,]   10    2
       [21,]    1    3
       [22,]    2    3
       [23,]    3    3
       [24,]    4    3
       [25,]    5    3
       [26,]    6    3
       [27,]    7    3
       [28,]    8    3
       [29,]    9    3
       [30,]   10    3
       [31,]    1    4
       [32,]    2    4
       [33,]    3    4
       [34,]    4    4
       [35,]    5    4
       [36,]    6    4
       [37,]    7    4
       [38,]    8    4
       [39,]    9    4
       [40,]   10    4
       [41,]    1    5
       [42,]    2    5
       [43,]    3    5
       [44,]    4    5
       [45,]    5    5
       [46,]    6    5
       [47,]    7    5
       [48,]    8    5
       [49,]    9    5
       [50,]   10    5
       [51,]    1    6
       [52,]    2    6
       [53,]    3    6
       [54,]    4    6
       [55,]    5    6
       [56,]    6    6
       [57,]    7    6
       [58,]    8    6
       [59,]    9    6
       [60,]   10    6
       [61,]    1    7
       [62,]    2    7
       [63,]    3    7
       [64,]    4    7
       [65,]    5    7
       [66,]    6    7
       [67,]    7    7
       [68,]    8    7
       [69,]    9    7
       [70,]   10    7
       [71,]    1    8
       [72,]    2    8
       [73,]    3    8
       [74,]    4    8
       [75,]    5    8
       [76,]    6    8
       [77,]    7    8
       [78,]    8    8
       [79,]    9    8
       [80,]   10    8
       [81,]    1    9
       [82,]    2    9
       [83,]    3    9
       [84,]    4    9
       [85,]    5    9
       [86,]    6    9
       [87,]    7    9
       [88,]    8    9
       [89,]    9    9
       [90,]   10    9
       [91,]    1   10
       [92,]    2   10
       [93,]    3   10
       [94,]    4   10
       [95,]    5   10
       [96,]    6   10
       [97,]    7   10
       [98,]    8   10
       [99,]    9   10
      [100,]   10   10
      [101,]    4    4
      [102,]    5    4
      [103,]    6    4
      [104,]    7    4
      [105,]    8    4
      [106,]    9    4
      [107,]   10    4
      [108,]   11    4
      [109,]   12    4
      [110,]   13    4
      [111,]    4    5
      [112,]    5    5
      [113,]    6    5
      [114,]    7    5
      [115,]    8    5
      [116,]    9    5
      [117,]   10    5
      [118,]   11    5
      [119,]   12    5
      [120,]   13    5
      [121,]    4    6
      [122,]    5    6
      [123,]    6    6
      [124,]    7    6
      [125,]    8    6
      [126,]    9    6
      [127,]   10    6
      [128,]   11    6
      [129,]   12    6
      [130,]   13    6
      [131,]    4    7
      [132,]    5    7
      [133,]    6    7
      [134,]    7    7
      [135,]    8    7
      [136,]    9    7
      [137,]   10    7
      [138,]   11    7
      [139,]   12    7
      [140,]   13    7
      [141,]    4    8
      [142,]    5    8
      [143,]    6    8
      [144,]    7    8
      [145,]    8    8
      [146,]    9    8
      [147,]   10    8
      [148,]   11    8
      [149,]   12    8
      [150,]   13    8
      [151,]    4    9
      [152,]    5    9
      [153,]    6    9
      [154,]    7    9
      [155,]    8    9
      [156,]    9    9
      [157,]   10    9
      [158,]   11    9
      [159,]   12    9
      [160,]   13    9
      [161,]    4   10
      [162,]    5   10
      [163,]    6   10
      [164,]    7   10
      [165,]    8   10
      [166,]    9   10
      [167,]   10   10
      [168,]   11   10
      [169,]   12   10
      [170,]   13   10
      [171,]    4   11
      [172,]    5   11
      [173,]    6   11
      [174,]    7   11
      [175,]    8   11
      [176,]    9   11
      [177,]   10   11
      [178,]   11   11
      [179,]   12   11
      [180,]   13   11
      [181,]    4   12
      [182,]    5   12
      [183,]    6   12
      [184,]    7   12
      [185,]    8   12
      [186,]    9   12
      [187,]   10   12
      [188,]   11   12
      [189,]   12   12
      [190,]   13   12
      [191,]    4   13
      [192,]    5   13
      [193,]    6   13
      [194,]    7   13
      [195,]    8   13
      [196,]    9   13
      [197,]   10   13
      [198,]   11   13
      [199,]   12   13
      [200,]   13   13
      
      $n
      [1] 200
      

