% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonlinear.R
\name{two_curvilinear}
\alias{two_curvilinear}
\title{Generate Two Curvilinear Data with Noise}
\usage{
two_curvilinear(n, num_noise, min_n, max_n)
}
\arguments{
\item{n}{The total number of samples to generate.}

\item{num_noise}{The number of additional noise dimensions to add to the data.}

\item{min_n}{The minimum value for the noise dimensions.}

\item{max_n}{The maximum value for the noise dimensions.}
}
\value{
A matrix containing the two curvilinear data with noise.
}
\description{
This function generates a dataset representing two curvilinear clusters with added noise.
}
\examples{
set.seed(20240412)
two_curvilinear <- two_curvilinear(
  n = 250, num_noise = 2, min_n = -0.05,
  max_n = 0.05
)
}
