% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid.R
\name{one_grid}
\alias{one_grid}
\title{Generate Grid Data with Noise}
\usage{
one_grid(nx, ny, num_noise, min_n, max_n)
}
\arguments{
\item{nx}{The number of grid points along the x axis.}

\item{ny}{The number of grid points along the y axis.}

\item{num_noise}{The number of additional noise dimensions to add to the data.}

\item{min_n}{The minimum value for the noise dimensions.}

\item{max_n}{The maximum value for the noise dimensions.}
}
\value{
A matrix containing the grid data with added noise.
}
\description{
This function generates a grid dataset with specified grid points along the x
and y axes, and optionally adds noise dimensions.
}
\examples{
set.seed(20240412)
one_grid <- one_grid(nx = 10, ny = 10, num_noise = 2, min_n = -0.05, max_n = 0.05)
}
