% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/branching.R
\name{eight_branch}
\alias{eight_branch}
\title{Generate Eight Branching Data with Noise}
\usage{
eight_branch(n, num_noise, min_n, max_n)
}
\arguments{
\item{n}{The total number of samples to generate.}

\item{num_noise}{The number of additional noise dimensions to add to the data.}

\item{min_n}{The minimum value for the noise dimensions.}

\item{max_n}{The maximum value for the noise dimensions.}
}
\value{
A matrix containing the eight branching data with added noise.
}
\description{
This function generates a dataset representing eight branching patterns, with added noise.
}
\examples{
set.seed(20240412)
branching_data <- eight_branch(
  n = 400, num_noise = 2, min_n = -0.05,
  max_n = 0.05
)
}
