% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/branching.R
\name{curvy_branch_clust}
\alias{curvy_branch_clust}
\title{Generate Curvy Branching Cluster Data}
\usage{
curvy_branch_clust(n, clust_vec, num_noise, min_n, max_n)
}
\arguments{
\item{n}{The total number of data points to be generated.}

\item{clust_vec}{A vector specifying the number of points for each cluster.
If not provided, the n is divided equally
among the clusters.}

\item{num_noise}{The number of additional noise dimensions to be generated.}

\item{min_n}{The minimum value for the noise added to the data points.}

\item{max_n}{The maximum value for the noise added to the data points.}
}
\value{
A matrix containing the generated data, with each row representing a data point.
}
\description{
This function generates curvy branching cluster data with three clusters of different shapes.
}
\examples{

# Generate curvy branching cluster data with custom parameters
set.seed(20240412)
data <- curvy_branch_clust(
  n = 300, clust_vec = c(100, 150, 50),
  num_noise = 2, min_n = -0.05, max_n = 0.05
)
}
