% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circulars.R
\name{cell_cycle}
\alias{cell_cycle}
\title{Generate Cell Cycle Data with Noise}
\usage{
cell_cycle(n, num_noise, min_n, max_n)
}
\arguments{
\item{n}{The total number of samples to generate.}

\item{num_noise}{The number of additional noise dimensions to add to the data.}

\item{min_n}{The minimum value for the noise dimensions.}

\item{max_n}{The maximum value for the noise dimensions.}
}
\value{
A matrix containing the cell cycle data with added noise.
}
\description{
This function generates a cell cycle dataset with added noise dimensions.
}
\examples{
set.seed(20240412)
cell_cycle_data <- cell_cycle(
  n = 300, num_noise = 2, min_n = -0.05,
  max_n = 0.05
)
}
