% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sym_as_sym.R
\name{as_sym}
\alias{as_sym}
\title{Convert R object to caracas symbol}
\usage{
as_sym(x, declare_symbols = TRUE)
}
\arguments{
\item{x}{R object to convert to a symbol}

\item{declare_symbols}{declare detected symbols automatically}
}
\description{
Variables are detected as a
character followed by a number of either:
character, number or underscore.
}
\details{
Default is to declare used variables. Alternatively, the user
must declare them first, e.g. by \code{\link[=symbol]{symbol()}}.

Note that matrices can be defined by specifying a Python matrix,
see below in examples.
}
\examples{
if (has_sympy()) {
  x <- symbol("x")
  A <- matrix(c("x", 0, 0, "2*x"), 2, 2)
  A
  B <- as_sym(A)
  B
  2 * B
  dim(B)
  sqrt(B)
  D <- as_sym("[[1, 4, 5], [-5, 8, 9]]")
  D
}

}
\concept{caracas_symbol}
