% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symbol.R
\name{subs_lst}
\alias{subs_lst}
\title{Substitute symbol for of value given by a list}
\usage{
subs_lst(s, x)
}
\arguments{
\item{s}{Expression}

\item{x}{Named list of values}
}
\description{
Useful for substituting solutions into expressions.
}
\examples{
if (have_sympy()) {
     p <- as_symbol(paste0("p", 1:3))
     y <- as_symbol(paste0("y", 1:3))
     a <- as_symbol("a")
     l <- sum(y*log(p))
     L <- -l + a*(sum(p) - 1)
     g <- der(L, c(a, p))
     sols <- solve_sys(g, c(a, p))
     sol <- sols[[1L]]
     sol
     H <- der2(L, c(p, a))
     H
     H_sol <- subs_lst(H, sol)
     H_sol
}

}
