% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/capl.R
\name{get_capl_domain_status}
\alias{get_capl_domain_status}
\title{Compute the status of a CAPL domain.}
\usage{
get_capl_domain_status(x = NULL, domain = NA)
}
\arguments{
\item{x}{A data frame that includes the required variables for a given domain (see Details).}

\item{domain}{A character vector representing one of the CAPL-2 domains (valid values are "pc", "db", "mc", "ku" and "capl")}
}
\value{
Returns a character vector with a value of "complete", "missing interpretation", "missing protocol" or "incomplete".
}
\description{
This function computes the status ("complete", "missing interpretation", "missing protocol" or "incomplete") of a CAPL domain (e.g., \code{pc_status},
\code{db_status}, \code{mc_status}, \code{ku_status}, \code{capl_status}).
}
\details{
If the \code{domain} argument is set to "pc", the following variables must be included in the \code{x} argument:
\itemize{
\item \code{pc_score}
\item \code{pc_interpretation}
\item \code{pacer_score}
\item \code{plank_score}
\item \code{camsa_score}
}

If the \code{domain} argument is set to "db", the following variables must be included the \code{x} argument:
\itemize{
\item \code{db_score}
\item \code{db_interpretation}
\item \code{step_score}
\item \code{self_report_pa_score}
}

If the \code{domain} argument is set to "mc", the following variables must be included the \code{x} argument:
\itemize{
\item \code{mc_score}
\item \code{mc_interpretation}
\item \code{predilection_score}
\item \code{adequacy_score}
\item \code{intrinsic_motivation_score}
\item \code{pa_competence_score}
}

If the \code{domain} argument is set to "ku", the following variables must be included the \code{x} argument:
\itemize{
\item \code{ku_score}
\item \code{ku_interpretation}
\item \code{pa_guideline_score}
\item \code{crf_means_score}
\item \code{ms_means_score}
\item \code{sports_skill_score}
\item \code{fill_in_the_blanks_score}
}

If the \code{domain} argument is set to "capl", the following variables must be included the \code{x} argument:
\itemize{
\item \code{capl_score}
\item \code{capl_interpretation}
\item \code{pc_score}
\item \code{db_score}
\item \code{mc_score}
\item \code{ku_score}
\item \code{capl_score}
}

Other \code{capl} functions called by this function include: \code{\link[=validate_character]{validate_character()}} and \code{\link[=validate_number]{validate_number()}}.
}
\examples{
capl_demo_data <- get_capl_demo_data(3)

capl_results <- get_capl(capl_demo_data)

get_capl_domain_status(capl_results, "pc")

# [1] "complete"               "incomplete"             "missing interpretation" 

}
