% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_interaction_error.R
\name{get_interaction_error}
\alias{get_interaction_error}
\title{Get error bars for interaction plot}
\usage{
get_interaction_error(x, y, trace, error_type = c("sd", "se"))
}
\arguments{
\item{x}{The vector whose levels will form the x axis}

\item{y}{The vector whose levels will form the y axis, 
the response vector i.e.}

\item{trace}{Another vector whose levels will form the traces}

\item{error_type}{Either "sd" for standard deviation, or
"se" for standard error.}
}
\value{
returns a list with two elements. The first element
called "means" contains the mean y values for the combinations 
of the x and trace variables. The second element, called "se"
or "sd" depending on error_type contains the errors for the 
same combinations.
}
\description{
This function gets error bars for an interaction plot
it takes in the x, y, and trace factor of the interaction
plot and returns a vector indicating how much should
default error type is standard error
}
\keyword{internal}
