% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cansim_parquet.R
\name{get_cansim_connection}
\alias{get_cansim_connection}
\title{Retrieve a Statistics Canada data table using NDM catalogue number as parquet, feather, or sqlite database connection}
\usage{
get_cansim_connection(
  cansimTableNumber,
  language = "english",
  format = "parquet",
  partitioning = c(),
  refresh = FALSE,
  timeout = 1000,
  cache_path = getOption("cansim.cache_path")
)
}
\arguments{
\item{cansimTableNumber}{the NDM table number to load}

\item{language}{\code{"en"} or \code{"english"} for English and \code{"fr"} or \code{"french"} for French language versions (defaults to English)}

\item{format}{(Optional) The format of the data table to retrieve. Either \code{"parquet"}, \code{"feather"}, or \code{sqlite} (default is \code{"parquet"}).}

\item{partitioning}{(Optional) Partition columns to use for parquet or feather formats.}

\item{refresh}{(Optional) Valid options are \code{FALSE} (the default), \code{TRUE}, and \code{"auto"}. When set
to \code{TRUE}, forces a reload of data table, when set to \code{"auto"} it will refresh the table by downloading
the newest version from StatCan if the table is out of date. If set to \code{FALSE} and the table is out of date
a warning will be emitted to alert the user that the data is outdated.}

\item{timeout}{(Optional) Timeout in seconds for downloading cansim table to work around scenarios where StatCan servers drop the network connection.}

\item{cache_path}{(Optional) Path to where to cache the table permanently. By default, the data is cached
in the path specified by `getOption("cansim.cache_path")`, if this is set. Otherwise it will use `tempdir()`.}
}
\value{
A database connection to a local parquet, feather, or sqlite database with the StatCan Table data. The data
frames after calling `collect()` or `collect_and_normalize()` are identical up to possibly different row order.
}
\description{
Retrieves a data table using an NDM catalogue number as parquet, feather, or SQLite database connection. Retrieved table data is
cached permanently if a cache path is supplied or for duration of the current R session.
If the table is cached the function will check if a newer version is available
and emit a warning message if the cached table is out of date.
}
\examples{
\dontrun{
con <- get_cansim_connection("34-10-0013")

# Work with the data connection
glimpse(con)

}
}
