% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_media.R
\name{filter_media}
\alias{filter_media}
\title{Filter media}
\usage{
filter_media(x, ...)
}
\arguments{
\item{x}{Camera Trap Data Package object, as returned by \code{read_camtrapdp()}.}

\item{...}{Filtering conditions, see \code{dplyr::filter()}.}
}
\value{
\code{x} filtered.
}
\description{
Subsets media in a Camera Trap Data Package object, retaining all rows that
satisfy the conditions.
}
\details{
\itemize{
\item Deployments are not filtered.
\item Observations are filtered on associated \code{mediaID} (for media-based
observations) and \code{eventID} (for event-based observations).
}
}
\examples{
x <- example_dataset()

# Filtering returns x, so pipe with media() to see the result
x \%>\%
  filter_media(captureMethod == "timeLapse") \%>\%
  media()

# Filtering on media also affects associated observations, but not deployments
x_filtered <- filter_media(x, favorite == TRUE)
observations(x_filtered)

# Filtering on multiple conditions (combined with &)
x \%>\%
  filter_media(captureMethod == "activityDetection", filePublic == FALSE) \%>\%
  media()

# Filtering on datetimes is easiest with lubridate
library(lubridate, warn.conflicts = FALSE)
x \%>\%
  filter_media(
    timestamp >= lubridate::as_datetime("2020-08-02 05:01:00"),
    timestamp <= lubridate::as_datetime("2020-08-02 05:02:00")
  ) \%>\%
  media()
}
\seealso{
Other filter functions: 
\code{\link{filter_deployments}()},
\code{\link{filter_observations}()}
}
\concept{filter functions}
