% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/counters.R
\name{prop_out}
\alias{prop_out}
\title{Proportion out}
\usage{
prop_out(x, y, na.rm = TRUE, ignore.case = FALSE)
}
\arguments{
\item{x}{A vector to check.}

\item{y}{A vector to compare against.}

\item{na.rm}{logical; Should \code{NA} be ignored?}

\item{ignore.case}{logical; if \code{FALSE}, the pattern matching is case
sensitive and if \code{TRUE}, case is ignored during matching.}
}
\value{
The proportion of \code{x} absent in \code{y}.
}
\description{
Find the proportion of values of \code{x} that are \verb{\%out\%} of the vector \code{y}.
}
\details{
\code{mean(x \%out\% y)}
}
\examples{
prop_out(c("VT", "NH", "ZZ", "ME"), state.abb)
}
\seealso{
Other counting wrappers: 
\code{\link{count_diff}()},
\code{\link{count_in}()},
\code{\link{count_na}()},
\code{\link{count_out}()},
\code{\link{count_vec}()},
\code{\link{na_in}()},
\code{\link{na_out}()},
\code{\link{na_rep}()},
\code{\link{prop_distinct}()},
\code{\link{prop_in}()},
\code{\link{prop_na}()},
\code{\link{which_in}()},
\code{\link{which_out}()}
}
\concept{counting wrappers}
