% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval.R, R/presets.R
\name{r}
\alias{r}
\alias{r_safe}
\title{Evaluate an expression in another R session}
\usage{
r(
  func,
  args = list(),
  libpath = .libPaths(),
  repos = default_repos(),
  stdout = NULL,
  stderr = NULL,
  poll_connection = TRUE,
  error = getOption("callr.error", "error"),
  cmdargs = c("--slave", "--no-save", "--no-restore"),
  show = FALSE,
  callback = NULL,
  block_callback = NULL,
  spinner = show && interactive(),
  system_profile = FALSE,
  user_profile = "project",
  env = rcmd_safe_env(),
  timeout = Inf,
  ...
)

r_safe(
  func,
  args = list(),
  libpath = .libPaths(),
  repos = default_repos(),
  stdout = NULL,
  stderr = NULL,
  poll_connection = TRUE,
  error = getOption("callr.error", "error"),
  cmdargs = c("--slave", "--no-save", "--no-restore"),
  show = FALSE,
  callback = NULL,
  block_callback = NULL,
  spinner = show && interactive(),
  system_profile = FALSE,
  user_profile = "project",
  env = rcmd_safe_env(),
  timeout = Inf,
  ...
)
}
\arguments{
\item{func}{Function object to call in the new R process.
The function should be self-contained and only refer to
other functions and use variables explicitly from other packages
using the \code{::} notation. The environment of the function
is set to \code{.GlobalEnv} before passing it to the child process.
Because of this, it is good practice to create an anonymous
function and pass that to \code{callr}, instead of passing
a function object from a (base or other) package. In particular\preformatted{r(.libPaths)
}

does not work, because \code{.libPaths} is defined in a special
environment, but\preformatted{r(function() .libPaths())
}

works just fine.}

\item{args}{Arguments to pass to the function. Must be a list.}

\item{libpath}{The library path.}

\item{repos}{The \code{repos} option. If \code{NULL}, then no
\code{repos} option is set. This options is only used if
\code{user_profile} or \code{system_profile} is set \code{FALSE},
as it is set using the system or the user profile.}

\item{stdout}{The name of the file the standard output of
the child R process will be written to.
If the child process runs with the \code{--slave} option (the default),
then the commands are not echoed and will not be shown
in the standard output. Also note that you need to call \code{print()}
explicitly to show the output of the command(s).}

\item{stderr}{The name of the file the standard error of
the child R process will be written to.
In particular \code{message()} sends output to the standard
error. If nothing was sent to the standard error, then this file
will be empty. This argument can be the same file as \code{stdout},
in which case they will be correctly interleaved. If this is the
string \code{"2>&1"}, then standard error is redirected to standard output.}

\item{poll_connection}{Whether to have a control connection to
the process. This is used to transmit messages from the subprocess
to the main process.}

\item{error}{What to do if the remote process throws an error.
See details below.}

\item{cmdargs}{Command line arguments to pass to the R process.
Note that \code{c("-f", rscript)} is appended to this, \code{rscript}
is the name of the script file to run. This contains a call to the
supplied function and some error handling code.}

\item{show}{Logical, whether to show the standard output on the screen
while the child process is running. Note that this is independent
of the \code{stdout} and \code{stderr} arguments. The standard
error is not shown currently.}

\item{callback}{A function to call for each line of the standard
output and standard error from the child process. It works together
with the \code{show} option; i.e. if \code{show = TRUE}, and a
callback is provided, then the output is shown of the screen, and the
callback is also called.}

\item{block_callback}{A function to call for each block of the standard
output and standard error. This callback is not line oriented, i.e.
multiple lines or half a line can be passed to the callback.}

\item{spinner}{Whether to show a calming spinner on the screen while
the child R session is running. By default it is shown if
\code{show = TRUE} and the R session is interactive.}

\item{system_profile}{Whether to use the system profile file.}

\item{user_profile}{Whether to use the user's profile file.
If this is \code{"project"}, then only the profile from the working
directory is used, but the \code{R_PROFILE_USER} environment variable
and the user level profile are not. See also "Security considerations"
below.}

\item{env}{Environment variables to set for the child process.}

\item{timeout}{Timeout for the function call to finish. It can be a
\link[base:difftime]{base::difftime} object, or a real number, meaning seconds.
If the process does not finish before the timeout period expires,
then a \code{system_command_timeout_error} error is thrown. \code{Inf}
means no timeout.}

\item{...}{Extra arguments are passed to \code{\link[processx:run]{processx::run()}}.}
}
\value{
Value of the evaluated expression.
}
\description{
From \code{callr} version 2.0.0, \code{r()} is equivalent to \code{r_safe()}, and
tries to set up a less error prone execution environment. In particular:
\itemize{
\item It makes sure that at least one reasonable CRAN mirror is set up.
\item Adds some command line arguments are added to avoid saving
\code{.RData} files, etc.
\item Ignores the system and user profiles.
\item Various environment variables are set: \code{CYGWIN} to avoid
warnings about DOS-style paths, \code{R_TESTS} to avoid issues
when \code{callr} is invoked from unit tests, \code{R_BROWSER}
and \code{R_PDFVIEWER} to avoid starting a browser or a PDF viewer.
See \code{\link[=rcmd_safe_env]{rcmd_safe_env()}}.
}
}
\details{
The \code{r()} function from before 2.0.0 is called \code{\link[=r_copycat]{r_copycat()}} now.
}
\section{Error handling}{


\code{callr} handles errors properly. If the child process throws an
error, then \code{callr} throws an error with the same error message
in the main process.

The \code{error} expert argument may be used to specify a different
behavior on error. The following values are possible:
\itemize{
\item \code{error} is the default behavior: throw an error in the main process,
with a prefix and the same error message as in the subprocess.
\item \code{stack} also throws an error in the main process, but the error
is of a special kind, class \code{callr_error}, and it contains
both the original error object, and the call stack of the child,
as written out by \code{\link[utils:dump.frames]{utils::dump.frames()}}. This is now deprecated,
because the error thrown for \code{"error"} has the same information.
\item \code{debugger} is similar to \code{stack}, but in addition
to returning the complete call stack, it also start up a debugger
in the child call stack, via \code{\link[utils:debugger]{utils::debugger()}}.
}

The default error behavior can be also set using the \code{callr.error}
option. This is useful to debug code that uses \code{callr}.

callr uses parent errors, to keep the stacks of the main process and the
subprocess(es) in the same error object.
}

\section{Security considerations}{


\code{callr} makes a copy of the user's \code{.Renviron} file and potentially of
the local or user \code{.Rprofile}, in the session temporary
directory. Avoid storing sensitive information such as passwords, in
your environment file or your profile, otherwise this information will
get scattered in various files, at least temporarily, until the
subprocess finishes. You can use the keyring package to avoid passwords
in plain files.
}

\examples{
\dontrun{
# Workspace is empty
r(function() ls())

# library path is the same by default
r(function() .libPaths())
.libPaths()
}

}
\seealso{
Other callr functions: 
\code{\link{r_copycat}()},
\code{\link{r_vanilla}()}
}
\concept{callr functions}
