% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_sci.R
\name{cluster_sci}
\alias{cluster_sci}
\title{Situational Clustering Index}
\usage{
cluster_sci(cacc_matrix)
}
\arguments{
\item{cacc_matrix}{A tibble. The output of the \code{cacc} function.}
}
\value{
Returns a numeric value.
}
\description{
Computes a Situational Clustering Index (SCI) to quantify the magnitude of the clustering of observations among dominant profiles in a \code{cacc_matrix}.
}
\examples{
cluster_sci(cacc(onharassment, ivs = sex:privacy, dv = rep_victim))
}
\references{
Hart, T. C. (2019). Identifying Situational Clustering and Quantifying Its Magnitude in Dominant Case Configurations: New Methods for Conjunctive Analysis. \emph{Crime & Delinquency, 66}(1), 143-159. https://doi.org/10.1177/0011128719866123
}
