% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cabinets.R
\name{create_r_proj}
\alias{create_r_proj}
\title{R project settings}
\usage{
create_r_proj(
  version = "1.0",
  restore_workspace = c("No", "Yes", "Default"),
  save_workspace = c("No", "Yes", "Default"),
  save_history = c("Default", "No", "Yes"),
  enable_code_indexing = c("Yes", "No", "Default"),
  spaces_for_tab = c("Yes", "No", "Default"),
  num_spaces_for_tab = 2,
  encoding = "UTF-8",
  rnw_weave = "Sweave",
  latex = "pdfLaTeX",
  auto_append_new_line = "Yes",
  strip_trailing_white_space = "Yes"
)
}
\arguments{
\item{version}{R project version number, to be passed as character string.}

\item{restore_workspace}{Load the .Rdata file (if any) found in the initial working directory into the  R workspace. Options are "No" (default), "Yes", and "Default". If "Default", global behaviour settings are inherited.}

\item{save_workspace}{Save .RData on exit. Options are "No" (default), "Yes", and "Default". If "Default", global behaviour settings are inherited.}

\item{save_history}{Always save history (even when not saving .RData). Options are "Default" (default), "Yes", and "No". If "Default", global behaviour settings are inherited.}

\item{enable_code_indexing}{Determines whether R source files within the project directory are indexed for code navigation. Options are "Yes" (default), "No", and "Default". If "Default", global behaviour settings are inherited.}

\item{spaces_for_tab}{Determine whether the tab key inserts multiple spaces rather than a tab character (soft tabs). Options are "Yes" (default), "No", and "Default". If "Default", global behaviour settings are inherited.}

\item{num_spaces_for_tab}{Specify the number of spaces per soft-tab, integer.}

\item{encoding}{Specify the default text encoding for source files. Default is "UTF-8".}

\item{rnw_weave}{Specify how to weave Rnw files. Default is "Sweave".}

\item{latex}{Specify LaTeX processing. Default is "pdfLaTeX".}

\item{auto_append_new_line}{Ensure that source files end with a new line. Default is "Yes".}

\item{strip_trailing_white_space}{Strip trailing horizontal white space when saving. Default is "Yes".}
}
\value{
The settings used to write a .Rproj file.
}
\description{
\code{create_r_proj} is a helper function for \code{new_cabinet_proj}. Calling it outside the scope of \code{new_cabinet_proj} will only print the specified settings the console.
}
\examples{
create_r_proj()
}
\seealso{
\url{https://support.rstudio.com/hc/en-us/articles/200526207-Using-Projects} for more information on these settings.
}
