% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_estimators_weights.R
\name{checkConvergence}
\alias{checkConvergence}
\title{Internal: Check convergence}
\usage{
checkConvergence(
  .W_new          = args_default()$.W_new,
  .W_old          = args_default()$.W_old,
  .conv_criterion = args_default()$.conv_criterion,
  .tolerance      = args_default()$.tolerance
  )
}
\arguments{
\item{.W_new}{A (J x K) matrix of weights.}

\item{.W_old}{A (J x K) matrix of weights.}

\item{.conv_criterion}{Character string. The criterion to use for the convergence check.
One of: "\emph{diff_absolute}", "\emph{diff_squared}", or "\emph{diff_relative}". Defaults
to "\emph{diff_absolute}".}

\item{.tolerance}{Double. The tolerance criterion for convergence.
Defaults to \code{1e-05}.}
}
\value{
\code{TRUE} if converged; \code{FALSE} otherwise.
}
\description{
Check convergence of an algorithm using one of the following criteria:
\describe{
\item{\code{diff_absolute}}{Checks if the largest elementwise absolute difference
between two matrices \code{.W_new} and \code{W.old} is
smaller than a given tolerance.}
\item{\code{diff_squared}}{Checks if the largest elementwise squared difference
between two matrices \code{.W_new} and \code{W.old} is
smaller than a given tolerance.}
\item{\code{diff_relative}}{Checks if the largest elementwise absolute rate of change
(new - old / new) for two matrices \code{.W_new}
and \code{W.old} is smaller than a given tolerance.}
}
}
\keyword{internal}
