% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelling.R
\name{subsample_lm}
\alias{subsample_lm}
\title{K-fold Resampled Coefficient Estimation for Linear Regression}
\usage{
subsample_lm(text, data, weights, k = 10)
}
\arguments{
\item{text}{A character string or formula specifying the model to be fitted}

\item{data}{A data frame containing the variables in the model}

\item{weights}{Optional numeric vector of weights. If NULL, unweighted regression is performed}

\item{k}{Integer specifying the number of resampling folds (default = 10)}
}
\value{
An object of class 'lm' with averaged coefficients from k-fold resampling.
For small samples, returns a standard lm object.
}
\description{
Performs k-fold resampling to estimate averaged coefficients for linear regression.
The coefficients are averaged across k different subsets of the data to provide
more stable estimates. For small samples (n < 100), returns a standard linear model instead.
}
\details{
The function splits the data into k subsets, fits a linear model on k-1 subsets,
and stores the coefficients. This process is repeated k times, and the final
coefficients are averaged across all iterations to provide more stable estimates.
}
