% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preparation.R
\name{prepareData}
\alias{prepareData}
\title{Prepare data for modeling in one step (convenience method)}
\usage{
prepareData(
  data = NULL,
  group = "group",
  raw = "raw",
  age = "group",
  k = 4,
  t = NULL,
  width = NA,
  weights = NULL,
  scale = "T",
  descend = FALSE,
  silent = FALSE
)
}
\arguments{
\item{data}{data.frame with a grouping variable named 'group' and a raw score variable
named 'raw'.}

\item{group}{grouping variable in the data, e. g. age groups, grades ...
Setting group = FALSE deactivates modeling in dependence of age. Use this in case you do want
conventional norm tables.}

\item{raw}{the raw scores}

\item{age}{the continuous explanatory variable; by default set to "group"}

\item{k}{The power parameter, default = 4}

\item{t}{the age power parameter (default NULL). If not set, cNORM automatically uses k. The age power parameter
can be used to specify the k to produce rectangular matrices and specify the course of scores per  independently from k}

\item{width}{if a width is provided, the function switches to rankBySlidingWindow to determine the
observed raw scores, otherwise, ranking is done by group (default)}

\item{weights}{Vector or variable name in the dataset with weights for each individual case. It can be used
to compensate for moderate imbalances due to insufficient norm data stratification. Weights should be numerical
and positive.
Please note, that this feature is currently EXPERIMENTAL and subject to ongoing work! Precision of weighting increases
with sample size. On the other hand, in large samples, it is easy to stratificate and then weighting is not needed anymore.}

\item{scale}{type of norm scale, either T (default), IQ, z or percentile (= no
transformation); a double vector with the mean and standard deviation can as well,
be provided f. e. c(10, 3) for Wechsler scale index point}

\item{descend}{ranking order (default descent = FALSE): inverses the
ranking order with higher raw scores getting lower norm scores; relevant
for example when norming error scores, where lower scores mean higher
performance}

\item{silent}{set to TRUE to suppress messages}
}
\value{
data frame including the norm scores, powers and interactions of the norm score and
grouping variable
}
\description{
This is a convenience method to either load the inbuilt sample dataset, or
to provide a data frame with the variables "raw" (for the raw scores) and "group"
The function ranks the data within groups, computes norm values, powers of the norm
scores and interactions. Afterwards, you can use these preprocessed data to
determine the best fitting model.
}
\examples{
# conducts ranking and computation of powers and interactions with the 'elfe' dataset
data.elfe <- prepareData(elfe)

# use vectors instead of data frame
data.elfe <- prepareData(raw=elfe$raw, group=elfe$group)

# variable names can be specified as well, here with the BMI data included in the package
\dontrun{
data.bmi <- prepareData(CDC, group = "group", raw = "bmi", age = "age")
}

# modeling with only one group with the 'elfe' dataset as an example
# this results in conventional norming
data.elfe2 <- prepareData(data = elfe, group = FALSE)
m <- bestModel(data.elfe2)
}
\seealso{
Other prepare: 
\code{\link{computePowers}()},
\code{\link{rankByGroup}()},
\code{\link{rankBySlidingWindow}()}
}
\concept{prepare}
