% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotDensity}
\alias{plotDensity}
\title{Plot the density function per group by raw score}
\usage{
plotDensity(model, minRaw = NULL, maxRaw = NULL, minNorm = NULL,
  maxNorm = NULL, group = NULL)
}
\arguments{
\item{model}{The model from the bestModel function}

\item{minRaw}{Lower bound of the raw score}

\item{maxRaw}{Upper bound of the raw score}

\item{minNorm}{Lower bound of the norm score}

\item{maxNorm}{Upper bound of the norm score}

\item{group}{Column of groups to plot}
}
\description{
The function plots the density  curves based on the regression model against
the actual percentiles from the raw data. As in 'plotNormCurves',
please check for inconsistent curves, especially curves showing implausible shapes.
}
\examples{
# Load example data set, compute model and plot results for age values 2, 4 and 6
normData <- prepareData()
m <- bestModel(data = normData)
plotDensity(m, group = c (2, 4, 6))
}
\seealso{
plotNormCurves, plotPercentiles
}
