% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/c14_date_list_spatial_determine_country_by_coordinate.R,
%   R/c14_date_list_spatial_finalize_country_name.R,
%   R/c14_date_list_spatial_standardize_country_name.R
\name{determine_country_by_coordinate}
\alias{determine_country_by_coordinate}
\alias{determine_country_by_coordinate.default}
\alias{determine_country_by_coordinate.c14_date_list}
\alias{country_attribution}
\alias{finalize_country_name}
\alias{finalize_country_name.default}
\alias{finalize_country_name.c14_date_list}
\alias{standardize_country_name}
\alias{standardize_country_name.default}
\alias{standardize_country_name.c14_date_list}
\title{Functions to improve the country attribution in a \strong{c14_date_list}}
\usage{
determine_country_by_coordinate(x, suppress_spatial_warnings = TRUE)

\method{determine_country_by_coordinate}{default}(x,
  suppress_spatial_warnings = TRUE)

\method{determine_country_by_coordinate}{c14_date_list}(x,
  suppress_spatial_warnings = TRUE)

finalize_country_name(x, quiet = FALSE)

\method{finalize_country_name}{default}(x, quiet = FALSE)

\method{finalize_country_name}{c14_date_list}(x, quiet = FALSE)

standardize_country_name(x, country_thesaurus = get_country_thesaurus(),
  codesets = c("country.name.de", "iso3c"), quiet = FALSE, ...)

\method{standardize_country_name}{default}(x,
  country_thesaurus = get_country_thesaurus(),
  codesets = c("country.name.de", "iso3c"), quiet = FALSE, ...)

\method{standardize_country_name}{c14_date_list}(x,
  country_thesaurus = get_country_thesaurus(),
  codesets = c("country.name.de", "iso3c"), quiet = FALSE, ...)
}
\arguments{
\item{x}{an object of class c14_date_list}

\item{suppress_spatial_warnings}{suppress some spatial data messages and warnings}

\item{quiet}{suppress suppress decision log output}

\item{country_thesaurus}{data.frame with correct and variants of country names}

\item{codesets}{which country codesets should be searched for in \code{countrycode::codelist}
beyond \strong{country.name.en}? See \code{?countrycode::codelist} for more information}

\item{...}{additional arguments are passed to \code{stringdist::stringdist()}.
\code{stringdist()} is used for fuzzy string matching of the country names in
\code{countrycode::codelist}}
}
\value{
an object of class c14_date_list with the additional columns \strong{country_thes},
\strong{country_coord} and/or \strong{country_final}
}
\description{
\code{c14bazAAR} provides several functions to check and improve the
spatial attribution of the individual dates in a \strong{c14_date_list} to a country. \cr \cr
\code{c14bazAAR::standardize_country_name()} adds column \strong{country_thes} with
standardized country names. Most source databases come with a column \strong{country}
that contains a character name of the origin country for each date. Unfortunately the
different source databases don't rely on a unified naming convention and therefore use
various terms to represent the same country (for example: United Kingdom, Great Britain,
GB, etc.). This function aims to standardize the country naming scheme. To achieve this,
it compares the names to values in an external (\code{countrycode::codelist})
and an internal
\href{https://github.com/ISAAKiel/c14bazAAR/blob/master/data-raw/country_thesaurus.csv}{country_thesaurus}
reference list. The latter needs
manual curation to catch semantic and spelling errors in the source databases. \cr \cr
\code{c14bazAAR::determine_country_by_coordinate()} adds the column \strong{country_coord}
with standardized country attribution based on the coordinate information of the dates.
Due to the inconsistencies in the \strong{country} column in many c14 source databases
it's often necessary to rely on the coordinate position (\strong{lat} & \strong{lon})
for reliable country attribution information. \cr \cr
\code{finalize_country_name()} picks the country name in a hierarchical order from the results
of \code{c14bazAAR::determine_country_by_coordinate()} and
\code{c14bazAAR::standardize_country_name()} functions, followed by the original input
of the database. The result is added to the input date list with the column
\strong{country_final}. \cr \cr
\code{finalize_country_name()} also calls the other functions
\code{c14bazAAR::determine_country_by_coordinate()} and
\code{c14bazAAR::standardize_country_name()} if the necessary columns are missing yet.
}
\examples{
library(magrittr)
example_c14_date_list \%>\%
  determine_country_by_coordinate() \%>\%
  standardize_country_name() \%>\%
  finalize_country_name()

}
