% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyperparam.R, R/print-bvharspec.R, R/member.R
\name{set_bvar}
\alias{set_bvar}
\alias{set_bvar_flat}
\alias{set_bvhar}
\alias{set_weight_bvhar}
\alias{print.bvharspec}
\alias{is.bvharspec}
\alias{knit_print.bvharspec}
\title{Hyperparameters for Bayesian Models}
\usage{
set_bvar(sigma, lambda = 0.1, delta, eps = 1e-04)

set_bvar_flat(U)

set_bvhar(sigma, lambda = 0.1, delta, eps = 1e-04)

set_weight_bvhar(sigma, lambda = 0.1, eps = 1e-04, daily, weekly, monthly)

\method{print}{bvharspec}(x, digits = max(3L, getOption("digits") - 3L), ...)

is.bvharspec(x)

\method{knit_print}{bvharspec}(x, ...)
}
\arguments{
\item{sigma}{Standard error vector for each variable (Default: sd)}

\item{lambda}{Tightness of the prior around a random walk or white noise (Default: .1)}

\item{delta}{Persistence (Default: Litterman sets 1 = random walk prior, White noise prior = 0)}

\item{eps}{Very small number (Default: 1e-04)}

\item{U}{Positive definite matrix. By default, identity matrix of dimension ncol(X0)}

\item{daily}{Same as delta in VHAR type (Default: 1 as Litterman)}

\item{weekly}{Fill the second part in the first block (Default: 1)}

\item{monthly}{Fill the third part in the first block (Default: 1)}

\item{x}{\code{bvharspec} object}

\item{digits}{digit option to print}

\item{...}{not used}
}
\value{
Every function returns \code{bvharspec} \link{class}.
It is the list of which the components are the same as the arguments provided.
If the argument is not specified, \code{NULL} is assigned here.
The default values mentioned above will be considered in each fitting function.
\describe{
\item{process}{Model name: \code{BVAR}, \code{BVHAR}}
\item{prior}{
Prior name: \code{Minnesota} (Minnesota prior for BVAR),
\code{Hierarchical} (Hierarchical prior for BVAR),
\code{MN_VAR} (BVHAR-S),
\code{MN_VHAR} (BVHAR-L),
\code{Flat} (Flat prior for BVAR)
}
\item{sigma}{Vector value (or \code{bvharpriorspec} class) assigned for sigma}
\item{lambda}{Value (or \code{bvharpriorspec} class) assigned for lambda}
\item{delta}{Vector value assigned for delta}
\item{eps}{Value assigned for epsilon}
}

\code{set_weight_bvhar()} has different component with \code{delta} due to its different construction.
\describe{
\item{daily}{Vector value assigned for daily weight}
\item{weekly}{Vector value assigned for weekly weight}
\item{monthly}{Vector value assigned for monthly weight}
}
}
\description{
Set hyperparameters of Bayesian VAR and VHAR models.
}
\details{
\itemize{
\item Missing arguments will be set to be default values in each model function mentioned above.
\item \code{set_bvar()} sets hyperparameters for \code{\link[=bvar_minnesota]{bvar_minnesota()}}.
\item Each \code{delta} (vector), \code{lambda} (length of 1), \code{sigma} (vector), \code{eps} (vector) corresponds to \eqn{\delta_j}, \eqn{\lambda}, \eqn{\delta_j}, \eqn{\epsilon}.
}

\eqn{\delta_i} are related to the belief to random walk.
\itemize{
\item If \eqn{\delta_i = 1} for all i, random walk prior
\item If \eqn{\delta_i = 0} for all i, white noise prior
}

\eqn{\lambda} controls the overall tightness of the prior around these two prior beliefs.
\itemize{
\item If \eqn{\lambda = 0}, the posterior is equivalent to prior and the data do not influence the estimates.
\item If \eqn{\lambda = \infty}, the posterior mean becomes OLS estimates (VAR).
}

\eqn{\sigma_i^2 / \sigma_j^2} in Minnesota moments explain the data scales.

\itemize{
\item \code{set_bvar_flat} sets hyperparameters for \code{\link[=bvar_flat]{bvar_flat()}}.
}

\itemize{
\item \code{set_bvhar()} sets hyperparameters for \code{\link[=bvhar_minnesota]{bvhar_minnesota()}} with VAR-type Minnesota prior, i.e. BVHAR-S model.
}

\itemize{
\item \code{set_weight_bvhar()} sets hyperparameters for \code{\link[=bvhar_minnesota]{bvhar_minnesota()}} with VHAR-type Minnesota prior, i.e. BVHAR-L model.
}
}
\note{
By using \code{\link[=set_psi]{set_psi()}} and \code{\link[=set_lambda]{set_lambda()}} each, hierarchical modeling is available.
}
\examples{
# Minnesota BVAR specification------------------------
bvar_spec <- set_bvar(
  sigma = c(.03, .02, .01), # Sigma = diag(.03^2, .02^2, .01^2)
  lambda = .2, # lambda = .2
  delta = rep(.1, 3), # delta1 = .1, delta2 = .1, delta3 = .1
  eps = 1e-04 # eps = 1e-04
)
class(bvar_spec)
str(bvar_spec)
# Flat BVAR specification-------------------------
# 3-dim
# p = 5 with constant term
# U = 500 * I(mp + 1)
bvar_flat_spec <- set_bvar_flat(U = 500 * diag(16))
class(bvar_flat_spec)
str(bvar_flat_spec)
# BVHAR-S specification-----------------------
bvhar_var_spec <- set_bvhar(
  sigma = c(.03, .02, .01), # Sigma = diag(.03^2, .02^2, .01^2)
  lambda = .2, # lambda = .2
  delta = rep(.1, 3), # delta1 = .1, delta2 = .1, delta3 = .1
  eps = 1e-04 # eps = 1e-04
)
class(bvhar_var_spec)
str(bvhar_var_spec)
# BVHAR-L specification---------------------------
bvhar_vhar_spec <- set_weight_bvhar(
  sigma = c(.03, .02, .01), # Sigma = diag(.03^2, .02^2, .01^2)
  lambda = .2, # lambda = .2
  eps = 1e-04, # eps = 1e-04
  daily = rep(.2, 3), # daily1 = .2, daily2 = .2, daily3 = .2
  weekly = rep(.1, 3), # weekly1 = .1, weekly2 = .1, weekly3 = .1
  monthly = rep(.05, 3) # monthly1 = .05, monthly2 = .05, monthly3 = .05
)
class(bvhar_vhar_spec)
str(bvhar_vhar_spec)
}
\references{
Bańbura, M., Giannone, D., & Reichlin, L. (2010). \emph{Large Bayesian vector auto regressions}. Journal of Applied Econometrics, 25(1).

Litterman, R. B. (1986). \emph{Forecasting with Bayesian Vector Autoregressions: Five Years of Experience}. Journal of Business & Economic Statistics, 4(1), 25.

Ghosh, S., Khare, K., & Michailidis, G. (2018). \emph{High-Dimensional Posterior Consistency in Bayesian Vector Autoregressive Models}. Journal of the American Statistical Association, 114(526).

Kim, Y. G., and Baek, C. (2024). \emph{Bayesian vector heterogeneous autoregressive modeling}. Journal of Statistical Computation and Simulation, 94(6), 1139-1157.

Kim, Y. G., and Baek, C. (2024). \emph{Bayesian vector heterogeneous autoregressive modeling}. Journal of Statistical Computation and Simulation, 94(6), 1139-1157.
}
\seealso{
\itemize{
\item lambda hyperprior specification \code{\link[=set_lambda]{set_lambda()}}
\item sigma hyperprior specification \code{\link[=set_psi]{set_psi()}}
}
}
