% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{etf_vix}
\alias{etf_vix}
\title{CBOE ETF Volatility Index Dataset}
\format{
A data frame of 1006 row and 9 columns:

From 2012-01-09 to 2015-06-27,
33 missing observations were interpolated by \code{\link[stats:approxfun]{stats::approx()}} with \code{linear}.
\describe{
\item{GVZCLS}{Gold ETF volatility index}
\item{VXFXICLS}{China ETF volatility index}
\item{OVXCLS}{Crude Oil ETF volatility index}
\item{VXEEMCLS}{Emerging Markets ETF volatility index}
\item{EVZCLS}{EuroCurrency ETF volatility index}
\item{VXSLVCLS}{Silver ETF volatility index}
\item{VXGDXCLS}{Gold Miners ETF volatility index}
\item{VXXLECLS}{Energy Sector ETF volatility index}
\item{VXEWZCLS}{Brazil ETF volatility index}
}
}
\source{
Source: \url{https://www.cboe.com}

Release: \url{https://www.cboe.com/us/options/market_statistics/daily/}
}
\usage{
etf_vix
}
\description{
Chicago Board Options Exchage (CBOE) Exchange Traded Funds (ETFs) volatility index from FRED.
}
\details{
Copyright, 2016, Chicago Board Options Exchange, Inc.

Note that, in this data frame, dates column is removed.
This dataset interpolated 36 missing observations (nontrading dates) using \code{imputeTS::na_interpolation()}.
}
\references{
Chicago Board Options Exchange, CBOE Gold ETF Volatility Index (GVZCLS), retrieved from FRED, Federal Reserve Bank of St. Louis; \url{https://fred.stlouisfed.org/series/GVZCLS}, July 31, 2021.

Chicago Board Options Exchange, CBOE China ETF Volatility Index (VXFXICLS), retrieved from FRED, Federal Reserve Bank of St. Louis; \url{https://fred.stlouisfed.org/series/VXFXICLS}, August 1, 2021.

Chicago Board Options Exchange, CBOE Crude Oil ETF Volatility Index (OVXCLS), retrieved from FRED, Federal Reserve Bank of St. Louis; \url{https://fred.stlouisfed.org/series/OVXCLS}, August 1, 2021.

Chicago Board Options Exchange, CBOE Emerging Markets ETF Volatility Index (VXEEMCLS), retrieved from FRED, Federal Reserve Bank of St. Louis; \url{https://fred.stlouisfed.org/series/VXEEMCLS}, August 1, 2021.

Chicago Board Options Exchange, CBOE EuroCurrency ETF Volatility Index (EVZCLS), retrieved from FRED, Federal Reserve Bank of St. Louis; \url{https://fred.stlouisfed.org/series/EVZCLS}, August 2, 2021.

Chicago Board Options Exchange, CBOE Silver ETF Volatility Index (VXSLVCLS), retrieved from FRED, Federal Reserve Bank of St. Louis; \url{https://fred.stlouisfed.org/series/VXSLVCLS}, August 1, 2021.

Chicago Board Options Exchange, CBOE Gold Miners ETF Volatility Index (VXGDXCLS), retrieved from FRED, Federal Reserve Bank of St. Louis; \url{https://fred.stlouisfed.org/series/VXGDXCLS}, August 1, 2021.

Chicago Board Options Exchange, CBOE Energy Sector ETF Volatility Index (VXXLECLS), retrieved from FRED, Federal Reserve Bank of St. Louis; \url{https://fred.stlouisfed.org/series/VXXLECLS}, August 1, 2021.

Chicago Board Options Exchange, CBOE Brazil ETF Volatility Index (VXEWZCLS), retrieved from FRED, Federal Reserve Bank of St. Louis; \url{https://fred.stlouisfed.org/series/VXEWZCLS}, August 2, 2021.
}
\keyword{datasets}
