% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary-sparse.R
\name{conf_prec}
\alias{conf_prec}
\alias{conf_prec.summary.bvharsp}
\title{Evaluate the Sparsity Estimation Based on Precision}
\usage{
conf_prec(x, y, ...)

\method{conf_prec}{summary.bvharsp}(x, y, truth_thr = 0, ...)
}
\arguments{
\item{x}{\code{summary.bvharsp} object.}

\item{y}{True inclusion variable.}

\item{...}{not used}

\item{truth_thr}{Threshold value when using non-sparse true coefficient matrix. By default, \code{0} for sparse matrix.}
}
\value{
Precision value in confusion table
}
\description{
This function computes precision for sparse element of the true coefficients given threshold.
}
\details{
If the element of the estimate \eqn{\hat\Phi} is smaller than some threshold,
it is treated to be zero.
Then the precision is computed by
\deqn{precision = \frac{TP}{TP + FP}}
where TP is true positive, and FP is false positive.
}
\references{
Bai, R., & Ghosh, M. (2018). High-dimensional multivariate posterior consistency under global–local shrinkage priors. Journal of Multivariate Analysis, 167, 157–170.
}
\seealso{
\code{\link[=confusion]{confusion()}}
}
