% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bvhar-sv.R
\name{bvhar_sv}
\alias{bvhar_sv}
\alias{print.bvharsv}
\alias{knit_print.bvharsv}
\title{Fitting Bayesian VHAR-SV of Minnesota Belief}
\usage{
bvhar_sv(
  y,
  har = c(5, 22),
  num_iter = 1000,
  num_burn = floor(num_iter/2),
  thinning = 1,
  bayes_spec = set_bvhar(),
  include_mean = TRUE,
  verbose = FALSE,
  num_thread = 1
)

\method{print}{bvharsv}(x, digits = max(3L, getOption("digits") - 3L), ...)

knit_print.bvharsv(x, ...)
}
\arguments{
\item{y}{Time series data of which columns indicate the variables}

\item{har}{Numeric vector for weekly and monthly order. By default, \code{c(5, 22)}.}

\item{num_iter}{MCMC iteration number}

\item{num_burn}{Number of burn-in (warm-up). Half of the iteration is the default choice.}

\item{thinning}{Thinning every thinning-th iteration}

\item{bayes_spec}{A BVHAR model specification by \code{\link[=set_bvhar]{set_bvhar()}} (default) or \code{\link[=set_weight_bvhar]{set_weight_bvhar()}}.}

\item{include_mean}{Add constant term (Default: \code{TRUE}) or not (\code{FALSE})}

\item{verbose}{Print the progress bar in the console. By default, \code{FALSE}.}

\item{num_thread}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Number of threads}

\item{x}{\code{bvarsv} object}

\item{digits}{digit option to print}

\item{...}{not used}
}
\value{
\code{bvhar_sv()} returns an object named \code{bvharsv} \link{class}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} This function fits VHAR-SV with Minnesota belief.
}
\details{
Cholesky stochastic volatility modeling for VHAR based on
\deqn{\Sigma_t = L^T D_t^{-1} L}
}
\references{
Chan, J., Koop, G., Poirier, D., & Tobias, J. (2019). \emph{Bayesian Econometric Methods (2nd ed., Econometric Exercises)}. Cambridge: Cambridge University Press.

Cogley, T., & Sargent, T. J. (2005). \emph{Drifts and volatilities: monetary policies and outcomes in the post WWII US}. Review of Economic Dynamics, 8(2), 262–302.
}
