#' @title n_traces
#' @description Returns the number of traces in an event log
#' @inheritParams act_collapse
#' @family Counters
#' @export n_traces

n_traces <- function(log) {
	UseMethod("n_traces")
}

#' @describeIn n_traces Count number of traces for eventlog
#' @export

n_traces.log <- function(log) {
	nrow(trace_list(log))
}

#' @describeIn n_traces Count number of traces for grouped eventlog
#' @export
n_traces.grouped_log <- function(log) {
	mapping <- mapping(log)

	log %>%
		# remove grouping
		ungroup() %>%
		# group_by + nest (has option to keep group-vars in nested data)
		nest_by(across(mapping$groups), .keep = TRUE) %>%
		# nest_by returns rowwise data.frame, which we don't need
		ungroup() %>%
		# make sure data is event log
		mutate(data = map(data, re_map, mapping)) %>%
		# compute output of function, taking over any arguments
		mutate(n_traces = map_dbl(data, n_traces)) %>%
		select(-data)
}

