% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activitylog.R
\name{activitylog}
\alias{activitylog}
\title{Create activity log}
\usage{
activitylog(activitylog, case_id, activity_id, resource_id, timestamps, order)
}
\arguments{
\item{activitylog}{The data object to be used as activity log. This can be a
\code{data.frame} or \code{tibble}.}

\item{case_id}{The case classifier of the activity log. A character vector containing variable names of length 1 or more.}

\item{activity_id}{The activity classifier of the activity log. A character vector containing variable names of length 1 or more.}

\item{resource_id}{The resource identifier of the activity log. A character vector containing variable names of length 1 or more.}

\item{timestamps}{The columns with timestamps refering to different lifecycle events. A character vector of 1 or more.
These should have one of the following names: "schedule","assign","reassign","start","suspend","resume","abort_activity","abort_case","complete","manualskip","autoskip".
These columns should be of the Date or POSIXct class.}

\item{order}{Configure how to handle sort events with equal timestamps:
auto will use the order in the original data,
alphabetical will sort the activity labels by alphabet,
sorted will assume that the data frame is already correctly sorted and has a column '.order',
providing a column name will use this column for ordering (can be numeric of character).
The latter will never overrule timestamp orderings.}
}
\description{
Create activity log
}
