% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_tagesschau.R
\name{tagesschau_homepage}
\alias{tagesschau_homepage}
\title{Fetch Tagesschau homepage items}
\usage{
tagesschau_homepage(flatten = FALSE, flatten_mode = "json")
}
\arguments{
\item{flatten}{Logical; drop nested list columns.}

\item{flatten_mode}{Flatten strategy for list columns. Use "unnest" to
expand list-columns into multiple rows.}
}
\value{
A tibble with homepage items.

Includes \code{date_time} as POSIXct in Europe/Berlin.
}
\description{
Fetch Tagesschau homepage items
}
\details{
Fetches the Tagesschau homepage feed as provided by the ARD Tagesschau API.
Official docs: https://bundesapi.github.io/tagesschau-api/.

Note: The registry rate limit allows up to 60 requests per hour. Usage of
content is restricted to private, non-commercial use unless otherwise stated
by the source (see Tagesschau CC license notes).
}
\examples{
\dontrun{
tagesschau_homepage(flatten = TRUE)
}

}
\seealso{
\code{\link[=tagesschau_news]{tagesschau_news()}}, \code{\link[=tagesschau_search]{tagesschau_search()}}, and \code{\link[=tagesschau_channels]{tagesschau_channels()}}.
}
