% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pair_methods.R
\name{pair_tauA}
\alias{pair_tauA}
\title{Kendall's tau  A for association between ordinal factors.}
\usage{
pair_tauA(d, handle.na = TRUE, warnings = TRUE, ...)
}
\arguments{
\item{d}{A dataframe}

\item{handle.na}{ignored. Pairwise complete observations are used automatically.}

\item{warnings}{If TRUE, generates a warning for datasets of one row, one column, or with constant variables.}

\item{...}{other arguments}
}
\value{
A tibble of class \code{pairwise} with factor pairs, or NULL if there are not at least two factor variables
}
\description{
Calculates Kendall's tau A for every  factor variable pair in a dataset.
}
\details{
Calculated using  \code{\link[DescTools]{KendallTauA}}. Assumes factor levels are in the given order.
NAs are automatically handled by pairwise omit.
}
\examples{
 d <- data.frame(x=rnorm(20), 
                 y=factor(sample(3,20, replace=TRUE)), 
                 z=factor(sample(2,20, replace=TRUE)))
 pair_tauA(d)
}
