% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise.R
\name{pairwise}
\alias{pairwise}
\alias{pairwise.matrix}
\alias{pairwise.data.frame}
\alias{pairwise.easycorrelation}
\alias{as.pairwise}
\title{A generic function to create a data structure for every variable pair in a dataset}
\usage{
pairwise(x, score = NA_character_, pair_type = NA_character_)

\method{pairwise}{matrix}(x, score = NA_character_, pair_type = NA_character_)

\method{pairwise}{data.frame}(x, score = NA_character_, pair_type = NA_character_)

\method{pairwise}{easycorrelation}(x, score = NA_character_, pair_type = NA_character_)

as.pairwise(x, score = NA_character_, pair_type = NA_character_)
}
\arguments{
\item{x}{A dataframe or symmetric matrix.}

\item{score}{a character string indicating the value of association, either "nn", "fn", "ff".}

\item{pair_type}{a character string specifying the type of variable pair.}
}
\value{
A tbl_df of class \code{pairwise} for pairs of variables with a column \code{value} for the score value,
\code{score} for a type of association value and \code{pair_type} for the type of variable pair.
}
\description{
Creates a data structure for every variable pair in a dataset.
}
\section{Methods (by class)}{
\itemize{
\item \code{pairwise(matrix)}: pairwise method

\item \code{pairwise(data.frame)}: pairwise method

\item \code{pairwise(easycorrelation)}: pairwise method

}}
\section{Functions}{
\itemize{
\item \code{as.pairwise()}: Same as \code{pairwise}

}}
\examples{
pairwise(cor(iris[,1:4]), score="pearson")
pairwise(iris)
}
