% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildmer.R
\name{buildgam}
\alias{buildgam}
\title{Use buildmer to fit generalized additive models using \code{gam()} from package \code{mgcv}}
\usage{
buildgam(formula, data = NULL, family = "gaussian", cl = NULL,
  direction = c("order", "backward"), crit = "LRT", include = NULL,
  calc.anova = TRUE, calc.summary = TRUE, quiet = FALSE, ...)
}
\arguments{
\item{formula}{The model formula for the maximal model you would like to fit, if possible.}

\item{data}{The data to fit the models to.}

\item{family}{The error distribution to use.}

\item{cl}{An optional cluster object as returned by function \code{makeCluster()} from package \code{parallel} to use for parallelizing the evaluation of terms.}

\item{direction}{Character string or vector indicating the direction for stepwise elimination; possible options are \code{'order'} (order terms by their contribution to the model), \code{'backward'} (backward elimination), \code{'forward'} (forward elimination, implies \code{order}). The default is the combination \code{c('order','backward')}, to first make sure that the model converges and to then perform backward elimination; other such combinations are perfectly allowed.}

\item{crit}{Character string or vector determining the criterion used to test terms for elimination. Possible options are \code{'LRT'} (likelihood-ratio test; this is the default), \code{'LL'} (use the raw -2 log likelihood), \code{'AIC'} (Akaike Information Criterion), and \code{'BIC'} (Bayesian Information Criterion).}

\item{include}{A character vector of terms that will be kept in the model at all times. These do not need to be specified separately in the \code{formula} argument.}

\item{calc.anova}{Logical indicating whether to also calculate the ANOVA table for the final model after term elimination.}

\item{calc.summary}{Logical indicating whether to also calculate the summary table for the final model after term elimination.}

\item{quiet}{Logical indicating whether to suppress progress messages.}

\item{...}{Additional options to be passed to \code{bam()}.}
}
\description{
Use buildmer to fit generalized additive models using \code{gam()} from package \code{mgcv}
}
\examples{
\dontshow{
library(buildmer)
m <- buildgam(f1 ~ s(timepoint,bs='cr'),data=vowels)
}
\donttest{
library(buildmer)
m <- buildgam(f1 ~ s(timepoint,by=following) + s(participant,by='following',bs='re') +
                   s(participant,timepoint,by=following,bs='fs'),data=vowels)
}
}
\seealso{
\code{\link[=buildmer]{buildmer()}}
}
