% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tool-git.R
\name{btw_tool_git_diff}
\alias{btw_tool_git_diff}
\title{Tool: Git Diff}
\usage{
btw_tool_git_diff(ref = NULL, `_intent` = "")
}
\arguments{
\item{ref}{a reference such as \code{"HEAD"}, or a commit id, or \code{NULL}
to the diff the working directory against the repository index.}

\item{_intent}{An optional string describing the intent of the tool use.
When the tool is used by an LLM, the model will use this argument to
explain why it called the tool.}
}
\value{
Returns a diff patch as a formatted string.
}
\description{
This tool allows an LLM to run \code{\link[gert:git_diff]{gert::git_diff_patch()}}, equivalent to
\verb{git diff} in the terminal, and to see the detailed changes made in a commit.
}
\examples{
\dontshow{if (rlang::is_installed("gert")) withAutoprint(\{ # examplesIf}
withr::with_tempdir({
  gert::git_init()
  gert::git_config_set("user.name", "R Example")
  gert::git_config_set("user.email", "ex@example.com")

  writeLines("hello, world", "hello.md")
  gert::git_add("hello.md")
  gert::git_commit("Initial commit")

  writeLines("hello, universe", "hello.md")

  # What the LLM sees
  cat(btw_tool_git_diff()@value)
})
\dontshow{\}) # examplesIf}
}
\seealso{
Other git tools: 
\code{\link{btw_tool_git_branch_checkout}()},
\code{\link{btw_tool_git_branch_create}()},
\code{\link{btw_tool_git_branch_list}()},
\code{\link{btw_tool_git_commit}()},
\code{\link{btw_tool_git_log}()},
\code{\link{btw_tool_git_status}()}
}
\concept{git tools}
