% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specify_bsvar_t.R
\name{specify_starting_values_bsvar_t}
\alias{specify_starting_values_bsvar_t}
\title{R6 Class Representing StartingValuesBSVART}
\description{
The class StartingValuesBSVART presents starting values for the bsvar model 
with t-distributed structural shocks.
}
\examples{
# starting values for a bsvar model for a 3-variable system
sv = specify_starting_values_bsvar_t$new(N = 3, p = 1, T = 100)


## ------------------------------------------------
## Method `specify_starting_values_bsvar_t$get_starting_values`
## ------------------------------------------------

# starting values for a homoskedastic bsvar with 1 lag for a 3-variable system
sv = specify_starting_values_bsvar$new(N = 3, p = 1)
sv$get_starting_values()   # show starting values as list


## ------------------------------------------------
## Method `specify_starting_values_bsvar_t$set_starting_values`
## ------------------------------------------------

# starting values for a homoskedastic bsvar with 1 lag for a 3-variable system
sv = specify_starting_values_bsvar$new(N = 3, p = 1)

# Modify the starting values by:
sv_list = sv$get_starting_values()   # getting them as list
sv_list$A <- matrix(rnorm(12), 3, 4) # modifying the entry
sv$set_starting_values(sv_list)      # providing to the class object

}
\section{Super class}{
\code{bsvars::StartingValuesBSVAR} -> \code{StartingValuesBSVART}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{A}}{an \code{NxK} matrix of starting values for the parameter \eqn{A}.}

\item{\code{B}}{an \code{NxN} matrix of starting values for the parameter \eqn{B}.}

\item{\code{hyper}}{a \code{(2*N+1)x2} matrix of starting values for the shrinkage hyper-parameters of the 
hierarchical prior distribution.}

\item{\code{lambda}}{a \code{Tx1} vector of starting values for latent variables.}

\item{\code{df}}{a positive scalar with starting values for the degrees of 
freedom parameter of the Student-t conditional distribution of structural 
shock.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-StartingValuesBSVART-new}{\code{specify_starting_values_bsvar_t$new()}}
\item \href{#method-StartingValuesBSVART-get_starting_values}{\code{specify_starting_values_bsvar_t$get_starting_values()}}
\item \href{#method-StartingValuesBSVART-set_starting_values}{\code{specify_starting_values_bsvar_t$set_starting_values()}}
\item \href{#method-StartingValuesBSVART-clone}{\code{specify_starting_values_bsvar_t$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StartingValuesBSVART-new"></a>}}
\if{latex}{\out{\hypertarget{method-StartingValuesBSVART-new}{}}}
\subsection{Method \code{new()}}{
Create new starting values StartingValuesBSVART
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_starting_values_bsvar_t$new(N, p, T, d = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{N}}{a positive integer - the number of dependent variables in the model.}

\item{\code{p}}{a positive integer - the autoregressive lag order of the SVAR model.}

\item{\code{T}}{a positive integer - the the time series dimension of the dependent variable matrix \eqn{Y}.}

\item{\code{d}}{a positive integer - the number of \code{exogenous} variables in the model.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Starting values StartingValuesBSVART
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StartingValuesBSVART-get_starting_values"></a>}}
\if{latex}{\out{\hypertarget{method-StartingValuesBSVART-get_starting_values}{}}}
\subsection{Method \code{get_starting_values()}}{
Returns the elements of the starting values StartingValuesBSVAR as a \code{list}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_starting_values_bsvar_t$get_starting_values()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# starting values for a homoskedastic bsvar with 1 lag for a 3-variable system
sv = specify_starting_values_bsvar$new(N = 3, p = 1)
sv$get_starting_values()   # show starting values as list

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StartingValuesBSVART-set_starting_values"></a>}}
\if{latex}{\out{\hypertarget{method-StartingValuesBSVART-set_starting_values}{}}}
\subsection{Method \code{set_starting_values()}}{
Returns the elements of the starting values StartingValuesBSVAR as a \code{list}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_starting_values_bsvar_t$set_starting_values(last_draw)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{last_draw}}{a list containing the last draw of elements \code{B} - an \code{NxN} matrix, 
\code{A} - an \code{NxK} matrix, and \code{hyper} - a vector of 5 positive real numbers.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class StartingValuesBSVAR including the last draw of the current MCMC 
as the starting value to be passed to the continuation of the MCMC estimation using \code{estimate()}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# starting values for a homoskedastic bsvar with 1 lag for a 3-variable system
sv = specify_starting_values_bsvar$new(N = 3, p = 1)

# Modify the starting values by:
sv_list = sv$get_starting_values()   # getting them as list
sv_list$A <- matrix(rnorm(12), 3, 4) # modifying the entry
sv$set_starting_values(sv_list)      # providing to the class object

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StartingValuesBSVART-clone"></a>}}
\if{latex}{\out{\hypertarget{method-StartingValuesBSVART-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_starting_values_bsvar_t$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
