% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ekpf_filter.R
\name{ekpf_filter}
\alias{ekpf_filter}
\alias{ekpf_filter.ssm_nlg}
\title{Extended Kalman Particle Filtering}
\usage{
ekpf_filter(object, particles, ...)

\method{ekpf_filter}{ssm_nlg}(
  object,
  particles,
  seed = sample(.Machine$integer.max, size = 1),
  ...
)
}
\arguments{
\item{object}{of class \code{ssm_nlg}.}

\item{particles}{Number of particles.}

\item{...}{Ignored.}

\item{seed}{Seed for RNG.}
}
\value{
A list containing samples, filtered estimates and the 
corresponding covariances, weights, and an estimate of log-likelihood.
}
\description{
Function \code{ekpf_filter} performs a extended Kalman particle filtering 
with stratification resampling, based on Van Der Merwe et al (2001).
}
\examples{
\dontrun{
set.seed(1)
n <- 50
x <- y <- numeric(n)
y[1] <- rnorm(1, exp(x[1]), 0.1)
for(i in 1:(n-1)) {
 x[i+1] <- rnorm(1, sin(x[i]), 0.1)
 y[i+1] <- rnorm(1, exp(x[i+1]), 0.1)
}

pntrs <- nlg_example_models("sin_exp")

model_nlg <- ssm_nlg(y = y, a1 = pntrs$a1, P1 = pntrs$P1, 
  Z = pntrs$Z_fn, H = pntrs$H_fn, T = pntrs$T_fn, R = pntrs$R_fn, 
  Z_gn = pntrs$Z_gn, T_gn = pntrs$T_gn,
  theta = c(log_H = log(0.1), log_R = log(0.1)), 
  log_prior_pdf = pntrs$log_prior_pdf,
  n_states = 1, n_etas = 1, state_names = "state")

out <- ekpf_filter(model_nlg, 100)
ts.plot(cbind(x, out$at[1:n], out$att[1:n]), col = 1:3)
}
}
\references{
Van Der Merwe, R., Doucet, A., De Freitas, N., & Wan, E. A. 
(2001). The unscented particle filter. In Advances in neural 
information processing systems (pp. 584-590).
}
