% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{ng_ar1}
\alias{ng_ar1}
\title{Non-Gaussian model with AR(1) latent process}
\usage{
ng_ar1(y, rho, sigma, mu, distribution, phi, u = 1, beta, xreg = NULL)
}
\arguments{
\item{y}{Vector or a \code{\link{ts}} object of observations.}

\item{rho}{prior for autoregressive coefficient.}

\item{sigma}{Prior for the standard deviation of noise of the AR-process.}

\item{mu}{A fixed value or a prior for the intercept mu of the transition equation. Parameter is omitted if this is set to 0.}

\item{distribution}{distribution of the observation. Possible choices are
\code{"poisson"}, \code{"binomial"} and \code{"negative binomial"}.}

\item{phi}{Additional parameter relating to the non-Gaussian distribution.
For Negative binomial distribution this is the dispersion term, and for other
distributions this is ignored.}

\item{u}{Constant parameter for non-Gaussian models. For Poisson and negative binomial distribution, this corresponds to the offset
term. For binomial, this is the number of trials.}

\item{beta}{Prior for the regression coefficients.}

\item{xreg}{Matrix containing covariates.}
}
\value{
Object of class \code{ng_ar1}.
}
\description{
Constructs a simple non-Gaussian model where the state dynamics follow an AR(1) process.
}
