# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Intervals of points in knot intervals
#'
#' Find first and last+1 indexes iip s.t. x[iip] belongs to interval starting at xk[iik]
#'
#' @param x Numeric vector, abscissa points (must be non decreasing)
#' @param xk Numeric vector, knots (must be non decreasing)
#' @return Integer matrix of size \code{(2 x length(xk)-1)}. Indexes are 0-based
#' @export
ipk <- function(x, xk) {
    .Call(`_bspline_ipk`, x, xk)
}

#' Basis matrix and knot Jacobian for B-spline of order 0 (step function) and higher
#'
#' This function is analogous but not equivalent to \code{splines:bs()} and \code{splines2::bSpline()}.
#' It is also several times faster.
#'
#' @param x Numeric vector, abscissa points
#' @param xk Numeric vector, knots
#' @param n Integer scalar, polynomial order (3 by default)
#' @param cjac Logical scalar, if \code{TRUE} makes to calculate Jacobian of basis
#'   vectors as function of knot positions (FALSE by default)
#' @return Numeric matrix (for cjac=FALSE), each column correspond to a
#'   B-spline calculated on x; or List (for cjac=TRUE) with components \describe{
#'      \item{mat}{basis matrix of dimension \code{nx x nw}, where nx is the length
#'        of x and \code{nw=nk-n-1} is the number of basis vectors}
#'      \item{jac}{array of dimension \code{nx x (n+2) x nw} where n+2
#'        is the number of support knots for each basis vector
#'    }
#' }
#' @details
#'   For n==0, step function is defined as constant on each interval
#'   \code{[xk[i]; xk[i+1][}, i.e. closed on the left and open on the right
#'   except for the last interval which is closed on the right too. The
#'   Jacobian for step function is considered 0 in every x point even if
#'   in points where x=xk, the derivative is not defined.\cr
#'   For n==1, Jacobian is discontinuous in such points so for
#'   these points we take the derivative from the right.
#' @seealso {splines::bs()}, {splines2::bSpline()}
#' @examples
#'   x=seq(0, 5, length.out=101)
#'   # cubic basis matrix
#'   n=3
#'   m=bsc(x, xk=c(rep(0, n+1), 1:4, rep(5, n+1)), n=n)
#'   matplot(x, m, t="l")
#'   stopifnot(all.equal.numeric(c(m), c(splines::bs(x, knots = 1:4, degree = n, intercept = TRUE))))
#' @importFrom Rcpp evalCpp
#' @export
bsc <- function(x, xk, n = 3L, cjac = FALSE) {
    .Call(`_bspline_bsc`, x, xk, n, cjac)
}

#' Knot Jacobian of B-spline with weights
#'
#' @param jac Numeric array, such as returned by \code{bsc(..., cjac=TRUE)}
#' @param qws Numeric matrix, each column is a set of weights forming a
#'   B-spline. If qws is a vector, it is coerced to 1-column matrix.
#' @return Numeric array of size \code{nx x ncol(qw) x nk}, where \code{nx=dim(jac)[1]}
#'   and nk is the number of knots \code{dim(jac)[3]+n+1} (n being polynomial order).
#' @export
jacw <- function(jac, qws) {
    .Call(`_bspline_jacw`, jac, qws)
}

