% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accordion.R
\name{accordion_panel_set}
\alias{accordion_panel_set}
\alias{accordion_panel_open}
\alias{accordion_panel_close}
\alias{accordion_panel_insert}
\alias{accordion_panel_remove}
\alias{accordion_panel_update}
\title{Dynamically update accordions}
\usage{
accordion_panel_set(id, values, session = get_current_session())

accordion_panel_open(id, values, session = get_current_session())

accordion_panel_close(id, values, session = get_current_session())

accordion_panel_insert(
  id,
  panel,
  target = NULL,
  position = c("after", "before"),
  session = get_current_session()
)

accordion_panel_remove(id, target, session = get_current_session())

accordion_panel_update(
  id,
  target,
  ...,
  title = NULL,
  value = NULL,
  icon = NULL,
  session = get_current_session()
)
}
\arguments{
\item{id}{an character string that matches an existing \code{\link[=accordion]{accordion()}}'s \code{id}.}

\item{values}{either a character string (used to identify particular
\code{\link[=accordion_panel]{accordion_panel()}}s by their \code{value}) or \code{TRUE} (i.e., all \code{values}).}

\item{session}{a shiny session object (the default should almost always be
used).}

\item{panel}{an \code{\link[=accordion_panel]{accordion_panel()}}.}

\item{target}{The \code{value} of an existing panel to insert next to. If
removing: the \code{value} of the \code{\link[=accordion_panel]{accordion_panel()}} to remove.}

\item{position}{Should \code{panel} be added before or after the target? When
\code{target} is \code{NULL} (the default), \code{"after"} will append after the last
panel and \code{"before"} will prepend before the first panel.}

\item{...}{Named arguments become attributes on the \verb{<div class="accordion">}
element. Unnamed arguments should be \code{accordion_panel()}s.}

\item{title}{A title to appear in the \code{accordion_panel()}'s header.}

\item{value}{A character string that uniquely identifies this panel.}

\item{icon}{A \link[htmltools:builder]{htmltools::tag} child (e.g., \code{\link[bsicons:bs_icon]{bsicons::bs_icon()}}) which is positioned just before the \code{title}.}
}
\description{
Dynamically (i.e., programmatically) update/modify \code{\link[=accordion]{accordion()}}s in a
Shiny app. These functions require an \code{id} to be provided to the
\code{accordion()} and must also be called within an active Shiny session.
}
\section{Functions}{
\itemize{
\item \code{accordion_panel_set()}: same as \code{accordion_panel_open()}, except it
also closes any currently open panels.

\item \code{accordion_panel_open()}: open \code{\link[=accordion_panel]{accordion_panel()}}s.

\item \code{accordion_panel_close()}: close \code{\link[=accordion_panel]{accordion_panel()}}s.

\item \code{accordion_panel_insert()}: insert a new \code{\link[=accordion_panel]{accordion_panel()}}

\item \code{accordion_panel_remove()}: remove \code{\link[=accordion_panel]{accordion_panel()}}s.

\item \code{accordion_panel_update()}: update a \code{\link[=accordion_panel]{accordion_panel()}}.

}}
