% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repo_delete_record.R
\name{bs_delete_record}
\alias{bs_delete_record}
\title{Delete a record in a repo}
\usage{
bs_delete_record(
  collection,
  rkey,
  user = get_bluesky_user(),
  pass = get_bluesky_pass(),
  auth = bs_auth(user, pass)
)
}
\arguments{
\item{collection}{Character, length 1. The NSID of the record collection.}

\item{rkey}{Character, length 1. The CID of the version of the record. If not specified, then return the most recent version.}

\item{user}{Character. User name to log in with. Defaults to \code{get_bluesky_user()}.}

\item{pass}{Character. App password to log in with. Defaults to \code{get_bluesky_pass()}.}

\item{auth}{Authentication information. Defaults to \code{bs_auth(user, pass)}.}
}
\value{
an \code{httr2} status code
}
\description{
Delete a record in a repo
}
\section{Lexicon references}{

\href{https://github.com/bluesky-social/atproto/blob/main/lexicons/com/atproto/repo/deleteRecord.json}{repo/deleteRecord.json (2023-11-25)}
}

\section{Function introduced}{

\code{v0.1.0} (2023-11-25)
}

\examples{
\dontshow{if (has_bluesky_pass() & has_bluesky_user()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# get info about a record
post_rcd <- bs_get_record('https://bsky.app/profile/bskyr.bsky.social/post/3kf2577exva2x')
# create a record, to like the post
like <- list(
  subject = list(
    uri = post_rcd$uri,
    cid = post_rcd$cid
  ),
  createdAt = bs_created_at()
)

rec <- bs_create_record(collection = 'app.bsky.feed.like', record = like)
bs_delete_record(collection = 'app.bsky.feed.like',
rkey = stringr::str_split_i(rec$uri, '/', i = 5))
\dontshow{\}) # examplesIf}
}
\concept{repo}
