% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bruceR-stats_1_basic.R
\name{add}
\alias{add}
\alias{added}
\title{Create, modify, and delete variables.}
\usage{
add(data, expr, when, by, drop = FALSE)

added(data, expr, when, by, drop = FALSE)
}
\arguments{
\item{data}{A \code{\link[data.table:data.table]{data.table}}
(preferred).}

\item{expr}{R expression(s) enclosed in \code{{...}} to compute variables.

Passing to \code{\link[data.table:data.table]{data.table}}:
\code{DT[ , `:=`(expr), ]}

Execute each line of expression in \code{{...}} \emph{one by one},
such that newly created variables are available immediately.
This is an advantage of \code{\link[dplyr:mutate]{mutate}} and
has been implemented here for \code{\link[data.table:data.table]{data.table}}.}

\item{when}{[Optional] Compute for which rows or rows meeting what condition(s)?

Passing to \code{\link[data.table:data.table]{data.table}}:
\code{DT[when, , ]}}

\item{by}{[Optional] Compute by what group(s)?

Passing to \code{\link[data.table:data.table]{data.table}}:
\code{DT[ , , by]}}

\item{drop}{Drop existing variables and return only new variables?
Default is \code{FALSE}, which returns all variables.}
}
\value{
\code{add()} returns a new
\code{\link[data.table:data.table]{data.table}},
with the raw data unchanged.

\code{added()} returns nothing and has already changed the raw data.
}
\description{
Enhanced functions to create, modify, and/or delete variables.
The functions \strong{combine} the advantages of
\code{\link[base:within]{within}} (base),
\code{\link[dplyr:mutate]{mutate}} (dplyr),
\code{\link[dplyr:transmute]{transmute}} (dplyr), and
\code{\link[data.table:data.table]{:=}} (data.table).
See examples below for the usage and convenience.
}
\section{Functions}{
\itemize{
\item \code{add()}: Return the \emph{new data}.

You need to assign the new data to an object:

\preformatted{data = add(data, {...})}

\item \code{added()}: Return nothing and \emph{change the raw data immediately}.

NO need to assign the new data:

\preformatted{added(data, {...})}

}}
\examples{
## ====== Usage 1: add() ====== ##

d = as.data.table(within.1)
d$XYZ = 1:8
d

# add() does not change the raw data:
add(d, {B = 1; C = 2})
d

# new data should be assigned to an object:
d = d \%>\% add({
  ID = str_extract(ID, "\\\\d")  # modify a variable
  XYZ = NULL                   # delete a variable
  A = .mean("A", 1:4)          # create a new variable
  B = A * 4    # new variable is immediately available
  C = 1        # never need ,/; at the end of any line
})
d


## ====== Usage 2: added() ====== ##

d = as.data.table(within.1)
d$XYZ = 1:8
d

# added() has already changed the raw data:
added(d, {B = 1; C = 2})
d

# raw data has already become the new data:
added(d, {
  ID = str_extract(ID, "\\\\d")
  XYZ = NULL
  A = .mean("A", 1:4)
  B = A * 4
  C = 1
})
d


## ====== Using `when` and `by` ====== ##

d = as.data.table(between.2)
d

added(d, {SCORE2 = SCORE - mean(SCORE)},
      A == 1 & B \%in\% 1:2,  # `when`: for what conditions
      by=B)                 # `by`: by what groups
d
na.omit(d)


## ====== Return Only New Variables ====== ##

newvars = add(within.1, {
  ID = str_extract(ID, "\\\\d")
  A = .mean("A", 1:4)
}, drop=TRUE)
newvars


## ====== Better Than `base::within()` ====== ##

d = as.data.table(within.1)

# wrong order: C B A
within(d, {
  A = 4
  B = A + 1
  C = 6
})

# correct order: A B C
add(d, {
  A = 4
  B = A + 1
  C = 6
})

}
