% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlogit-tidiers.R
\name{tidy.mlogit}
\alias{tidy.mlogit}
\alias{mlogit_tidiers}
\title{Tidying methods for logit models}
\usage{
\method{tidy}{mlogit}(x, conf.int = FALSE, conf.level = 0.95, ...)
}
\arguments{
\item{x}{an object returned from \code{\link[mlogit:mlogit]{mlogit::mlogit()}}.}

\item{conf.int}{Logical indicating whether or not to include a confidence
interval in the tidied output. Defaults to \code{FALSE}.}

\item{conf.level}{The confidence level to use for the confidence interval
if \code{conf.int = TRUE}. Must be strictly greater than 0 and less than 1.
Defaults to 0.95, which corresponds to a 95 percent confidence interval.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\description{
These methods tidy the coefficients of mnl and nl models generated
by the functions of the \code{mlogit} package.
}
\examples{

# feel free to ignore the following line—it allows {broom} to supply 
# examples without requiring the model-supplying package to be installed.
if (requireNamespace("mlogit", quietly = TRUE)) {

# load libraries for models and data
library(mlogit)

data("Fishing", package = "mlogit")
Fish <- dfidx(Fishing, varying = 2:9, shape = "wide", choice = "mode")

# fit model
m <- mlogit(mode ~ price + catch | income, data = Fish)

# summarize model fit with tidiers
tidy(m)
augment(m)
glance(m)

}

}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[mlogit:mlogit]{mlogit::mlogit()}}

Other mlogit tidiers: 
\code{\link{augment.mlogit}()},
\code{\link{glance.mlogit}()}
}
\concept{mlogit tidiers}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with columns:
  \item{conf.high}{Upper bound on the confidence interval for the estimate.}
  \item{conf.low}{Lower bound on the confidence interval for the estimate.}
  \item{estimate}{The estimated value of the regression term.}
  \item{p.value}{The two-sided p-value associated with the observed statistic.}
  \item{statistic}{The value of a T-statistic to use in a hypothesis that the regression term is non-zero.}
  \item{std.error}{The standard error of the regression term.}
  \item{term}{The name of the regression term.}

}
