% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bingroup-tidiers.R
\name{tidy.binWidth}
\alias{tidy.binWidth}
\alias{binwidth_tidiers}
\title{Tidy a(n) binWidth object}
\usage{
\method{tidy}{binWidth}(x, ...)
}
\arguments{
\item{x}{A \code{\link[binGroup:binWidth]{binGroup::binWidth()}} object.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\value{
A one-row \link[tibble:tibble]{tibble::tibble} with columns:
\item{ci.width}{Expected width of confidence interval.}
\item{alternative}{Alternative hypothesis.}
\item{p}{True proportion.}
\item{n}{Total sample size.}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies cross models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\examples{

if (require("binGroup", quietly = TRUE)) {
    bw <- binWidth(100, .1)
    bw
    tidy(bw)

    library(dplyr)
    d <- expand.grid(n = seq(100, 800, 100),
                     p = .5,
                     method = c("CP", "Blaker", "Score", "Wald"),
                     stringsAsFactors = FALSE) \%>\%
        group_by(n, p, method) \%>\%
        do(tidy(binWidth(.$n, .$p, method = .$method)))

    library(ggplot2)
    ggplot(d, aes(n, ci.width, color = method)) +
        geom_line() +
        xlab("Total Observations") +
        ylab("Expected CI Width")
}

}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[binGroup:binWidth]{binGroup::binWidth()}}

Other bingroup tidiers: \code{\link{glance.binDesign}},
  \code{\link{tidy.binDesign}}
}
\concept{bingroup tidiers}
